/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

public abstract class OracleXAConnection
extends OraclePooledConnection
implements XAConnection {
    protected XAResource xaResource;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:44_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAConnection() throws XAException {
        block4: {
            this((Connection)null);
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAConnection(Connection pc) throws XAException {
        block4: {
            super(pc);
            this.xaResource = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(pc));
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    @Override
    public abstract XAResource getXAResource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Connection conn = super.getConnection();
                if (this.xaResource != null) {
                    ((OracleXAResource)this.xaResource).setLogicalConnection(conn);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + conn);
                    OracleLog.recursiveTrace = false;
                }
                connection = conn;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleXAConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAutoCommit() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAConnection.logger().log(OracleLog.TRACE_16, "return: " + this.autoCommit);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.autoCommit;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAutoCommit(boolean value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            this.autoCommit = value;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleXAConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

