/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.SyncProvider;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;

class OracleWebRowSetXmlWriterImpl
implements OracleWebRowSetXmlWriter {
    private Writer xmlWriter;
    private Stack xmlTagStack;
    private static final String WEBROWSET_ELEMENT = "webRowSet";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String METADATA_ELEMENT = "metadata";
    private static final String DATA_ELEMENT = "data";
    private static final String PROPERTY_COMMAND = "command";
    private static final String PROPERTY_CONCURRENCY = "concurrency";
    private static final String PROPERTY_DATASOURCE = "datasource";
    private static final String PROPERTY_ESCAPEPROCESSING = "escape-processing";
    private static final String PROPERTY_FETCHDIRECTION = "fetch-direction";
    private static final String PROPERTY_FETCHSIZE = "fetch-size";
    private static final String PROPERTY_ISOLATIONLEVEL = "isolation-level";
    private static final String PROPERTY_KEYCOLUMNS = "key-columns";
    private static final String PROPERTY_MAP = "map";
    private static final String PROPERTY_MAXFIELDSIZE = "max-field-size";
    private static final String PROPERTY_MAXROWS = "max-rows";
    private static final String PROPERTY_QUERYTIMEOUT = "query-timeout";
    private static final String PROPERTY_READONLY = "read-only";
    private static final String PROPERTY_ROWSETTYPE = "rowset-type";
    private static final String PROPERTY_SHOWDELETED = "show-deleted";
    private static final String PROPERTY_TABLENAME = "table-name";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_SYNCPROVIDER = "sync-provider";
    private static final String PROPERTY_NULL = "null";
    private static final String PROPERTY_KC_COLUMN = "column";
    private static final String PROPERTY_MAP_TYPE = "type";
    private static final String PROPERTY_MAP_CLASS = "class";
    private static final String PROPERTY_S_PROVIDERNAME = "sync-provider-name";
    private static final String PROPERTY_S_PROVIDERVENDOR = "sync-provider-vendor";
    private static final String PROPERTY_S_PROVIDERVERSION = "sync-provider-version";
    private static final String PROPERTY_S_PROVIDERGRADE = "sync-provider-grade";
    private static final String PROPERTY_S_DATASOURCELOCK = "data-source-lock";
    private static final String METADATA_COLUMNCOUNT = "column-count";
    private static final String METADATA_COLUMNDEFINITION = "column-definition";
    private static final String METADATA_COLUMNINDEX = "column-index";
    private static final String METADATA_AUTOINCREMENT = "auto-increment";
    private static final String METADATA_CASESENSITIVE = "case-sensitive";
    private static final String METADATA_CURRENCY = "currency";
    private static final String METADATA_NULLABLE = "nullable";
    private static final String METADATA_SIGNED = "signed";
    private static final String METADATA_SEARCHABLE = "searchable";
    private static final String METADATA_COLUMNDISPLAYSIZE = "column-display-size";
    private static final String METADATA_COLUMNLABEL = "column-label";
    private static final String METADATA_COLUMNNAME = "column-name";
    private static final String METADATA_SCHEMANAME = "schema-name";
    private static final String METADATA_COLUMNPRECISION = "column-precision";
    private static final String METADATA_COLUMNSCALE = "column-scale";
    private static final String METADATA_TABLENAME = "table-name";
    private static final String METADATA_CATALOGNAME = "catalog-name";
    private static final String METADATA_COLUMNTYPE = "column-type";
    private static final String METADATA_COLUMNTYPENAME = "column-type-name";
    private static final String METADATA_NULL = "null";
    private static final String DATA_CURRENTROW = "currentRow";
    private static final String DATA_INSERTROW = "insertRow";
    private static final String DATA_DELETEROW = "deleteRow";
    private static final String DATA_MODIFYROW = "modifyRow";
    private static final String DATA_COLUMNVALUE = "columnValue";
    private static final String DATA_UPDATEVALUE = "updateValue";
    private static final String DATA_NULL = "null";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:50_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    OracleWebRowSetXmlWriterImpl() {
    }

    @Override
    public void writeXML(WebRowSet webrowset, Writer writer) throws SQLException {
        if (!(webrowset instanceof OracleWebRowSet)) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing SQLException: 359");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 359);
        }
        this.xmlTagStack = new Stack();
        this.xmlWriter = writer;
        this.writeRowSet((OracleWebRowSet)webrowset);
    }

    @Override
    public boolean writeData(RowSetInternal internal) throws SQLException {
        return false;
    }

    private void writeRowSet(OracleWebRowSet webrowset) throws SQLException {
        try {
            this.writeHeaderAndStartWebRowSetElement();
            this.writeProperties(webrowset);
            this.writeMetaData(webrowset);
            this.writeData(webrowset);
            this.endWebRowSetElement();
        }
        catch (IOException ioexception) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing SQLException: IOException: " + ioexception.getMessage());
                OracleLog.recursiveTrace = false;
            }
            throw new SQLException("IOException: " + ioexception.getMessage());
        }
    }

    private void writeHeaderAndStartWebRowSetElement() throws IOException {
        this.xmlWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.xmlWriter.write("\n");
        this.setCurrentTag(WEBROWSET_ELEMENT);
        this.xmlWriter.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\"\n");
        this.xmlWriter.write("           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        this.xmlWriter.write("           xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
        this.xmlWriter.write("http://java.sun.com/xml/ns/jdbc/webrowset.xsd");
        this.xmlWriter.write("\">\n");
    }

    private void endWebRowSetElement() throws IOException {
        this.endTag(WEBROWSET_ELEMENT);
    }

    private void startElement(String elementName) throws IOException {
        this.startTag(elementName);
        this.xmlWriter.write("\n");
    }

    private void endElement(String elementName) throws IOException {
        this.writeIndent(this.xmlTagStack.size());
        this.endTag(elementName);
    }

    private void endElement() throws IOException {
        this.writeIndent(this.xmlTagStack.size());
        String currentTag = this.getCurrentTag();
        this.xmlWriter.write("</" + currentTag + ">\n");
        this.xmlWriter.flush();
    }

    private void startTag(String tag) throws IOException {
        this.setCurrentTag(tag);
        this.writeIndent(this.xmlTagStack.size());
        this.xmlWriter.write("<" + tag + ">");
    }

    private void endTag(String tag) throws IOException {
        String currentTag = this.getCurrentTag();
        if (tag.equals(currentTag)) {
            this.xmlWriter.write("</" + currentTag + ">\n");
        }
        this.xmlWriter.flush();
    }

    private void setCurrentTag(String tag) {
        this.xmlTagStack.push(tag);
    }

    private String getCurrentTag() {
        return (String)this.xmlTagStack.pop();
    }

    private void writeEmptyElement(String elementName) throws IOException {
        this.xmlWriter.write("<" + elementName + "/>");
    }

    private void writeProperties(OracleWebRowSet webrowset) throws IOException {
        this.startElement(PROPERTIES_ELEMENT);
        try {
            this.writeElementString(PROPERTY_COMMAND, webrowset.getCommand());
            this.writeElementInteger(PROPERTY_CONCURRENCY, webrowset.getConcurrency());
            this.writeElementString(PROPERTY_DATASOURCE, webrowset.getDataSourceName());
            this.writeElementBoolean(PROPERTY_ESCAPEPROCESSING, webrowset.getEscapeProcessing());
            this.writeElementInteger(PROPERTY_FETCHDIRECTION, webrowset.getFetchDirection());
            this.writeElementInteger(PROPERTY_FETCHSIZE, webrowset.getFetchSize());
            this.writeElementInteger(PROPERTY_ISOLATIONLEVEL, webrowset.getTransactionIsolation());
            this.startElement(PROPERTY_KEYCOLUMNS);
            int[] keyColumns = webrowset.getKeyColumns();
            for (int i2 = 0; keyColumns != null && i2 < keyColumns.length; ++i2) {
                this.writeElementInteger(PROPERTY_KC_COLUMN, keyColumns[i2]);
            }
            this.endElement(PROPERTY_KEYCOLUMNS);
            this.startElement(PROPERTY_MAP);
            Map map = webrowset.getTypeMap();
            if (map != null) {
                for (String typeName : map.keySet()) {
                    Class currentClass = (Class)map.get(typeName);
                    this.writeElementString(PROPERTY_MAP_TYPE, typeName);
                    this.writeElementString(PROPERTY_MAP_CLASS, currentClass.getName());
                }
            }
            this.endElement(PROPERTY_MAP);
            this.writeElementInteger(PROPERTY_MAXFIELDSIZE, webrowset.getMaxFieldSize());
            this.writeElementInteger(PROPERTY_MAXROWS, webrowset.getMaxRows());
            this.writeElementInteger(PROPERTY_QUERYTIMEOUT, webrowset.getQueryTimeout());
            this.writeElementBoolean(PROPERTY_READONLY, webrowset.isReadOnly());
            this.writeElementInteger(PROPERTY_ROWSETTYPE, webrowset.getType());
            this.writeElementBoolean(PROPERTY_SHOWDELETED, webrowset.getShowDeleted());
            this.writeElementString("table-name", webrowset.getTableName());
            this.writeElementString(PROPERTY_URL, webrowset.getUrl());
            this.startElement(PROPERTY_SYNCPROVIDER);
            SyncProvider syncProvider = webrowset.getSyncProvider();
            this.writeElementString(PROPERTY_S_PROVIDERNAME, syncProvider.getProviderID());
            this.writeElementString(PROPERTY_S_PROVIDERVENDOR, syncProvider.getVendor());
            this.writeElementString(PROPERTY_S_PROVIDERVERSION, syncProvider.getVersion());
            this.writeElementInteger(PROPERTY_S_PROVIDERGRADE, syncProvider.getProviderGrade());
            this.writeElementInteger(PROPERTY_S_DATASOURCELOCK, syncProvider.getDataSourceLock());
            this.endElement(PROPERTY_SYNCPROVIDER);
        }
        catch (SQLException sqlexception) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing IOException: SQLException: " + sqlexception.getMessage());
                OracleLog.recursiveTrace = false;
            }
            throw new IOException("SQLException: " + sqlexception.getMessage());
        }
        this.endElement(PROPERTIES_ELEMENT);
    }

    private void writeMetaData(OracleWebRowSet webrowset) throws IOException {
        this.startElement(METADATA_ELEMENT);
        try {
            ResultSetMetaData rsmd = webrowset.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.writeElementInteger(METADATA_COLUMNCOUNT, columnCount);
            for (int j2 = 1; j2 <= columnCount; ++j2) {
                this.startElement(METADATA_COLUMNDEFINITION);
                this.writeElementInteger(METADATA_COLUMNINDEX, j2);
                this.writeElementBoolean(METADATA_AUTOINCREMENT, rsmd.isAutoIncrement(j2));
                this.writeElementBoolean(METADATA_CASESENSITIVE, rsmd.isCaseSensitive(j2));
                this.writeElementBoolean(METADATA_CURRENCY, rsmd.isCurrency(j2));
                this.writeElementInteger(METADATA_NULLABLE, rsmd.isNullable(j2));
                this.writeElementBoolean(METADATA_SIGNED, rsmd.isSigned(j2));
                this.writeElementBoolean(METADATA_SEARCHABLE, rsmd.isSearchable(j2));
                this.writeElementInteger(METADATA_COLUMNDISPLAYSIZE, rsmd.getColumnDisplaySize(j2));
                this.writeElementString(METADATA_COLUMNLABEL, rsmd.getColumnLabel(j2));
                this.writeElementString(METADATA_COLUMNNAME, rsmd.getColumnName(j2));
                this.writeElementString(METADATA_SCHEMANAME, rsmd.getSchemaName(j2));
                this.writeElementInteger(METADATA_COLUMNPRECISION, rsmd.getPrecision(j2));
                this.writeElementInteger(METADATA_COLUMNSCALE, rsmd.getScale(j2));
                this.writeElementString("table-name", rsmd.getTableName(j2));
                this.writeElementString(METADATA_CATALOGNAME, rsmd.getCatalogName(j2));
                this.writeElementInteger(METADATA_COLUMNTYPE, rsmd.getColumnType(j2));
                this.writeElementString(METADATA_COLUMNTYPENAME, rsmd.getColumnTypeName(j2));
                this.endElement(METADATA_COLUMNDEFINITION);
            }
        }
        catch (SQLException sqlexception) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing IOException: SQLException: " + sqlexception.getMessage());
                OracleLog.recursiveTrace = false;
            }
            throw new IOException("SQLException: " + sqlexception.getMessage());
        }
        this.endElement(METADATA_ELEMENT);
    }

    private void writeElementBoolean(String elementName, boolean flag) throws IOException {
        this.startTag(elementName);
        this.writeBoolean(flag);
        this.endTag(elementName);
    }

    private void writeElementInteger(String elementName, int i2) throws IOException {
        this.startTag(elementName);
        this.writeInteger(i2);
        this.endTag(elementName);
    }

    private void writeElementString(String elementName, String str) throws IOException {
        this.startTag(elementName);
        this.writeString(str);
        this.endTag(elementName);
    }

    private void writeData(OracleWebRowSet webrowset) throws IOException {
        try {
            ResultSetMetaData rsmd = webrowset.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.startElement(DATA_ELEMENT);
            webrowset.beforeFirst();
            webrowset.setShowDeleted(true);
            while (webrowset.next()) {
                if (webrowset.rowDeleted() && webrowset.rowInserted()) {
                    this.startElement(DATA_MODIFYROW);
                } else if (webrowset.rowDeleted()) {
                    this.startElement(DATA_DELETEROW);
                } else if (webrowset.rowInserted()) {
                    this.startElement(DATA_INSERTROW);
                } else {
                    this.startElement(DATA_CURRENTROW);
                }
                for (int j2 = 1; j2 <= columnCount; ++j2) {
                    if (webrowset.columnUpdated(j2)) {
                        ResultSet resultset = webrowset.getOriginalRow();
                        resultset.next();
                        this.startTag(DATA_COLUMNVALUE);
                        this.writeValue(j2, (RowSet)resultset);
                        this.endTag(DATA_COLUMNVALUE);
                        this.startTag(DATA_UPDATEVALUE);
                        this.writeValue(j2, webrowset);
                        this.endTag(DATA_UPDATEVALUE);
                        continue;
                    }
                    this.startTag(DATA_COLUMNVALUE);
                    this.writeValue(j2, webrowset);
                    this.endTag(DATA_COLUMNVALUE);
                }
                this.endElement();
            }
            this.endElement(DATA_ELEMENT);
        }
        catch (SQLException sqlexception) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing IOException: SQLException: " + sqlexception.getMessage());
                OracleLog.recursiveTrace = false;
            }
            throw new IOException("SQLException: " + sqlexception.getMessage());
        }
    }

    private void writeBigDecimal(BigDecimal bigdecimal) throws IOException {
        if (bigdecimal != null) {
            this.xmlWriter.write(bigdecimal.toString());
        } else {
            this.writeEmptyElement("null");
        }
    }

    private void writeBoolean(boolean flag) throws IOException {
        this.xmlWriter.write(new Boolean(flag).toString());
    }

    private void writeDouble(double d2) throws IOException {
        this.xmlWriter.write(Double.toString(d2));
    }

    private void writeFloat(float f2) throws IOException {
        this.xmlWriter.write(Float.toString(f2));
    }

    private void writeInteger(int i2) throws IOException {
        this.xmlWriter.write(Integer.toString(i2));
    }

    private void writeLong(long l2) throws IOException {
        this.xmlWriter.write(Long.toString(l2));
    }

    private void writeNull() throws IOException {
        this.writeEmptyElement("null");
    }

    private void writeShort(short shrt) throws IOException {
        this.xmlWriter.write(Short.toString(shrt));
    }

    private void writeBytes(byte[] b2) throws IOException {
        this.xmlWriter.write(new String(b2));
    }

    private void writeString(String str) throws IOException {
        if (str != null) {
            this.xmlWriter.write(str);
        } else {
            this.xmlWriter.write("");
        }
    }

    private void writeIndent(int indent) throws IOException {
        for (int j2 = 1; j2 < indent; ++j2) {
            this.xmlWriter.write("  ");
        }
    }

    private void writeValue(int columnIndex, RowSet rowset) throws IOException {
        try {
            int columnType = rowset.getMetaData().getColumnType(columnIndex);
            switch (columnType) {
                case -7: 
                case 5: {
                    short shrt = rowset.getShort(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeShort(shrt);
                    break;
                }
                case 4: {
                    int val = rowset.getInt(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeInteger(val);
                    break;
                }
                case -5: {
                    long l2 = rowset.getLong(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(l2);
                    break;
                }
                case 6: 
                case 7: {
                    float f2 = rowset.getFloat(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeFloat(f2);
                    break;
                }
                case 8: {
                    double d2 = rowset.getDouble(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeDouble(d2);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigdec = rowset.getBigDecimal(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBigDecimal(bigdec);
                    break;
                }
                case 91: {
                    Date date = rowset.getDate(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(date.getTime());
                    break;
                }
                case 92: {
                    Time time = rowset.getTime(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(time.getTime());
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowset.getTimestamp(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(timestamp.getTime());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    byte[] bytes = rowset.getBytes(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBytes(bytes);
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    String str = rowset.getString(columnIndex);
                    if (rowset.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeString(str);
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing SQLException: The type " + columnType + " is not supported currently.");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new SQLException("The type " + columnType + " is not supported currently.");
                }
            }
        }
        catch (SQLException sqlexception) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(Level.SEVERE, "Throwing IOException: Failed to writeValue: " + sqlexception.getMessage());
                OracleLog.recursiveTrace = false;
            }
            throw new IOException("Failed to writeValue: " + sqlexception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleWebRowSetXmlWriterImpl.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

