/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.WebRowSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriterImpl;

public class OracleWebRowSet
extends OracleCachedRowSet
implements WebRowSet {
    private transient OracleWebRowSetXmlReader xmlReader;
    private transient OracleWebRowSetXmlWriter xmlWriter;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:50_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleWebRowSet() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.xmlReader = new OracleWebRowSetXmlReaderImpl();
                this.xmlWriter = new OracleWebRowSetXmlWriterImpl();
                this.setReadOnly(false);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readXml(Reader reader) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(reader));
                    OracleLog.recursiveTrace = false;
                }
                if (this.xmlReader != null) {
                    this.xmlReader.readXML(this, reader);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleWebRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 355");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 355);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(Writer writer) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(writer));
                    OracleLog.recursiveTrace = false;
                }
                if (this.xmlWriter != null) {
                    this.xmlWriter.writeXML(this, writer);
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleWebRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 356");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 356);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(ResultSet resultset, Writer writer) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(resultset) + ", " + OracleLog.argument(writer));
                    OracleLog.recursiveTrace = false;
                }
                this.populate(resultset);
                this.writeXml(writer);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readXml(InputStream istream) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(istream));
                    OracleLog.recursiveTrace = false;
                }
                this.readXml(new InputStreamReader(istream));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(OutputStream ostream) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(ostream));
                    OracleLog.recursiveTrace = false;
                }
                this.writeXml(new OutputStreamWriter(ostream));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(ResultSet rset, OutputStream ostream) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rset) + ", " + OracleLog.argument(ostream));
                    OracleLog.recursiveTrace = false;
                }
                this.writeXml(rset, new OutputStreamWriter(ostream));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleWebRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleWebRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

