/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet
implements JoinRowSet {
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins = new boolean[]{false, true, false, false, false};
    private int joinType;
    private Vector addedRowSets;
    private Vector addedRowSetNames;
    private Object lockForJoinActions;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:49_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleJoinRowSet() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.joinType = 1;
                this.addedRowSets = new Vector();
                this.addedRowSetNames = new Vector();
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRowSet(Joinable rowSet) throws SQLException {
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowSet));
                    OracleLog.recursiveTrace = false;
                }
                if (rowSet == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 350");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 350);
                }
                if (!(rowSet instanceof RowSet)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 351");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 351);
                }
                OracleCachedRowSet addedRowSet = this.checkAndWrapRowSet((RowSet)((Object)rowSet));
                String tblName = this.getMatchColumnTableName((RowSet)((Object)rowSet));
                switch (this.joinType) {
                    case 1: {
                        this.doInnerJoin(addedRowSet);
                        this.addedRowSets.add(rowSet);
                        this.addedRowSetNames.add(tblName);
                        break;
                    }
                    default: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 352");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 352);
                    }
                }
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRowSet(RowSet rowSet, int matchColumnIndex) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowSet) + ", " + OracleLog.argument(matchColumnIndex));
                    OracleLog.recursiveTrace = false;
                }
                ((OracleRowSet)((Object)rowSet)).setMatchColumn(matchColumnIndex);
                this.addRowSet((Joinable)((Object)rowSet));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRowSet(RowSet rowSet, String matchColumnName) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowSet) + ", " + OracleLog.argument(matchColumnName));
                    OracleLog.recursiveTrace = false;
                }
                ((OracleRowSet)((Object)rowSet)).setMatchColumn(matchColumnName);
                this.addRowSet((Joinable)((Object)rowSet));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRowSet(RowSet[] rowSets, int[] matchColumnIndexes) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowSets) + ", " + OracleLog.argument(matchColumnIndexes));
                    OracleLog.recursiveTrace = false;
                }
                if (rowSets.length != matchColumnIndexes.length) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 353");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 353);
                }
                for (int i2 = 0; i2 < rowSets.length; ++i2) {
                    ((OracleRowSet)((Object)rowSets[i2])).setMatchColumn(matchColumnIndexes[i2]);
                    this.addRowSet((Joinable)((Object)rowSets[i2]));
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addRowSet(RowSet[] rowSets, String[] matchColumnNames) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowSets) + ", " + OracleLog.argument(matchColumnNames));
                    OracleLog.recursiveTrace = false;
                }
                if (rowSets.length != matchColumnNames.length) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 353");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 353);
                }
                for (int i2 = 0; i2 < rowSets.length; ++i2) {
                    ((OracleRowSet)((Object)rowSets[i2])).setMatchColumn(matchColumnNames[i2]);
                    this.addRowSet((Joinable)((Object)rowSets[i2]));
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRowSets() throws SQLException {
        Vector vector;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.addedRowSets);
                    OracleLog.recursiveTrace = false;
                }
                vector = this.addedRowSets;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRowSetNames() throws SQLException {
        String[] stringArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Object[] objs = this.addedRowSetNames.toArray();
                String[] names = new String[objs.length];
                for (int i2 = 0; i2 < objs.length; ++i2) {
                    names[i2] = (String)objs[i2];
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + names);
                    OracleLog.recursiveTrace = false;
                }
                stringArray = names;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createCopy();
                ocrs.setCommand("");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ocrs);
                    OracleLog.recursiveTrace = false;
                }
                oracleCachedRowSet = ocrs;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleCachedRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJoinType() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.joinType);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.joinType;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsCrossJoin() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + supportedJoins[0]);
                    OracleLog.recursiveTrace = false;
                }
                bl = supportedJoins[0];
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsInnerJoin() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + supportedJoins[1]);
                    OracleLog.recursiveTrace = false;
                }
                bl = supportedJoins[1];
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsLeftOuterJoin() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + supportedJoins[2]);
                    OracleLog.recursiveTrace = false;
                }
                bl = supportedJoins[2];
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsRightOuterJoin() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + supportedJoins[3]);
                    OracleLog.recursiveTrace = false;
                }
                bl = supportedJoins[3];
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsFullJoin() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + supportedJoins[4]);
                    OracleLog.recursiveTrace = false;
                }
                bl = supportedJoins[4];
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJoinType(int jtype) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(jtype));
                    OracleLog.recursiveTrace = false;
                }
                if (jtype != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 352");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 352);
                }
                this.joinType = jtype;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getWhereClause() throws SQLException {
        String string;
        block13: {
            block11: {
                String string2;
                block12: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (this.addedRowSets.size() >= 2) break block11;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: WHERE");
                        OracleLog.recursiveTrace = false;
                    }
                    string2 = "WHERE";
                    if (!TRACE || OracleLog.recursiveTrace) break block12;
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return string2;
            }
            try {
                StringBuffer whereClause = new StringBuffer();
                whereClause.append("WHERE\n");
                OracleRowSet leftRowSet = (OracleRowSet)this.addedRowSets.get(0);
                int[] matchIndexesLeft = leftRowSet.getMatchColumnIndexes();
                ResultSetMetaData leftMd = leftRowSet.getMetaData();
                String leftTable = leftRowSet.getTableName();
                for (int i2 = 1; i2 < this.addedRowSets.size(); ++i2) {
                    if (i2 > 1) {
                        whereClause.append("\nAND\n");
                    }
                    OracleRowSet rightRowSet = (OracleRowSet)this.addedRowSets.get(i2);
                    int[] matchIndexesRight = rightRowSet.getMatchColumnIndexes();
                    ResultSetMetaData rightMd = rightRowSet.getMetaData();
                    String rightTable = rightRowSet.getTableName();
                    for (int j2 = 0; j2 < matchIndexesLeft.length; ++j2) {
                        if (j2 > 0) {
                            whereClause.append("\nAND\n");
                        }
                        whereClause.append("(" + leftTable + "." + leftMd.getColumnName(matchIndexesLeft[j2]) + " = " + rightTable + "." + rightMd.getColumnName(matchIndexesRight[j2]) + ")");
                    }
                    leftRowSet = rightRowSet;
                    matchIndexesLeft = matchIndexesRight;
                    leftMd = rightMd;
                    leftTable = rightTable;
                }
                whereClause.append(";");
                String __result__ = whereClause.toString();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block13;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleJoinRowSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInnerJoin(OracleCachedRowSet addedRowSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(addedRowSet));
                OracleLog.recursiveTrace = false;
            }
            if (this.addedRowSets.isEmpty()) {
                this.setMetaData((RowSetMetaData)addedRowSet.getMetaData());
                this.populate(addedRowSet);
                this.setMatchColumn(addedRowSet.getMatchColumnIndexes());
            } else {
                boolean isMatchColumn;
                Vector<OracleRow> newRows = new Vector<OracleRow>(100);
                OracleRowSetMetaData newMd = new OracleRowSetMetaData(10);
                int[] matchIndexesLeft = this.getMatchColumnIndexes();
                int[] matchIndexesRight = addedRowSet.getMatchColumnIndexes();
                int newColCount = this.getMetaData().getColumnCount() + addedRowSet.getMetaData().getColumnCount() - matchIndexesRight.length;
                newMd.setColumnCount(newColCount);
                String tableNameForMatchColumn = this.getTableName() + "#" + addedRowSet.getTableName();
                for (int indexLeft = 1; indexLeft <= this.colCount; ++indexLeft) {
                    isMatchColumn = false;
                    for (int j2 = 0; j2 < matchIndexesLeft.length; ++j2) {
                        if (indexLeft != matchIndexesLeft[j2]) continue;
                        isMatchColumn = true;
                        break;
                    }
                    this.setNewColumnMetaData(indexLeft, newMd, indexLeft, (RowSetMetaData)this.rowsetMetaData, isMatchColumn, tableNameForMatchColumn);
                }
                RowSetMetaData addedRowSetMd = (RowSetMetaData)addedRowSet.getMetaData();
                int addedRowSetColCount = addedRowSetMd.getColumnCount();
                int indexRightNew = this.colCount + 1;
                int[] indexesRightNew = new int[addedRowSetColCount];
                for (int indexRight = 1; indexRight <= addedRowSetColCount; ++indexRight) {
                    isMatchColumn = false;
                    for (int j3 = 0; j3 < matchIndexesRight.length; ++j3) {
                        if (indexRight != matchIndexesLeft[j3]) continue;
                        isMatchColumn = true;
                        break;
                    }
                    if (!isMatchColumn) {
                        this.setNewColumnMetaData(indexRightNew, newMd, indexRight, addedRowSetMd, isMatchColumn, tableNameForMatchColumn);
                        indexesRightNew[indexRight - 1] = indexRightNew++;
                        continue;
                    }
                    indexesRightNew[indexRight - 1] = -1;
                }
                this.beforeFirst();
                int addedRowSetRowCount = addedRowSet.size();
                boolean matchFound = false;
                for (int leftRow = 1; leftRow <= this.rowCount; ++leftRow) {
                    this.next();
                    addedRowSet.beforeFirst();
                    for (int rightRow = 1; rightRow <= addedRowSetRowCount; ++rightRow) {
                        addedRowSet.next();
                        matchFound = true;
                        for (int i2 = 0; i2 < matchIndexesLeft.length; ++i2) {
                            Object rightObj;
                            Object leftObj = this.getObject(matchIndexesLeft[i2]);
                            if (leftObj.equals(rightObj = addedRowSet.getObject(matchIndexesRight[i2]))) continue;
                            matchFound = false;
                            break;
                        }
                        if (!matchFound) continue;
                        OracleRow newRow = new OracleRow(newColCount, true);
                        for (int colLeft = 1; colLeft <= this.colCount; ++colLeft) {
                            newRow.updateObject(colLeft, this.getObject(colLeft));
                        }
                        for (int colRight = 1; colRight <= addedRowSetColCount; ++colRight) {
                            if (indexesRightNew[colRight - 1] == -1) continue;
                            newRow.updateObject(indexesRightNew[colRight - 1], addedRowSet.getObject(colRight));
                        }
                        newRows.add(newRow);
                    }
                }
                this.rows = newRows;
                this.presentRow = 0;
                this.rowCount = this.rows.size();
                this.setMetaData(newMd);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewColumnMetaData(int newColIndex, RowSetMetaData newMd, int origColIndex, RowSetMetaData origMd, boolean isMatchColumn, String tableNameForMatchColumn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(newColIndex) + ", " + OracleLog.argument(newMd) + ", " + OracleLog.argument(origColIndex) + ", " + OracleLog.argument(origMd) + ", " + OracleLog.argument(isMatchColumn) + ", " + OracleLog.argument(tableNameForMatchColumn));
                OracleLog.recursiveTrace = false;
            }
            newMd.setAutoIncrement(newColIndex, origMd.isAutoIncrement(origColIndex));
            newMd.setCaseSensitive(newColIndex, origMd.isCaseSensitive(origColIndex));
            newMd.setCatalogName(newColIndex, origMd.getCatalogName(origColIndex));
            newMd.setColumnDisplaySize(newColIndex, origMd.getColumnDisplaySize(origColIndex));
            if (isMatchColumn) {
                newMd.setColumnName(newColIndex, origMd.getColumnName(newColIndex) + MATCH_COLUMN_SUFFIX);
            } else {
                newMd.setColumnName(newColIndex, origMd.getColumnName(origColIndex));
            }
            newMd.setColumnLabel(newColIndex, newMd.getColumnName(origColIndex));
            newMd.setColumnType(newColIndex, origMd.getColumnType(origColIndex));
            newMd.setColumnTypeName(newColIndex, origMd.getColumnTypeName(origColIndex));
            newMd.setCurrency(newColIndex, origMd.isCurrency(origColIndex));
            newMd.setNullable(newColIndex, origMd.isNullable(origColIndex));
            newMd.setPrecision(newColIndex, origMd.getPrecision(origColIndex));
            newMd.setScale(newColIndex, origMd.getScale(origColIndex));
            newMd.setSchemaName(newColIndex, origMd.getSchemaName(origColIndex));
            newMd.setSearchable(newColIndex, origMd.isSearchable(origColIndex));
            newMd.setSigned(newColIndex, origMd.isSigned(origColIndex));
            if (isMatchColumn) {
                newMd.setTableName(newColIndex, tableNameForMatchColumn);
            } else {
                newMd.setTableName(newColIndex, origMd.getTableName(origColIndex));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowSet));
                OracleLog.recursiveTrace = false;
            }
            OracleCachedRowSet ocrs = null;
            if (rowSet instanceof OracleCachedRowSet) {
                ocrs = (OracleCachedRowSet)rowSet;
            } else if (rowSet instanceof OracleJDBCRowSet) {
                ocrs = new OracleCachedRowSet();
                ocrs.populate(rowSet);
                int[] matchIndexes = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
                ocrs.setMatchColumn(matchIndexes);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleJoinRowSet.logger().log(Level.SEVERE, "Throwing SQLException: 354");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 354);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "return: " + ocrs);
                OracleLog.recursiveTrace = false;
            }
            OracleCachedRowSet oracleCachedRowSet = ocrs;
            return oracleCachedRowSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMatchColumnTableName(RowSet rowset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset));
                OracleLog.recursiveTrace = false;
            }
            String tblName = null;
            if (rowset instanceof OracleRowSet) {
                tblName = ((OracleRowSet)((Object)rowset)).getTableName();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "return: " + tblName);
                OracleLog.recursiveTrace = false;
            }
            String string = tblName;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleJoinRowSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleJoinRowSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

