/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private StringBuffer updateClause;
    private StringBuffer deleteClause;
    private StringBuffer insertClause;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:49_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleCachedRowSetWriter() {
        block4: {
            this.updateClause = new StringBuffer("");
            this.deleteClause = new StringBuffer("");
            this.insertClause = new StringBuffer("");
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleCachedRowSetWriter.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchemaName(RowSet rowset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = rowset.getUsername();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableName(RowSet rowset) throws SQLException {
        try {
            StringTokenizer st;
            String tableName;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset));
                OracleLog.recursiveTrace = false;
            }
            if ((tableName = ((OracleCachedRowSet)rowset).getTableName()) != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + tableName);
                    OracleLog.recursiveTrace = false;
                }
                String string = tableName;
                return string;
            }
            String cmd = rowset.getCommand().toUpperCase();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.getTableName(RowSet),cmd=" + cmd);
                OracleLog.recursiveTrace = false;
            }
            int index = cmd.indexOf(" FROM ");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.getTableName(RowSet),index=" + index);
                OracleLog.recursiveTrace = false;
            }
            if (index == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(Level.SEVERE, "Throwing SQLException: 343" + (cmd != "" ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string."));
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 343, cmd != "" ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string.");
            }
            String tab = cmd.substring(index + 6).trim();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.getTableName(), tab=" + tab);
                OracleLog.recursiveTrace = false;
            }
            if ((st = new StringTokenizer(tab)).hasMoreTokens()) {
                tab = st.nextToken();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + tab);
                OracleLog.recursiveTrace = false;
            }
            String string = tab;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSQLStatement(RowSet rowset) throws SQLException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset));
                OracleLog.recursiveTrace = false;
            }
            this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowset) + "(");
            this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
            this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
            this.rsmd = rowset.getMetaData();
            this.columnCount = this.rsmd.getColumnCount();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.initSQLStatement(RowSet), insertClause=" + this.insertClause + ", updateClause=" + this.updateClause + ", deleteClause=" + this.deleteClause + ", rsmd=" + this.rsmd + ", columnCount=" + this.columnCount);
                OracleLog.recursiveTrace = false;
            }
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(this.rsmd.getColumnName(i2 + 1));
                if (i2 != 0) {
                    this.updateClause.append(", ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                if (i2 != 0) {
                    this.deleteClause.append(" AND ");
                }
                this.deleteClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(") VALUES (");
            this.updateClause.append(" WHERE ");
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(":" + i2);
                if (i2 != 0) {
                    this.updateClause.append(" AND ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(")");
            this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
            this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
            this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.initSQLStatement(RowSet), insertStmt=" + this.insertStmt + ", updateStmt=" + this.updateStmt + ", deleteStmt=" + this.deleteStmt);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertRow(OracleRow row) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            this.insertStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.insertRow(OracleRow), o=" + o2);
                    OracleLog.recursiveTrace = false;
                }
                if (o2 == null) {
                    this.insertStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                this.insertStmt.setObject(i2, o2);
            }
            boolean bl = __result__ = this.insertStmt.executeUpdate() == 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRow(RowSet rowset, OracleRow row) throws SQLException {
        try {
            boolean __result__;
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            this.updateStmt.clearParameters();
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.updateRow(OracleRow), o=" + o2);
                    OracleLog.recursiveTrace = false;
                }
                if (o2 == null) {
                    this.updateStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                this.updateStmt.setObject(i2, o2);
            }
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (row.isOriginalNull(i2)) {
                    boolean __result__2 = this.updateRowWithNull(rowset, row);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__2);
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = __result__2;
                    return bl;
                }
                this.updateStmt.setObject(i2 + this.columnCount, row.getColumn(i2));
            }
            boolean bl = __result__ = this.updateStmt.executeUpdate() == 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            boolean returnValue = false;
            StringBuffer updateClauseWithNull = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    updateClauseWithNull.append(", ");
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            updateClauseWithNull.append(" WHERE ");
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    updateClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i2)) {
                    updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                    continue;
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            Statement stmt = null;
            try {
                int i3;
                stmt = this.connection.prepareStatement(updateClauseWithNull.substring(0, updateClauseWithNull.length()));
                for (i3 = 1; i3 <= this.columnCount; ++i3) {
                    Object o2 = null;
                    Object object = o2 = row.isColumnChanged(i3) ? row.getModifiedColumn(i3) : row.getColumn(i3);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.updateRowWithNull(OracleRow), o=" + o2);
                        OracleLog.recursiveTrace = false;
                    }
                    if (o2 == null) {
                        stmt.setNull(i3, this.rsmd.getColumnType(i3));
                        continue;
                    }
                    stmt.setObject(i3, o2);
                }
                int columnIndex = 1;
                for (i3 = 1; i3 <= this.columnCount; ++i3) {
                    if (row.isOriginalNull(i3)) continue;
                    stmt.setObject(columnIndex + this.columnCount, row.getColumn(i3));
                    ++columnIndex;
                }
                returnValue = stmt.executeUpdate() == 1;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + returnValue);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = returnValue;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRow(RowSet rowset, OracleRow row) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            this.deleteStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (row.isOriginalNull(i2)) {
                    boolean __result__2 = this.deleteRowWithNull(rowset, row);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__2);
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = __result__2;
                    return bl;
                }
                Object o2 = row.getColumn(i2);
                if (o2 == null) {
                    this.deleteStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                this.deleteStmt.setObject(i2, o2);
            }
            boolean bl = __result__ = this.deleteStmt.executeUpdate() == 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                OracleLog.recursiveTrace = false;
            }
            boolean returnValue = false;
            StringBuffer deleteClauseWithNull = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    deleteClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i2)) {
                    deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                    continue;
                }
                deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            Statement stmt = null;
            try {
                stmt = this.connection.prepareStatement(deleteClauseWithNull.substring(0, deleteClauseWithNull.length()));
                int columnIndex = 1;
                for (int i3 = 1; i3 <= this.columnCount; ++i3) {
                    if (row.isOriginalNull(i3)) continue;
                    stmt.setObject(columnIndex++, row.getColumn(i3));
                }
                returnValue = stmt.executeUpdate() == 1;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + returnValue);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = returnValue;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean writeData(RowSetInternal rowsetInternal) throws SQLException {
        boolean bl;
        block23: {
            OracleCachedRowSet rowset;
            block21: {
                boolean exc2;
                block22: {
                    block20: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetWriter.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rowsetInternal));
                            OracleLog.recursiveTrace = false;
                        }
                        rowset = (OracleCachedRowSet)rowsetInternal;
                        this.connection = ((OracleCachedRowSetReader)rowset.getReader()).getConnection(rowsetInternal);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.writeData(RowSetInternal),connection=" + this.connection + ",columnCount=" + this.columnCount);
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.connection == null) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleCachedRowSetWriter.logger().log(Level.SEVERE, "Throwing SQLException: 342");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 342);
                        }
                        if (this.connection.getAutoCommit()) {
                            this.connection.setAutoCommit(false);
                        }
                        try {
                            this.connection.setTransactionIsolation(rowset.getTransactionIsolation());
                        }
                        catch (Exception exc2) {
                            if (!TRACE || OracleLog.recursiveTrace) break block20;
                            OracleLog.recursiveTrace = true;
                            OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.writeData(), setTransactionIsolation() throws exception: " + exc2);
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    this.initSQLStatement(rowset);
                    if (this.columnCount >= 1) break block21;
                    this.connection.close();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleCachedRowSetWriter.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                        OracleLog.recursiveTrace = false;
                    }
                    exc2 = true;
                    if (!TRACE || OracleLog.recursiveTrace) break block22;
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return exc2;
            }
            try {
                boolean oldFlag = rowset.getShowDeleted();
                rowset.setShowDeleted(true);
                rowset.beforeFirst();
                boolean updateFlag = true;
                boolean insertFlag = true;
                boolean deleteFlag = true;
                OracleRow row = null;
                while (rowset.next()) {
                    if (rowset.rowInserted()) {
                        if (rowset.rowDeleted()) continue;
                        row = rowset.getCurrentRow();
                        insertFlag = this.insertRow(row) || insertFlag;
                        continue;
                    }
                    if (rowset.rowUpdated()) {
                        row = rowset.getCurrentRow();
                        updateFlag = this.updateRow(rowset, row) || updateFlag;
                        continue;
                    }
                    if (!rowset.rowDeleted()) continue;
                    row = rowset.getCurrentRow();
                    deleteFlag = this.deleteRow(rowset, row) || deleteFlag;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, "Debug: OracleCachedRowSetWriter.writeData(RowSetInternal),oldFlag=" + oldFlag + ", updateFlag=" + updateFlag + ", insertFlag=" + insertFlag + ", deleteFlag" + deleteFlag + ", row=" + row);
                    OracleLog.recursiveTrace = false;
                }
                if (updateFlag && insertFlag && deleteFlag) {
                    this.connection.commit();
                    rowset.setOriginal();
                } else {
                    this.connection.rollback();
                }
                this.insertStmt.close();
                this.updateStmt.close();
                this.deleteStmt.close();
                if (!rowset.isConnectionStayingOpen()) {
                    this.connection.close();
                }
                rowset.setShowDeleted(oldFlag);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block23;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleCachedRowSetWriter.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleCachedRowSetWriter.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetWriter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

