/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;

class OracleRuntimeLoadBalancingEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    String m_service;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:44_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleRuntimeLoadBalancingEventHandlerThread(String service) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(service));
                OracleLog.recursiveTrace = false;
            }
            this.m_service = service;
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Subscriber sub = null;
            final String type = "%\"eventType=database/event/servicemetrics/" + this.m_service + "\"";
            while (this.cacheManager.failoverEnabledCacheExists()) {
                block16: {
                    block15: {
                        try {
                            sub = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws ONSException {
                                    return new Subscriber(type, "", 30000L);
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            if (!TRACE || OracleLog.recursiveTrace) break block15;
                            OracleLog.recursiveTrace = true;
                            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_10, "Event: OracleRuntimeLoadBalancingEventHandlerThread.run() - PrivilegedActionException:" + e2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    if (sub != null) {
                        try {
                            while (this.cacheManager.failoverEnabledCacheExists()) {
                                this.event = sub.receive(300000L);
                                if (this.event == null) continue;
                                this.handleEvent(this.event);
                            }
                        }
                        catch (ONSException e3) {
                            sub.close();
                            if (!TRACE || OracleLog.recursiveTrace) break block16;
                            OracleLog.recursiveTrace = true;
                            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_10, "Event: OracleRuntimeLoadBalancingEventHandlerThread.run()- ONSException " + e3.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ea) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_20, "Debug: OracleRuntimeLoadBalancingEventHandlerThread.run Got an InterruptedException" + ea.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEvent(Notification event) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(event));
                OracleLog.recursiveTrace = false;
            }
            try {
                this.cacheManager.parseRuntimeLoadBalancingEvent(this.m_service, event == null ? null : event.body());
            }
            catch (SQLException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_20, "Debug: OracleRuntimeLoadBalancingEventHandlerThread.handleEvent() - SQLException:" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

