/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:44_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oicc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oicc));
                OracleLog.recursiveTrace = false;
            }
            this.implicitCache = oicc;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long threadTTLTimeout = 0L;
            long threadInactivityTimeout = 0L;
            long threadAbandonedTimeout = 0L;
            while (this.timeToLive) {
                try {
                    if (this.timeToLive && (threadTTLTimeout = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                        this.runTimeToLiveTimeout(threadTTLTimeout);
                    }
                    if (this.timeToLive && (threadInactivityTimeout = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                        this.runInactivityTimeout();
                    }
                    if (this.timeToLive && (threadAbandonedTimeout = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                        this.runAbandonedTimeout(threadAbandonedTimeout);
                    }
                    if (this.timeToLive) {
                        block14: {
                            this.isSleeping = true;
                            try {
                                OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                            }
                            catch (InterruptedException ie) {
                                if (!TRACE || OracleLog.recursiveTrace) break block14;
                                OracleLog.recursiveTrace = true;
                                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.run() - InterruptedException" + ie.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                        }
                        this.isSleeping = false;
                    }
                    if (this.implicitCache != null && (threadTTLTimeout > 0L || threadInactivityTimeout > 0L || threadAbandonedTimeout > 0L)) continue;
                    this.timeToLive = false;
                }
                catch (SQLException e2) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.run() - SQL Exceoption " + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeToLiveTimeout(long threadTTLTimeout) throws SQLException {
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(threadTTLTimeout));
                    OracleLog.recursiveTrace = false;
                }
                long connCurrTime = 0L;
                long connStartTime = 0L;
                if (this.implicitCache.getNumberOfCheckedOutConnections() <= 0) break block12;
                OraclePooledConnection pc = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    int sz = this.implicitCache.checkedOutConnectionList.size();
                    for (int k2 = 0; k2 < sz; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        Connection conn = pc.getLogicalHandle();
                        if (conn == null) continue;
                        connStartTime = ((OracleConnection)conn).getStartTime();
                        connCurrTime = System.currentTimeMillis();
                        if (connCurrTime - connStartTime <= threadTTLTimeout * 1000L) continue;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.runTimeToLiveTimeout():TTL Timeout expired... Executing cancel()/close()");
                            OracleLog.recursiveTrace = false;
                        }
                        try {
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            continue;
                        }
                        catch (SQLException e2) {
                            if (!TRACE || OracleLog.recursiveTrace) continue;
                            OracleLog.recursiveTrace = true;
                            OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.runTimeToLiveTimeout() - while closeCheckedOutConnection - SQLException:" + e2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInactivityTimeout() {
        try {
            block8: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                try {
                    this.implicitCache.doForEveryCachedConnection(4);
                }
                catch (SQLException e2) {
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.runInactivityTimeout() - while doForEveryCachedConnection - SQLException:" + e2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            return;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAbandonedTimeout(long abandonedTimeout) throws SQLException {
        block13: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(abandonedTimeout));
                    OracleLog.recursiveTrace = false;
                }
                if (this.implicitCache.getNumberOfCheckedOutConnections() <= 0) break block13;
                OraclePooledConnection pc = null;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
                synchronized (oracleImplicitConnectionCache) {
                    Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                    for (int k2 = 0; k2 < ObjArr.length; ++k2) {
                        pc = (OraclePooledConnection)ObjArr[k2];
                        OracleConnection conn = (OracleConnection)pc.getLogicalHandle();
                        if (conn == null) continue;
                        OracleConnectionCacheCallback occc = conn.getConnectionCacheCallbackObj();
                        if ((long)(conn.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= abandonedTimeout) continue;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.runAbandonedTimeout():Abandoned Timeout expired...Executing cancel()/close()");
                            OracleLog.recursiveTrace = false;
                        }
                        try {
                            boolean closeCheckedOutConnection = true;
                            if (occc != null && (conn.getConnectionCacheCallbackFlag() == 4 || conn.getConnectionCacheCallbackFlag() == 1)) {
                                closeCheckedOutConnection = occc.handleAbandonedConnection(conn, conn.getConnectionCacheCallbackPrivObj());
                            }
                            if (!closeCheckedOutConnection) continue;
                            this.implicitCache.closeCheckedOutConnection(pc, true);
                            continue;
                        }
                        catch (SQLException e2) {
                            if (!TRACE || OracleLog.recursiveTrace) continue;
                            OracleLog.recursiveTrace = true;
                            OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCacheThread.runAbandonedTimeout() - while closeCheckedOutConnection -  SQLException:" + e2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleImplicitConnectionCacheThread.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleImplicitConnectionCacheThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

