/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

class OracleFailoverWorkerThread
extends Thread {
    protected OracleImplicitConnectionCache implicitCache = null;
    protected int eventType = 0;
    protected String eventServiceName = null;
    protected String instanceNameKey = null;
    protected String databaseNameKey = null;
    protected String hostNameKey = null;
    protected String status = null;
    protected int cardinality = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:44_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleFailoverWorkerThread(OracleImplicitConnectionCache oicc, int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oicc) + ", " + OracleLog.argument(eventType) + ", " + OracleLog.argument(instNameKey) + ", " + OracleLog.argument(dbUniqNameKey) + ", " + OracleLog.argument(hostNameKey) + ", " + OracleLog.argument(status) + ", " + OracleLog.argument(card));
                OracleLog.recursiveTrace = false;
            }
            this.implicitCache = oicc;
            this.eventType = eventType;
            this.instanceNameKey = instNameKey;
            this.databaseNameKey = dbUniqNameKey;
            this.hostNameKey = hostNameKey;
            this.status = status;
            this.cardinality = card;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.status != null) {
                    this.implicitCache.processFailoverEvent(this.eventType, this.instanceNameKey, this.databaseNameKey, this.hostNameKey, this.status, this.cardinality);
                }
            }
            catch (Exception ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_20, "Debug: OracleImplicitConnectionCache.OracleFailoverWorkerThread()\neventType=" + this.eventType + "\ninstanceName=" + this.instanceNameKey + "\ndatabaseName=" + this.databaseNameKey + "\nhostName=" + this.hostNameKey + "\nstatus=" + this.status + "\ncardinality=" + this.cardinality + "\n" + ex.getMessage());
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleFailoverWorkerThread.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleFailoverWorkerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

