/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleDataSourceFactory
implements ObjectFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:43_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        OracleDataSource oracleDataSource;
        block43: {
            StringRefAddr st;
            Properties info;
            String cn;
            OracleDataSource ods;
            Reference ref;
            block41: {
                Object pn_conn_min_limit2;
                block42: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleDataSourceFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(refObj) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(nameCtx) + ", " + OracleLog.argument(env));
                            OracleLog.recursiveTrace = false;
                        }
                        ref = (Reference)refObj;
                        ods = null;
                        cn = ref.getClassName();
                        info = new Properties();
                        if (cn.equals("oracle.jdbc.pool.OracleDataSource") || cn.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
                            String isFailoverEnabled;
                            String isCacheEnabled;
                            ods = cn.equals("oracle.jdbc.pool.OracleDataSource") ? new OracleDataSource() : new OracleXADataSource();
                            st = null;
                            st = (StringRefAddr)ref.get("connectionCachingEnabled");
                            if (st != null && (isCacheEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                                ods.setConnectionCachingEnabled(true);
                            }
                            if ((st = (StringRefAddr)ref.get("connectionCacheName")) != null) {
                                ods.setConnectionCacheName((String)st.getContent());
                            }
                            if ((st = (StringRefAddr)ref.get("connectionCacheProperties")) != null) {
                                String val = (String)st.getContent();
                                Properties props = this.extractConnectionCacheProperties(val);
                                ods.setConnectionCacheProperties(props);
                            }
                            if ((st = (StringRefAddr)ref.get("fastConnectionFailoverEnabled")) != null && (isFailoverEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                                ods.setFastConnectionFailoverEnabled(true);
                            }
                            if ((st = (StringRefAddr)ref.get("onsConfigStr")) != null) {
                                ods.setONSConfiguration((String)st.getContent());
                            }
                            break block41;
                        }
                        if (cn.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource")) {
                            ods = new OracleConnectionPoolDataSource();
                            break block41;
                        }
                        if (cn.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
                            ods = new OracleOCIConnectionPool();
                            String pn_conn_min_limit2 = null;
                            String pn_conn_max_limit = null;
                            String pn_conn_increment = null;
                            String pn_conn_active_size = null;
                            String pn_conn_pool_size = null;
                            String pn_conn_timeout = null;
                            String pn_conn_nowait = null;
                            StringRefAddr st2 = null;
                            Object pn = null;
                            String pn_txn_dist = null;
                            st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT);
                            if (st2 != null) {
                                pn_conn_min_limit2 = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT)) != null) {
                                pn_conn_max_limit = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_INCREMENT)) != null) {
                                pn_conn_increment = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_ACTIVE_SIZE)) != null) {
                                pn_conn_active_size = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_POOL_SIZE)) != null) {
                                pn_conn_pool_size = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_TIMEOUT)) != null) {
                                pn_conn_timeout = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_NOWAIT)) != null) {
                                pn_conn_nowait = (String)st2.getContent();
                            }
                            if ((st2 = (StringRefAddr)ref.get("transactions_distributed")) != null) {
                                pn_txn_dist = (String)st2.getContent();
                            }
                            info.put(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT, pn_conn_min_limit2);
                            info.put(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT, pn_conn_max_limit);
                            info.put(OracleOCIConnectionPool.CONNPOOL_INCREMENT, pn_conn_increment);
                            info.put(OracleOCIConnectionPool.CONNPOOL_ACTIVE_SIZE, pn_conn_active_size);
                            info.put(OracleOCIConnectionPool.CONNPOOL_POOL_SIZE, pn_conn_pool_size);
                            info.put(OracleOCIConnectionPool.CONNPOOL_TIMEOUT, pn_conn_timeout);
                            if (pn_conn_nowait == "true") {
                                info.put(OracleOCIConnectionPool.CONNPOOL_NOWAIT, pn_conn_nowait);
                            }
                            if (pn_txn_dist == "true") {
                                info.put("transactions_distributed", pn_txn_dist);
                            }
                            break block41;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleDataSourceFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                            OracleLog.recursiveTrace = false;
                        }
                        pn_conn_min_limit2 = null;
                        if (!TRACE || OracleLog.recursiveTrace) break block42;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleDataSourceFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleDataSourceFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return pn_conn_min_limit2;
            }
            if (ods != null) {
                st = null;
                st = (StringRefAddr)ref.get("url");
                if (st != null) {
                    ods.setURL((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("userName")) != null || (st = (StringRefAddr)ref.get("u")) != null || (st = (StringRefAddr)ref.get("user")) != null) {
                    ods.setUser((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("passWord")) != null || (st = (StringRefAddr)ref.get("password")) != null) {
                    ods.setPassword((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("description")) != null || (st = (StringRefAddr)ref.get("describe")) != null) {
                    ods.setDescription((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("driverType")) != null || (st = (StringRefAddr)ref.get("driver")) != null) {
                    ods.setDriverType((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("serverName")) != null || (st = (StringRefAddr)ref.get("host")) != null) {
                    ods.setServerName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("databaseName")) != null || (st = (StringRefAddr)ref.get("sid")) != null) {
                    ods.setDatabaseName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("serviceName")) != null) {
                    ods.setServiceName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("networkProtocol")) != null || (st = (StringRefAddr)ref.get("protocol")) != null) {
                    ods.setNetworkProtocol((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("portNumber")) != null || (st = (StringRefAddr)ref.get("port")) != null) {
                    String pn = (String)st.getContent();
                    ods.setPortNumber(Integer.parseInt(pn));
                }
                if ((st = (StringRefAddr)ref.get("tnsentryname")) != null || (st = (StringRefAddr)ref.get("tns")) != null) {
                    ods.setTNSEntryName((String)st.getContent());
                } else if (cn.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
                    String pn_is_poolCreated = null;
                    st = (StringRefAddr)ref.get(OracleOCIConnectionPool.CONNPOOL_IS_POOLCREATED);
                    if (st != null) {
                        pn_is_poolCreated = (String)st.getContent();
                    }
                    if (pn_is_poolCreated.equals(String.valueOf("true"))) {
                        ((OracleOCIConnectionPool)ods).setPoolConfig(info);
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ods);
                OracleLog.recursiveTrace = false;
            }
            oracleDataSource = ods;
            if (!TRACE || OracleLog.recursiveTrace) break block43;
            OracleLog.recursiveTrace = true;
            OracleDataSourceFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionCacheProperties(String val) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(val));
                OracleLog.recursiveTrace = false;
            }
            Properties cprops = new Properties();
            int awIdx = (val = val.substring(1, val.length() - 1)).indexOf("AttributeWeights", 0);
            if (awIdx >= 0) {
                StringTokenizer strTokens1;
                if (val.charAt(awIdx + 16) != '=' || awIdx > 0 && val.charAt(awIdx - 1) != ' ') {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleDataSourceFactory.logger().log(Level.SEVERE, "Throwing SQLException: 139");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 139);
                }
                Properties awProps = new Properties();
                int awLastIdx = val.indexOf("}", awIdx);
                String tmpawStr = val.substring(awIdx, awLastIdx);
                String awStr = tmpawStr.substring(18);
                StringTokenizer stringTokenizer = strTokens1 = new StringTokenizer(awStr, ", ");
                synchronized (stringTokenizer) {
                    while (strTokens1.hasMoreTokens()) {
                        String strTkn = strTokens1.nextToken();
                        int len = strTkn.length();
                        int equalsIndex = strTkn.indexOf("=");
                        String key = strTkn.substring(0, equalsIndex);
                        String value = strTkn.substring(equalsIndex + 1, len);
                        awProps.setProperty(key, value);
                    }
                }
                cprops.put("AttributeWeights", awProps);
                if (awIdx > 0 && awLastIdx + 1 == val.length()) {
                    val = val.substring(0, awIdx - 2);
                } else if (awIdx > 0 && awLastIdx + 1 < val.length()) {
                    String valA = val.substring(0, awIdx - 2);
                    String valB = val.substring(awLastIdx + 1, val.length());
                    val = valA.concat(valB);
                } else {
                    val = val.substring(awLastIdx + 2, val.length());
                }
            }
            StringTokenizer strTokens2 = new StringTokenizer(val, ", ");
            Object object = strTokens2;
            synchronized (object) {
                while (strTokens2.hasMoreTokens()) {
                    String strTkn = strTokens2.nextToken();
                    int len = strTkn.length();
                    int equalsIndex = strTkn.indexOf("=");
                    String key = strTkn.substring(0, equalsIndex);
                    String value = strTkn.substring(equalsIndex + 1, len);
                    cprops.setProperty(key, value);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "return: " + cprops);
                OracleLog.recursiveTrace = false;
            }
            object = cprops;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDataSourceFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSourceFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

