/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:43_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnectionPoolDataSource() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.dataSourceName = "OracleConnectionPoolDataSource";
                this.isOracleDataSource = false;
                this.connCachingEnabled = false;
                this.fastConnFailover = false;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        PooledConnection pooledConnection;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String localUser = null;
                String localPassword = null;
                OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
                synchronized (oracleConnectionPoolDataSource) {
                    localUser = this.user;
                    localPassword = this.password;
                }
                PooledConnection __result__ = this.getPooledConnection(localUser, localPassword);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                pooledConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String _user, String _passwd) throws SQLException {
        OraclePooledConnection oraclePooledConnection;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(_user) + ", " + OracleLog.argument(_passwd));
                    OracleLog.recursiveTrace = false;
                }
                Connection conn = this.getPhysicalConnection(this.url, _user, _passwd);
                OraclePooledConnection opc = new OraclePooledConnection(conn);
                if (_passwd == null) {
                    _passwd = this.password;
                }
                opc.setUserName(!_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + opc);
                    OracleLog.recursiveTrace = false;
                }
                oraclePooledConnection = opc;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleConnectionPoolDataSource.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledConnection getPooledConnection(Properties prop) throws SQLException {
        try {
            String _passwd;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(prop));
                OracleLog.recursiveTrace = false;
            }
            Connection conn = this.getPhysicalConnection(prop);
            OraclePooledConnection opc = new OraclePooledConnection(conn);
            String _user = prop.getProperty("user");
            if (_user == null) {
                _user = ((OracleConnection)conn).getUserName();
            }
            if ((_passwd = prop.getProperty("password")) == null) {
                _passwd = this.password;
            }
            opc.setUserName(!_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "return: " + opc);
                OracleLog.recursiveTrace = false;
            }
            OraclePooledConnection oraclePooledConnection = opc;
            return oraclePooledConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Connection __result__ = super.getConnection(this.user, this.password);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Connection connection = __result__;
            return connection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(String _url, String _user, String _passwd) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_url) + ", " + OracleLog.argument(_user) + ", " + OracleLog.argument(_passwd));
                OracleLog.recursiveTrace = false;
            }
            this.url = _url;
            Connection __result__ = super.getConnection(_user, _passwd);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Connection connection = __result__;
            return connection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(String _user, String _passwd) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_user) + ", " + OracleLog.argument(_passwd));
                OracleLog.recursiveTrace = false;
            }
            Connection __result__ = super.getConnection(_user, _passwd);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Connection connection = __result__;
            return connection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConnectionPoolDataSource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionPoolDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

