/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class Util {
    private static int[] ldsRoundTable = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:24_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkNextByte(InputStream in, byte value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            try {
                if (in.read() != value) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        Util.logger().log(Level.SEVERE, "Throwing SQLException: 47parseTDS");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 47, "parseTDS");
                }
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] toJavaUnsignedBytes(byte[] array) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(array));
                OracleLog.recursiveTrace = false;
            }
            int[] result = new int[array.length];
            for (int i2 = 0; i2 < array.length; ++i2) {
                result[i2] = array[i2] & 0xFF;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readBytes(InputStream in, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            byte[] array = new byte[length];
            try {
                int length_read = in.read(array);
                if (length_read != length) {
                    byte[] final_bytes = new byte[length_read];
                    System.arraycopy(array, 0, final_bytes, 0, length_read);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        Util.logger().log(OracleLog.TRACE_30, "return: " + final_bytes);
                        OracleLog.recursiveTrace = false;
                    }
                    byte[] byArray = final_bytes;
                    return byArray;
                }
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + array);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = array;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBytes(OutputStream out, byte[] array) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out) + ", " + OracleLog.argument(array));
                OracleLog.recursiveTrace = false;
            }
            try {
                out.write(array);
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void skipBytes(InputStream in, int byte_num) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in) + ", " + OracleLog.argument(byte_num));
                OracleLog.recursiveTrace = false;
            }
            try {
                in.skip(byte_num);
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLong(InputStream in) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            byte[] bytes = new byte[4];
            try {
                in.read(bytes);
                long __result__ = (((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF)) * 256 + (bytes[2] & 0xFF)) * 256 + (bytes[3] & 0xFF);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                long l2 = __result__;
                return l2;
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
                long __result__ = 0L;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                long l3 = __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return l3;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short readShort(InputStream in) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            byte[] bytes = new byte[2];
            try {
                in.read(bytes);
                short __result__ = (short)((bytes[0] & 0xFF) * 256 + (bytes[1] & 0xFF));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                short s2 = __result__;
                return s2;
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
                short __result__ = 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                short s3 = __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return s3;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte readByte(InputStream in) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            try {
                byte __result__ = (byte)in.read();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte by = __result__;
                return by;
            }
            catch (IOException ex) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, ex);
                byte __result__ = 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte by = __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return by;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte fdoGetSize(byte[] FDO, int mapping_offset) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                OracleLog.recursiveTrace = false;
            }
            byte value = Util.fdoGetEntry(FDO, mapping_offset);
            byte __result__ = (byte)(value >> 3 & 0x1F);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte fdoGetAlign(byte[] FDO, int mapping_offset) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                OracleLog.recursiveTrace = false;
            }
            byte value = Util.fdoGetEntry(FDO, mapping_offset);
            byte __result__ = (byte)(value & 7);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int ldsRound(int size, int alignvalue) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(size) + ", " + OracleLog.argument(alignvalue));
                OracleLog.recursiveTrace = false;
            }
            int sval = ldsRoundTable[alignvalue];
            int __result__ = (size >> sval) + 1 << sval;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte fdoGetEntry(byte[] FDO, int mapping_offset) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(FDO) + ", " + OracleLog.argument(mapping_offset));
                OracleLog.recursiveTrace = false;
            }
            short fdo_5 = Util.getUnsignedByte(FDO[5]);
            byte value = FDO[6 + fdo_5 + mapping_offset];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + value);
                OracleLog.recursiveTrace = false;
            }
            byte by = value;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getUnsignedByte(byte b2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(b2));
                OracleLog.recursiveTrace = false;
            }
            short __result__ = (short)(b2 & 0xFF);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Object obj) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj));
                OracleLog.recursiveTrace = false;
            }
            if (obj == null) {
                byte[] __result__ = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = __result__;
                return byArray;
            }
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p2 = new ObjectOutputStream(ostream);
            p2.writeObject(obj);
            p2.flush();
            byte[] __result__ = ostream.toByteArray();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            if (bytes == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    Util.logger().log(OracleLog.TRACE_30, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var1_1 = null;
                return var1_1;
            }
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            Object __result__ = new ObjectInputStream(istream).readObject();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public static void printByteArray(byte[] x) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                Util.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.Util"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

