/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:24_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    public UnpickleContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnpickleContext(byte[] image, int begin_offset, boolean[] null_bytes, long[] lds_offset_array, boolean big_endian) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(image) + ", " + OracleLog.argument(begin_offset) + ", " + OracleLog.argument(null_bytes) + ", " + OracleLog.argument(lds_offset_array) + ", " + OracleLog.argument(big_endian));
                OracleLog.recursiveTrace = false;
            }
            this.image = image;
            this.beginOffset = begin_offset;
            this.absoluteOffset = begin_offset;
            this.bigEndian = big_endian;
            this.nullIndicators = null_bytes;
            this.patches = null;
            this.ldsOffsets = lds_offset_array;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                byte __result__ = this.image[this.absoluteOffset];
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte by = __result__;
                ++this.absoluteOffset;
                return by;
            }
            catch (Throwable throwable) {
                ++this.absoluteOffset;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readVarNumBytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] varNumBytes = new byte[this.image[this.absoluteOffset] & 0xFF];
            try {
                System.arraycopy(this.image, this.absoluteOffset + 1, varNumBytes, 0, varNumBytes.length);
            }
            finally {
                this.absoluteOffset += 22;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + varNumBytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = varNumBytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPtrBytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] bytes = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
            System.arraycopy(this.image, this.absoluteOffset, bytes, 0, bytes.length);
            this.absoluteOffset += bytes.length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + bytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipPtrBytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(n2));
                OracleLog.recursiveTrace = false;
            }
            try {
                byte[] bytes = new byte[n2];
                System.arraycopy(this.image, this.absoluteOffset, bytes, 0, n2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + bytes);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = bytes;
                this.absoluteOffset += n2;
                return byArray;
            }
            catch (Throwable throwable) {
                this.absoluteOffset += n2;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                long __result__ = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                long l2 = __result__;
                this.absoluteOffset += 4;
                return l2;
            }
            catch (Throwable throwable) {
                this.absoluteOffset += 4;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                short __result__ = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                short s2 = __result__;
                this.absoluteOffset += 2;
                return s2;
            }
            catch (Throwable throwable) {
                this.absoluteOffset += 2;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLengthBytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long variable_length = this.readLong();
            byte[] __result__ = this.readBytes((int)variable_length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipLengthBytes() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long variable_length = this.readLong();
            this.absoluteOffset = (int)((long)this.absoluteOffset + variable_length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(long offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (offset > (long)(this.absoluteOffset - this.beginOffset)) {
                this.absoluteOffset = this.beginOffset + (int)offset;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(int offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (offset > this.absoluteOffset - this.beginOffset) {
                this.absoluteOffset = this.beginOffset + offset;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.markedOffset = this.absoluteOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.absoluteOffset = this.markedOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAndSkip() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.markedOffset = this.absoluteOffset + 4;
            this.absoluteOffset = this.beginOffset + (int)this.readLong();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAndSkip(long offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            this.markedOffset = this.absoluteOffset;
            this.absoluteOffset = this.beginOffset + (int)offset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipBytes(int n2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(n2));
                OracleLog.recursiveTrace = false;
            }
            if (n2 >= 0) {
                this.absoluteOffset += n2;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull(int idx) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx));
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = this.nullIndicators[idx];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int absoluteOffset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.absoluteOffset);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.absoluteOffset;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.absoluteOffset - this.beginOffset;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] image() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "return: " + this.image);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.image;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                UnpickleContext.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.UnpickleContext"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

