/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class TDSReader {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    long fixedDataSize;
    Vector patches;
    byte[] tds;
    int beginIndex;
    int index;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:24_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TDSReader(byte[] tds, long beginIndex) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tds) + ", " + OracleLog.argument(beginIndex));
                OracleLog.recursiveTrace = false;
            }
            this.fixedDataSize = 0L;
            this.patches = null;
            this.tds = tds;
            this.beginIndex = (int)beginIndex;
            this.index = (int)beginIndex;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void skipBytes(int number) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(number));
                OracleLog.recursiveTrace = false;
            }
            this.index += number;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNextByte(byte value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            try {
                if (value != this.tds[this.index]) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TDSReader.logger().log(Level.SEVERE, "Throwing SQLException: 47parseTDS");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
                }
            }
            finally {
                ++this.index;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte readByte() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                byte __result__ = this.tds[this.index];
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                byte by = __result__;
                ++this.index;
                return by;
            }
            catch (Throwable throwable) {
                ++this.index;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readUnsignedByte() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                int __result__ = this.tds[this.index] & 0xFF;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                ++this.index;
                return n2;
            }
            catch (Throwable throwable) {
                ++this.index;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readUB2() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                int __result__ = ((this.tds[this.index] & 0xFF) << 8) + (this.tds[this.index + 1] & 0xFF);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                this.index += 2;
                return n2;
            }
            catch (Throwable throwable) {
                this.index += 2;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readLong() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                long __result__ = (((this.tds[this.index] & 0xFF) * 256 + (this.tds[this.index + 1] & 0xFF)) * 256 + (this.tds[this.index + 2] & 0xFF)) * 256 + (this.tds[this.index + 3] & 0xFF);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                long l2 = __result__;
                this.index += 4;
                return l2;
            }
            catch (Throwable throwable) {
                this.index += 4;
                throw throwable;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNormalPatch(long pos, byte uptStyle, OracleType type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(uptStyle) + ", " + OracleLog.argument(type));
                OracleLog.recursiveTrace = false;
            }
            this.addPatch(new TDSPatch(0, type, pos, uptStyle));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSimplePatch(long pos, OracleType type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(type));
                OracleLog.recursiveTrace = false;
            }
            this.addPatch(new TDSPatch(1, type, pos, 0));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPatch(TDSPatch patch) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(patch));
                OracleLog.recursiveTrace = false;
            }
            if (this.patches == null) {
                this.patches = new Vector(5);
            }
            this.patches.addElement(patch);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long moveToPatchPos(TDSPatch patch) throws SQLException {
        try {
            long patchPos;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(patch));
                OracleLog.recursiveTrace = false;
            }
            if ((long)this.beginIndex + (patchPos = patch.getPosition()) > (long)this.tds.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSReader.logger().log(Level.SEVERE, "Throwing SQLException: 47parseTDS");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
            }
            this.skip_to(patchPos);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + patchPos);
                OracleLog.recursiveTrace = false;
            }
            long l2 = patchPos;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TDSPatch getNextPatch() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            TDSPatch patch = null;
            if (this.patches != null && this.patches.size() > 0) {
                patch = (TDSPatch)this.patches.firstElement();
                this.patches.removeElementAt(0);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + patch);
                OracleLog.recursiveTrace = false;
            }
            TDSPatch tDSPatch = patch;
            return tDSPatch;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void skip_to(long offset) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            this.index = this.beginIndex + (int)offset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long offset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long __result__ = this.index - this.beginIndex;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long absoluteOffset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + this.index);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.index;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] tds() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + this.tds);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.tds;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJavaObject(int version, byte flag) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(version) + ", " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = version >= 3 && (flag & 2) != 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFinalType(int version, byte flag) {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(version) + ", " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = version >= 3 && (flag & 1) == 0;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.TDSReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

