/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:24_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDSPatch(int type, OracleType owner, long pos, int uptCode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(owner) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(uptCode));
                OracleLog.recursiveTrace = false;
            }
            this.typeId = type;
            this.owner = owner;
            this.position = pos;
            this.uptCode = uptCode;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getType() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "return: " + this.typeId);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.typeId;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleNamedType getOwner() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleNamedType __result__ = (OracleNamedType)this.owner;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleNamedType oracleNamedType = __result__;
            return oracleNamedType;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPosition() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "return: " + this.position);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.position;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getUptTypeCode() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte __result__ = (byte)this.uptCode;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(OracleType typeValue) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typeValue));
                OracleLog.recursiveTrace = false;
            }
            this.apply(typeValue, -1);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(OracleType typeValue, int opcode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typeValue) + ", " + OracleLog.argument(opcode));
                OracleLog.recursiveTrace = false;
            }
            if (this.typeId == 0) {
                OracleTypeUPT patchElem = (OracleTypeUPT)this.owner;
                patchElem.realType = (OracleTypeADT)typeValue;
                if (typeValue instanceof OracleNamedType) {
                    OracleNamedType namedType = (OracleNamedType)typeValue;
                    namedType.setParent(patchElem.getParent());
                    namedType.setOrder(patchElem.getOrder());
                }
            } else if (this.typeId == 1) {
                OracleTypeCOLLECTION patchElem = (OracleTypeCOLLECTION)this.owner;
                patchElem.opcode = opcode;
                patchElem.elementType = typeValue;
                if (typeValue instanceof OracleNamedType) {
                    OracleNamedType namedType = (OracleNamedType)typeValue;
                    namedType.setParent(patchElem);
                    namedType.setOrder(1);
                }
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TDSPatch.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TDSPatch.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.TDSPatch"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

