/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.RAW;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    int length;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:23_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeRAW() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeRAW(int typecode) {
        super(typecode);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typecode));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            RAW datum = null;
            if (value != null) {
                try {
                    datum = value instanceof RAW ? (RAW)value : new RAW(value);
                }
                catch (SQLException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeRAW.logger().log(Level.SEVERE, "Throwing SQLException: 59" + value);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, value);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + datum);
                OracleLog.recursiveTrace = false;
            }
            RAW rAW = datum;
            return rAW;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(obj) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray = null;
            if (obj != null) {
                if (obj instanceof char[][]) {
                    char[][] strArray = (char[][])obj;
                    int length = (int)(count == -1 ? (long)strArray.length : Math.min((long)strArray.length - beginIdx + 1L, (long)count));
                    datumArray = new Datum[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        datumArray[i2] = this.toDatum(new String(strArray[(int)beginIdx + i2 - 1]), conn);
                    }
                } else {
                    if (obj instanceof Object[]) {
                        Datum[] __result__ = super.toDatumArray(obj, conn, beginIdx, count);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Datum[] datumArray2 = __result__;
                        return datumArray2;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeRAW.logger().log(Level.SEVERE, "Throwing SQLException: 59" + obj);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, obj);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + datumArray);
                OracleLog.recursiveTrace = false;
            }
            Datum[] datumArray3 = datumArray;
            return datumArray3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: -2");
                OracleLog.recursiveTrace = false;
            }
            int n2 = -2;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tdsReader));
                OracleLog.recursiveTrace = false;
            }
            super.parseTDSrec(tdsReader);
            this.length = tdsReader.readUB2();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ctx) + ", " + OracleLog.argument(data));
                OracleLog.recursiveTrace = false;
            }
            if (data.getLength() > (long)this.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeRAW.logger().log(Level.SEVERE, "Throwing SQLException: 72" + this);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 72, this);
            }
            int len = ctx.writeLength((int)data.getLength());
            len += ctx.writeData(data.shareBytes());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + len);
                OracleLog.recursiveTrace = false;
            }
            int n2 = len;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + this.length);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.length;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] val, int style, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(val) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            if (val == null || val.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var4_4 = null;
                return var4_4;
            }
            switch (style) {
                case 1: {
                    RAW __result__ = new RAW(val);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    RAW rAW = __result__;
                    return rAW;
                }
                case 2: 
                case 3: {
                    byte[] __result__ = val;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    byte[] byArray = __result__;
                    return byArray;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(Level.SEVERE, "Throwing SQLException: 59" + val);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 59, val);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out));
                OracleLog.recursiveTrace = false;
            }
            out.writeInt(this.length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            this.length = in.readInt();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeRAW.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeRAW"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

