/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    public static final int TYPE_PLSQL_INDEX_TABLE = 1;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int TYPE_VARRAY = 3;
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    static final int TRY_USER_WITH_FULL_NAME = 1;
    static final int TRY_USER_WITH_TYPE_NAME = 2;
    static final int TRY_ALL_WITH_FULL_NAME = 3;
    static final int TRY_ALL_WITH_TYPE_NAME = 4;
    static final int BREAK_LOOP = 5;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:22_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(String sql_name, OracleConnection conn) throws SQLException {
        super(sql_name, (Connection)conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(OracleTypeADT parent, int idx, OracleConnection conn) throws SQLException {
        super(parent, idx, (Connection)conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(parent) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        super(sqlName, typoid, version, tds, conn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(typoid) + ", " + OracleLog.argument(version) + ", " + OracleLog.argument(tds) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            if (value != null) {
                if (value instanceof ARRAY) {
                    ARRAY __result__ = (ARRAY)value;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    ARRAY aRRAY = __result__;
                    return aRRAY;
                }
                ArrayDescriptor desc = this.createArrayDescriptor();
                ARRAY __result__ = new ARRAY(desc, this.connection, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                ARRAY aRRAY = __result__;
                return aRRAY;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = null;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTypeCode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: 2003");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 2003;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(anOracleType));
                OracleLog.recursiveTrace = false;
            }
            if (anOracleType == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (anOracleType == this) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (anOracleType.getClass() != this.getClass()) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            boolean __result__ = anOracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(aStructDescriptor));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObjectType() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            long elementPos = tdsReader.readLong();
            this.maxSize = tdsReader.readLong();
            this.userCode = tdsReader.readByte();
            tdsReader.addSimplePatch(elementPos, this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int type, Map objmap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(objmap));
                OracleLog.recursiveTrace = false;
            }
            Datum __result__ = this.unlinearize(pickled_bytes, offset, container, 1L, -1, type, objmap);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = __result__;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        try {
            Object object;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(cnt) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(objmap));
                OracleLog.recursiveTrace = false;
            }
            OracleConnection mc = this.getConnection();
            Datum ret = null;
            if (mc == null) {
                ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
            } else {
                object = mc;
                synchronized (object) {
                    ret = this.unlinearizeInternal(pickled_bytes, offset, container, idx, cnt, style, objmap);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            object = ret;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Datum unlinearizeInternal(byte[] pickled_bytes, long offset, Datum container, long idx, int cnt, int style, Map objmap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(idx) + ", " + OracleLog.argument(cnt) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(objmap));
                OracleLog.recursiveTrace = false;
            }
            if (pickled_bytes == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Datum datum = null;
                return datum;
            }
            PickleContext context = new PickleContext(pickled_bytes, offset);
            ARRAY __result__ = this.unpickle81(context, (ARRAY)container, idx, cnt, 1, style, objmap);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInlineImage(byte[] pickled_bytes, int offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pickled_bytes) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (pickled_bytes == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (PickleContext.isCollectionImage_pctx(pickled_bytes[offset])) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (PickleContext.isDegenerateImage_pctx(pickled_bytes[offset])) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1Image is not a collection image");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int pickle81(PickleContext ctx, Datum datum) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ctx) + ", " + OracleLog.argument(datum));
                OracleLog.recursiveTrace = false;
            }
            ARRAY data = (ARRAY)datum;
            boolean inline = data.hasDataSeg();
            int imglen = 0;
            int lenOffset = ctx.offset() + 2;
            if (inline) {
                if (!this.metaDataInitialized) {
                    this.copy_properties((OracleTypeCOLLECTION)data.getDescriptor().getPickler());
                }
                Datum[] dataValues = data.getOracleArray();
                if (this.userCode == 3 && (long)dataValues.length > this.maxSize) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 71" + null);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 71, null);
                }
                imglen += ctx.writeCollImageHeader(dataValues.length, this.typeVersion);
                for (int ctr = 0; ctr < dataValues.length; ++ctr) {
                    imglen = dataValues[ctr] == null ? (imglen += ctx.writeElementNull()) : (imglen += this.elementType.pickle81(ctx, dataValues[ctr]));
                    String z = "idx=" + ctr + " is " + dataValues[ctr];
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_32, "Debug: " + z);
                    OracleLog.recursiveTrace = false;
                }
            } else {
                imglen += ctx.writeCollImageHeader(data.getLocator());
            }
            ctx.patchImageLen(lenOffset, imglen);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + imglen);
                OracleLog.recursiveTrace = false;
            }
            int n2 = imglen;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY unpickle81(PickleContext context, ARRAY container, int style, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                OracleLog.recursiveTrace = false;
            }
            ARRAY __result__ = this.unpickle81(context, container, 1L, -1, style, elemStyle, elemMap);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ARRAY aRRAY = __result__;
            return aRRAY;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY unpickle81(PickleContext context, ARRAY container, long beginIdx, int count, int style, int elemStyle, Map elemMap) throws SQLException {
        try {
            ARRAY coll_obj;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                OracleLog.recursiveTrace = false;
            }
            if ((coll_obj = container) == null) {
                ArrayDescriptor desc = this.createArrayDescriptor();
                coll_obj = new ARRAY(desc, (byte[])null, this.connection);
            }
            if (this.unpickle81ImgHeader(context, coll_obj, style, elemStyle)) {
                if (beginIdx == 1L && count == -1) {
                    this.unpickle81ImgBody(context, coll_obj, elemStyle, elemMap);
                } else {
                    this.unpickle81ImgBody(context, coll_obj, beginIdx, count, elemStyle, elemMap);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + coll_obj);
                OracleLog.recursiveTrace = false;
            }
            ARRAY aRRAY = coll_obj;
            return aRRAY;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unpickle81ImgHeader(PickleContext context, ARRAY container, int style, int elemStyle) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(style) + ", " + OracleLog.argument(elemStyle));
                OracleLog.recursiveTrace = false;
            }
            boolean inline = true;
            if (style == 3) {
                container.setImage(context.image(), context.absoluteOffset(), 0L);
            }
            byte flags = context.readByte();
            if (!PickleContext.is81format(flags)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1Image is not in 8.1 format");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format");
            }
            if (!PickleContext.hasPrefix(flags)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1Image has no prefix segment");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment");
            }
            if (PickleContext.isCollectionImage_pctx(flags)) {
                inline = true;
            } else if (PickleContext.isDegenerateImage_pctx(flags)) {
                inline = false;
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1Image is not a collection image");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image");
            }
            context.readByte();
            if (style == 9) {
                context.skipBytes(context.readLength(true) - 2);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (style == 3) {
                long length = context.readLength();
                container.setImageLength(length);
                context.skipTo(container.getImageOffset() + length);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            context.skipLength();
            int psegLen = context.readLength();
            container.setPrefixFlag(context.readByte());
            if (container.isInline()) {
                context.readDataValue(psegLen - 1);
            } else {
                container.setLocator(context.readDataValue(psegLen - 1));
            }
            boolean __result__ = container.isInline();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpickle81ImgBody(PickleContext context, ARRAY container, long beginIdx, int count, int elemStyle, Map elemMap) throws SQLException {
        try {
            boolean cacheAll;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                OracleLog.recursiveTrace = false;
            }
            context.readByte();
            int coll_len = context.readLength();
            container.setLength(coll_len);
            if (elemStyle == 0) {
                return;
            }
            int length = (int)this.getAccessLength(coll_len, beginIdx, count);
            boolean bl = cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
            if (beginIdx > 1L && length > 0) {
                long lastIdx = container.getLastIndex();
                if (lastIdx < beginIdx) {
                    if (lastIdx > 0L) {
                        context.skipTo(container.getLastOffset());
                    } else {
                        lastIdx = 1L;
                    }
                    if (cacheAll) {
                        for (long i2 = lastIdx; i2 < beginIdx; ++i2) {
                            container.setIndexOffset(i2, context.offset());
                            this.elementType.unpickle81rec(context, 9, null);
                        }
                    } else {
                        for (long i3 = lastIdx; i3 < beginIdx; ++i3) {
                            this.elementType.unpickle81rec(context, 9, null);
                        }
                    }
                } else if (lastIdx > beginIdx) {
                    long offset = container.getOffset(beginIdx);
                    if (offset != -1L) {
                        context.skipTo(offset);
                    } else if (cacheAll) {
                        int i4 = 1;
                        while ((long)i4 < beginIdx) {
                            container.setIndexOffset(i4, context.offset());
                            this.elementType.unpickle81rec(context, 9, null);
                            ++i4;
                        }
                    } else {
                        int i5 = 1;
                        while ((long)i5 < beginIdx) {
                            this.elementType.unpickle81rec(context, 9, null);
                            ++i5;
                        }
                    }
                } else {
                    context.skipTo(container.getLastOffset());
                }
                container.setLastIndexOffset(beginIdx, context.offset());
            }
            this.unpickle81ImgBodyElements(context, container, (int)beginIdx, length, elemStyle, elemMap);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpickle81ImgBody(PickleContext context, ARRAY container, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                OracleLog.recursiveTrace = false;
            }
            context.readByte();
            int length = context.readLength();
            container.setLength(length);
            if (elemStyle == 0) {
                return;
            }
            this.unpickle81ImgBodyElements(context, container, 1, length, elemStyle, elemMap);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpickle81ImgBodyElements(PickleContext context, ARRAY container, int beginIdx, int length, int elemStyle, Map elemMap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(context) + ", " + OracleLog.argument(container) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(elemStyle) + ", " + OracleLog.argument(elemMap));
                OracleLog.recursiveTrace = false;
            }
            boolean cacheAll = ArrayDescriptor.getCacheStyle(container) == 1;
            switch (elemStyle) {
                case 1: {
                    Datum[] datumArray = new Datum[length];
                    if (cacheAll) {
                        for (int i2 = 0; i2 < length; ++i2) {
                            container.setIndexOffset(beginIdx + i2, context.offset());
                            datumArray[i2] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    } else {
                        for (int i3 = 0; i3 < length; ++i3) {
                            datumArray[i3] = (Datum)this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    }
                    container.setDatumArray(datumArray);
                    break;
                }
                case 2: {
                    Object[] darray = ArrayDescriptor.makeJavaArray(length, this.elementType.getTypeCode());
                    if (cacheAll) {
                        for (int i4 = 0; i4 < length; ++i4) {
                            container.setIndexOffset(beginIdx + i4, context.offset());
                            darray[i4] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    } else {
                        for (int i5 = 0; i5 < length; ++i5) {
                            darray[i5] = this.elementType.unpickle81rec(context, elemStyle, elemMap);
                        }
                    }
                    container.setObjArray(darray);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                        container.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(context, 1L, length, elemStyle));
                        break;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 23This feature is limited to numeric collection");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection");
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 68Invalid conversion type " + this.elementType);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType);
                }
            }
            container.setLastIndexOffset(beginIdx + length, context.offset());
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initCollElemTypeName() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Statement stmt = null;
            ResultSet rset = null;
            try {
                stmt = this.connection.createStatement();
                int op = 2;
                do {
                    String sqlString = "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM";
                    switch (op) {
                        case 1: {
                            sqlString = sqlString + " USER_COLL_TYPES WHERE TYPE_NAME='" + this.sqlName.getSimpleName() + "'  AND OWNER='" + this.sqlName.getSchema() + "'";
                            op = 2;
                            break;
                        }
                        case 2: {
                            sqlString = sqlString + " USER_COLL_TYPES WHERE TYPE_NAME='" + this.sqlName.getSimpleName() + "'";
                            op = 3;
                            break;
                        }
                        case 3: {
                            sqlString = sqlString + " ALL_COLL_TYPES WHERE TYPE_NAME='" + this.sqlName.getSimpleName() + "'  AND OWNER='" + this.sqlName.getSchema() + "'";
                            op = 4;
                            break;
                        }
                        case 4: {
                            sqlString = sqlString + " ALL_COLL_TYPES WHERE TYPE_NAME='" + this.sqlName.getSimpleName() + "'";
                            op = 5;
                        }
                    }
                    rset = stmt.executeQuery(sqlString);
                    if (rset.next()) {
                        if (this.attrTypeNames == null) {
                            this.attrTypeNames = new String[1];
                        }
                        this.attrTypeNames[0] = rset.getString(2) + "." + rset.getString(1);
                        op = 5;
                        continue;
                    }
                    if (op != 5) continue;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
                } while (op != 5);
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeName(int idx) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeName(int idx, boolean force) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx) + ", " + OracleLog.argument(force));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.getAttributeName(idx);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeType(int idx) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(idx));
                OracleLog.recursiveTrace = false;
            }
            if (idx != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            if (this.attrTypeNames == null) {
                this.initCollElemTypeName();
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + this.attrTypeNames[0]);
                OracleLog.recursiveTrace = false;
            }
            String string = this.attrTypeNames[0];
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeType(int idx, boolean force) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (force) {
                String __result__ = this.getAttributeType(idx);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                String string = __result__;
                return string;
            }
            if (idx != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            if (this.sqlName != null && this.attrTypeNames != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + this.attrTypeNames[0]);
                    OracleLog.recursiveTrace = false;
                }
                String string = this.attrTypeNames[0];
                return string;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumAttrs() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleType getAttrTypeAt(int idx) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleType oracleType = null;
            return oracleType;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayDescriptor createArrayDescriptor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            ArrayDescriptor __result__ = new ArrayDescriptor(this, (Connection)this.connection);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.descriptor == null) {
                this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
            }
            ArrayDescriptor __result__ = (ArrayDescriptor)this.descriptor;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleType getElementType() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + this.elementType);
                OracleLog.recursiveTrace = false;
            }
            OracleType oracleType = this.elementType;
            return oracleType;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUserCode() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + this.userCode);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.userCode;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLength() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + this.maxSize);
                OracleLog.recursiveTrace = false;
            }
            long l2 = this.maxSize;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAccessLength(long coll_len, long beginIdx, int count) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(coll_len) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                OracleLog.recursiveTrace = false;
            }
            if (beginIdx > coll_len) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                long l2 = 0L;
                return l2;
            }
            if (count < 0) {
                long __result__ = coll_len - beginIdx + 1L;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                long l3 = __result__;
                return l3;
            }
            long __result__ = Math.min(coll_len - beginIdx + 1L, (long)count);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            long l4 = __result__;
            return l4;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(out));
                OracleLog.recursiveTrace = false;
            }
            out.writeInt(this.userCode);
            out.writeLong(this.maxSize);
            out.writeObject(this.elementType);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(in));
                OracleLog.recursiveTrace = false;
            }
            this.userCode = in.readInt();
            this.maxSize = in.readLong();
            this.elementType = (OracleType)in.readObject();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.connection = conn;
            this.elementType.setConnection(conn);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initMetadataRecursively() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.initMetadata(this.connection);
            if (this.elementType != null) {
                this.elementType.initMetadataRecursively();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initChildNamesRecursively(Map typesMap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typesMap));
                OracleLog.recursiveTrace = false;
            }
            TypeTreeElement element = (TypeTreeElement)typesMap.get(this.sqlName);
            if (this.elementType != null) {
                this.elementType.setNames(element.getChildSchemaName(0), element.getChildTypeName(0));
                this.elementType.initChildNamesRecursively(typesMap);
                this.elementType.cacheDescriptor();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheDescriptor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.descriptor = ArrayDescriptor.createDescriptor(this);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent));
                OracleLog.recursiveTrace = false;
            }
            this.printXML(pw, indent, false);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pw) + ", " + OracleLog.argument(indent) + ", " + OracleLog.argument(fetchAllMetaDataAsNeeded));
                OracleLog.recursiveTrace = false;
            }
            for (i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" " + ">");
            if (this.elementType != null) {
                this.elementType.printXML(pw, indent + 1, fetchAllMetaDataAsNeeded);
            }
            for (i2 = 0; i2 < indent; ++i2) {
                pw.print("  ");
            }
            pw.println("</OracleTypeCOLLECTION>");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleTypeCOLLECTION.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeCOLLECTION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

