/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    TimestampTzConverter tstzConverter = null;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:43_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestamptzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 181, 181, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestamptzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 181, 181, form, false);
            this.initForDescribe(181, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 13;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            boolean am;
            String regname;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            int off = this.columnIndex + this.byteLength * currentRow;
            int regionID = 0;
            if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(off));
                if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(off)))) {
                    TIMEZONETAB.updateTable(this.statement.connection, regionID);
                }
                regname = new String(ZONEIDMAP.getRegion(regionID));
            } else {
                int off_hour = this.oracleTZ1(off) - OFFSET_HOUR;
                int off_minute = this.oracleTZ2(off) - OFFSET_MINUTE;
                regname = new String("GMT" + (off_hour < 0 ? "-" : "+") + Math.abs(off_hour) + ":" + (off_minute < 10 ? "0" : "") + off_minute);
            }
            TimeZone zone = TimeZone.getTimeZone(regname);
            Calendar cal = Calendar.getInstance(zone);
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            cal.set(1, year);
            cal.set(2, this.oracleMonth(off));
            cal.set(5, this.oracleDay(off));
            cal.set(11, this.oracleHour(off));
            cal.set(12, this.oracleMin(off));
            cal.set(13, this.oracleSec(off));
            cal.set(14, 0);
            if ((this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                int offset = TIMEZONETAB.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(14, offset);
            } else {
                cal.add(10, this.oracleTZ1(off) - OFFSET_HOUR);
                cal.add(12, this.oracleTZ2(off) - OFFSET_MINUTE);
            }
            year = cal.get(1);
            int month = cal.get(2) + 1;
            int date = cal.get(5);
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            boolean bl = am = hour < 12;
            if (regname.length() > 3 && regname.startsWith("GMT")) {
                regname = regname.substring(3);
            }
            int nanos = this.oracleNanos(off);
            String __result__ = this.toText(year, month, date, hour, min, sec, nanos, am, regname);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(hour) + ", " + OracleLog.argument(min) + ", " + OracleLog.argument(sec) + ", " + OracleLog.argument(nanos) + ", " + OracleLog.argument(am) + ", " + OracleLog.argument(zone));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = year + "-" + month + "-" + day + " " + hour + "." + min + "." + sec + "." + nanos + " " + zone;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        return this.tstzConverter.getDate(currentRow);
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        return this.tstzConverter.getTime(currentRow);
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        return this.tstzConverter.getTimestamp(currentRow);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.tstzConverter.getObject(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.tstzConverter.getOracleObject(currentRow);
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        return this.tstzConverter.getTIMESTAMPTZ(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setHighOrderbits(int ID) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ID));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = (ID & 0x1FC0) >> 6;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setLowOrderbits(int ID) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ID));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = (ID & 0x3F) << 2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getHighOrderbits(int ID) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ID));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = (ID & 0x7F) << 6;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getLowOrderbits(int ID) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ID));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = (ID & 0xFC) >> 2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestamptzAccessor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestamptzAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract class TimestampTzConverter {
        TimestampTzConverter() {
        }

        abstract Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getObject(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ tIMESTAMPTZ = __result__;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Datum getOracleObject(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ tIMESTAMPTZ = __result__;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getObject(int currentRow, Map map) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ tIMESTAMPTZ = __result__;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        GmtTimestampTzConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Date getDate(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    Date date = null;
                    return date;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                int off1 = TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR;
                int off2 = TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE;
                Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                long millis = cal.getTimeInMillis();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + new Date(millis));
                    OracleLog.recursiveTrace = false;
                }
                Date date = new Date(millis);
                return date;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Time getTime(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    Time time = null;
                    return time;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                int off1 = TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR;
                int off2 = TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE;
                Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                Time time = new Time(cal.getTimeInMillis());
                return time;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    Timestamp timestamp = null;
                    return timestamp;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                int off1 = TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR;
                int off2 = TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE;
                Calendar cal = TimestamptzAccessor.this.statement.getGMTCalendar();
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                long millis = cal.getTimeInMillis();
                Timestamp result = new Timestamp(millis);
                int nanos = TimestamptzAccessor.this.oracleNanos(off);
                result.setNanos(nanos);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                Timestamp timestamp = result;
                return timestamp;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ result = null;
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) {
                    int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                    byte[] data = new byte[13];
                    System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, off, data, 0, 13);
                    result = new TIMESTAMPTZ(data);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ tIMESTAMPTZ = result;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        OldTimestampTzConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Date getDate(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    Date date = null;
                    return date;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
                Calendar cal = Calendar.getInstance(zone);
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                    int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                    if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                        TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                    }
                    int offset = TIMEZONETAB.getOffset(cal, regionID);
                    boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                    boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                    if (!sourceTimeInDST && destinationTimeInDST) {
                        cal.add(14, -1 * zone.getDSTSavings());
                    } else if (sourceTimeInDST && !destinationTimeInDST) {
                        cal.add(14, zone.getDSTSavings());
                    }
                    cal.add(10, offset / 3600000);
                    cal.add(12, offset % 3600000 / 60000);
                } else {
                    cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                    cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
                }
                long millis = cal.getTimeInMillis();
                Date __result__ = new Date(millis);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Date date = __result__;
                return date;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Time getTime(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    Time time = null;
                    return time;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
                Calendar cal = Calendar.getInstance(zone);
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                    int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                    if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                        TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                    }
                    int offset = TIMEZONETAB.getOffset(cal, regionID);
                    boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                    boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                    if (!sourceTimeInDST && destinationTimeInDST) {
                        cal.add(14, -1 * zone.getDSTSavings());
                    } else if (sourceTimeInDST && !destinationTimeInDST) {
                        cal.add(14, zone.getDSTSavings());
                    }
                    cal.add(10, offset / 3600000);
                    cal.add(12, offset % 3600000 / 60000);
                } else {
                    cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                    cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
                }
                long millis = cal.getTimeInMillis();
                Time __result__ = new Time(millis);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Time time = __result__;
                return time;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] == -1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    Timestamp timestamp = null;
                    return timestamp;
                }
                int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
                Calendar cal = Calendar.getInstance(zone);
                int year = ((TimestamptzAccessor.this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (TimestamptzAccessor.this.rowSpaceByte[1 + off] & 0xFF) - 100;
                cal.set(1, year);
                cal.set(2, TimestamptzAccessor.this.oracleMonth(off));
                cal.set(5, TimestamptzAccessor.this.oracleDay(off));
                cal.set(11, TimestamptzAccessor.this.oracleHour(off));
                cal.set(12, TimestamptzAccessor.this.oracleMin(off));
                cal.set(13, TimestamptzAccessor.this.oracleSec(off));
                cal.set(14, 0);
                if ((TimestamptzAccessor.this.oracleTZ1(off) & REGIONIDBIT) != 0) {
                    int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(off));
                    if (TIMEZONETAB.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(off)))) {
                        TIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                    }
                    int offset = TIMEZONETAB.getOffset(cal, regionID);
                    boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                    boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                    if (!sourceTimeInDST && destinationTimeInDST) {
                        cal.add(14, -1 * zone.getDSTSavings());
                    } else if (sourceTimeInDST && !destinationTimeInDST) {
                        cal.add(14, zone.getDSTSavings());
                    }
                    cal.add(10, offset / 3600000);
                    cal.add(12, offset % 3600000 / 60000);
                } else {
                    cal.add(10, TimestamptzAccessor.this.oracleTZ1(off) - OFFSET_HOUR);
                    cal.add(12, TimestamptzAccessor.this.oracleTZ2(off) - OFFSET_MINUTE);
                }
                long millis = cal.getTimeInMillis();
                Timestamp result = new Timestamp(millis);
                int nanos = TimestamptzAccessor.this.oracleNanos(off);
                result.setNanos(nanos);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                Timestamp timestamp = result;
                return timestamp;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ result = null;
                if (TimestamptzAccessor.this.rowSpaceIndicator == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestamptzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(TimestamptzAccessor.this.getConnectionDuringExceptionHandling(), 21);
                }
                if (TimestamptzAccessor.this.rowSpaceIndicator[TimestamptzAccessor.this.indicatorIndex + currentRow] != -1) {
                    int off = TimestamptzAccessor.this.columnIndex + TimestamptzAccessor.this.byteLength * currentRow;
                    byte[] data = new byte[13];
                    System.arraycopy(TimestamptzAccessor.this.rowSpaceByte, off, data, 0, 13);
                    result = new TIMESTAMPTZ(data);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ tIMESTAMPTZ = result;
                return tIMESTAMPTZ;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestamptzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }
}

