/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static int INV_ZONEID = -1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:42_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 231, 231, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 231, 231, form, false);
            this.initForDescribe(231, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 11;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 198");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 198);
            }
            TimeZone zone = this.statement.getDefaultTimeZone();
            zone.setID(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            this.TimeZoneAdjust(dbTzCal, sessTzCal);
            year = sessTzCal.get(1);
            int month = sessTzCal.get(2) + 1;
            int date = sessTzCal.get(5);
            int hour = sessTzCal.get(11);
            int minute = sessTzCal.get(12);
            int second = sessTzCal.get(13);
            int nanos = 0;
            boolean am = hour < 12;
            String regname = sessTzCal.getTimeZone().getID();
            if (regname.length() > 3 && regname.startsWith("GMT")) {
                regname = regname.substring(3);
            }
            if (len == 11) {
                nanos = this.oracleNanos(off);
            }
            String __result__ = this.toText(year, month, date, hour, minute, second, nanos, am, regname);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(hour) + ", " + OracleLog.argument(min) + ", " + OracleLog.argument(sec) + ", " + OracleLog.argument(nanos) + ", " + OracleLog.argument(am) + ", " + OracleLog.argument(zone));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + year + "-" + month + "-" + day + " " + hour + "." + min + "." + sec + "." + nanos);
                OracleLog.recursiveTrace = false;
            }
            String string = year + "-" + month + "-" + day + " " + hour + "." + min + "." + sec + "." + nanos;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Date getDate(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Date date = null;
                return date;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 198");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 198);
            }
            TimeZone zone = this.statement.getDefaultTimeZone();
            zone.setID(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            this.TimeZoneAdjust(dbTzCal, sessTzCal);
            long millis = sessTzCal.getTime().getTime();
            Date __result__ = new Date(millis);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Date date = __result__;
            return date;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Time getTime(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Time time = null;
                return time;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 198");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 198);
            }
            TimeZone zone = this.statement.getDefaultTimeZone();
            zone.setID(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            this.TimeZoneAdjust(dbTzCal, sessTzCal);
            long millis = sessTzCal.getTime().getTime();
            Time __result__ = new Time(millis);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Time time = __result__;
            return time;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Timestamp timestamp = null;
                return timestamp;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 198");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 198);
            }
            TimeZone zone = this.statement.getDefaultTimeZone();
            zone.setID(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            int off = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(off));
            dbTzCal.set(5, this.oracleDay(off));
            dbTzCal.set(11, this.oracleHour(off));
            dbTzCal.set(12, this.oracleMin(off));
            dbTzCal.set(13, this.oracleSec(off));
            dbTzCal.set(14, 0);
            this.TimeZoneAdjust(dbTzCal, sessTzCal);
            long millis = sessTzCal.getTime().getTime();
            Timestamp result = new Timestamp(millis);
            if (len == 11) {
                result.setNanos(this.oracleNanos(off));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = new TIMESTAMPLTZ(data);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = result;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TimeZoneAdjust(Calendar cal1, Calendar cal2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cal1) + ", " + OracleLog.argument(cal2));
                OracleLog.recursiveTrace = false;
            }
            String cal1String = cal1.getTimeZone().getID();
            String cal2String = cal2.getTimeZone().getID();
            if (!cal2String.equals(cal1String)) {
                int Offset_gmt;
                OffsetDST trans_db = new OffsetDST();
                byte dbolap = this.getZoneOffset(cal1, trans_db);
                int offset = trans_db.getOFFSET();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
                if (cal2String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3) {
                    Offset_gmt = cal2.getTimeZone().getRawOffset();
                } else {
                    int regionID = ZONEIDMAP.getID(cal2String);
                    if (regionID == INV_ZONEID) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 199");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 199);
                    }
                    if (TIMEZONETAB.checkID(regionID)) {
                        TIMEZONETAB.updateTable(this.statement.connection, regionID);
                    }
                    Offset_gmt = TIMEZONETAB.getOffset(cal1, regionID);
                }
                cal1.add(11, Offset_gmt / 3600000);
                cal1.add(12, Offset_gmt % 3600000 / 60000);
            }
            if (cal2String.equals("Custom") && cal1String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3 && cal1String.startsWith("GMT") && cal1String.length() > 3) {
                int offset1 = cal1.getTimeZone().getRawOffset();
                int offset2 = cal2.getTimeZone().getRawOffset();
                int net_offset = 0;
                if (offset1 != offset2) {
                    net_offset = offset1 - offset2;
                    int n2 = net_offset = net_offset > 0 ? net_offset : -net_offset;
                }
                if (offset1 > offset2) {
                    net_offset = -net_offset;
                }
                cal1.add(11, net_offset / 3600000);
                cal1.add(12, net_offset % 3600000 / 60000);
            }
            int year = cal1.get(1);
            int month = cal1.get(2);
            int day = cal1.get(5);
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            int second = cal1.get(13);
            int msecond = cal1.get(14);
            cal2.set(1, year);
            cal2.set(2, month);
            cal2.set(5, day);
            cal2.set(11, hour);
            cal2.set(12, minute);
            cal2.set(13, second);
            cal2.set(14, msecond);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getZoneOffset(Calendar cal, OffsetDST tempVar) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cal) + ", " + OracleLog.argument(tempVar));
                OracleLog.recursiveTrace = false;
            }
            byte olap = 0;
            String timeZone = cal.getTimeZone().getID();
            if (timeZone == "Custom" || timeZone.startsWith("GMT") && timeZone.length() > 3) {
                tempVar.setOFFSET(cal.getTimeZone().getRawOffset());
            } else {
                int regionID = ZONEIDMAP.getID(timeZone);
                if (regionID == INV_ZONEID) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        TimestampltzAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 199");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 199);
                }
                if (TIMEZONETAB.checkID(regionID)) {
                    TIMEZONETAB.updateTable(this.statement.connection, regionID);
                }
                olap = TIMEZONETAB.getLocalOffset(cal, regionID, tempVar);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "return: " + olap);
                OracleLog.recursiveTrace = false;
            }
            byte by = olap;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                TimestampltzAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestampltzAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

