/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4Caqe
extends T4CTTIfun {
    static final int KPD_AQ_BUFMSG = 2;
    static final int KPD_AQ_EITHER = 16;
    static final int OCI_COMMIT_ON_SUCCESS = 32;
    static final int ATTR_TRANSFORMATION = 196;
    T4CConnection connection;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:42_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4Caqe(T4CMAREngine _mrengine, T4CConnection _connection, T4CTTIoer _oer) throws IOException, SQLException {
        super((byte)3, 0, (short)121);
        this.setMarshalingEngine(_mrengine);
        this.connection = _connection;
        this.oer = _oer;
        this.toh = new T4Ctoh();
        this.aqm = new T4CTTIaqm(_mrengine, this.toh);
    }

    void marshal(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI messageProperties, byte[] messageData, byte[] messageOid, boolean isRawQueue) throws SQLException, IOException {
        super.marshalFunHeader();
        byte[] queueNameBytes = null;
        if (queueName != null && queueName.length() != 0) {
            queueNameBytes = this.meg.conv.StringToCharBytes(queueName);
            this.meg.marshalPTR();
            this.meg.marshalSWORD(queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.aqm.initToDefaultValues();
        this.aqm.aqmpri = messageProperties.getPriority();
        this.aqm.aqmdel = messageProperties.getDelay();
        this.aqm.aqmexp = messageProperties.getExpiration();
        this.aqm.aqmcor = messageProperties.getCorrelation();
        this.aqm.aqmeqn = messageProperties.getExceptionQueue();
        this.aqm.senderAgent = (AQAgentI)messageProperties.getSender();
        this.aqm.originalMsgId = messageProperties.getPreviousQueueMessageId();
        this.aqm.marshal(this.meg);
        AQAgentI[] attrRecipientList = (AQAgentI[])messageProperties.getRecipientList();
        boolean sendRecipientList = false;
        if (attrRecipientList != null && attrRecipientList.length > 0) {
            sendRecipientList = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(attrRecipientList.length * 3);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSB4(enqueueOptions.getVisibility().getCode());
        boolean sendRelativeMessageId = false;
        if (enqueueOptions.getRelativeMessageId() != null && enqueueOptions.getRelativeMessageId().length > 0) {
            sendRelativeMessageId = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(enqueueOptions.getRelativeMessageId().length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSWORD(enqueueOptions.getSequenceDeviation().getCode());
        this.meg.marshalPTR();
        this.meg.marshalSWORD(16);
        this.meg.marshalUB2(1);
        if (!isRawQueue) {
            this.meg.marshalPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            this.meg.marshalUB4(messageData.length);
        }
        if (enqueueOptions.getRetrieveMessageId()) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int aqeflg = 0;
        if (this.connection.autocommit) {
            aqeflg = 32;
        }
        if (enqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
            aqeflg |= 2;
        }
        this.meg.marshalUB4(aqeflg);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        boolean sendExtensions = false;
        int nbExtensions = 0;
        Object extensionTextValues = null;
        Object extensionBinaryValues = null;
        int[] extensionKeywords = null;
        String transformation = enqueueOptions.getTransformation();
        if (transformation != null && transformation.length() > 0) {
            sendExtensions = true;
            nbExtensions = 1;
            extensionTextValues = new byte[nbExtensions][];
            extensionBinaryValues = new byte[nbExtensions][];
            extensionKeywords = new int[nbExtensions];
            extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
            extensionBinaryValues[0] = null;
            extensionKeywords[0] = 196;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(nbExtensions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        if (this.meg.versionNumber >= 10200) {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalCHR(queueNameBytes);
        if (sendRecipientList) {
            byte[][] recipientTextValues = new byte[attrRecipientList.length * 3][];
            byte[][] recipientBinaryValues = new byte[attrRecipientList.length * 3][];
            int[] recipientKeywords = new int[attrRecipientList.length * 3];
            for (int i2 = 0; i2 < attrRecipientList.length; ++i2) {
                if (attrRecipientList[i2].getName() != null) {
                    recipientTextValues[3 * i2] = this.meg.conv.StringToCharBytes(attrRecipientList[i2].getName());
                }
                if (attrRecipientList[i2].getAddress() != null) {
                    recipientTextValues[3 * i2 + 1] = this.meg.conv.StringToCharBytes(attrRecipientList[i2].getAddress());
                }
                recipientBinaryValues[3 * i2 + 2] = new byte[1];
                recipientBinaryValues[3 * i2 + 2][0] = (byte)attrRecipientList[i2].getProtocol();
                recipientKeywords[3 * i2] = 3 * i2;
                recipientKeywords[3 * i2 + 1] = 3 * i2 + 1;
                recipientKeywords[3 * i2 + 2] = 3 * i2 + 2;
            }
            this.meg.marshalKPDKV(recipientTextValues, recipientBinaryValues, recipientKeywords);
        }
        if (sendRelativeMessageId) {
            this.meg.marshalB1Array(enqueueOptions.getRelativeMessageId());
        }
        this.meg.marshalB1Array(messageOid);
        if (!isRawQueue) {
            this.toh.init(messageOid, messageData.length);
            this.toh.marshal(this.meg);
            this.meg.marshalCLR(messageData, 0, messageData.length);
        } else {
            this.meg.marshalB1Array(messageData);
        }
        if (sendExtensions) {
            this.meg.marshalKPDKV((byte[][])extensionTextValues, (byte[][])extensionBinaryValues, extensionKeywords);
        }
    }

    void receive(AQEnqueueOptions enqueueOptions, byte[][] msgid) throws SQLException, IOException {
        block9: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            if (enqueueOptions.getRetrieveMessageId()) {
                                byte[] aqemsi = new byte[16];
                                this.meg.unmarshalBuffer(aqemsi, 0, 16);
                                msgid[0] = aqemsi;
                            }
                            int ign1 = this.meg.unmarshalUB2();
                            break;
                        }
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block9;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block9;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block9;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4Caqe.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqe.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqe.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4Caqe.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4Caqe"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

