/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int[] errorNumber;
    private String password;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:42_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CXAResource(T4CConnection _physicalConn, OracleXAConnection xaconn, boolean _isTransLoose) throws XAException {
        super(_physicalConn, xaconn);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_physicalConn) + ", " + OracleLog.argument(xaconn) + ", " + OracleLog.argument(_isTransLoose));
                OracleLog.recursiveTrace = false;
            }
            this.physicalConn = _physicalConn;
            this.isTransLoose = _isTransLoose;
            this.errorNumber = new int[1];
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doStart(Xid xid, int flag) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            try {
                int returnVal;
                block24: {
                    int swtch;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag));
                        OracleLog.recursiveTrace = false;
                    }
                    returnVal = -1;
                    if (this.isTransLoose) {
                        flag |= 0x10000;
                    }
                    if ((swtch = flag & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                        int n3 = 0;
                        return n3;
                    }
                    this.applicationValueArr[0] = 0;
                    try {
                        try {
                            T4CTTIOtxse otxse = this.physicalConn.otxse;
                            byte[] xidxid = null;
                            byte[] gtrid = xid.getGlobalTransactionId();
                            byte[] bqual = xid.getBranchQualifier();
                            int gtrid_l = 0;
                            int bqual_l = 0;
                            if (gtrid != null && bqual != null) {
                                gtrid_l = Math.min(gtrid.length, 64);
                                bqual_l = Math.min(bqual.length, 64);
                                xidxid = new byte[128];
                                System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                                System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                            }
                            int t4cflag = 0;
                            t4cflag = (flag & 0x200000) != 0 || (flag & 0x8000000) != 0 ? (t4cflag |= 4) : (t4cflag |= 1);
                            if ((flag & 0x100) != 0) {
                                t4cflag |= 0x100;
                            }
                            if ((flag & 0x200) != 0) {
                                t4cflag |= 0x200;
                            }
                            if ((flag & 0x400) != 0) {
                                t4cflag |= 0x400;
                            }
                            if ((flag & 0x10000) != 0) {
                                t4cflag |= 0x10000;
                            }
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.marshal(1, null, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = 0;
                            byte[] ctx = otxse.receive(this.applicationValueArr);
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_start: IOException caught:" + ioe.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                        }
                    }
                    catch (SQLException s2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_start: SQLException caught:" + s2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                        if ((returnVal = s2.getErrorCode()) != 0) break block24;
                        throw new XAException(-6);
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = returnVal;
                return n2;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            try {
                int returnVal;
                block25: {
                    int bqual_l;
                    int gtrid_l;
                    byte[] xidxid;
                    T4CTTIOtxse otxse;
                    block24: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(flag) + ", " + OracleLog.argument(isLocallySuspended));
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = -1;
                        otxse = this.physicalConn.otxse;
                        xidxid = null;
                        byte[] gtrid = xid.getGlobalTransactionId();
                        byte[] bqual = xid.getBranchQualifier();
                        gtrid_l = 0;
                        bqual_l = 0;
                        if (gtrid != null && bqual != null) {
                            gtrid_l = Math.min(gtrid.length, 64);
                            bqual_l = Math.min(bqual.length, 64);
                            xidxid = new byte[128];
                            System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                            System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                        }
                        if (this.context != null || (returnVal = this.doStart(xid, 0x8000000)) == 0) break block24;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                            OracleLog.recursiveTrace = false;
                        }
                        int n2 = returnVal;
                        return n2;
                    }
                    try {
                        try {
                            byte[] txctx = this.context;
                            int t4cflag = 0;
                            if ((flag & 2) == 2) {
                                t4cflag = 0x100000;
                            } else if ((flag & 0x2000000) == 0x2000000 && (flag & 0x100000) != 0x100000) {
                                t4cflag = 0x100000;
                                if (!isLocallySuspended) {
                                    this.applicationValueArr[0] = 65536;
                                }
                            }
                            this.physicalConn.needLine();
                            this.physicalConn.sendPiggyBackedMessages();
                            otxse.marshal(2, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, t4cflag, this.applicationValueArr);
                            this.applicationValueArr[0] = 0;
                            byte[] ctx = otxse.receive(this.applicationValueArr);
                            if (ctx != null) {
                                this.context = ctx;
                            }
                            returnVal = 0;
                        }
                        catch (IOException ioe) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_end: IOException caught:" + ioe.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                        }
                    }
                    catch (SQLException s2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_end: SQLException caught:" + s2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                        if ((returnVal = s2.getErrorCode()) != 0) break block25;
                        throw new XAException(-6);
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                    OracleLog.recursiveTrace = false;
                }
                int n3 = returnVal;
                return n3;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doCommit(Xid xid, int cPhase) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2;
            block34: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(cPhase));
                        OracleLog.recursiveTrace = false;
                    }
                    int returnVal = -1;
                    int command = cPhase == 1 ? 4 : 2;
                    returnVal = this.doTransaction(xid, 1, command);
                    if (cPhase == 1 && (returnVal == 2 || returnVal == 4)) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_commit: server returns K2CMDcommit");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 0;
                    } else if (cPhase != 1 && returnVal == 5) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_commit: server returns K2CMDforget");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 0;
                    } else if (returnVal == 8) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_commit: server returns K2CMDtimeout");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(106);
                    }
                    if (returnVal == 24756) {
                        returnVal = this.kputxrec(xid, 1, this.timeout + 120);
                    } else if (returnVal == 24780) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_commit: got a 24780.");
                            OracleLog.recursiveTrace = false;
                        }
                        OracleXADataSource oxds = null;
                        PooledConnection pc = null;
                        try {
                            oxds = new OracleXADataSource();
                            oxds.setURL(this.physicalConn.url);
                            oxds.setUser(this.physicalConn.userName);
                            this.physicalConn.getPasswordInternal(this);
                            oxds.setPassword(this.password);
                            pc = oxds.getXAConnection();
                            XAResource oxar = pc.getXAResource();
                            oxar.commit(xid, cPhase == 1);
                            returnVal = 0;
                        }
                        catch (SQLException e2) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_commit: Got a SQLException while processing a 24780." + e2.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                            throw new XAException(-6);
                        }
                        finally {
                            try {
                                if (pc != null) {
                                    pc.close();
                                }
                                if (oxds != null) {
                                    oxds.close();
                                }
                            }
                            catch (Exception ee) {}
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = returnVal;
                    if (!TRACE || OracleLog.recursiveTrace) break block34;
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doPrepare(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2;
            block24: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                        OracleLog.recursiveTrace = false;
                    }
                    int returnVal = -1;
                    returnVal = this.doTransaction(xid, 3, 0);
                    if (returnVal == 8) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_prepare: server returns K2CMDtimeout");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(106);
                    }
                    if (returnVal == 4) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_prepare: server returns K2CMDrdonly");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 24767;
                    } else if (returnVal == 1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_prepare: server returns K2CMDrqcommit");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 0;
                    } else if (returnVal == 3) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_prepare: server returns K2CMDabort");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 24761;
                    } else {
                        switch (returnVal) {
                            case 2054: 
                            case 2056: 
                            case 2091: 
                            case 2092: 
                            case 24756: 
                            case 24761: 
                            case 24767: 
                            case 24775: {
                                break;
                            }
                            case 25351: {
                                returnVal = 17448;
                                break;
                            }
                            default: {
                                returnVal = 24768;
                            }
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = returnVal;
                    if (!TRACE || OracleLog.recursiveTrace) break block24;
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doForget(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int returnVal;
            block18: {
                int resumeReturn;
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                                    OracleLog.recursiveTrace = false;
                                }
                                returnVal = -1;
                                if (!OracleXid.isLocalTransaction(xid)) break block17;
                                int n2 = 24771;
                                if (!TRACE) return n2;
                                if (OracleLog.recursiveTrace) return n2;
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                                return n2;
                            }
                            resumeReturn = this.doStart(xid, 0x8000000);
                            if (resumeReturn == 24756) break block18;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_forget : resume returned : " + resumeReturn);
                                OracleLog.recursiveTrace = false;
                            }
                            if (resumeReturn == 0) {
                                try {
                                    this.doEnd(xid, 0, false);
                                }
                                catch (Exception e2) {
                                    if (!TRACE || OracleLog.recursiveTrace) break block19;
                                    OracleLog.recursiveTrace = true;
                                    T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_forget : end txn that existsts throws exception : " + e2.getMessage());
                                    OracleLog.recursiveTrace = false;
                                }
                            }
                        }
                        if (resumeReturn != 0 && resumeReturn != 2079 && resumeReturn != 24754 && resumeReturn != 24761 && resumeReturn != 24774 && resumeReturn != 24776 && resumeReturn != 25351) break block20;
                        int n3 = 24769;
                        if (!TRACE) return n3;
                        if (OracleLog.recursiveTrace) return n3;
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                        return n3;
                    }
                    if (resumeReturn != 24752) break block21;
                    int n4 = 24771;
                    if (!TRACE) return n4;
                    if (OracleLog.recursiveTrace) return n4;
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                    return n4;
                }
                int n5 = resumeReturn;
                if (!TRACE) return n5;
                if (OracleLog.recursiveTrace) return n5;
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
                return n5;
            }
            returnVal = this.kputxrec(xid, 4, 1);
            if (!TRACE) return returnVal;
            if (OracleLog.recursiveTrace) return returnVal;
            OracleLog.recursiveTrace = true;
            T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
            OracleLog.recursiveTrace = false;
            return returnVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRollback(Xid xid) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2;
            block30: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid));
                        OracleLog.recursiveTrace = false;
                    }
                    int returnVal = -1;
                    returnVal = this.doTransaction(xid, 2, 3);
                    if (returnVal == 8) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_rollback: server returns K2CMDtimeout");
                            OracleLog.recursiveTrace = false;
                        }
                        throw new XAException(106);
                    }
                    if (returnVal == 3 || returnVal == 25402) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_rollback: server returns K2CMDabort");
                            OracleLog.recursiveTrace = false;
                        }
                        returnVal = 0;
                    }
                    if (returnVal == 24756) {
                        returnVal = this.kputxrec(xid, 2, this.timeout + 120);
                    } else if (returnVal == 24780) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_rollback: got a 24780.");
                            OracleLog.recursiveTrace = false;
                        }
                        OracleXADataSource oxds = null;
                        PooledConnection pc = null;
                        try {
                            oxds = new OracleXADataSource();
                            oxds.setURL(this.physicalConn.url);
                            oxds.setUser(this.physicalConn.userName);
                            this.physicalConn.getPasswordInternal(this);
                            oxds.setPassword(this.password);
                            pc = oxds.getXAConnection();
                            XAResource oxar = pc.getXAResource();
                            oxar.rollback(xid);
                            returnVal = 0;
                        }
                        catch (SQLException e2) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_rollback: Got a SQLException while processing a 24780." + e2.getMessage());
                                OracleLog.recursiveTrace = false;
                            }
                            throw new XAException(-6);
                        }
                        finally {
                            try {
                                if (pc != null) {
                                    pc.close();
                                }
                                if (oxds != null) {
                                    oxds.close();
                                }
                            }
                            catch (Exception ee) {}
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = returnVal;
                    if (!TRACE || OracleLog.recursiveTrace) break block30;
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doTransaction(Xid xid, int mode, int command) throws XAException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(command));
                OracleLog.recursiveTrace = false;
            }
            int returnVal = -1;
            try {
                try {
                    T4CTTIOtxen otxen = this.physicalConn.otxen;
                    byte[] xidxid = null;
                    byte[] gtrid = xid.getGlobalTransactionId();
                    byte[] bqual = xid.getBranchQualifier();
                    int gtrid_l = 0;
                    int bqual_l = 0;
                    if (gtrid != null && bqual != null) {
                        gtrid_l = Math.min(gtrid.length, 64);
                        bqual_l = Math.min(bqual.length, 64);
                        xidxid = new byte[128];
                        System.arraycopy(gtrid, 0, xidxid, 0, gtrid_l);
                        System.arraycopy(bqual, 0, xidxid, gtrid_l, bqual_l);
                    }
                    byte[] txctx = this.context;
                    this.physicalConn.needLine();
                    this.physicalConn.sendPiggyBackedMessages();
                    otxen.marshal(mode, txctx, xidxid, xid.getFormatId(), gtrid_l, bqual_l, this.timeout, command, 0);
                    returnVal = otxen.receive(this.errorNumber);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_transaction: otxen.receive returns " + returnVal + ", errorNumber[0]=" + this.errorNumber[0]);
                        OracleLog.recursiveTrace = false;
                    }
                }
                catch (IOException ioe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_transaction: IOException caught:" + ioe.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CXAResource.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                }
            }
            catch (SQLException s2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_transaction: SQLException caught:" + s2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                this.errorNumber[0] = s2.getErrorCode();
            }
            if (this.errorNumber[0] == 0) {
                throw new XAException(-6);
            }
            if (returnVal == -1) {
                returnVal = this.errorNumber[0];
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.do_transaction: returns " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + returnVal);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnVal;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int kputxrec(Xid xid, int opcode, int tries) throws XAException {
        try {
            int incmd;
            int command;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(opcode) + ", " + OracleLog.argument(tries));
                OracleLog.recursiveTrace = false;
            }
            int rtnst = 0;
            switch (opcode) {
                case 1: {
                    command = 3;
                    break;
                }
                case 4: {
                    command = 2;
                    break;
                }
                default: {
                    command = 0;
                }
            }
            int endstate = 0;
            while (tries-- > 0 && (endstate = this.doTransaction(xid, 5, command)) == 7) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {}
            }
            if (endstate == 7) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.kputxrec: Try to recover but transaction operation cannot be completed now");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "return: 24763");
                    OracleLog.recursiveTrace = false;
                }
                int e2 = 24763;
                return e2;
            }
            if (endstate == 24756) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_16, "return: 24756");
                    OracleLog.recursiveTrace = false;
                }
                int e2 = 24756;
                return e2;
            }
            switch (endstate) {
                case 3: {
                    if (opcode == 1) {
                        incmd = 7;
                        break;
                    }
                    incmd = 8;
                    rtnst = -24762;
                    break;
                }
                case 0: {
                    if (opcode == 4) {
                        incmd = 8;
                        rtnst = 24762;
                        break;
                    }
                    incmd = 7;
                    rtnst = opcode == 1 ? 24756 : 0;
                    break;
                }
                case 2: {
                    if (opcode == 4) {
                        incmd = 8;
                        rtnst = 24770;
                        break;
                    }
                }
                default: {
                    int[] heuristic = new int[1];
                    rtnst = this.kpuho2oc(endstate, heuristic);
                    if (opcode == 4 && heuristic[0] == 1) {
                        incmd = 7;
                        rtnst = 0;
                        break;
                    }
                    incmd = 8;
                }
            }
            T4CTTIk2rpc k2rpc = this.physicalConn.k2rpc;
            try {
                k2rpc.marshal(3, incmd);
                k2rpc.receive();
            }
            catch (IOException ioe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.kputxrec: IOException caught:" + ioe.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(-7);
            }
            catch (SQLException s2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CXAResource.logger().log(OracleLog.TRACE_20, "Debug: T4CXAResource.kputxrec: SQLException caught:" + s2.getMessage());
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(-6);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + rtnst);
                OracleLog.recursiveTrace = false;
            }
            int n2 = rtnst;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int kpuho2oc(int state, int[] heuristic) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(state) + ", " + OracleLog.argument(heuristic));
                OracleLog.recursiveTrace = false;
            }
            int rtnst = 0;
            switch (state) {
                case 5: {
                    heuristic[0] = 1;
                    rtnst = 24764;
                    break;
                }
                case 4: {
                    heuristic[0] = 1;
                    rtnst = 24765;
                    break;
                }
                case 6: {
                    heuristic[0] = 1;
                    rtnst = 24766;
                    break;
                }
                default: {
                    rtnst = 24762;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + rtnst);
                OracleLog.recursiveTrace = false;
            }
            int n2 = rtnst;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    final void setPasswordInternal(String p2) {
        this.password = p2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "return: " + this.physicalConn);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.physicalConn;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CXAResource.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

