/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;

public class T4CXAConnection
extends OracleXAConnection {
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CConnection physicalConnection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:42_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    public T4CXAConnection(Connection _physicalConnection) throws XAException {
        super(_physicalConnection);
        this.physicalConnection = (T4CConnection)_physicalConnection;
        this.xaResource = null;
    }

    @Override
    public synchronized XAResource getXAResource() {
        try {
            if (this.xaResource == null) {
                this.xaResource = new T4CXAResource(this.physicalConnection, this, this.isXAResourceTransLoose);
                if (this.logicalHandle != null) {
                    ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                }
            }
        }
        catch (Exception e2) {
            this.xaResource = null;
        }
        return this.xaResource;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CXAConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

