/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CVarcharAccessor
extends VarcharAccessor {
    T4CMAREngine mare;
    static final int t4MaxLength = 4000;
    static final int t4CallMaxLength = 4001;
    static final int t4PlsqlMaxLength = 32766;
    static final int t4SqlMinLength = 32;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    static final int NONE = -1;
    static final int DAY = 1;
    static final int MM_MONTH = 2;
    static final int FULL_MONTH = 3;
    static final int MON_MONTH = 4;
    static final int YY_YEAR = 5;
    static final int RR_YEAR = 6;
    static final int HH_HOUR = 7;
    static final int HH24_HOUR = 8;
    static final int MINUTE = 9;
    static final int SECOND = 10;
    static final int NSECOND = 11;
    static final int AM = 12;
    static final int TZR = 13;
    static final int TZH = 14;
    static final int TZM = 15;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:42_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarcharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                OracleLog.recursiveTrace = false;
            }
            this.mare = _mare;
            this.calculateSizeTmpByteArray();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarcharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_oacmxl) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                OracleLog.recursiveTrace = false;
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.calculateSizeTmpByteArray();
            this.oacmxl = _oacmxl;
            if (this.oacmxl == -1) {
                this.underlyingLong = true;
                this.oacmxl = 4000;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        byte[] bytesBuffer = this.statement.tmpByteArray;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (!this.underlyingLong) {
            if (this.rowSpaceIndicator == null) {
                byte[] buff = new byte[16000];
                this.mare.unmarshalCLR(buff, 0, this.meta);
                this.processIndicator(this.meta[0]);
                ++this.lastRowProcessed;
                return false;
            }
            if (this.isNullByDescribe) {
                this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
                this.rowSpaceIndicator[tmpLengthOffset] = 0;
                ++this.lastRowProcessed;
                if (this.mare.versionNumber < 9200) {
                    this.processIndicator(0);
                }
                return false;
            }
            if (this.statement.maxFieldSize > 0) {
                this.mare.unmarshalCLR(bytesBuffer, 0, this.meta, this.statement.maxFieldSize);
            } else {
                this.mare.unmarshalCLR(bytesBuffer, 0, this.meta);
            }
        } else {
            this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
            if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
                this.meta[0] = 0;
                this.mare.processIndicator(false, 0);
                int ignore = this.mare.unmarshalUB2();
            } else {
                int nbBytesReadTemp = 0;
                int nbBytesRead = 0;
                byte[] bufferToUse = bytesBuffer;
                int offset = 0;
                this.readHeaderArr[0] = true;
                this.readAsNonStreamArr[0] = false;
                while (nbBytesReadTemp != -1) {
                    if (bufferToUse == bytesBuffer && nbBytesRead + 255 > bytesBuffer.length) {
                        bufferToUse = new byte[255];
                    }
                    if ((nbBytesReadTemp = T4CLongAccessor.readStreamFromWire(bufferToUse, offset = bufferToUse == bytesBuffer ? nbBytesRead : 0, 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    if (bufferToUse == bytesBuffer) {
                        nbBytesRead += nbBytesReadTemp;
                        continue;
                    }
                    if (bytesBuffer.length - nbBytesRead <= 0) continue;
                    int nbBytesAvailable = bytesBuffer.length - nbBytesRead;
                    System.arraycopy(bufferToUse, 0, bytesBuffer, nbBytesRead, nbBytesAvailable);
                    nbBytesRead += nbBytesAvailable;
                }
                if (bufferToUse != bytesBuffer) {
                    bufferToUse = null;
                }
                this.meta[0] = nbBytesRead;
            }
        }
        this.tmp[0] = this.meta[0];
        int nbOfCharsConverted = 0;
        nbOfCharsConverted = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[tmpSpaceCharOffset] = (char)(nbOfCharsConverted * 2);
        if (!this.underlyingLong) {
            this.processIndicator(this.meta[0]);
        }
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        int rowIdSource = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch : this.lastRowProcessed;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndex + (rowIdSource - 1) * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + rowIdSource - 1;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + rowIdSource - 1;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        System.arraycopy(this.rowSpaceChar, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, this.rowSpaceChar[tmpSpaceCharOffsetLastRow] / 2 + 1);
        ++this.lastRowProcessed;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceCharOffset = this.columnIndex + (newPrefetchSize - 1) * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceCharLastRow, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, rowSpaceCharLastRow[tmpSpaceCharOffsetLastRow] / 2 + 1);
        }
    }

    @Override
    void calculateSizeTmpByteArray() {
        int maxNbBytes = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < maxNbBytes) {
            this.statement.sizeTmpByteArray = maxNbBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            String ret;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        NUMBER result = null;
        if (this.definedColumnType == 0) {
            result = super.getNUMBER(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                return T4CVarcharAccessor.StringToNUMBER(s2);
            }
        }
        return result;
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        DATE result = null;
        if (this.definedColumnType == 0) {
            result = super.getDATE(currentRow);
        } else {
            Date d2 = this.getDate(currentRow);
            if (d2 != null) {
                result = new DATE(d2);
            }
        }
        return result;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMP result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMP(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMP(ts);
            }
        }
        return result;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPLTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    @Override
    RAW getRAW(int currentRow) throws SQLException {
        RAW result = null;
        if (this.definedColumnType == 0) {
            result = super.getRAW(currentRow);
        } else {
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = new RAW(super.getBytes(currentRow));
            }
        }
        return result;
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(currentRow);
        }
        Datum result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(currentRow);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(currentRow);
                }
                case 91: {
                    return this.getDATE(currentRow);
                }
                case 92: {
                    return this.getDATE(currentRow);
                }
                case 93: {
                    return this.getTIMESTAMP(currentRow);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(currentRow);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(currentRow);
                }
                case -8: {
                    return this.getROWID(currentRow);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
        }
        return result;
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getBytes(currentRow);
        }
        Datum datum = this.getOracleObject(currentRow);
        return datum.shareBytes();
    }

    @Override
    boolean getBoolean(int currentRow) throws SQLException {
        boolean result = false;
        result = this.definedColumnType == 0 ? super.getBoolean(currentRow) : this.getNUMBER(currentRow).booleanValue();
        return result;
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        byte result = 0;
        result = this.definedColumnType == 0 ? super.getByte(currentRow) : this.getNUMBER(currentRow).byteValue();
        return result;
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        int result = 0;
        result = this.definedColumnType == 0 ? super.getInt(currentRow) : this.getNUMBER(currentRow).intValue();
        return result;
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        short result = 0;
        result = this.definedColumnType == 0 ? super.getShort(currentRow) : this.getNUMBER(currentRow).shortValue();
        return result;
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        long result = 0L;
        result = this.definedColumnType == 0 ? super.getLong(currentRow) : this.getNUMBER(currentRow).longValue();
        return result;
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        float result = 0.0f;
        result = this.definedColumnType == 0 ? super.getFloat(currentRow) : this.getNUMBER(currentRow).floatValue();
        return result;
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        double result = 0.0;
        result = this.definedColumnType == 0 ? super.getDouble(currentRow) : this.getNUMBER(currentRow).doubleValue();
        return result;
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        Date result = null;
        if (this.definedColumnType == 0) {
            result = super.getDate(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                result = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
            }
        }
        return result;
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        Timestamp result = null;
        if (this.definedColumnType == 0) {
            result = super.getTimestamp(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                result = new Timestamp(cal.getTimeInMillis());
                result.setNanos(nanos[0]);
            }
        }
        return result;
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        Time result = null;
        if (this.definedColumnType == 0) {
            result = super.getTime(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                result = new Time(cal.getTimeInMillis());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.definedColumnType == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + super.getObject(currentRow));
                    OracleLog.recursiveTrace = false;
                }
                Object object = super.getObject(currentRow);
                return object;
            }
            Object result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                switch (this.definedColumnType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        String __result__ = this.getString(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        String string = __result__;
                        return string;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal __result__ = this.getBigDecimal(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        BigDecimal bigDecimal = __result__;
                        return bigDecimal;
                    }
                    case 4: {
                        Integer __result__ = new Integer(this.getInt(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Integer n2 = __result__;
                        return n2;
                    }
                    case -6: {
                        Byte __result__ = new Byte(this.getByte(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Byte by = __result__;
                        return by;
                    }
                    case 5: {
                        Short __result__ = new Short(this.getShort(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Short s2 = __result__;
                        return s2;
                    }
                    case -7: 
                    case 16: {
                        Boolean __result__ = new Boolean(this.getBoolean(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Boolean bl = __result__;
                        return bl;
                    }
                    case -5: {
                        Long __result__ = new Long(this.getLong(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Long l2 = __result__;
                        return l2;
                    }
                    case 7: {
                        Float __result__ = new Float(this.getFloat(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Float f2 = __result__;
                        return f2;
                    }
                    case 6: 
                    case 8: {
                        Double __result__ = new Double(this.getDouble(currentRow));
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Double d2 = __result__;
                        return d2;
                    }
                    case 91: {
                        Date __result__ = this.getDate(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Date date = __result__;
                        return date;
                    }
                    case 92: {
                        Time __result__ = this.getTime(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Time time = __result__;
                        return time;
                    }
                    case 93: {
                        Timestamp __result__ = this.getTimestamp(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        Timestamp timestamp = __result__;
                        return timestamp;
                    }
                    case -101: {
                        TIMESTAMPTZ __result__ = this.getTIMESTAMPTZ(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        TIMESTAMPTZ tIMESTAMPTZ = __result__;
                        return tIMESTAMPTZ;
                    }
                    case -102: {
                        TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        TIMESTAMPLTZ tIMESTAMPLTZ = __result__;
                        return tIMESTAMPLTZ;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] __result__ = this.getBytesInternal(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        byte[] byArray = __result__;
                        return byArray;
                    }
                    case -8: {
                        ROWID __result__ = this.getROWID(currentRow);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        ROWID rOWID = __result__;
                        return rOWID;
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var3_20 = null;
                return var3_20;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Object var3_21 = result;
            return var3_21;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ROWID getROWID(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = this.getBytesInternal(currentRow);
            ROWID rowid = null;
            if (b2 != null) {
                rowid = new ROWID(b2);
            }
            ROWID __result__ = rowid;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ROWID rOWID = __result__;
            return rOWID;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CVarcharAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    static final NUMBER StringToNUMBER(String str) throws SQLException {
        return new NUMBER(new BigDecimal(str));
    }

    static final Calendar DATEStringToCalendar(String value, String fmt, int[] out) throws SQLException {
        char[] fmtChars = (fmt + " ").toCharArray();
        value = value + " ";
        int sLength = Math.min(value.length(), fmtChars.length);
        int state = -1;
        int oldState = -1;
        int index = 0;
        int prevIndex = 0;
        int vsIndex = 0;
        int veIndex = 0;
        int day = 0;
        int month = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nsecond = 0;
        String am = null;
        String tzr = null;
        boolean needToProcessValue = false;
        String[] sMonths = null;
        String[] lMonths = null;
        for (int i2 = 0; i2 < sLength; ++i2) {
            switch (fmtChars[i2]) {
                case 'R': 
                case 'r': {
                    if (state == 6) break;
                    state = 6;
                    index = i2;
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (state == 5) break;
                    state = 5;
                    index = i2;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state == 1) break;
                    state = 1;
                    index = i2;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (state == 2 && state == 4 && state == 3 && state == 9) break;
                    index = i2;
                    if (!(i2 + 4 >= sLength || fmtChars[i2 + 1] != 'O' && fmtChars[i2 + 1] != 'o' || fmtChars[i2 + 2] != 'N' && fmtChars[i2 + 2] != 'n' || fmtChars[i2 + 3] != 'T' && fmtChars[i2 + 3] != 't' || fmtChars[i2 + 4] != 'H' && fmtChars[i2 + 4] != 'h')) {
                        state = 3;
                        i2 += 4;
                        break;
                    }
                    if (!(i2 + 2 >= sLength || fmtChars[i2 + 1] != 'O' && fmtChars[i2 + 1] != 'o' || fmtChars[i2 + 2] != 'N' && fmtChars[i2 + 2] != 'n')) {
                        state = 4;
                        i2 += 2;
                        break;
                    }
                    if (i2 + 1 < sLength && (fmtChars[i2 + 1] == 'M' || fmtChars[i2 + 1] == 'm')) {
                        state = 2;
                        ++i2;
                        break;
                    }
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'I' && fmtChars[i2 + 1] != 'i') break;
                    state = 9;
                    ++i2;
                    break;
                }
                case 'H': 
                case 'h': {
                    if (state != 7) {
                        state = 7;
                        index = i2;
                        break;
                    }
                    if (i2 + 2 >= sLength || fmtChars[i2 + 1] != '2' && fmtChars[i2 + 4] != '4') break;
                    state = 8;
                    i2 += 2;
                    break;
                }
                case 'S': 
                case 's': {
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'S' && fmtChars[i2 + 1] != 's') break;
                    state = 10;
                    index = i2++;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (state == 11) break;
                    state = 11;
                    index = i2;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'M' && fmtChars[i2 + 1] != 'm') break;
                    state = 12;
                    index = i2++;
                    break;
                }
                case 'T': 
                case 't': {
                    if (i2 + 2 >= sLength || fmtChars[i2 + 1] != 'Z' && fmtChars[i2 + 1] != 'z' || fmtChars[i2 + 2] != 'R' && fmtChars[i2 + 2] != 'r') break;
                    state = 13;
                    index = i2;
                    i2 += 2;
                    break;
                }
                default: {
                    needToProcessValue = true;
                }
            }
            if (!needToProcessValue || state == -1) continue;
            int length = i2 - index;
            int skip = index - prevIndex;
            vsIndex = veIndex + skip;
            veIndex = vsIndex + length;
            switch (state) {
                case 1: {
                    day = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 2: {
                    month = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 3: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i2]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (lMonths == null) {
                        lMonths = new DateFormatSymbols().getMonths();
                    }
                    for (month = 0; month < lMonths.length && !temp.equalsIgnoreCase(lMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 59");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 59);
                    break;
                }
                case 4: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i2]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (sMonths == null) {
                        sMonths = new DateFormatSymbols().getShortMonths();
                    }
                    for (month = 0; month < sMonths.length && !temp.equalsIgnoreCase(sMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CVarcharAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 59");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 59);
                    break;
                }
                case 5: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length != 2) break;
                    year += 2000;
                    break;
                }
                case 6: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length == 2 && year < 50) {
                        year += 2000;
                        break;
                    }
                    year += 1900;
                    break;
                }
                case 7: 
                case 8: {
                    veIndex = vsIndex + 2;
                    hour = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 9: {
                    minute = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 10: {
                    second = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 11: {
                    char c2;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && (c2 = value.charAt(x)) >= '0' && c2 <= '9'; ++x) {
                    }
                    if ((veIndex += x - vsIndex) == vsIndex) break;
                    nsecond = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 12: {
                    if (veIndex <= 0) break;
                    am = value.substring(vsIndex, veIndex);
                    break;
                }
                case 13: {
                    char c2;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    x = vsIndex;
                    while (x < value.length() && ((c2 = value.charAt(x)) >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                        veIndex = x++;
                    }
                    if (veIndex == vsIndex) break;
                    tzr = value.substring(vsIndex, veIndex);
                    break;
                }
                default: {
                    System.out.println("\n\n\n             ***** ERROR(1) ****\n");
                }
            }
            prevIndex = i2;
            state = -1;
            needToProcessValue = false;
        }
        GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
        if (am != null) {
            cal.set(9, am.equalsIgnoreCase("AM") ? 0 : 1);
        }
        if (tzr != null) {
            // empty if block
        }
        return cal;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CVarcharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

