/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

class T4CTTIspfp
extends T4CTTIfun {
    T4CTTIoer oer;
    T4CConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:41_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIspfp(T4CMAREngine _mrengine, T4CTTIoer _oer, T4CConnection _connection) throws IOException, SQLException {
        super((byte)3, 0, (short)138);
        this.oer = _oer;
        this.connection = _connection;
        this.setMarshalingEngine(_mrengine);
    }

    @Override
    void marshal() throws IOException, SQLException {
        super.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSWORD(100);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
    }

    void receive() throws SQLException, IOException {
        boolean mode = false;
        block7: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 9: {
                            short _endToEndECIDSequenceNumber;
                            if (this.meg.versionNumber < 10000) break block7;
                            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
                            break block7;
                        }
                        case 8: {
                            int length = this.meg.unmarshalUB2();
                            byte[] warning = this.meg.unmarshalNBytes(length);
                            if (length > 1) {
                                String warningStr = this.meg.conv.CharBytesToString(warning, length, true);
                                SQLWarning newsqlwarning = new SQLWarning(warningStr);
                                SQLWarning sqlwarning = this.connection.getWarnings();
                                if (sqlwarning == null) {
                                    this.connection.setWarnings(newsqlwarning);
                                } else {
                                    sqlwarning.setNextWarning(newsqlwarning);
                                }
                            }
                            this.meg.unmarshalUB2();
                            this.meg.unmarshalUB2();
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block7;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIspfp.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIspfp.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIspfp.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIspfp.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIspfp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

