/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;

class T4CTTIokeyval
extends T4CTTIfun {
    static final byte KVASET_KPDUSR = 1;
    static final byte KVACLA_KPDUSR = 2;
    private byte[] namespaceByteArr;
    private char[] charArr;
    private byte[][] attrArr;
    private int[] attrArrSize;
    private byte[][] valueArr;
    private int[] valueArrSize;
    private byte[] kvalflg;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:41_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIokeyval(T4CMAREngine _mrengine) throws IOException, SQLException {
        super((byte)17, 0);
        this.setMarshalingEngine(_mrengine);
        this.setFunCode((short)154);
        this.namespaceByteArr = new byte[100];
        this.charArr = new char[100];
        this.attrArr = new byte[10][];
        this.attrArrSize = new int[10];
        this.valueArr = new byte[10][];
        this.valueArrSize = new int[10];
        this.kvalflg = new byte[10];
    }

    void marshal(Namespace namespace) throws IOException, SQLException {
        String namespaceStr = namespace.name;
        String[] keys = namespace.keys;
        String[] values = namespace.values;
        boolean clear = namespace.clear;
        int nbKeyVal = namespace.nbPairs;
        int namespaceByteArrSize = namespaceStr.length() * this.meg.conv.cMaxCharSize;
        if (namespaceByteArrSize > this.namespaceByteArr.length) {
            this.namespaceByteArr = new byte[namespaceByteArrSize];
        }
        if (namespaceStr.length() > this.charArr.length) {
            this.charArr = new char[namespaceStr.length()];
        }
        namespaceStr.getChars(0, namespaceStr.length(), this.charArr, 0);
        int nbNamespaceBytes = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.namespaceByteArr, 0, namespaceStr.length());
        if (nbKeyVal > 0) {
            if (nbKeyVal > this.attrArr.length) {
                this.attrArr = new byte[nbKeyVal][];
                this.attrArrSize = new int[nbKeyVal];
                this.valueArr = new byte[nbKeyVal][];
                this.valueArrSize = new int[nbKeyVal];
                this.kvalflg = new byte[nbKeyVal];
            }
            for (int i2 = 0; i2 < nbKeyVal; ++i2) {
                String attr = keys[i2];
                String val = values[i2];
                int attrByteArrSize = attr.length() * this.meg.conv.cMaxCharSize;
                if (this.attrArr[i2] == null || this.attrArr[i2].length < attrByteArrSize) {
                    this.attrArr[i2] = new byte[attrByteArrSize];
                }
                int valueByteArrSize = val.length() * this.meg.conv.cMaxCharSize;
                if (this.valueArr[i2] == null || this.valueArr[i2].length < valueByteArrSize) {
                    this.valueArr[i2] = new byte[valueByteArrSize];
                }
                if (attr.length() > this.charArr.length) {
                    this.charArr = new char[attr.length()];
                }
                attr.getChars(0, attr.length(), this.charArr, 0);
                this.attrArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.attrArr[i2], 0, attr.length());
                if (val.length() > this.charArr.length) {
                    this.charArr = new char[val.length()];
                }
                val.getChars(0, val.length(), this.charArr, 0);
                this.valueArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.valueArr[i2], 0, val.length());
            }
        }
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalUB4(nbNamespaceBytes);
        if (nbKeyVal > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(nbKeyVal);
        int flag = 0;
        if (nbKeyVal > 0) {
            flag = 1;
        }
        if (clear) {
            flag |= 2;
        }
        this.meg.marshalUB2(flag);
        this.meg.marshalNULLPTR();
        this.meg.marshalCHR(this.namespaceByteArr, 0, nbNamespaceBytes);
        if (nbKeyVal > 0) {
            this.meg.marshalKEYVAL(this.attrArr, this.attrArrSize, this.valueArr, this.valueArrSize, this.kvalflg, nbKeyVal);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIokeyval"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

