/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.ns.BreakNetException;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5LoginClientHelper;
import oracle.sql.converter.CharacterSetMetaData;

class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName = null;
    String ressourceManagerId;
    T4CConnection conn;
    boolean bUseO5Logon;
    int verifierType;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ = true;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String DRIVER_NAME = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    String sessionTimeZone = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:40_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIoauthenticate(T4CMAREngine _mrengine, String _ressourceManagerId, T4CTTIoer _oer, T4CConnection _conn) throws SQLException {
        super((byte)3, 0, (short)0);
        this.oer = _oer;
        this.setMarshalingEngine(_mrengine);
        this.ressourceManagerId = _ressourceManagerId;
        this.conn = _conn;
        this.setSessionFields();
        this.isSessionTZ = this.conn.ver.getVersionNumber() >= 8100;
        this.bUseO5Logon = false;
    }

    void marshalOsesskey(String userName, long logonMode) throws IOException, SQLException {
        byte[] user = this.meg.conv.StringToCharBytes(userName);
        this.funCode = (short)118;
        this.marshalFunHeader();
        this.meg.marshalPTR();
        this.meg.marshalSB4(user.length);
        this.meg.marshalUB4(logonMode | 1L);
        this.meg.marshalPTR();
        T4CKvaldfList keyValList = new T4CKvaldfList(this.meg.conv);
        keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        keyValList.add(AUTH_MACHINE, this.machine);
        keyValList.add(AUTH_PID, this.processID);
        keyValList.add(AUTH_SID, this.sysUserName);
        this.meg.marshalUB4(keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalCHR(user);
        this.meg.marshalKEYVAL(keyValList.getKeys(), keyValList.getValues(), keyValList.getFlags(), keyValList.size());
    }

    void receiveOsesskey() throws IOException, SQLException {
        Object keys = null;
        Object values = null;
        int[] flags = new int[]{};
        block8: while (true) {
            try {
                while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            int nbPairs = this.meg.unmarshalUB2();
                            keys = new byte[nbPairs][];
                            values = new byte[nbPairs][];
                            flags = this.meg.unmarshalKEYVAL((byte[][])keys, (byte[][])values, nbPairs);
                            break;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            if (this.oer.getRetCode() == 28035 && this.conn.net.getAuthenticationAdaptorName() == "RADIUS") break block8;
                            this.oer.processError();
                            break block8;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        if (this.conn.net.getAuthenticationAdaptorName() != "RADIUS") {
            if (keys == null || ((byte[][])keys).length < 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 438");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 438);
            }
            int indexOfSessKey = -1;
            for (int i2 = 0; i2 < ((byte[][])keys).length; ++i2) {
                if (!new String(keys[i2]).equals(AUTH_SESSKEY)) continue;
                indexOfSessKey = i2;
                break;
            }
            if (indexOfSessKey == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 438");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 438);
            }
            this.encryptedSK = values[indexOfSessKey];
            int indexOfVfrDat = -1;
            for (int i3 = 0; i3 < ((byte[][])keys).length; ++i3) {
                if (!new String(keys[i3]).equals(AUTH_VFR_DATA)) continue;
                indexOfVfrDat = i3;
                break;
            }
            if (indexOfVfrDat != -1) {
                this.bUseO5Logon = true;
                this.salt = values[indexOfVfrDat];
                this.verifierType = flags[indexOfVfrDat];
            }
            if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 438");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 438);
            }
        }
    }

    void marshalOauth(String userStr, String passwordStr, long logonMode) throws IOException, SQLException {
        byte[] user = null;
        if (userStr != null && userStr.length() > 0) {
            user = this.meg.conv.StringToCharBytes(userStr);
        }
        byte[] passwordNet = null;
        byte[] paddedPwd = null;
        byte[] password = null;
        String authenticationAdaptor = this.conn.net.getAuthenticationAdaptorName();
        if (userStr != null && userStr.length() != 0) {
            if (authenticationAdaptor != "RADIUS" && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 413");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 413);
            }
            if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 413");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 413);
            }
            String trimUser = userStr.trim();
            String trimPwd = null;
            if (passwordStr != null) {
                trimPwd = passwordStr.trim();
            }
            passwordStr = null;
            String noQuotesUser = trimUser;
            String noQuotesPwd = trimPwd;
            if (trimUser.startsWith("\"") || trimUser.endsWith("\"")) {
                noQuotesUser = this.removeQuotes(trimUser);
            }
            if (trimPwd != null && (trimPwd.startsWith("\"") || trimPwd.endsWith("\""))) {
                noQuotesPwd = this.removeQuotes(trimPwd);
            }
            if (noQuotesPwd != null) {
                passwordNet = this.meg.conv.StringToCharBytes(noQuotesPwd);
            }
            if (authenticationAdaptor != "RADIUS") {
                if (passwordNet == null) {
                    password = null;
                } else if (this.bUseO5Logon) {
                    int k2;
                    if (this.verifierType == 2361) {
                        this.encryptedKB = new byte[64];
                        for (k2 = 0; k2 < 64; ++k2) {
                            this.encryptedKB[k2] = 1;
                        }
                    } else if (this.verifierType == 6949) {
                        this.encryptedKB = new byte[96];
                        for (k2 = 0; k2 < 96; ++k2) {
                            this.encryptedKB[k2] = 1;
                        }
                    }
                    password = new byte[256];
                    for (k2 = 0; k2 < 256; ++k2) {
                        password[k2] = 0;
                    }
                    O5LoginClientHelper.generateOAuthResponse(this.verifierType, this.salt, noQuotesUser, noQuotesPwd, passwordNet, this.encryptedSK, this.encryptedKB, password);
                } else {
                    O3LoginClientHelper loginHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
                    byte[] sessionKey = loginHelper.getSessionKey(noQuotesUser, noQuotesPwd, this.encryptedSK);
                    byte pwdPadLen = passwordNet.length % 8 > 0 ? (byte)((byte)(8 - passwordNet.length % 8)) : (byte)0;
                    paddedPwd = new byte[passwordNet.length + pwdPadLen];
                    System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                    byte[] ePwdOnSessKey = loginHelper.getEPasswd(sessionKey, paddedPwd);
                    password = new byte[2 * paddedPwd.length + 1];
                    if (password.length < 2 * ePwdOnSessKey.length) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 413");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 413);
                    }
                    RepConversion.bArray2Nibbles(ePwdOnSessKey, password);
                    password[password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
                }
            } else if (passwordNet != null) {
                int pwdPadLen = (passwordNet.length + 1) % 8 > 0 ? (int)((byte)(8 - (passwordNet.length + 1) % 8)) : 0;
                paddedPwd = new byte[passwordNet.length + 1 + pwdPadLen];
                System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                byte[] opwd = AuthenticationService.obfuscatePasswordForRadius(paddedPwd);
                password = new byte[opwd.length * 2];
                for (int i2 = 0; i2 < opwd.length; ++i2) {
                    byte b1 = (byte)((opwd[i2] & 0xF0) >> 4);
                    byte b2 = (byte)(opwd[i2] & 0xF);
                    password[i2 * 2] = (byte)(b1 < 10 ? b1 + 48 : b1 - 10 + 97);
                    password[i2 * 2 + 1] = (byte)(b2 < 10 ? b2 + 48 : b2 - 10 + 97);
                }
            }
        }
        this.doMarshalOauth(user, password, logonMode, authenticationAdaptor, false, null, null, null, -1, -1);
    }

    void marshalOauth(int type, Properties prop, int gl_session_id, int gl_serial_nb) throws IOException, SQLException {
        byte[] dn = null;
        byte[] certificate = null;
        String[] strRoles = null;
        Object roles = null;
        byte[] proxyClientUser = null;
        if (type == 1) {
            String _userStr = prop.getProperty("PROXY_USER_NAME");
            proxyClientUser = this.meg.conv.StringToCharBytes(_userStr);
        } else if (type == 2) {
            String _dnStr = prop.getProperty("PROXY_DISTINGUISHED_NAME");
            dn = this.meg.conv.StringToCharBytes(_dnStr);
        } else {
            try {
                certificate = (byte[])prop.get("PROXY_CERTIFICATE");
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < certificate.length; ++i2) {
                    String str = Integer.toHexString(0xFF & certificate[i2]);
                    int length = str.length();
                    if (length == 0) {
                        sb.append("00");
                        continue;
                    }
                    if (length == 1) {
                        sb.append('0');
                        sb.append(str);
                        continue;
                    }
                    sb.append(str);
                }
                certificate = sb.toString().getBytes();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        try {
            strRoles = (String[])prop.get("PROXY_ROLES");
        }
        catch (Exception e3) {
            // empty catch block
        }
        if (strRoles != null) {
            roles = new byte[strRoles.length][];
            for (int i3 = 0; i3 < strRoles.length; ++i3) {
                roles[i3] = this.meg.conv.StringToCharBytes(strRoles[i3]);
            }
        }
        this.doMarshalOauth(proxyClientUser, null, 0L, null, true, dn, certificate, (byte[][])roles, gl_session_id, gl_serial_nb);
    }

    void doMarshalOauth(byte[] luser, byte[] lpassword, long logonMode, String authenticationAdaptor, boolean proxyAuthentication, byte[] proxyDN, byte[] proxyCertificate, byte[][] proxyRoles, int gl_session_id, int gl_serial_nb) throws IOException, SQLException {
        this.funCode = (short)115;
        this.marshalFunHeader();
        if (luser != null && luser.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(luser.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        long flagProc = logonMode | 1L;
        if (proxyAuthentication) {
            flagProc |= 0x400L;
        }
        if (luser != null && luser.length != 0 && lpassword != null && authenticationAdaptor != "RADIUS") {
            flagProc |= 0x100L;
        }
        this.meg.marshalUB4(flagProc);
        this.meg.marshalPTR();
        T4CKvaldfList keyValList = new T4CKvaldfList(this.meg.conv);
        if (lpassword != null) {
            keyValList.add(AUTH_PASSWORD, lpassword);
        }
        if (proxyRoles != null) {
            for (int i2 = 0; i2 < proxyRoles.length; ++i2) {
                keyValList.add(AUTH_INITIAL_CLIENT_ROLE, proxyRoles[i2]);
            }
        }
        if (proxyDN != null) {
            keyValList.add(AUTH_CLIENT_DN, proxyDN);
        }
        if (proxyCertificate != null) {
            keyValList.add(AUTH_CLIENT_CERTIFICATE, proxyCertificate);
        }
        keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.bUseO5Logon && this.encryptedKB != null) {
            keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
        }
        if (this.programName != null) {
            keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        if (this.clientname != null) {
            keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
        }
        keyValList.add(AUTH_MACHINE, this.machine);
        keyValList.add(AUTH_PID, this.processID);
        if (!this.ressourceManagerId.equals("0000")) {
            byte[] key = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            key[key.length - 1] = 0;
            keyValList.add(key, this.internalName);
            key = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            key[key.length - 1] = 0;
            keyValList.add(key, this.externalName);
        }
        keyValList.add(AUTH_ACL, this.aclValue);
        keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
        if (this.editionName != null) {
            keyValList.add(AUTH_ORA_EDITION, this.editionName);
        }
        keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.meg.conv.StringToCharBytes(DRIVER_NAME));
        keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.conn.getMetaData().getDriverVersion()), 10)));
        if (gl_session_id != -1) {
            keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString(gl_session_id)));
        }
        if (gl_serial_nb != -1) {
            keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString(gl_serial_nb)));
        }
        keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
        this.meg.marshalUB4(keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (luser != null && luser.length > 0) {
            this.meg.marshalCHR(luser);
        }
        this.meg.marshalKEYVAL(keyValList.getKeys(), keyValList.getValues(), keyValList.getFlags(), keyValList.size());
    }

    void receiveOauth() throws IOException, SQLException {
        Object keys = null;
        Object values = null;
        int nbPairs = 0;
        block13: while (true) {
            try {
                block14: while (true) {
                    byte code = this.meg.unmarshalSB1();
                    switch (code) {
                        case 8: {
                            nbPairs = this.meg.unmarshalUB2();
                            keys = new byte[nbPairs][];
                            values = new byte[nbPairs][];
                            this.meg.unmarshalKEYVAL((byte[][])keys, (byte[][])values, nbPairs);
                            break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning ea) {
                                this.conn.setWarnings(DatabaseError.addSqlWarning(this.conn.getWarnings(), ea));
                            }
                            continue block14;
                        }
                        case 4: {
                            this.oer.init();
                            this.oer.unmarshal();
                            this.oer.processError();
                            break block13;
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            break;
                        }
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        Properties connectionValues = new Properties();
        for (int i2 = 0; i2 < nbPairs; ++i2) {
            String keyStr = this.meg.conv.CharBytesToString(keys[i2], keys[i2].length).trim();
            String valueStr = "";
            if (values[i2] != null) {
                valueStr = this.meg.conv.CharBytesToString(values[i2], values[i2].length).trim();
            }
            connectionValues.setProperty(keyStr, valueStr);
        }
        String versionNoStr = connectionValues.getProperty(AUTH_VERSION_NO);
        if (versionNoStr != null) {
            try {
                int serverVersionInt = new Integer(versionNoStr);
                String serverVersionStr = this.versionIntToString(serverVersionInt);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        connectionValues.setProperty("SERVER_HOST", connectionValues.getProperty(AUTH_SC_SERVER_HOST, ""));
        connectionValues.setProperty("INSTANCE_NAME", connectionValues.getProperty(AUTH_SC_INSTANCE_NAME, ""));
        connectionValues.setProperty("DATABASE_NAME", connectionValues.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
        connectionValues.setProperty("SERVICE_NAME", connectionValues.getProperty(AUTH_SC_SERVICE_NAME, ""));
        connectionValues.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
        this.conn.sessionProperties = connectionValues;
    }

    void setSessionFields() throws SQLException {
        String terminalStr = this.conn.thinVsessionTerminal;
        String machineStr = this.conn.thinVsessionMachine;
        String osuserStr = this.conn.thinVsessionOsuser;
        String programStr = this.conn.thinVsessionProgram;
        String processStr = this.conn.thinVsessionProcess;
        String internalNameStr = this.conn.thinVsessionIname;
        String externalNameStr = this.conn.thinVsessionEname;
        String clientNameStr = this.conn.proxyClientName;
        String editionStr = this.conn.editionName;
        if (machineStr == null) {
            try {
                machineStr = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e2) {
                machineStr = "jdbcclient";
            }
        }
        if (externalNameStr == null) {
            externalNameStr = "jdbc_" + this.ressourceManagerId;
        }
        this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
        this.machine = this.meg.conv.StringToCharBytes(machineStr);
        this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
        this.programName = this.meg.conv.StringToCharBytes(programStr);
        this.processID = this.meg.conv.StringToCharBytes(processStr);
        this.internalName = this.meg.conv.StringToCharBytes(internalNameStr);
        this.externalName = this.meg.conv.StringToCharBytes(externalNameStr);
        if (clientNameStr != null) {
            this.clientname = this.meg.conv.StringToCharBytes(clientNameStr);
        }
        if (editionStr != null) {
            this.editionName = this.meg.conv.StringToCharBytes(editionStr);
        }
        TimeZone tz = TimeZone.getDefault();
        int l_rawOffset = tz.getRawOffset();
        int hr = l_rawOffset / 3600000;
        int mi = l_rawOffset / 60000 % 60;
        if (tz.useDaylightTime() && tz.inDaylightTime(new Date())) {
            ++hr;
        }
        this.sessionTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
        String nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault());
        String nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault());
        if (nlslanguage == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(Level.SEVERE, "Throwing SQLException: 176");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 176);
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + " NLS_LANGUAGE='" + nlslanguage + "' NLS_TERRITORY='" + nlsterritory + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeQuotes(String str) {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(str));
                OracleLog.recursiveTrace = false;
            }
            int first = 0;
            int last = str.length() - 1;
            for (i2 = 0; i2 < str.length(); ++i2) {
                if (str.charAt(i2) == '\"') continue;
                first = i2;
                break;
            }
            for (i2 = str.length() - 1; i2 >= 0; --i2) {
                if (str.charAt(i2) == '\"') continue;
                last = i2;
                break;
            }
            String result = str.substring(first, last + 1);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private int versionStringToInt(String driverVersion) throws SQLException {
        String[] versionElements = driverVersion.split("\\.");
        int versionNumber = Integer.parseInt(versionElements[0].replaceAll("\\D", ""));
        int releaseNumber = Integer.parseInt(versionElements[1].replaceAll("\\D", ""));
        int updateNumber = Integer.parseInt(versionElements[2].replaceAll("\\D", ""));
        int portingReleaseNumber = Integer.parseInt(versionElements[3].replaceAll("\\D", ""));
        int portingUpdateNumber = Integer.parseInt(versionElements[4].replaceAll("\\D", ""));
        int numericVersion = versionNumber << 24 | releaseNumber << 20 | updateNumber << 12 | portingReleaseNumber << 8 | portingUpdateNumber;
        return numericVersion;
    }

    private String versionIntToString(int versionInt) throws SQLException {
        int versionNumber = (versionInt & 0xFF000000) >> 24 & 0xFF;
        int releaseNumber = (versionInt & 0xF00000) >> 20 & 0xFF;
        int updateNumber = (versionInt & 0xFF000) >> 12 & 0xFF;
        int portingReleaseNumber = (versionInt & 0xF00) >> 8 & 0xFF;
        int portingUpdateNumber = versionInt & 0xFF;
        String version = "" + versionNumber + "." + releaseNumber + "." + updateNumber + "." + portingReleaseNumber + "." + portingUpdateNumber;
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "return: " + this.conn);
                OracleLog.recursiveTrace = false;
            }
            T4CConnection t4CConnection = this.conn;
            return t4CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CTTIoauthenticate.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoauthenticate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

