/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4Ctoh;
import oracle.sql.TIMESTAMP;

class T4CTTIaqm {
    static final int ATTR_ORIGINAL_MSGID = 69;
    static final byte ATTR_AGENT_NAME = 64;
    static final byte ATTR_AGENT_ADDRESS = 65;
    static final byte ATTR_AGENT_PROTOCOL = 66;
    static final int AQM_MSG_NO_DELAY = 0;
    static final int AQM_MSG_NO_EXPIRATION = -1;
    static final int AQM_MSGPROP_CORRID_SIZE = 128;
    int aqmpri;
    int aqmdel;
    int aqmexp;
    String aqmcor;
    int aqmatt;
    String aqmeqn;
    int aqmsta;
    private byte[] aqmeqtBuffer = new byte[7];
    private int[] retInt = new int[1];
    TIMESTAMP aqmeqt;
    String aqmeti;
    AQAgentI senderAgent;
    byte[] originalMsgId;
    T4Ctoh toh;
    int aqmcsn;
    int aqmdsn;
    int aqmflg;
    T4CMAREngine mar;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:40_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIaqm(T4CMAREngine _mar, T4Ctoh _toh) {
        this.toh = _toh;
        this.mar = _mar;
    }

    void initToDefaultValues() {
        this.aqmpri = 0;
        this.aqmdel = 0;
        this.aqmexp = -1;
        this.aqmcor = null;
        this.aqmatt = 0;
        this.aqmeqn = null;
        this.aqmsta = 0;
        this.aqmeqt = null;
        this.aqmeti = null;
        this.senderAgent = null;
        this.originalMsgId = null;
        this.aqmcsn = 0;
        this.aqmdsn = 0;
        this.aqmflg = 0;
    }

    void marshal(T4CMAREngine mar) throws SQLException, IOException {
        mar.marshalSB4(this.aqmpri);
        mar.marshalSB4(this.aqmdel);
        mar.marshalSB4(this.aqmexp);
        if (this.aqmcor != null && this.aqmcor.length() != 0) {
            byte[] aqmcorBytes = mar.conv.StringToCharBytes(this.aqmcor);
            mar.marshalSWORD(aqmcorBytes.length);
            mar.marshalCLR(aqmcorBytes, 0, aqmcorBytes.length);
        } else {
            mar.marshalSWORD(0);
        }
        mar.marshalSB4(0);
        if (this.aqmeqn != null && this.aqmeqn.length() != 0) {
            byte[] aqmeqnBytes = mar.conv.StringToCharBytes(this.aqmeqn);
            mar.marshalSWORD(aqmeqnBytes.length);
            mar.marshalCLR(aqmeqnBytes, 0, aqmeqnBytes.length);
        } else {
            mar.marshalSWORD(0);
        }
        mar.marshalSB4(this.aqmsta);
        mar.marshalSWORD(0);
        if (mar.versionNumber >= 10000) {
            if (this.aqmeti != null && this.aqmeti.length() > 0) {
                byte[] aqmetiBytes = mar.conv.StringToCharBytes(this.aqmeti);
                mar.marshalSWORD(aqmetiBytes.length);
                mar.marshalCLR(aqmetiBytes, 0, aqmetiBytes.length);
            } else {
                mar.marshalSWORD(0);
            }
        }
        int nbExtentions = 4;
        byte[][] extensionTextValues = new byte[nbExtentions][];
        byte[][] extensionBinaryValues = new byte[nbExtentions][];
        int[] extensionKeywords = new int[nbExtentions];
        extensionTextValues[0] = (byte[])(this.senderAgent != null && this.senderAgent.getName() != null ? mar.conv.StringToCharBytes(this.senderAgent.getName()) : null);
        extensionBinaryValues[0] = null;
        extensionKeywords[0] = 64;
        extensionTextValues[1] = (byte[])(this.senderAgent != null && this.senderAgent.getAddress() != null ? mar.conv.StringToCharBytes(this.senderAgent.getAddress()) : null);
        extensionBinaryValues[1] = null;
        extensionKeywords[1] = 65;
        extensionTextValues[2] = null;
        extensionBinaryValues[2] = new byte[1];
        extensionBinaryValues[2][0] = this.senderAgent != null ? (byte)this.senderAgent.getProtocol() : (byte)0;
        extensionKeywords[2] = 66;
        extensionTextValues[3] = null;
        extensionBinaryValues[3] = this.originalMsgId;
        extensionKeywords[3] = 69;
        mar.marshalSWORD(nbExtentions);
        mar.marshalUB1((short)14);
        mar.marshalKPDKV(extensionTextValues, extensionBinaryValues, extensionKeywords);
        if (mar.versionNumber >= 10000) {
            mar.marshalUB4(1L);
            this.toh.init(T4Ctoh.ANYDATA_TOID, 0);
            this.toh.marshal(mar);
            mar.marshalUB4(0L);
            mar.marshalUB4(0L);
            if (mar.versionNumber >= 10200) {
                mar.marshalUB4(0L);
            }
        }
    }

    void receive(T4CMAREngine mar) throws SQLException, IOException {
        int aqmetil;
        this.aqmpri = mar.unmarshalSB4();
        this.aqmdel = mar.unmarshalSB4();
        this.aqmexp = mar.unmarshalSB4();
        int correlationLength = mar.unmarshalSWORD();
        if (correlationLength > 0) {
            byte[] correlationBytes = new byte[correlationLength];
            int[] intAr = new int[1];
            mar.unmarshalCLR(correlationBytes, 0, intAr, correlationBytes.length);
            this.aqmcor = mar.conv.CharBytesToString(correlationBytes, correlationBytes.length, true);
        }
        this.aqmatt = mar.unmarshalSB4();
        int exceptionQueueLength = mar.unmarshalSWORD();
        if (exceptionQueueLength > 0) {
            byte[] exceptionQueueBytes = new byte[exceptionQueueLength];
            int[] intAr = new int[1];
            mar.unmarshalCLR(exceptionQueueBytes, 0, intAr, exceptionQueueBytes.length);
            this.aqmeqn = mar.conv.CharBytesToString(exceptionQueueBytes, exceptionQueueBytes.length, true);
        }
        this.aqmsta = mar.unmarshalSB4();
        int enqueueTimeLength = mar.unmarshalSB4();
        if (enqueueTimeLength > 0) {
            mar.unmarshalCLR(this.aqmeqtBuffer, 0, this.retInt, 7);
            this.aqmeqt = new TIMESTAMP(this.aqmeqtBuffer);
        }
        if (mar.versionNumber >= 10000 && (aqmetil = mar.unmarshalSWORD()) > 0) {
            byte[] aqmetiBytes = new byte[aqmetil];
            int[] intAr = new int[1];
            mar.unmarshalCLR(aqmetiBytes, 0, intAr, aqmetiBytes.length);
            this.aqmeti = mar.conv.CharBytesToString(aqmetiBytes, aqmetiBytes.length, true);
        }
        int nbExtentions = mar.unmarshalSWORD();
        mar.unmarshalUB1();
        if (nbExtentions > 0) {
            byte[][] extensionTextValues = new byte[nbExtentions][];
            byte[][] extensionBinaryValues = new byte[nbExtentions][];
            int[] extensionKeywords = new int[nbExtentions];
            mar.unmarshalKPDKV(extensionTextValues, extensionBinaryValues, extensionKeywords);
            String aqAgentName = null;
            String aqAgentAddress = null;
            int aqAgentProtocol = 0;
            for (int i2 = 0; i2 < nbExtentions; ++i2) {
                if (extensionKeywords[i2] == 64 && extensionTextValues[i2] != null && extensionTextValues[i2].length > 0) {
                    aqAgentName = mar.conv.CharBytesToString(extensionTextValues[i2], extensionTextValues[i2].length, true);
                }
                if (extensionKeywords[i2] == 65 && extensionTextValues[i2] != null && extensionTextValues[i2].length > 0) {
                    aqAgentAddress = mar.conv.CharBytesToString(extensionTextValues[i2], extensionTextValues[i2].length, true);
                }
                if (extensionKeywords[i2] == 66 && extensionBinaryValues[i2] != null && extensionBinaryValues[i2].length > 0) {
                    aqAgentProtocol = extensionBinaryValues[i2][0];
                }
                if (extensionKeywords[i2] != 69 || extensionBinaryValues[i2] == null || extensionBinaryValues[i2].length <= 0) continue;
                this.originalMsgId = extensionBinaryValues[i2];
            }
            this.senderAgent = new AQAgentI();
            this.senderAgent.setName(aqAgentName);
            this.senderAgent.setAddress(aqAgentAddress);
            this.senderAgent.setProtocol(aqAgentProtocol);
        }
        if (mar.versionNumber >= 10000) {
            int aqmuprl = mar.unmarshalSWORD();
            this.aqmcsn = (int)mar.unmarshalUB4();
            this.aqmdsn = (int)mar.unmarshalUB4();
            if (mar.versionNumber >= 10200) {
                this.aqmflg = (int)mar.unmarshalUB4();
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIaqm"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

