/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;

class T4CPreparedStatement
extends OraclePreparedStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    boolean aFetchWasDoneDuringDescribe = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:39_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CPreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                OracleLog.recursiveTrace = false;
            }
            this.nbPostPonedColumns = new int[1];
            this.nbPostPonedColumns[0] = 0;
            this.indexOfPostPonedColumn = new int[1][3];
            this.t4Connection = (T4CConnection)conn;
            this.theRowidBinder = theStaticT4CRowidBinder;
            this.theRowidNullBinder = theStaticT4CRowidNullBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void doOall8(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe) throws SQLException, IOException {
        int i2;
        if (doParse || doDescribe || !doExecute || this.sqlKind != 2 && this.sqlKind != 1 && this.sqlKind != 4) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
        if (this.sqlKind != 1 && this.sqlKind != 4 && this.sqlKind != 3 && this.sqlKind != 0 && this.sqlKind != 2) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 439");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 439);
        }
        if (doFetch) {
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        int number_of_define_positions_local = this.numberOfDefinePositions;
        if (this.sqlKind == 2) {
            number_of_define_positions_local = 0;
        }
        if (this.accessors != null) {
            for (i2 = 0; i2 < this.accessors.length; ++i2) {
                if (this.accessors[i2] == null) continue;
                this.accessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.outBindAccessors != null) {
            for (i2 = 0; i2 < this.outBindAccessors.length; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.returnParamAccessors != null) {
            for (i2 = 0; i2 < this.returnParamAccessors.length; ++i2) {
                if (this.returnParamAccessors[i2] == null) continue;
                this.returnParamAccessors[i2].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int maxNbBytes = 0;
            if (this.ibtBindChars != null) {
                maxNbBytes = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int P = 0; P < this.numberOfBindPositions; ++P) {
                int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
                int charPitch = this.bindIndicators[subRangeOffset + 2] & 0xFFFF;
                if (charPitch == 0) continue;
                int formOfUse = this.bindIndicators[subRangeOffset + 9] & 0xFFFF;
                maxNbBytes = formOfUse == 2 ? Math.max(charPitch * this.connection.conversion.maxNCharSize, maxNbBytes) : Math.max(charPitch * this.connection.conversion.cMaxCharSize, maxNbBytes);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[maxNbBytes];
            } else if (this.tmpBindsByteArray.length < maxNbBytes) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[maxNbBytes];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        this.allocateTmpByteArray();
        T4C8Oall all8 = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        this.oacdefSent = all8.marshal(doParse, doExecute, doFetch, doDescribe, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, number_of_define_positions_local, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, this.definedColumnType, this.definedColumnSize, this.definedColumnFormOfUse, this.registration);
        try {
            all8.receive();
            this.cursorId = all8.getCursorId();
        }
        catch (SQLException ea) {
            this.cursorId = all8.getCursorId();
            if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw ea;
        }
    }

    @Override
    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseBuffers() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            super.releaseBuffers();
            this.tmpByteArray = null;
            this.tmpBindsByteArray = null;
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void allocateRowidAccessor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.needToParse = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection.disableDefinecolumntype) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: T4CStatement.defineColumnTypeInternal--DISABLED");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (column_index < 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (sizeNotGiven) {
                if (type == 1 || type == 12) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
                }
            } else if (size < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 53");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 53);
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 28");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 28);
            }
            int idx = column_index - 1;
            if (this.definedColumnType == null || this.definedColumnType.length <= idx) {
                if (this.definedColumnType == null) {
                    this.definedColumnType = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnType = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnType, 0, n_definedColumnType, 0, this.definedColumnType.length);
                    this.definedColumnType = n_definedColumnType;
                }
            }
            this.definedColumnType[idx] = type;
            if (this.definedColumnSize == null || this.definedColumnSize.length <= idx) {
                if (this.definedColumnSize == null) {
                    this.definedColumnSize = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnSize = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnSize, 0, n_definedColumnSize, 0, this.definedColumnSize.length);
                    this.definedColumnSize = n_definedColumnSize;
                }
            }
            this.definedColumnSize[idx] = size;
            if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= idx) {
                if (this.definedColumnFormOfUse == null) {
                    this.definedColumnFormOfUse = new int[(idx + 1) * 4];
                } else {
                    int[] n_definedColumnFormOfUse = new int[(idx + 1) * 4];
                    System.arraycopy(this.definedColumnFormOfUse, 0, n_definedColumnFormOfUse, 0, this.definedColumnFormOfUse.length);
                    this.definedColumnFormOfUse = n_definedColumnFormOfUse;
                }
            }
            this.definedColumnFormOfUse[idx] = form;
            if (this.accessors != null && idx < this.accessors.length && this.accessors[idx] != null) {
                this.accessors[idx].definedColumnSize = size;
                if (!(this.accessors[idx].internalType != 96 && this.accessors[idx].internalType != 1 || type != 1 && type != 12 || size > this.accessors[idx].oacmxl)) {
                    this.needToPrepareDefineBuffer = true;
                    this.columnsDefinedByUser = true;
                    this.accessors[idx].initForDataAccess(type, size, null);
                    this.accessors[idx].calculateSizeTmpByteArray();
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                super.clearDefines();
                this.definedColumnType = null;
                this.definedColumnSize = null;
                this.definedColumnFormOfUse = null;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void saveDefineBuffersIfRequired(char[] tmpDefineChars, byte[] tmpDefineBytes, short[] tmpDefineIndicators, boolean isIndicatorsReused) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tmpDefineChars) + ", " + OracleLog.argument(tmpDefineBytes) + ", " + OracleLog.argument(tmpDefineIndicators) + ", " + OracleLog.argument(isIndicatorsReused));
                OracleLog.recursiveTrace = false;
            }
            if (isIndicatorsReused) {
                tmpDefineIndicators = new short[this.defineIndicators.length];
                int lengthIndex = this.accessors[0].lengthIndexLastRow;
                int indicatorIndex = this.accessors[0].indicatorIndexLastRow;
                for (int i2 = 1; i2 <= this.accessors.length; ++i2) {
                    int length = lengthIndex + this.rowPrefetchInLastFetch * i2 - 1;
                    int indicator = indicatorIndex + this.rowPrefetchInLastFetch * i2 - 1;
                    tmpDefineIndicators[indicator] = this.defineIndicators[indicator];
                    tmpDefineIndicators[length] = this.defineIndicators[length];
                }
            }
            for (int i3 = 0; i3 < this.accessors.length; ++i3) {
                this.accessors[i3].saveDataFromOldDefineBuffers(tmpDefineBytes, tmpDefineChars, tmpDefineIndicators, this.rowPrefetchInLastFetch != -1 ? this.rowPrefetchInLastFetch : this.rowPrefetch, this.rowPrefetch);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            Accessor result = null;
            switch (internal_type) {
                case 96: {
                    result = new T4CCharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 8: {
                    if (!forBind) {
                        result = new T4CLongAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 1: {
                    result = new T4CVarcharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 2: {
                    result = new T4CNumberAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 6: {
                    result = new T4CVarnumAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 24: {
                    if (!forBind) {
                        result = new T4CLongRawAccessor(this, col_index, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                }
                case 23: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    if (forBind) {
                        result = new T4COutRawAccessor(this, max_len, form, external_type, this.t4Connection.mare);
                        break;
                    }
                    result = new T4CRawAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 100: {
                    result = new T4CBinaryFloatAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 101: {
                    result = new T4CBinaryDoubleAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 104: {
                    if (this.sqlKind == 4) {
                        result = new T4CVarcharAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                        result.definedColumnType = -8;
                        break;
                    }
                    result = new T4CRowidAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 102: {
                    result = new T4CResultSetAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 12: {
                    result = new T4CDateAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 113: {
                    result = new T4CBlobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 112: {
                    result = new T4CClobAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 114: {
                    result = new T4CBfileAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 109: {
                    result = new T4CNamedTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result.initMetadata();
                    break;
                }
                case 111: {
                    result = new T4CRefTypeAccessor(this, typeName, form, external_type, forBind, this.t4Connection.mare);
                    result.initMetadata();
                    break;
                }
                case 180: {
                    result = new T4CTimestampAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 181: {
                    result = new T4CTimestamptzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 231: {
                    result = new T4CTimestampltzAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 182: {
                    result = new T4CIntervalymAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 183: {
                    result = new T4CIntervaldsAccessor(this, max_len, form, external_type, forBind, this.t4Connection.mare);
                    break;
                }
                case 995: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 89");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            T4CCharAccessor t4CCharAccessor = result;
            return t4CCharAccessor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(includeNames));
                OracleLog.recursiveTrace = false;
            }
            if (!this.isOpen) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 144");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 144);
            }
            try {
                this.t4Connection.needLine();
                this.t4Connection.sendPiggyBackedMessages();
                this.t4Connection.describe.init(this, 0);
                this.t4Connection.describe.marshal();
                this.accessors = this.t4Connection.describe.receive(this.accessors);
                this.numberOfDefinePositions = this.t4Connection.describe.numuds;
                for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    this.accessors[i2].initMetadata();
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            this.describedWithNames = true;
            this.described = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
            this.cleanOldTempLobs();
            try {
                if (this.t4Connection.useFetchSizeWithLongColumn) {
                    this.doOall8(true, true, true, true);
                } else {
                    this.doOall8(true, true, false, true);
                }
            }
            catch (SQLException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: oracle.jdbc.driver.T4CPreparedStatement.parseExecuteDescribe: throwing " + e2);
                    OracleLog.recursiveTrace = false;
                }
                throw e2;
            }
            catch (IOException e3) {
                ((T4CConnection)this.connection).handleIOException(e3);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e3);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e3);
            }
            finally {
                this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            this.needToParse = false;
            this.aFetchWasDoneDuringDescribe = false;
            if (this.t4Connection.all8.aFetchWasDone) {
                this.aFetchWasDoneDuringDescribe = true;
                this.rowPrefetchInLastFetch = this.rowPrefetch;
            }
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
            this.needToPrepareDefineBuffer = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeMaybeDescribe() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean needExplicitFetch = true;
            if (this.rowPrefetchChanged) {
                if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
            if (!this.needToPrepareDefineBuffer) {
                if (this.accessors == null) {
                    this.needToPrepareDefineBuffer = true;
                } else if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
                }
            }
            boolean executed_for_describe = false;
            try {
                this.isExecuting = true;
                if (this.needToPrepareDefineBuffer) {
                    if (!this.columnsDefinedByUser) {
                        this.executeForDescribe();
                        executed_for_describe = true;
                        if (this.aFetchWasDoneDuringDescribe) {
                            needExplicitFetch = false;
                        }
                    } else {
                        this.prepareAccessors();
                    }
                }
                int len = this.accessors.length;
                for (int i2 = this.numberOfDefinePositions; i2 < len; ++i2) {
                    Accessor accessor = this.accessors[i2];
                    if (accessor == null) continue;
                    accessor.rowSpaceIndicator = null;
                }
                if (needExplicitFetch) {
                    this.executeForRows(executed_for_describe);
                }
            }
            catch (SQLException ea) {
                this.needToParse = true;
                throw ea;
            }
            finally {
                this.isExecuting = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean executed_for_describe) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(executed_for_describe));
                OracleLog.recursiveTrace = false;
            }
            try {
                try {
                    if (this.columnsDefinedByUser && this.needToPrepareDefineBuffer) {
                        this.needToPrepareDefineBuffer = false;
                    }
                    this.doOall8(this.needToParse, !executed_for_describe, true, false);
                    this.needToParse = false;
                }
                finally {
                    this.validRows = this.t4Connection.all8.getNumRows();
                }
            }
            catch (SQLException e2) {
                throw e2;
            }
            catch (IOException e3) {
                ((T4CConnection)this.connection).handleIOException(e3);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e3);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e3);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetch() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            try {
                this.doOall8(false, false, true, false);
                this.validRows = this.t4Connection.all8.getNumRows();
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void continueReadRow(int start) throws SQLException {
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(start));
                    OracleLog.recursiveTrace = false;
                }
                try {
                    if (!this.connection.useFetchSizeWithLongColumn) {
                        T4C8Oall all8 = this.t4Connection.all8;
                        all8.continueReadRow(start);
                    }
                }
                catch (IOException ex) {
                    ((T4CConnection)this.connection).handleIOException(ex);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
                }
                catch (SQLException ea) {
                    if (ea.getErrorCode() == DatabaseError.getVendorCode(110)) {
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
                        break block11;
                    }
                    throw ea;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
            try {
                if (this.cursorId != 0) {
                    this.t4Connection.cursorToClose[this.t4Connection.cursorToCloseOffset++] = this.cursorId;
                    if (this.t4Connection.cursorToCloseOffset >= this.t4Connection.cursorToClose.length) {
                        this.t4Connection.sendPiggyBackedMessages();
                    }
                }
            }
            catch (IOException ex) {
                ((T4CConnection)this.connection).handleIOException(ex);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + ex);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ex);
            }
            this.tmpByteArray = null;
            this.tmpBindsByteArray = null;
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            this.oacdefSent = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeQuery() throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
                if (this.streamList == null) break block9;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        ((T4CConnection)this.connection).handleIOException(exc);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T4CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder getRowidNullBinder(int index) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index));
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlKind == 4) {
                this.currentRowCharLens[index] = 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.theVarcharNullBinder);
                    OracleLog.recursiveTrace = false;
                }
                Binder binder = this.theVarcharNullBinder;
                return binder;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.theRowidNullBinder);
                OracleLog.recursiveTrace = false;
            }
            Binder binder = this.theRowidNullBinder;
            return binder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doLocalInitialization() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            super.doLocalInitialization();
            this.t4Connection.all8.bindChars = this.bindChars;
            this.t4Connection.all8.bindBytes = this.bindBytes;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T4CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CPreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

