/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleLog;

class T4CKvaldfList {
    static final int INTIAL_CAPACITY = 30;
    private int capacity;
    private int offset;
    private byte[][] keys;
    private byte[][] values;
    private byte[] flags;
    DBConversion conv;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:39_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4CKvaldfList(DBConversion _conv) {
        this.conv = _conv;
        this.initializeList();
    }

    void initializeList() {
        this.capacity = 30;
        this.offset = 0;
        this.keys = new byte[this.capacity][];
        this.values = new byte[this.capacity][];
        this.flags = new byte[this.capacity];
    }

    void add(byte[] key, byte[] value, byte flag) {
        if (this.offset == this.capacity) {
            byte[][] keys2 = new byte[this.capacity * 2][];
            byte[][] values2 = new byte[this.capacity * 2][];
            byte[] flags2 = new byte[this.capacity * 2];
            System.arraycopy(this.keys, 0, keys2, 0, this.capacity);
            System.arraycopy(this.values, 0, values2, 0, this.capacity);
            System.arraycopy(this.flags, 0, flags2, 0, this.capacity);
            this.keys = keys2;
            this.values = values2;
            this.flags = flags2;
            this.capacity *= 2;
        }
        this.keys[this.offset] = key;
        this.values[this.offset] = value;
        this.flags[this.offset++] = flag;
    }

    void add(byte[] key, byte[] value) {
        this.add(key, value, (byte)0);
    }

    void add(String key, byte[] value) throws SQLException {
        this.add(this.conv.StringToCharBytes(key), value, (byte)0);
    }

    void add(String key, byte[] value, byte flag) throws SQLException {
        this.add(this.conv.StringToCharBytes(key), value, flag);
    }

    int size() {
        return this.offset;
    }

    byte[][] getKeys() {
        return this.keys;
    }

    byte[][] getValues() {
        return this.values;
    }

    byte[] getFlags() {
        return this.flags;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CKvaldfList"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

