/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.net.ns.BreakNetException;

class T4C8Odscrarr
extends T4CTTIfun {
    byte operationflags = (byte)7;
    byte[] sqltext = new byte[0];
    long sqlparseversion = 2L;
    T4CTTIdcb dcb;
    int cursor_id = 0;
    int numuds = 0;
    boolean numitemsO2U = true;
    boolean udsarrayO2U = true;
    boolean numudsO2U = true;
    boolean colnameO2U = true;
    boolean lencolsO2U = true;
    OracleStatement statement = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:37_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T4C8Odscrarr(T4CMAREngine _mrengine, T4CTTIoer _oer) throws IOException, SQLException {
        super((byte)3, 0, (short)43);
        this.setMarshalingEngine(_mrengine);
        this.oer = _oer;
        this.funCode = (short)98;
        this.dcb = new T4CTTIdcb(_mrengine);
    }

    void init(OracleStatement stmt, int _offset) throws IOException, SQLException {
        this.numuds = 0;
        this.numitemsO2U = true;
        this.udsarrayO2U = true;
        this.numudsO2U = true;
        this.colnameO2U = true;
        this.lencolsO2U = true;
        this.oer.init();
        this.cursor_id = stmt.cursorId;
        this.statement = stmt;
        this.operationflags = (byte)7;
        this.sqltext = new byte[0];
        this.sqlparseversion = 2L;
        this.dcb.init(stmt, _offset);
    }

    @Override
    void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalUB1(this.operationflags);
        this.meg.marshalSWORD(this.cursor_id);
        if (this.sqltext.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sqltext.length);
        this.meg.marshalUB4(this.sqlparseversion);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalCHR(this.sqltext);
    }

    Accessor[] receive(Accessor[] accessors) throws SQLException, IOException {
        boolean descinfo_read = false;
        block7: while (!descinfo_read) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        accessors = this.dcb.receiveCommon(accessors, true);
                        this.numuds = this.dcb.numuds;
                        continue block7;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        descinfo_read = true;
                        continue block7;
                    }
                    case 9: {
                        descinfo_read = true;
                        continue block7;
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T4C8Odscrarr.logger().log(Level.SEVERE, "Throwing SQLException: 401");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 401);
            }
            catch (BreakNetException ea) {}
        }
        return accessors;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8Odscrarr"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

