/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CPreparedStatement
extends OraclePreparedStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:36_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T2CPreparedStatement(T2CConnection conn, String sqlText, int batchValue, int rowPrefetchValue, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sqlText, batchValue, rowPrefetchValue, UserResultSetType, UserResultSetConcur);
        this.userResultSetType = UserResultSetType;
        this.userResultSetConcur = UserResultSetConcur;
        this.connection = conn;
    }

    String bytes2String(byte[] bytes, int offset, int size) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return this.connection.conversion.CharBytesToString(tmp, size);
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int currentShort = this.connection.queryMetaData1Offset;
        int currentChar = this.connection.queryMetaData2Offset;
        short[] s2 = this.connection.queryMetaData1;
        byte[] c2 = this.connection.queryMetaData2;
        int i2 = 0;
        while (i2 < this.numberOfDefinePositions) {
            Accessor accessor;
            short accessorType = s2[currentShort + 0];
            short maxLength = s2[currentShort + 1];
            short maxCharLength = s2[currentShort + 11];
            boolean nullable = s2[currentShort + 2] != 0;
            short precision = s2[currentShort + 3];
            short scale = s2[currentShort + 4];
            int flags = 0;
            int contflag = 0;
            int totalElems = 0;
            short formOfUse = s2[currentShort + 5];
            short columnNameLen = s2[currentShort + 6];
            String columnName = this.bytes2String(c2, currentChar, columnNameLen);
            short typeNameLen = s2[currentShort + 12];
            String typeName = null;
            OracleTypeADT otype = null;
            currentChar += columnNameLen;
            if (typeNameLen > 0) {
                typeName = this.bytes2String(c2, currentChar, typeNameLen);
                currentChar += typeNameLen;
                otype = new OracleTypeADT(typeName, (Connection)this.connection);
                otype.tdoCState = ((long)s2[currentShort + 7] & 0xFFFFL) << 48 | ((long)s2[currentShort + 8] & 0xFFFFL) << 32 | ((long)s2[currentShort + 9] & 0xFFFFL) << 16 | (long)s2[currentShort + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[i2]) != null && !accessor.useForDescribeIfPossible(accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (accessorType) {
                    case 1: {
                        accessor = new VarcharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        if (maxCharLength <= 0) break;
                        accessor.setDisplaySize(maxCharLength);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        if (maxCharLength <= 0) break;
                        accessor.setDisplaySize(maxCharLength);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, i2 + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, i2 + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                        break;
                    }
                    default: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CPreparedStatement.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 1Unknown or unimplemented accessor type: " + accessorType);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + accessorType);
                    }
                }
                this.accessors[i2] = accessor;
            } else if (otype != null) {
                accessor.initMetadata();
            }
            accessor.columnName = columnName;
            ++i2;
            currentShort += 13;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDescribe(boolean includeNames) throws SQLException {
        try {
            boolean try_again;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(includeNames));
                OracleLog.recursiveTrace = false;
            }
            if (this.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
            }
            if (this.described) {
                return;
            }
            if (!this.isOpen) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 144");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 144);
            }
            do {
                try_again = false;
                this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size);
                if (this.numberOfDefinePositions == -1) {
                    this.connection.checkError(this.numberOfDefinePositions);
                }
                if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
                try_again = true;
                this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
            } while (try_again);
            this.processDescribeData();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        try {
            boolean try_again;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            boolean need_to_describe = !this.described;
            boolean executed = false;
            do {
                try_again = false;
                if (this.connection.endToEndAnyChanged) {
                    this.pushEndToEndValues();
                    this.connection.endToEndAnyChanged = false;
                }
                byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
                int status = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, need_to_describe, executed, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, this.preparedAllBinds, this.preparedCharBinds, this.accessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
                this.validRows = (int)this.t2cOutput[1];
                if (status == -1) {
                    this.connection.checkError(status);
                } else if (status == T2C_EXTEND_BUFFER) {
                    status = this.connection.queryMetaData1Size * 2;
                }
                if (this.t2cOutput[3] != 0L) {
                    this.foundPlsqlCompilerWarning();
                } else if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
                this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
                this.needToParse = false;
                executed = true;
                if (this.sqlKind == 0) {
                    this.numberOfDefinePositions = status;
                    if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                    try_again = true;
                    executed = true;
                    this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                    continue;
                }
                this.numberOfDefinePositions = 0;
                this.validRows = status;
            } while (try_again);
            this.processDescribeData();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushEndToEndValues() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            T2CConnection c2 = this.connection;
            byte[] e2e_action = new byte[]{};
            byte[] e2e_clientid = new byte[]{};
            byte[] e2e_ecid = new byte[]{};
            byte[] e2e_module = new byte[]{};
            if (c2.endToEndValues != null) {
                if (c2.endToEndHasChanged[0]) {
                    String action = c2.endToEndValues[0];
                    if (action != null) {
                        e2e_action = DBConversion.stringToDriverCharBytes(action, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[0] = false;
                }
                if (c2.endToEndHasChanged[1]) {
                    String clientid = c2.endToEndValues[1];
                    if (clientid != null) {
                        e2e_clientid = DBConversion.stringToDriverCharBytes(clientid, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[1] = false;
                }
                if (c2.endToEndHasChanged[2]) {
                    String ecid = c2.endToEndValues[2];
                    if (ecid != null) {
                        e2e_ecid = DBConversion.stringToDriverCharBytes(ecid, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[2] = false;
                }
                if (c2.endToEndHasChanged[3]) {
                    String module = c2.endToEndValues[3];
                    if (module != null) {
                        e2e_module = DBConversion.stringToDriverCharBytes(module, c2.m_clientCharacterSet);
                    }
                    c2.endToEndHasChanged[3] = false;
                }
                T2CStatement.t2cEndToEndUpdate(this.c_state, e2e_action, e2e_action.length, e2e_clientid, e2e_clientid.length, e2e_ecid, e2e_ecid.length, e2e_module, e2e_module.length, c2.endToEndECIDSequenceNumber);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean executed_for_describe) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(executed_for_describe));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            if (!executed_for_describe) {
                if (this.numberOfDefinePositions > 0) {
                    this.doDefineExecuteFetch();
                } else {
                    this.executeForDescribe();
                }
            } else if (this.numberOfDefinePositions > 0) {
                this.doDefineFetch();
            }
            this.needToPrepareDefineBuffer = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupForDefine() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfDefinePositions > this.connection.queryMetaData1Size) {
                int n2 = this.numberOfDefinePositions / 100 + 1;
                this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * n2, this.connection.queryMetaData2Size * n2 * 8);
            }
            short[] s2 = this.connection.queryMetaData1;
            int currentShort = this.connection.queryMetaData1Offset;
            int i2 = 0;
            while (i2 < this.numberOfDefinePositions) {
                Accessor currentAccessor = this.accessors[i2];
                if (currentAccessor == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
                }
                s2[currentShort + 0] = (short)currentAccessor.defineType;
                s2[currentShort + 11] = (short)currentAccessor.charLength;
                s2[currentShort + 1] = (short)currentAccessor.byteLength;
                s2[currentShort + 5] = currentAccessor.formOfUse;
                if (currentAccessor.internalOtype != null) {
                    long tdo = ((OracleTypeADT)currentAccessor.internalOtype).getTdoCState();
                    s2[currentShort + 7] = (short)((tdo & 0xFFFF000000000000L) >> 48);
                    s2[currentShort + 8] = (short)((tdo & 0xFFFF00000000L) >> 32);
                    s2[currentShort + 9] = (short)((tdo & 0xFFFF0000L) >> 16);
                    s2[currentShort + 10] = (short)(tdo & 0xFFFFL);
                }
                ++i2;
                currentShort += 13;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDefineFetch() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.needToPrepareDefineBuffer) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing Error: doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
                    OracleLog.recursiveTrace = false;
                }
                throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
            }
            this.setupForDefine();
            this.t2cOutput[2] = 0L;
            this.validRows = T2CStatement.t2cDefineFetch(this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
            if (this.validRows == -1) {
                this.connection.checkError(this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDefineExecuteFetch() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            short[] queryMetaData1 = null;
            if (this.needToPrepareDefineBuffer || this.needToParse) {
                this.setupForDefine();
                queryMetaData1 = this.connection.queryMetaData1;
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.preparedAllBinds, this.preparedCharBinds, this.accessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
            if (this.validRows == -1) {
                this.connection.checkError(this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetch() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfDefinePositions > 0) {
                if (this.needToPrepareDefineBuffer) {
                    this.doDefineFetch();
                } else {
                    this.t2cOutput[2] = 0L;
                    this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
                    if (this.validRows == -1) {
                        this.connection.checkError(this.validRows);
                    }
                    if (this.t2cOutput[2] != 0L) {
                        this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                    }
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doClose() throws SQLException {
        try {
            int returnCode;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.defineBytes != null) {
                this.defineBytes = null;
                this.accessorByteOffset = 0;
            }
            if (this.defineChars != null) {
                this.defineChars = null;
                this.accessorCharOffset = 0;
            }
            if (this.defineIndicators != null) {
                this.defineIndicators = null;
                this.accessorShortOffset = 0;
            }
            if ((returnCode = T2CStatement.t2cCloseStatement(this.c_state)) != 0) {
                this.connection.checkError(returnCode);
            }
            this.t2cOutput = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeQuery() throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.streamList == null) break block9;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            if (internal_type == 116 || internal_type == 102) {
                T2CResultSetAccessor result;
                if (forBind && typeName != null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                }
                T2CResultSetAccessor t2CResultSetAccessor = result = new T2CResultSetAccessor(this, max_len, form, external_type, forBind);
                return t2CResultSetAccessor;
            }
            Accessor __result__ = super.allocateAccessor(internal_type, external_type, col_index, max_len, form, typeName, forBind);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Accessor accessor = __result__;
            return accessor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeUsedStreams(int columnIndex) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(columnIndex));
                OracleLog.recursiveTrace = false;
            }
            while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CPreparedStatement.logger().log(OracleLog.TRACE_32, "Debug: closeUsedStream(" + columnIndex + ") closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                        OracleLog.recursiveTrace = false;
                    }
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (this.nextStream != null) {
                try {
                    this.nextStream.needBytes();
                }
                catch (IOException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        T2CPreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetchDmlReturnParams() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
            if (this.rowsDmlReturned != 0) {
                this.allocateDmlReturnStorage();
                int n2 = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
            }
            this.returnParamsFetched = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeIndicatorSubRange() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.bindIndicatorSubRange = this.numberOfBindPositions * 5;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(number_of_rows_to_be_bound) + ", " + OracleLog.argument(number_of_rows_to_be_set_up));
                OracleLog.recursiveTrace = false;
            }
            int saveBindIndicatorSubRange = this.bindIndicatorSubRange;
            this.initializeIndicatorSubRange();
            int preambleSize = this.bindIndicatorSubRange;
            this.bindIndicatorSubRange = saveBindIndicatorSubRange;
            int currentPreambleIndex = this.bindIndicatorSubRange - preambleSize;
            OracleTypeADT[] otypes = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int inout;
                OracleTypeADT otype;
                Binder binder = this.lastBinders[i2];
                if (binder == this.theReturnParamBinder) {
                    otype = (OracleTypeADT)this.returnParamAccessors[i2].internalOtype;
                    inout = 0;
                } else {
                    OracleTypeADT oracleTypeADT = otype = otypes == null ? null : otypes[i2];
                    if (this.outBindAccessors == null) {
                        inout = 0;
                    } else {
                        Accessor accessor = this.outBindAccessors[i2];
                        if (accessor == null) {
                            inout = 0;
                        } else if (binder == this.theOutBinder) {
                            inout = 1;
                            if (otype == null) {
                                otype = (OracleTypeADT)accessor.internalOtype;
                            }
                        } else {
                            inout = 2;
                        }
                    }
                    if (binder == this.theSetCHARBinder) {
                        inout = (short)(inout | 4);
                    }
                }
                this.bindIndicators[currentPreambleIndex++] = inout;
                if (otype != null) {
                    long tdo = otype.getTdoCState();
                    this.bindIndicators[currentPreambleIndex + 0] = (short)(tdo >> 48 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 1] = (short)(tdo >> 32 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 2] = (short)(tdo >> 16 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 3] = (short)(tdo & 0xFFFFL);
                }
                currentPreambleIndex += 4;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CPreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CPreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

