/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:36_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    T2CDriverExtension() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Connection getConnection(String url, Properties info) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(url) + ", " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            T2CConnection t2Conn = null;
            t2Conn = info.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(url, info, (Object)this) : new T2CConnection(url, info, this);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "return: " + t2Conn);
                OracleLog.recursiveTrace = false;
            }
            T2CConnection t2CConnection = t2Conn;
            return t2CConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleStatement allocateStatement(PhysicalConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                OracleLog.recursiveTrace = false;
            }
            T2CStatement __result__ = new T2CStatement((T2CConnection)conn, 1, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            T2CStatement t2CStatement = __result__;
            return t2CStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                OracleLog.recursiveTrace = false;
            }
            T2CPreparedStatement __result__ = new T2CPreparedStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            T2CPreparedStatement t2CPreparedStatement = __result__;
            return t2CPreparedStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleCallableStatement allocateCallableStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                OracleLog.recursiveTrace = false;
            }
            T2CCallableStatement __result__ = new T2CCallableStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            T2CCallableStatement t2CCallableStatement = __result__;
            return t2CCallableStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(accessor));
                OracleLog.recursiveTrace = false;
            }
            T2CInputStream __result__ = new T2CInputStream(stmt, index, accessor);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            T2CInputStream t2CInputStream = __result__;
            return t2CInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                T2CDriverExtension.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CDriverExtension"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

