/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor descriptor;
    OracleTypeADT otype;
    OracleType[] types;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:36_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructMetaData(StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            if (desc == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructMetaData.logger().log(Level.SEVERE, "Throwing SQLException: 1illegal operation: descriptor is null");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "illegal operation: descriptor is null");
            }
            this.descriptor = desc;
            this.otype = desc.getOracleTypeADT();
            this.types = this.otype.getAttrTypes();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + this.types.length);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.types.length;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSearchable(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrency(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + (this.types[idx] instanceof OracleTypeNUMBER || this.types[idx] instanceof OracleTypeFLOAT));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.types[idx] instanceof OracleTypeNUMBER || this.types[idx] instanceof OracleTypeFLOAT;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            boolean __result__ = this.types[idx] instanceof OracleTypeCHAR;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int isNullable(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            int idx;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (this.types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeCHAR) {
                int __result__ = ((OracleTypeCHAR)this.types[idx]).getLength();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            if (this.types[idx] instanceof OracleTypeRAW) {
                int __result__ = ((OracleTypeRAW)this.types[idx]).getLength();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n3 = __result__;
                return n3;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n4 = 0;
            return n4;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.getColumnName(column);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            String __result__ = this.otype.getAttributeName(column);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(int column) throws SQLException {
        try {
            int idx;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (this.types[idx = this.getValidColumnIndex(column)] instanceof OracleTypeADT) {
                String __result__ = ((OracleTypeADT)this.types[idx]).getSchemaName();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                String string = __result__;
                return string;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            String string = "";
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getPrecision();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScale(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getScale();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalogName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            int __result__ = this.types[idx].getTypeCode();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int type = this.getColumnType(column);
            int idx = this.getValidColumnIndex(column);
            switch (type) {
                case 12: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: VARCHAR");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "VARCHAR";
                    return string;
                }
                case 1: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: CHAR");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "CHAR";
                    return string;
                }
                case -2: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: RAW");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "RAW";
                    return string;
                }
                case 6: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: FLOAT");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "FLOAT";
                    return string;
                }
                case 2: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: NUMBER");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "NUMBER";
                    return string;
                }
                case 8: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: DOUBLE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "DOUBLE";
                    return string;
                }
                case 3: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: DECIMAL");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "DECIMAL";
                    return string;
                }
                case 100: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BINARY_FLOAT");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BINARY_FLOAT";
                    return string;
                }
                case 101: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BINARY_DOUBLE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BINARY_DOUBLE";
                    return string;
                }
                case 91: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: DATE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "DATE";
                    return string;
                }
                case -104: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: INTERVALDS");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "INTERVALDS";
                    return string;
                }
                case -103: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: INTERVALYM");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "INTERVALYM";
                    return string;
                }
                case 93: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMP");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMPTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMPTZ";
                    return string;
                }
                case -102: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMPLTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMPLTZ";
                    return string;
                }
                case 2004: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BLOB";
                    return string;
                }
                case 2005: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: CLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "CLOB";
                    return string;
                }
                case -13: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BFILE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BFILE";
                    return string;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    String __result__ = ((OracleTypeADT)this.types[idx]).getFullName();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
                case 2006: {
                    String __result__ = "REF " + ((OracleTypeREF)this.types[idx]).getFullName();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int type = this.getColumnType(column);
            switch (type) {
                case 1: 
                case 12: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: java.lang.String");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "java.lang.String";
                    return string;
                }
                case -2: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: byte[]");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "byte[]";
                    return string;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: java.math.BigDecimal");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "java.math.BigDecimal";
                    return string;
                }
                case 91: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: java.sql.Timestamp");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "java.sql.Timestamp";
                    return string;
                }
                case -103: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.INTERVALYM");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.INTERVALYM";
                    return string;
                }
                case -104: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.INTERVALDS");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.INTERVALDS";
                    return string;
                }
                case 93: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.TIMESTAMP");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.TIMESTAMPTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.TIMESTAMPTZ";
                    return string;
                }
                case -102: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.TIMESTAMPLTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.TIMESTAMPLTZ";
                    return string;
                }
                case 2004: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.BLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.BLOB";
                    return string;
                }
                case 2005: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.CLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.CLOB";
                    return string;
                }
                case -13: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.BFILE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.BFILE";
                    return string;
                }
                case 2002: 
                case 2008: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.STRUCT");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.STRUCT";
                    return string;
                }
                case 2007: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.OPAQUE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.OPAQUE";
                    return string;
                }
                case 2003: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.ARRAY");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.ARRAY";
                    return string;
                }
                case 2006: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: oracle.sql.REF");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "oracle.sql.REF";
                    return string;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOracleColumnClassName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int type = this.getColumnType(column);
            switch (type) {
                case 1: 
                case 12: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: CHAR");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "CHAR";
                    return string;
                }
                case -2: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: RAW");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "RAW";
                    return string;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: NUMBER");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "NUMBER";
                    return string;
                }
                case 91: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: DATE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "DATE";
                    return string;
                }
                case -103: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: INTERVALYM");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "INTERVALYM";
                    return string;
                }
                case -104: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: INTERVALDS");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "INTERVALDS";
                    return string;
                }
                case 93: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMP");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMP";
                    return string;
                }
                case -101: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMPTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMPTZ";
                    return string;
                }
                case -102: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: TIMESTAMPLTZ");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "TIMESTAMPLTZ";
                    return string;
                }
                case 2004: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BLOB";
                    return string;
                }
                case 2005: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: CLOB");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "CLOB";
                    return string;
                }
                case -13: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: BFILE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "BFILE";
                    return string;
                }
                case 2002: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: STRUCT");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "STRUCT";
                    return string;
                }
                case 2008: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: JAVA_STRUCT");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "JAVA_STRUCT";
                    return string;
                }
                case 2007: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: OPAQUE");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "OPAQUE";
                    return string;
                }
                case 2003: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: ARRAY");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "ARRAY";
                    return string;
                }
                case 2006: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StructMetaData.logger().log(OracleLog.TRACE_16, "return: REF");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "REF";
                    return string;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalColumnCount() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.descriptor.getLocalAttributeCount();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInherited(int column) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = column <= this.getColumnCount() - this.getLocalColumnCount();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttributeJavaName(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            String __result__ = this.descriptor.getAttributeJavaName(idx);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValidColumnIndex(int column) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            if ((index = column - 1) < 0 || index >= this.types.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    StructMetaData.logger().log(Level.SEVERE, "Throwing SQLException: 3getValidColumnIndex");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex");
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + index);
                OracleLog.recursiveTrace = false;
            }
            int n2 = index;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR(int column) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column));
                OracleLog.recursiveTrace = false;
            }
            int idx = this.getValidColumnIndex(column);
            boolean __result__ = this.types[idx].isNCHAR();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean bl;
        block10: {
            block8: {
                boolean bl2;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(iface));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!iface.isInterface()) break block8;
                        boolean __result__ = iface.isInstance(this);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(Level.SEVERE, "Throwing SQLException: 177");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            bl = false;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        block10: {
            block8: {
                StructMetaData structMetaData;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(iface));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!iface.isInterface() || !iface.isInstance(this)) break block8;
                        StructMetaData __result__ = this;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        structMetaData = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return (T)structMetaData;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(Level.SEVERE, "Throwing SQLException: 177");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            t = null;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            StructMetaData.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                StructMetaData.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.StructMetaData"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

