/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class ShortBinder
extends VarnumBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortBinder() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ShortBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ShortBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ShortBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = bindBytes;
            int offset = byteoffset + 1;
            int val = stmt.parameterInt[rank][bindPosition];
            int len = 0;
            if (val == 0) {
                b2[offset] = -128;
                len = 1;
            } else if (val < 0) {
                if (-val < 100) {
                    b2[offset] = 62;
                    b2[offset + 1] = (byte)(101 + val);
                    b2[offset + 2] = 102;
                    len = 3;
                } else if (-val < 10000) {
                    b2[offset] = 61;
                    b2[offset + 1] = (byte)(101 - -val / 100);
                    int x = -val % 100;
                    if (x != 0) {
                        b2[offset + 2] = (byte)(101 - x);
                        b2[offset + 3] = 102;
                        len = 4;
                    } else {
                        b2[offset + 2] = 102;
                        len = 3;
                    }
                } else {
                    b2[offset] = 60;
                    b2[offset + 1] = (byte)(101 - -val / 10000);
                    int x = -val % 100;
                    if (x != 0) {
                        b2[offset + 2] = (byte)(101 - -val % 10000 / 100);
                        b2[offset + 3] = (byte)(101 - x);
                        b2[offset + 4] = 102;
                        len = 5;
                    } else {
                        x = -val % 10000 / 100;
                        if (x != 0) {
                            b2[offset + 2] = (byte)(101 - x);
                            b2[offset + 3] = 102;
                            len = 4;
                        } else {
                            b2[offset + 2] = 102;
                            len = 3;
                        }
                    }
                }
            } else if (val < 100) {
                b2[offset] = -63;
                b2[offset + 1] = (byte)(val + 1);
                len = 2;
            } else if (val < 10000) {
                b2[offset] = -62;
                b2[offset + 1] = (byte)(val / 100 + 1);
                int x = val % 100;
                if (x != 0) {
                    b2[offset + 2] = (byte)(x + 1);
                    len = 3;
                } else {
                    len = 2;
                }
            } else {
                b2[offset] = -61;
                b2[offset + 1] = (byte)(val / 10000 + 1);
                int x = val % 100;
                if (x != 0) {
                    b2[offset + 2] = (byte)(val % 10000 / 100 + 1);
                    b2[offset + 3] = (byte)(x + 1);
                    len = 4;
                } else {
                    x = val % 10000 / 100;
                    if (x != 0) {
                        b2[offset + 2] = (byte)(x + 1);
                        len = 3;
                    } else {
                        len = 2;
                    }
                }
            }
            b2[byteoffset] = (byte)len;
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)(len + 1);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ShortBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ShortBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

