/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:36_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SensitiveScrollableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        super(scrollStmt, rset, type, update);
        try {
            int valid_rows;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(scrollStmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                OracleLog.recursiveTrace = false;
            }
            if ((valid_rows = rset.getValidRows()) > 0) {
                this.beginLastFetchedIndex = 1;
                this.endLastFetchedIndex = valid_rows;
            } else {
                this.beginLastFetchedIndex = 0;
                this.endLastFetchedIndex = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.next()) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.first()) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.last()) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(row));
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.absolute(row)) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rows));
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.relative(rows)) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block11: {
                block9: {
                    boolean bl2;
                    block10: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            if (!super.previous()) break block9;
                            this.handle_refetch();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                OracleLog.recursiveTrace = false;
                            }
                            bl2 = true;
                            if (!TRACE || OracleLog.recursiveTrace) break block10;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block13: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (!this.isValidRow(this.currentRow)) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 11");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    }
                    int direction = this.getFetchDirection();
                    int realSz = 0;
                    try {
                        realSz = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), direction);
                    }
                    catch (SQLException e2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, "Throwing SQLException: " + e2 + 90 + "Unsupported syntax for refreshRow()");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2, 90, "Unsupported syntax for refreshRow()");
                    }
                    if (realSz != 0) {
                        this.beginLastFetchedIndex = this.currentRow;
                        this.endLastFetchedIndex = this.currentRow + realSz - 1;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int removeRowInCache(int rowIdx) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block12: {
                try {
                    int retval;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rowIdx));
                        OracleLog.recursiveTrace = false;
                    }
                    if ((retval = super.removeRowInCache(rowIdx)) != 0) {
                        if (rowIdx >= this.beginLastFetchedIndex && rowIdx <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                            --this.endLastFetchedIndex;
                        } else {
                            this.endLastFetchedIndex = 0;
                            this.beginLastFetchedIndex = 0;
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: " + retval);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = retval;
                    if (!TRACE || OracleLog.recursiveTrace) break block12;
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handle_refetch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: false");
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.refreshRow();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    SensitiveScrollableResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SensitiveScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

