/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:35_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    ResultSetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OracleResultSet createScrollResultSet(ScrollRsetStatement owner, OracleResultSet referencedRset, int rsetType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(owner) + ", " + OracleLog.argument(referencedRset) + ", " + OracleLog.argument(rsetType));
                OracleLog.recursiveTrace = false;
            }
            switch (rsetType) {
                case 1: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + referencedRset);
                        OracleLog.recursiveTrace = false;
                    }
                    OracleResultSet oracleResultSet = referencedRset;
                    return oracleResultSet;
                }
                case 2: {
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
                case 3: {
                    ScrollableResultSet __result__ = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    ScrollableResultSet scrollableResultSet = __result__;
                    return scrollableResultSet;
                }
                case 4: {
                    ScrollableResultSet _rset = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, _rset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
                case 5: {
                    SensitiveScrollableResultSet __result__ = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    SensitiveScrollableResultSet sensitiveScrollableResultSet = __result__;
                    return sensitiveScrollableResultSet;
                }
                case 6: {
                    SensitiveScrollableResultSet _rset1 = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    UpdatableResultSet __result__ = new UpdatableResultSet(owner, _rset1, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    UpdatableResultSet updatableResultSet = __result__;
                    return updatableResultSet;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(Level.SEVERE, "Throwing SQLException: 23" + null);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 23, null);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleResultSet oracleResultSet = null;
            return oracleResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getScrollType(int typeCode) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typeCode));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = allRsetTypes[typeCode][0];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getUpdateConcurrency(int typeCode) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typeCode));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = allRsetTypes[typeCode][1];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRsetTypeCode(int scrollType, int updateConcurrency) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            for (int i2 = 0; i2 < allRsetTypes.length; ++i2) {
                if (allRsetTypes[i2][0] != scrollType || allRsetTypes[i2][1] != updateConcurrency) continue;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + i2);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = i2;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 68);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needIdentifier(int typeCode) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = typeCode != 1 && typeCode != 3;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needIdentifier(int type, int concur) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needCache(int typeCode) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = typeCode >= 3;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean needCache(int type, int concur) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean supportRefreshRow(int typeCode) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = typeCode >= 4;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean supportRefreshRow(int type, int concur) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur));
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ResultSetUtil.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ResultSetUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

