/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSQLPermission;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BufferCache;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCallableStatementWrapper;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

abstract class PhysicalConnection
extends OracleConnection {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final char left_square_bracket_character = '[';
    public static final char right_square_bracket_character = ']';
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    Properties sessionProperties = null;
    boolean retainV9BindBehavior;
    String userName;
    String database;
    boolean autocommit;
    String protocol;
    int streamChunkSize;
    boolean setFloatAndDoubleUseBinary;
    String ocidll;
    String thinVsessionTerminal;
    String thinVsessionMachine;
    String thinVsessionOsuser;
    String thinVsessionProgram;
    String thinVsessionProcess;
    String thinVsessionIname;
    String thinVsessionEname;
    String thinNetProfile;
    String thinNetAuthenticationServices;
    String thinNetAuthenticationKrb5Mutual;
    String thinNetAuthenticationKrb5CcName;
    String thinNetEncryptionLevel;
    String thinNetEncryptionTypes;
    String thinNetChecksumLevel;
    String thinNetChecksumTypes;
    String thinNetCryptoSeed;
    boolean thinTcpNoDelay;
    String thinReadTimeout;
    String thinNetConnectTimeout;
    boolean thinNetDisableOutOfBandBreak;
    boolean timestamptzInGmt;
    String thinSslServerDnMatch;
    String thinSslVersion;
    String thinSslCipherSuites;
    String thinJavaxNetSslKeystore;
    String thinJavaxNetSslKeystoretype;
    String thinJavaxNetSslKeystorepassword;
    String thinJavaxNetSslTruststore;
    String thinJavaxNetSslTruststoretype;
    String thinJavaxNetSslTruststorepassword;
    String thinSslKeymanagerfactoryAlgorithm;
    String thinSslTrustmanagerfactoryAlgorithm;
    String thinNetOldsyntax;
    String thinNamingContextInitial;
    String thinNamingProviderUrl;
    String thinNamingSecurityAuthentication;
    String thinNamingSecurityPrincipal;
    String thinNamingSecurityCredentials;
    String walletLocation;
    String proxyClientName;
    String ociDriverCharset;
    String editionName;
    String logonCap;
    String internalLogon;
    boolean createDescriptorUseCurrentSchemaForSchemaName;
    long ociSvcCtxHandle;
    long ociEnvHandle;
    long ociErrHandle;
    boolean prelimAuth;
    boolean nlsLangBackdoor;
    String setNewPassword;
    boolean spawnNewThreadToCancel;
    int defaultExecuteBatch;
    int defaultRowPrefetch;
    boolean reportRemarks;
    boolean includeSynonyms;
    boolean restrictGettables;
    boolean accumulateBatchResult;
    boolean useFetchSizeWithLongColumn;
    boolean processEscapes;
    boolean fixedString;
    boolean defaultnchar;
    boolean permitTimestampDateMismatch;
    String resourceManagerId;
    boolean disableDefinecolumntype;
    boolean convertNcharLiterals;
    boolean j2ee13Compliant;
    boolean mapDateToTimestamp;
    String url;
    String savedUser;
    int commitOption;
    int ociConnectionPoolMinLimit = 0;
    int ociConnectionPoolMaxLimit = 0;
    int ociConnectionPoolIncrement = 0;
    int ociConnectionPoolTimeout = 0;
    boolean ociConnectionPoolNoWait = false;
    boolean ociConnectionPoolTransactionDistributed = false;
    String ociConnectionPoolLogonMode = null;
    boolean ociConnectionPoolIsPooling = false;
    Object ociConnectionPoolObject = null;
    Object ociConnectionPoolConnID = null;
    String ociConnectionPoolProxyType = null;
    Integer ociConnectionPoolProxyNumRoles = new Integer(0);
    Object ociConnectionPoolProxyRoles = null;
    String ociConnectionPoolProxyUserName = null;
    String ociConnectionPoolProxyPassword = null;
    String ociConnectionPoolProxyDistinguishedName = null;
    Object ociConnectionPoolProxyCertificate = null;
    static NTFManager ntfManager = new NTFManager();
    public int protocolId = -3;
    OracleTimeout timeout;
    DBConversion conversion;
    boolean xaWantsError;
    boolean usingXA;
    int txnMode = 0;
    byte[] fdo;
    Boolean bigEndian;
    OracleStatement statements;
    int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    static final int BLOCKED = 16;
    boolean clientIdSet = false;
    String clientId = null;
    int txnLevel;
    Map map;
    Map javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statementHoldingLine;
    oracle.jdbc.OracleDatabaseMetaData databaseMetaData = null;
    LogicalConnection logicalConnectionAttached;
    boolean isProxy = false;
    OracleSql sqlObj = null;
    SQLWarning sqlWarning = null;
    boolean readOnly = false;
    LRUStatementCache statementCache = null;
    boolean clearStatementMetaData = false;
    boolean defaultAutoRefetch = true;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    Statement savepointStatement = null;
    boolean isUsable = true;
    TimeZone defaultTimeZone = null;
    static final int[] endToEndMaxLength = new int[4];
    boolean endToEndAnyChanged = false;
    final boolean[] endToEndHasChanged = new boolean[4];
    short endToEndECIDSequenceNumber = Short.MIN_VALUE;
    static final int DMS_NONE = 0;
    static final int DMS_10G = 1;
    static final int DMS_11 = 2;
    String[] endToEndValues = null;
    final int whichDMS = 0;
    oracle.jdbc.OracleConnection wrapper = null;
    int minVcsBindSize;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    String instanceName = null;
    OracleDriverExtension driverExtension;
    static final String uninitializedMarker = "";
    String databaseProductVersion = "";
    short versionNumber = (short)-1;
    int namedTypeAccessorByteLen;
    int refTypeAccessorByteLen;
    CharacterSet setCHARCharSetObj;
    CharacterSet setCHARNCharSetObj;
    boolean plsqlCompilerWarnings = false;
    private static final OracleSQLPermission CALL_ABORT_PERMISSION;
    static final String DATABASE_NAME = "DATABASE_NAME";
    static final String SERVER_HOST = "SERVER_HOST";
    static final String INSTANCE_NAME = "INSTANCE_NAME";
    static final String SERVICE_NAME = "SERVICE_NAME";
    Hashtable clientData;
    int byteBufferLength = 0;
    BufferCache byteBufferCache = null;
    int charBufferLength = 0;
    BufferCache charBufferCache = null;
    private int pingResult;
    String sessionTimeZone = null;
    Calendar dbTzCalendar = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:34_PDT_2007";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    protected PhysicalConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PhysicalConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                OracleLog.recursiveTrace = false;
            }
            this.readConnectionProperties(ur, info);
            this.driverExtension = ext;
            this.initialize(null, null, null);
            this.logicalConnectionAttached = null;
            try {
                this.needLine();
                this.logon();
                this.setAutoCommit(this.autocommit);
                if (this.getVersionNumber() >= 11000) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 32766;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32766;
                } else if (this.getVersionNumber() >= 10000) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 32512;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32512;
                } else if (this.getVersionNumber() >= 9200) {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 32512;
                    this.maxVcsCharsSql = 32766;
                    this.maxVcsNCharsSql = 32766;
                    this.maxVcsBytesPlsql = 32512;
                } else {
                    this.minVcsBindSize = 4001;
                    this.maxRawBytesSql = 2000;
                    this.maxRawBytesPlsql = 2000;
                    this.maxVcsCharsSql = 4000;
                    this.maxVcsNCharsSql = 4000;
                    this.maxVcsBytesPlsql = 4000;
                }
                this.initializeSetCHARCharSetObjs();
            }
            catch (SQLException ea) {
                try {
                    this.logoff();
                }
                catch (SQLException eb) {
                    // empty catch block
                }
                throw ea;
            }
            this.txnMode = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static final String propertyVariableName(String fieldName) {
        char[] fieldNameInChars = new char[fieldName.length()];
        fieldName.getChars(0, fieldName.length(), fieldNameInChars, 0);
        String propertyVariableName = uninitializedMarker;
        for (int i2 = 0; i2 < fieldNameInChars.length; ++i2) {
            if (Character.isUpperCase(fieldNameInChars[i2])) {
                propertyVariableName = propertyVariableName + "_";
            }
            propertyVariableName = propertyVariableName + Character.toUpperCase(fieldNameInChars[i2]);
        }
        return propertyVariableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConnectionProperties(String ul, Properties info) throws SQLException {
        try {
            String password;
            int login_timeout_value;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(ul) + ", " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            String tempval = null;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.RetainV9LongBindBehavior", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.retainV9BindBehavior = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("user")) == null) {
                tempval = info.getProperty("oracle.jdbc.user");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.user", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.userName = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("database")) == null) {
                tempval = info.getProperty("oracle.jdbc.database");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.database", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.database = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("autoCommit")) == null) {
                tempval = info.getProperty("oracle.jdbc.autoCommit");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.autoCommit", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.autocommit = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("protocol")) == null) {
                tempval = info.getProperty("oracle.jdbc.protocol");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.protocol", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.protocol = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.StreamChunkSize");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.StreamChunkSize", null);
            }
            if (tempval == null) {
                tempval = "16384";
            }
            try {
                this.streamChunkSize = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'streamChunkSize'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'streamChunkSize'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("SetFloatAndDoubleUseBinary")) == null) {
                tempval = info.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.SetFloatAndDoubleUseBinary", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.setFloatAndDoubleUseBinary = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ocinativelibrary");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ocinativelibrary", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.ocidll = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.terminal")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.terminal");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.terminal", null);
            }
            if (tempval == null) {
                tempval = "unknown";
            }
            this.thinVsessionTerminal = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.machine")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.machine");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.machine", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionMachine = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.osuser")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.osuser");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.osuser", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionOsuser = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.program")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.program");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.program", null);
            }
            if (tempval == null) {
                tempval = "JDBC Thin Client";
            }
            this.thinVsessionProgram = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.process")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.process");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.process", null);
            }
            if (tempval == null) {
                tempval = "1234";
            }
            this.thinVsessionProcess = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.iname")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.iname");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.iname", null);
            }
            if (tempval == null) {
                tempval = "jdbc_ttc_impl";
            }
            this.thinVsessionIname = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("v$session.ename")) == null) {
                tempval = info.getProperty("oracle.jdbc.v$session.ename");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.v$session.ename", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinVsessionEname = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.profile");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.profile", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetProfile = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.authentication_services");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.authentication_services", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationServices = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_mutual_authentication");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.kerberos5_mutual_authentication", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5Mutual = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.kerberos5_cc_name");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.kerberos5_cc_name", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetAuthenticationKrb5CcName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.encryption_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.encryption_types_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.encryption_types_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetEncryptionTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumLevel = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_checksum_types_client");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_types_client", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetChecksumTypes = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.crypto_seed");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.crypto_seed", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetCryptoSeed = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.TcpNoDelay");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.TcpNoDelay", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinTcpNoDelay = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ReadTimeout");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ReadTimeout", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinReadTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.CONNECT_TIMEOUT");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.CONNECT_TIMEOUT", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetConnectTimeout = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.disableOob");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.disableOob", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.thinNetDisableOutOfBandBreak = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.timestampTzInGmt");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.timestampTzInGmt", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.timestamptzInGmt = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_server_dn_match");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_server_dn_match", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslServerDnMatch = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_version");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_version", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslVersion = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.ssl_cipher_suites");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.ssl_cipher_suites", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslCipherSuites = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStore");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStore", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStoreType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStoreType", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.keyStorePassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslKeystorepassword = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStore");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStore", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststore = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStoreType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStoreType", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststoretype = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("javax.net.ssl.trustStorePassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinJavaxNetSslTruststorepassword = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslKeymanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
                tempval = info.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinSslTrustmanagerfactoryAlgorithm = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.oldSyntax");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.oldSyntax", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNetOldsyntax = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.factory.initial");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingContextInitial = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.provider.url");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingProviderUrl = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.authentication");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityAuthentication = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.principal");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityPrincipal = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("java.naming.security.credentials");
            }
            if (tempval == null) {
                tempval = null;
            }
            this.thinNamingSecurityCredentials = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.net.wallet_location");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.net.wallet_location", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.walletLocation = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.proxyClientName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.proxyClientName", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.proxyClientName = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("JDBCDriverCharSetId")) == null) {
                tempval = info.getProperty("oracle.jdbc.JDBCDriverCharSetId");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.JDBCDriverCharSetId", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.ociDriverCharset = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.editionName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.editionName", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.editionName = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.thinLogonCapability");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.thinLogonCapability", null);
            }
            if (tempval == null) {
                tempval = "o5";
            }
            this.logonCap = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("internal_logon")) == null) {
                tempval = info.getProperty("oracle.jdbc.internal_logon");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.internal_logon", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.internalLogon = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.createDescriptorUseCurrentSchemaForSchemaName = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCISvcCtxHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCISvcCtxHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCISvcCtxHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociSvcCtxHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'ociSvcCtxHandle'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociSvcCtxHandle'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIEnvHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIEnvHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCIEnvHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociEnvHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'ociEnvHandle'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociEnvHandle'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCIErrHandle")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCIErrHandle");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCIErrHandle", null);
            }
            if (tempval == null) {
                tempval = "0";
            }
            try {
                this.ociErrHandle = Long.parseLong(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'ociErrHandle'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociErrHandle'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("prelim_auth")) == null) {
                tempval = info.getProperty("oracle.jdbc.prelim_auth");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.prelim_auth", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.prelimAuth = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.ociNlsLangBackwardCompatible", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.nlsLangBackdoor = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("OCINewPassword")) == null) {
                tempval = info.getProperty("oracle.jdbc.OCINewPassword");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.OCINewPassword", null);
            }
            if (tempval == null) {
                tempval = null;
            }
            this.setNewPassword = tempval;
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.spawnNewThreadToCancel");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.spawnNewThreadToCancel", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.spawnNewThreadToCancel = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultExecuteBatch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultExecuteBatch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultExecuteBatch", null);
            }
            if (tempval == null) {
                tempval = "1";
            }
            try {
                this.defaultExecuteBatch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'defaultExecuteBatch'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultExecuteBatch'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultRowPrefetch")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultRowPrefetch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultRowPrefetch", null);
            }
            if (tempval == null) {
                tempval = "10";
            }
            try {
                this.defaultRowPrefetch = Integer.parseInt(tempval);
            }
            catch (NumberFormatException nfe) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is 'defaultRowPrefetch'");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultRowPrefetch'");
            }
            tempval = null;
            if (info != null && (tempval = info.getProperty("remarksReporting")) == null) {
                tempval = info.getProperty("oracle.jdbc.remarksReporting");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.remarksReporting", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.reportRemarks = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("includeSynonyms")) == null) {
                tempval = info.getProperty("oracle.jdbc.includeSynonyms");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.includeSynonyms", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.includeSynonyms = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("restrictGetTables")) == null) {
                tempval = info.getProperty("oracle.jdbc.restrictGetTables");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.restrictGetTables", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.restrictGettables = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("AccumulateBatchResult")) == null) {
                tempval = info.getProperty("oracle.jdbc.AccumulateBatchResult");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.AccumulateBatchResult", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.accumulateBatchResult = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("useFetchSizeWithLongColumn")) == null) {
                tempval = info.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.useFetchSizeWithLongColumn", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.useFetchSizeWithLongColumn = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("processEscapes")) == null) {
                tempval = info.getProperty("oracle.jdbc.processEscapes");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.processEscapes", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.processEscapes = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("fixedString")) == null) {
                tempval = info.getProperty("oracle.jdbc.fixedString");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.fixedString", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.fixedString = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("defaultNChar")) == null) {
                tempval = info.getProperty("oracle.jdbc.defaultNChar");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.defaultNChar", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.defaultnchar = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.permitTimestampDateMismatch = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null && (tempval = info.getProperty("RessourceManagerId")) == null) {
                tempval = info.getProperty("oracle.jdbc.RessourceManagerId");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.RessourceManagerId", null);
            }
            if (tempval == null) {
                tempval = "0000";
            }
            this.resourceManagerId = tempval;
            tempval = null;
            if (info != null && (tempval = info.getProperty("disableDefineColumnType")) == null) {
                tempval = info.getProperty("oracle.jdbc.disableDefineColumnType");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.disableDefineColumnType", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.disableDefinecolumntype = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.convertNcharLiterals");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.convertNcharLiterals", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.convertNcharLiterals = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.J2EE13Compliant");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.J2EE13Compliant", null);
            }
            if (tempval == null) {
                tempval = "false";
            }
            this.j2ee13Compliant = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.mapDateToTimestamp");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.mapDateToTimestamp", null);
            }
            if (tempval == null) {
                tempval = "true";
            }
            this.mapDateToTimestamp = tempval != null && tempval.equalsIgnoreCase("true");
            tempval = null;
            if (info != null) {
                tempval = info.getProperty("oracle.jdbc.commitOption");
            }
            if (tempval == null) {
                tempval = PhysicalConnection.getSystemProperty("oracle.jdbc.commitOption", null);
            }
            if (tempval != null) {
                this.commitOption = 0;
                String[] values = tempval.split(",");
                if (values != null && values.length > 0) {
                    for (String opt : values) {
                        if (opt.trim() == uninitializedMarker) continue;
                        this.commitOption |= OracleConnection.CommitOption.valueOf(opt.trim()).getCode();
                    }
                }
            }
            this.includeSynonyms = PhysicalConnection.parseConnectionProperty_boolean(info, "synonyms", (byte)3, this.includeSynonyms);
            this.reportRemarks = PhysicalConnection.parseConnectionProperty_boolean(info, "remarks", (byte)3, this.reportRemarks);
            this.defaultRowPrefetch = PhysicalConnection.parseConnectionProperty_int(info, "prefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultRowPrefetch = PhysicalConnection.parseConnectionProperty_int(info, "rowPrefetch", (byte)3, this.defaultRowPrefetch);
            this.defaultExecuteBatch = PhysicalConnection.parseConnectionProperty_int(info, "batch", (byte)3, this.defaultExecuteBatch);
            this.defaultExecuteBatch = PhysicalConnection.parseConnectionProperty_int(info, "executeBatch", (byte)3, this.defaultExecuteBatch);
            this.proxyClientName = PhysicalConnection.parseConnectionProperty_String(info, "PROXY_CLIENT_NAME", (byte)1, this.proxyClientName);
            if (this.defaultRowPrefetch <= 0) {
                this.defaultRowPrefetch = Integer.parseInt("10");
            }
            if (this.defaultExecuteBatch <= 0) {
                this.defaultExecuteBatch = Integer.parseInt("1");
            }
            this.streamChunkSize = this.streamChunkSize > 0 ? Math.max(4096, this.streamChunkSize) : Integer.parseInt("16384");
            if (this.thinVsessionOsuser == null) {
                this.thinVsessionOsuser = PhysicalConnection.getSystemProperty("user.name", null);
                if (this.thinVsessionOsuser == null) {
                    this.thinVsessionOsuser = "jdbcuser";
                }
            }
            if (this.thinNetConnectTimeout == CONNECTION_PROPERTY_THIN_NET_CONNECT_TIMEOUT_DEFAULT && (login_timeout_value = DriverManager.getLoginTimeout()) != 0) {
                this.thinNetConnectTimeout = uninitializedMarker + login_timeout_value * 1000;
            }
            this.url = ul;
            Hashtable url_properties = PhysicalConnection.parseUrl(this.url, this.walletLocation);
            if (this.userName == CONNECTION_PROPERTY_USER_NAME_DEFAULT) {
                this.userName = (String)url_properties.get("user");
            }
            String[] loginModeOUT = new String[1];
            String[] proxyClientNameOUT = new String[1];
            this.userName = PhysicalConnection.parseLoginOption(this.userName, info, loginModeOUT, proxyClientNameOUT);
            if (loginModeOUT[0] != null) {
                this.internalLogon = loginModeOUT[0];
            }
            if (proxyClientNameOUT[0] != null) {
                this.proxyClientName = proxyClientNameOUT[0];
            }
            if ((password = info.getProperty("password", CONNECTION_PROPERTY_PASSWORD_DEFAULT)) == CONNECTION_PROPERTY_PASSWORD_DEFAULT) {
                password = (String)url_properties.get("password");
            }
            this.initializePassword(password);
            if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
                this.database = info.getProperty("server", CONNECTION_PROPERTY_DATABASE_DEFAULT);
            }
            if (this.database == CONNECTION_PROPERTY_DATABASE_DEFAULT) {
                this.database = (String)url_properties.get("database");
            }
            this.protocol = (String)url_properties.get("protocol");
            if (this.protocol == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 40Protocol is not specified in URL");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 40, "Protocol is not specified in URL");
            }
            if (this.protocol.equals("oci8") || this.protocol.equals("oci")) {
                this.database = this.translateConnStr(this.database);
            }
            if (info.getProperty("is_connection_pooling") == "true" && this.database == null) {
                this.database = uninitializedMarker;
            }
            if (this.userName != null && !this.userName.startsWith("\"")) {
                this.userName = this.userName.toUpperCase();
            }
            this.xaWantsError = false;
            this.usingXA = false;
            this.readOCIConnectionPoolProperties(info);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOCIConnectionPoolProperties(Properties info) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            this.ociConnectionPoolMinLimit = PhysicalConnection.parseConnectionProperty_int(info, OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT, (byte)1, 0);
            this.ociConnectionPoolMaxLimit = PhysicalConnection.parseConnectionProperty_int(info, OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT, (byte)1, 0);
            this.ociConnectionPoolIncrement = PhysicalConnection.parseConnectionProperty_int(info, OracleOCIConnectionPool.CONNPOOL_INCREMENT, (byte)1, 0);
            this.ociConnectionPoolTimeout = PhysicalConnection.parseConnectionProperty_int(info, OracleOCIConnectionPool.CONNPOOL_TIMEOUT, (byte)1, 0);
            this.ociConnectionPoolNoWait = PhysicalConnection.parseConnectionProperty_boolean(info, OracleOCIConnectionPool.CONNPOOL_NOWAIT, (byte)1, false);
            this.ociConnectionPoolTransactionDistributed = PhysicalConnection.parseConnectionProperty_boolean(info, "transactions_distributed", (byte)1, false);
            this.ociConnectionPoolLogonMode = PhysicalConnection.parseConnectionProperty_String(info, "connection_pool", (byte)1, null);
            this.ociConnectionPoolIsPooling = PhysicalConnection.parseConnectionProperty_boolean(info, "is_connection_pooling", (byte)1, false);
            this.ociConnectionPoolObject = PhysicalConnection.parseConnectionProperty_Object(info, "connpool_object", null);
            this.ociConnectionPoolConnID = PhysicalConnection.parseConnectionProperty_Object(info, "connection_id", null);
            this.ociConnectionPoolProxyType = PhysicalConnection.parseConnectionProperty_String(info, "proxytype", (byte)1, null);
            this.ociConnectionPoolProxyNumRoles = (Integer)PhysicalConnection.parseConnectionProperty_Object(info, "proxy_num_roles", new Integer(0));
            this.ociConnectionPoolProxyRoles = PhysicalConnection.parseConnectionProperty_Object(info, "proxy_roles", null);
            this.ociConnectionPoolProxyUserName = PhysicalConnection.parseConnectionProperty_String(info, "proxy_user_name", (byte)1, null);
            this.ociConnectionPoolProxyPassword = PhysicalConnection.parseConnectionProperty_String(info, "proxy_password", (byte)1, null);
            this.ociConnectionPoolProxyDistinguishedName = PhysicalConnection.parseConnectionProperty_String(info, "proxy_distinguished_name", (byte)1, null);
            this.ociConnectionPoolProxyCertificate = PhysicalConnection.parseConnectionProperty_Object(info, "proxy_certificate", null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object parseConnectionProperty_Object(Properties props, String name, Object def) throws SQLException {
        try {
            Object val;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(def));
                OracleLog.recursiveTrace = false;
            }
            Object ret = def;
            if (props != null && (val = props.get(name)) != null) {
                ret = val;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            Object object = ret;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String parseConnectionProperty_String(Properties props, String name, byte mode, String def) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                OracleLog.recursiveTrace = false;
            }
            String ret = null;
            if (!(mode != 1 && mode != 3 || props == null || (ret = props.getProperty(name)) != null || name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax."))) {
                ret = props.getProperty("oracle.jdbc." + name);
            }
            if (ret == null && (mode == 2 || mode == 3)) {
                ret = name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax.") ? PhysicalConnection.getSystemProperty(name, null) : PhysicalConnection.getSystemProperty("oracle.jdbc." + name, null);
            }
            if (ret == null) {
                ret = def;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            String string = ret;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static final int parseConnectionProperty_int(Properties props, String name, byte mode, String def) throws SQLException {
        return PhysicalConnection.parseConnectionProperty_int(props, name, mode, Integer.parseInt(def));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int parseConnectionProperty_int(Properties props, String name, byte mode, int def) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                OracleLog.recursiveTrace = false;
            }
            int ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                try {
                    ret = Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is '" + name + "' and value is '" + val + "'");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 190, "Property is '" + name + "' and value is '" + val + "'");
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static final long parseConnectionProperty_long(Properties props, String name, byte mode, String def) throws SQLException {
        return PhysicalConnection.parseConnectionProperty_long(props, name, mode, Long.parseLong(def));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long parseConnectionProperty_long(Properties props, String name, byte mode, long def) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                OracleLog.recursiveTrace = false;
            }
            long ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                try {
                    ret = Long.parseLong(val);
                }
                catch (NumberFormatException nfe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 190Property is '" + name + "' and value is '" + val + "'");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(null, 190, "Property is '" + name + "' and value is '" + val + "'");
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            long l2 = ret;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static final boolean parseConnectionProperty_boolean(Properties props, String name, byte mode, String def) throws SQLException {
        return PhysicalConnection.parseConnectionProperty_boolean(props, name, mode, def.equalsIgnoreCase("true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean parseConnectionProperty_boolean(Properties props, String name, byte mode, boolean def) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(props) + ", " + OracleLog.argument(name) + ", " + OracleLog.argument(mode) + ", " + OracleLog.argument(def));
                OracleLog.recursiveTrace = false;
            }
            boolean ret = def;
            String val = PhysicalConnection.parseConnectionProperty_String(props, name, mode, null);
            if (val != null) {
                if (val.equalsIgnoreCase("false")) {
                    ret = false;
                } else if (val.equalsIgnoreCase("true")) {
                    ret = true;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseLoginOption(String _user, Properties info, String[] loginModeOUT, String[] proxyClientNameOUT) {
        try {
            String lowerCaseUser;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(_user) + ", " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            int j2 = 0;
            String userOnly = null;
            String proxyClient = null;
            if (_user == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            int len = _user.length();
            if (len == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                String string = null;
                return string;
            }
            int i2 = _user.indexOf(91);
            if (i2 > 0) {
                j2 = _user.indexOf(93);
                proxyClient = _user.substring(i2 + 1, j2);
                if ((proxyClient = proxyClient.trim()).length() > 0) {
                    proxyClientNameOUT[0] = proxyClient;
                }
                _user = _user.substring(0, i2) + _user.substring(j2 + 1, len);
            }
            if ((i2 = (lowerCaseUser = _user.toLowerCase()).lastIndexOf(" as ")) == -1 || i2 < lowerCaseUser.lastIndexOf("\"")) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + _user);
                    OracleLog.recursiveTrace = false;
                }
                String string = _user;
                return string;
            }
            userOnly = _user.substring(0, i2);
            i2 += 4;
            while (i2 < len && lowerCaseUser.charAt(i2) == ' ') {
                ++i2;
            }
            if (i2 == len) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + _user);
                    OracleLog.recursiveTrace = false;
                }
                String string = _user;
                return string;
            }
            String loginMode = lowerCaseUser.substring(i2).trim();
            if (loginMode.length() > 0) {
                loginModeOUT[0] = loginMode;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + userOnly);
                OracleLog.recursiveTrace = false;
            }
            String string = userOnly;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Hashtable parseUrl(String url, String wallet_location) throws SQLException {
        try {
            String alias;
            String[] tmpCreds;
            int end;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(url));
                OracleLog.recursiveTrace = false;
            }
            Hashtable<String, String> result = new Hashtable<String, String>(5);
            int sub_sub_index = url.indexOf(58, url.indexOf(58) + 1) + 1;
            if (sub_sub_index == (end = url.length())) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                Hashtable<String, String> hashtable = result;
                return hashtable;
            }
            int next_colon_index = url.indexOf(58, sub_sub_index);
            if (next_colon_index == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                Hashtable<String, String> hashtable = result;
                return hashtable;
            }
            result.put("protocol", url.substring(sub_sub_index, next_colon_index));
            int _user = next_colon_index + 1;
            int slash = url.indexOf(47, _user);
            int at_sign = url.indexOf(64, _user);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: sub_sub_index=" + sub_sub_index + ", end=" + end + ", next_colon_index=" + next_colon_index + ", _user=" + _user + ", slash=" + slash + ", at_sign=" + at_sign);
                OracleLog.recursiveTrace = false;
            }
            if (at_sign > _user && _user > sub_sub_index && slash == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 67");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 67);
            }
            if (at_sign == -1) {
                at_sign = end;
            }
            if (slash == -1) {
                slash = at_sign;
            }
            if (slash < at_sign && slash != _user && at_sign != _user) {
                result.put("user", url.substring(_user, slash));
                result.put("password", url.substring(slash + 1, at_sign));
            }
            if (!(slash > at_sign || slash != _user && at_sign != _user || at_sign >= end || (tmpCreds = PhysicalConnection.getSecretStoreCredentials(alias = url.substring(at_sign + 1), wallet_location))[0] == null && tmpCreds[1] == null)) {
                result.put("user", tmpCreds[0]);
                result.put("password", tmpCreds[1]);
            }
            if (at_sign < end) {
                result.put("database", url.substring(at_sign + 1));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Hashtable<String, String> hashtable = result;
            return hashtable;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] getSecretStoreCredentials(String connectString, String wallet_location) throws SQLException {
        try {
            String[] userPwd;
            block16: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                userPwd = new String[]{null, null};
                if (wallet_location != null) {
                    try {
                        OracleWallet wallet = new OracleWallet();
                        if (!wallet.exists(wallet_location)) break block16;
                        wallet.open(wallet_location, null);
                        OracleSecretStore secretStore = wallet.getSecretStore();
                        if (secretStore.containsAlias("oracle.security.client.default_username")) {
                            userPwd[0] = new String(secretStore.getSecret("oracle.security.client.default_username"));
                        }
                        if (secretStore.containsAlias("oracle.security.client.default_password")) {
                            userPwd[1] = new String(secretStore.getSecret("oracle.security.client.default_password"));
                        }
                        Enumeration list = wallet.getSecretStore().internalAliases();
                        String alias = null;
                        while (list.hasMoreElements()) {
                            alias = (String)list.nextElement();
                            if (!alias.startsWith("oracle.security.client.connect_string") || !connectString.equalsIgnoreCase(new String(secretStore.getSecret(alias)))) continue;
                            String idx = alias.substring("oracle.security.client.connect_string".length());
                            userPwd[0] = new String(secretStore.getSecret("oracle.security.client.username" + idx));
                            userPwd[1] = new String(secretStore.getSecret("oracle.security.client.password" + idx));
                            break;
                        }
                    }
                    catch (NoClassDefFoundError ndef) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 167");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(null, 167);
                    }
                    catch (Exception s2) {
                        if (s2 instanceof RuntimeException) {
                            throw (RuntimeException)s2;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 168");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(null, 168);
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + userPwd);
                OracleLog.recursiveTrace = false;
            }
            String[] stringArray = userPwd;
            return stringArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String translateConnStr(String database) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(database));
                OracleLog.recursiveTrace = false;
            }
            int fColon = 0;
            int sColon = 0;
            if (database == null || database.equals(uninitializedMarker)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + database);
                    OracleLog.recursiveTrace = false;
                }
                String string = database;
                return string;
            }
            if (database.indexOf(41) != -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + database);
                    OracleLog.recursiveTrace = false;
                }
                String string = database;
                return string;
            }
            boolean ipV6LiteralFormat = false;
            if (database.indexOf(91) != -1) {
                fColon = database.indexOf(93);
                if (fColon == -1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 67" + database);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 67, database);
                }
                ipV6LiteralFormat = true;
            }
            if ((fColon = database.indexOf(58, fColon)) == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + database);
                    OracleLog.recursiveTrace = false;
                }
                String string = database;
                return string;
            }
            sColon = database.indexOf(58, fColon + 1);
            if (sColon == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + database);
                    OracleLog.recursiveTrace = false;
                }
                String string = database;
                return string;
            }
            if (database.indexOf(58, sColon + 1) != -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 67" + database);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 67, database);
            }
            String host = null;
            host = ipV6LiteralFormat ? database.substring(1, fColon - 1) : database.substring(0, fColon);
            String port = database.substring(fColon + 1, sColon);
            String sid = database.substring(sColon + 1, database.length());
            String translate_database = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SID=" + sid + ")))";
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: translate_database=" + translate_database);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + translate_database);
                OracleLog.recursiveTrace = false;
            }
            String string = translate_database;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getSystemPropertyPollInterval() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + PhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000"));
                OracleLog.recursiveTrace = false;
            }
            String string = PhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(defaultValue));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + PhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue));
                OracleLog.recursiveTrace = false;
            }
            String string = PhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue);
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getSystemPropertyJserverVersion() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = PhysicalConnection.getSystemProperty("oracle.jserver.version", null);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemProperty(String str, String defaultValue) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(str) + ", " + OracleLog.argument(defaultValue));
                OracleLog.recursiveTrace = false;
            }
            if (str != null) {
                final String fstr = str;
                final String fdefaultValue = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        rets[0] = System.getProperty(fstr, fdefaultValue);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                            OracleLog.recursiveTrace = false;
                        }
                        return null;
                    }
                });
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + rets[0]);
                    OracleLog.recursiveTrace = false;
                }
                String string = rets[0];
                return string;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + defaultValue);
                OracleLog.recursiveTrace = false;
            }
            String string = defaultValue;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    abstract void initializePassword(String var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Properties properties;
        block16: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Properties props = new Properties();
                try {
                    Class<?> connectionclass = null;
                    Class<?> physicalConnectionClass = null;
                    try {
                        connectionclass = Class.forName("oracle.jdbc.OracleConnection");
                        physicalConnectionClass = Class.forName("oracle.jdbc.driver.PhysicalConnection");
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                    Field[] physicalConnectionFields = physicalConnectionClass.getDeclaredFields();
                    for (int i2 = 0; i2 < physicalConnectionFields.length; ++i2) {
                        String propertyValue;
                        int modifier = physicalConnectionFields[i2].getModifiers();
                        if (Modifier.isStatic(modifier)) continue;
                        String fieldName = physicalConnectionFields[i2].getName();
                        String propertyConstantName = "CONNECTION_PROPERTY_" + PhysicalConnection.propertyVariableName(fieldName);
                        Field connectionPropertyField = null;
                        try {
                            connectionPropertyField = connectionclass.getField(propertyConstantName);
                        }
                        catch (NoSuchFieldException ex) {
                            continue;
                        }
                        if (propertyConstantName.matches(".*PASSWORD.*")) continue;
                        String propertyName = (String)connectionPropertyField.get(null);
                        String typeName = physicalConnectionFields[i2].getType().getName();
                        if (typeName.equals("boolean")) {
                            boolean propertyValue2 = physicalConnectionFields[i2].getBoolean(this);
                            if (propertyValue2) {
                                props.setProperty(propertyName, "true");
                                continue;
                            }
                            props.setProperty(propertyName, "false");
                            continue;
                        }
                        if (typeName.equals("int")) {
                            int propertyValue3 = physicalConnectionFields[i2].getInt(this);
                            props.setProperty(propertyName, Integer.toString(propertyValue3));
                            continue;
                        }
                        if (typeName.equals("long")) {
                            long propertyValue4 = physicalConnectionFields[i2].getLong(this);
                            props.setProperty(propertyName, Long.toString(propertyValue4));
                            continue;
                        }
                        if (!typeName.equals("java.lang.String") || (propertyValue = (String)physicalConnectionFields[i2].get(this)) == null) continue;
                        props.setProperty(propertyName, propertyValue);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + props);
                    OracleLog.recursiveTrace = false;
                }
                properties = props;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection _getPC() {
        Connection connection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                connection = null;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        PhysicalConnection physicalConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this);
                    OracleLog.recursiveTrace = false;
                }
                physicalConnection = this;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isLogicalConnection() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Hashtable dc, Map pcmap, Map omap) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dc) + ", " + OracleLog.argument(pcmap) + ", " + OracleLog.argument(omap));
                OracleLog.recursiveTrace = false;
            }
            this.clearStatementMetaData = false;
            this.descriptorCache = dc != null ? dc : new Hashtable(10);
            this.map = pcmap;
            this.javaObjectMap = omap != null ? omap : new Hashtable(10);
            this.lifecycle = 1;
            this.txnLevel = 2;
            this.clientIdSet = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeSetCHARCharSetObjs() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.setCHARNCharSetObj = this.conversion.getDriverNCharSetObj();
            this.setCHARCharSetObj = this.conversion.getDriverCharSetObj();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleTimeout getTimeout() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.timeout == null) {
                this.timeout = OracleTimeout.newTimeout(this.url);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.timeout);
                OracleLog.recursiveTrace = false;
            }
            OracleTimeout oracleTimeout = this.timeout;
            return oracleTimeout;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement createStatement() throws SQLException {
        Statement statement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Statement __result__ = this.createStatement(-1, -1);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                statement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        OracleStatementWrapper oracleStatementWrapper;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                OracleStatement stmt = null;
                stmt = this.driverExtension.allocateStatement(this, resultSetType, resultSetConcurrency);
                OracleStatementWrapper __result__ = new OracleStatementWrapper(stmt);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleStatementWrapper = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                    OracleLog.recursiveTrace = false;
                }
                PreparedStatement __result__ = this.prepareStatement(sql, -1, -1);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                preparedStatement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement;
        block14: {
            block12: {
                PreparedStatement preparedStatement;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.lifecycle != 1) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                        }
                        if (key != null) break block12;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                            OracleLog.recursiveTrace = false;
                        }
                        preparedStatement = null;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return preparedStatement;
            }
            if (!this.isStatementCacheInitialized()) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 95");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 95);
            }
            oracle.jdbc.internal.OraclePreparedStatement pstmt = null;
            pstmt = (OraclePreparedStatement)this.statementCache.searchExplicitCache(key);
            if (pstmt != null) {
                pstmt = new OraclePreparedStatementWrapper(pstmt);
            }
            OraclePreparedStatement __result__ = pstmt;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            oraclePreparedStatement = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block14;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OraclePreparedStatementWrapper oraclePreparedStatementWrapper;
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    OracleLog.recursiveTrace = false;
                }
                if (sql == null || sql == uninitializedMarker) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 104");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 104);
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                OraclePreparedStatement pstmt = null;
                if (this.statementCache != null) {
                    pstmt = (OraclePreparedStatement)this.statementCache.searchImplicitCache(sql, 1, resultSetType != -1 || resultSetConcurrency != -1 ? ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency) : 1);
                }
                if (pstmt == null) {
                    pstmt = this.driverExtension.allocatePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
                }
                OraclePreparedStatementWrapper __result__ = new OraclePreparedStatementWrapper(pstmt);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oraclePreparedStatementWrapper = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePreparedStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStatement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                    OracleLog.recursiveTrace = false;
                }
                CallableStatement __result__ = this.prepareCall(sql, -1, -1);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                callableStatement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        OracleCallableStatementWrapper oracleCallableStatementWrapper;
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    OracleLog.recursiveTrace = false;
                }
                if (sql == null || sql == uninitializedMarker) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 104");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 104);
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                OracleCallableStatement cstmt = null;
                if (this.statementCache != null) {
                    cstmt = (OracleCallableStatement)this.statementCache.searchImplicitCache(sql, 2, resultSetType != -1 || resultSetConcurrency != -1 ? ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency) : 1);
                }
                if (cstmt == null) {
                    cstmt = this.driverExtension.allocateCallableStatement(this, sql, resultSetType, resultSetConcurrency);
                }
                OracleCallableStatementWrapper __result__ = new OracleCallableStatementWrapper(cstmt);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleCallableStatementWrapper = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleCallableStatementWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement prepareCallWithKey(String key) throws SQLException {
        OracleCallableStatement oracleCallableStatement;
        block14: {
            block12: {
                CallableStatement callableStatement;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.lifecycle != 1) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                        }
                        if (key != null) break block12;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                            OracleLog.recursiveTrace = false;
                        }
                        callableStatement = null;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return callableStatement;
            }
            if (!this.isStatementCacheInitialized()) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 95");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 95);
            }
            oracle.jdbc.internal.OracleCallableStatement cstmt = null;
            cstmt = (OracleCallableStatement)this.statementCache.searchExplicitCache(key);
            if (cstmt != null) {
                cstmt = new OracleCallableStatementWrapper(cstmt);
            }
            OracleCallableStatement __result__ = cstmt;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            oracleCallableStatement = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block14;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String sql) throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                    OracleLog.recursiveTrace = false;
                }
                if (this.sqlObj == null) {
                    this.sqlObj = new OracleSql(this.conversion);
                }
                this.sqlObj.initialize(sql);
                String osql = this.sqlObj.getSql(this.processEscapes, this.convertNcharLiterals);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + osql);
                    OracleLog.recursiveTrace = false;
                }
                string = osql;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(autoCommit));
                    OracleLog.recursiveTrace = false;
                }
                if (autoCommit) {
                    this.disallowGlobalTxnMode(116);
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                this.needLine();
                this.doSetAutoCommit(autoCommit);
                this.autocommit = autoCommit;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.autocommit);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.autocommit;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                OracleStatement stmt = this.statements;
                if (this.lifecycle != 1 && this.lifecycle != 16) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                boolean connectionHasBeenCancelled = false;
                while (stmt != null) {
                    block11: {
                        try {
                            if (stmt.doCancel()) {
                                connectionHasBeenCancelled = true;
                            }
                        }
                        catch (SQLException e2) {
                            if (!TRACE || OracleLog.recursiveTrace) break block11;
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.TRACE_10, "Event: PhysicalConnection.cancel() failed: " + e2.getMessage());
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    stmt = stmt.next;
                }
                if (!connectionHasBeenCancelled) {
                    this.cancelOperationOnServer();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    @Override
    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        int optionsAsInt = 0;
        if (options != null) {
            if (options.contains((Object)OracleConnection.CommitOption.WRITEBATCH) && options.contains((Object)OracleConnection.CommitOption.WRITEIMMED) || options.contains((Object)OracleConnection.CommitOption.WAIT) && options.contains((Object)OracleConnection.CommitOption.NOWAIT)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 191");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 191);
            }
            for (OracleConnection.CommitOption option : options) {
                optionsAsInt |= option.getCode();
            }
        }
        this.commit(optionsAsInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void commit(int flags) throws SQLException {
        block10: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(114);
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                OracleStatement s2 = this.statements;
                while (s2 != null) {
                    if (!s2.closed) {
                        s2.sendBatch();
                    }
                    s2 = s2.next;
                }
                if ((flags & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0 && (flags & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0 || (flags & OracleConnection.CommitOption.WAIT.getCode()) != 0 && (flags & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 191");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 191);
                }
                this.registerHeartbeat();
                this.needLine();
                this.doCommit(flags);
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.commit(this.commitOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(115);
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                OracleStatement s2 = this.statements;
                while (s2 != null) {
                    if (s2.isOracleBatchStyle()) {
                        s2.clearBatch();
                    }
                    s2 = s2.next;
                }
                this.registerHeartbeat();
                this.needLine();
                this.doRollback();
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block17: {
            block14: {
                block15: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.lifecycle != 2 && this.lifecycle != 4) break block14;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                            OracleLog.recursiveTrace = false;
                        }
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (this.lifecycle == 1) {
                this.lifecycle = 2;
            }
            try {
                if (this.closeCallback != null) {
                    this.closeCallback.beforeClose(this, this.privateData);
                }
                this.closeStatementCache();
                this.closeStatements(false);
                this.needLineUnchecked();
                if (this.isProxy) {
                    this.close(1);
                }
                this.logoff();
                this.cleanup();
                if (this.timeout != null) {
                    this.timeout.close();
                }
                if (this.closeCallback != null) {
                    this.closeCallback.afterClose(this.privateData);
                }
            }
            finally {
                this.lifecycle = 4;
                this.isUsable = false;
            }
            if (!TRACE || OracleLog.recursiveTrace) break block17;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        return null;
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        return null;
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInternal(boolean putPhysicalConnBackInCache) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(putPhysicalConnBackInCache));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAndClose(boolean putPhysicalConnBackInCache) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(putPhysicalConnBackInCache));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupAndClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            this.lifecycle = 16;
            this.cancel();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeLogicalConnection() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle == 1 || this.lifecycle == 16 || this.lifecycle == 2) {
                this.closeStatements(true);
                if (this.clientIdSet) {
                    this.clearClientIdentifier(this.clientId);
                }
                this.logicalConnectionAttached = null;
                this.lifecycle = 1;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Properties cachedConnectionAttributes) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cachedConnectionAttributes));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(int opt) throws SQLException {
        block10: {
            block8: {
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(opt));
                            OracleLog.recursiveTrace = false;
                        }
                        if ((opt & 0x1000) == 0) break block8;
                        this.close();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                            OracleLog.recursiveTrace = false;
                        }
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if ((opt & 1) != 0 && this.isProxy) {
                this.purgeStatementCache();
                this.closeStatements(false);
                this.closeProxySession();
                this.isProxy = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                OracleLog.recursiveTrace = false;
            }
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() throws SQLException {
        block9: {
            block7: {
                block8: {
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        security.checkPermission(CALL_ABORT_PERMISSION);
                    }
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.lifecycle != 4 && this.lifecycle != 8) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                            OracleLog.recursiveTrace = false;
                        }
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            this.lifecycle = 8;
            this.doAbort();
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    abstract void doAbort() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServerSessionInfo() throws SQLException {
        Properties properties;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                properties = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void applyConnectionAttributes(Properties cachedConnectionAttributes) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cachedConnectionAttributes));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getConnectionAttributes() throws SQLException {
        Properties properties;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                properties = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        Properties properties;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                properties = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAbandonedTimeoutEnabled(boolean val) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(val));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback occc, Object userObj, int cbkFlag) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(occc) + ", " + OracleLog.argument(userObj) + ", " + OracleLog.argument(cbkFlag));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        OracleConnectionCacheCallback oracleConnectionCacheCallback;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnectionCacheCallback = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnectionCacheCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        Object var1_1;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var1_1 = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionCacheCallbackFlag() throws SQLException {
        int n2;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setConnectionReleasePriority(int priority) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(priority));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionReleasePriority() throws SQLException {
        int n2;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isClosed() throws SQLException {
        boolean bl;
        block5: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = __result__ = this.lifecycle != 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isProxySession() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.isProxy);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.isProxy;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openProxySession(int type, Properties prop) throws SQLException {
        block22: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                    OracleLog.recursiveTrace = false;
                }
                if (this.isProxy) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 149");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 149);
                }
                this.purgeStatementCache();
                this.closeStatements(false);
                String user = prop.getProperty("PROXY_USER_NAME");
                String passwd = prop.getProperty("PROXY_USER_PASSWORD");
                String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                Object certif = prop.get("PROXY_CERTIFICATE");
                if (type == 1) {
                    if (user == null && passwd == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    }
                } else if (type == 2) {
                    if (distName == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    }
                } else if (type == 3) {
                    if (certif == null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    }
                    try {
                        byte[] verify = (byte[])certif;
                    }
                    catch (ClassCastException e2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                    }
                } else {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 150");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 150);
                }
                this.doProxySession(type, prop);
                if (!TRACE || OracleLog.recursiveTrace) break block22;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.fdo = null;
            this.conversion = null;
            this.statements = null;
            this.descriptorCache = null;
            this.map = null;
            this.javaObjectMap = null;
            this.statementHoldingLine = null;
            this.sqlObj = null;
            this.isProxy = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        oracle.jdbc.OracleDatabaseMetaData oracleDatabaseMetaData;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (this.databaseMetaData == null) {
                    this.databaseMetaData = new OracleDatabaseMetaData(this);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.databaseMetaData);
                    OracleLog.recursiveTrace = false;
                }
                oracleDatabaseMetaData = this.databaseMetaData;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleDatabaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean value) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.readOnly = value;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.readOnly);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.readOnly;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(catalog));
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                string = null;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        block13: {
            try {
                if (PhysicalConnection.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(level));
                    OracleLog.recursiveTrace = false;
                }
                ostmt = this.createStatement();
                try {
                    switch (level) {
                        case 2: {
                            ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                            this.txnLevel = 2;
                            ** break;
lbl14:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                            this.txnLevel = 8;
                            ** break;
lbl20:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (PhysicalConnection.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 30");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 30);
                            break;
                        }
                    }
                }
                finally {
                    ostmt.close();
                }
                if (!PhysicalConnection.TRACE || OracleLog.recursiveTrace) break block13;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable var4_4) {
                if (PhysicalConnection.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw var4_4;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.txnLevel);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.txnLevel;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoClose(boolean autoClose) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(autoClose));
                    OracleLog.recursiveTrace = false;
                }
                if (!autoClose) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 31");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 31);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoClose() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.sqlWarning);
                    OracleLog.recursiveTrace = false;
                }
                sQLWarning = this.sqlWarning;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.sqlWarning = null;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWarnings(SQLWarning warn) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(warn));
                    OracleLog.recursiveTrace = false;
                }
                this.sqlWarning = warn;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultRowPrefetch(int value) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                if (value <= 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 20");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 20);
                }
                this.defaultRowPrefetch = value;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultRowPrefetch() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.defaultRowPrefetch);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.defaultRowPrefetch;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDefaultExecuteBatch(int batch) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(batch));
                    OracleLog.recursiveTrace = false;
                }
                if (batch <= 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 42");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 42);
                }
                this.defaultExecuteBatch = batch;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getDefaultExecuteBatch() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.defaultExecuteBatch);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.defaultExecuteBatch;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setRemarksReporting(boolean _reportRemarks) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(_reportRemarks));
                    OracleLog.recursiveTrace = false;
                }
                this.reportRemarks = _reportRemarks;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getRemarksReporting() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.reportRemarks);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.reportRemarks;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncludeSynonyms(boolean synonyms) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(synonyms));
                    OracleLog.recursiveTrace = false;
                }
                this.includeSynonyms = synonyms;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getEndToEndMetrics() throws SQLException {
        String[] stringArray;
        block7: {
            try {
                String[] result;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.endToEndValues == null) {
                    result = null;
                } else {
                    result = new String[this.endToEndValues.length];
                    System.arraycopy(this.endToEndValues, 0, result, 0, this.endToEndValues.length);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                stringArray = result;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getEndToEndECIDSequenceNumber() throws SQLException {
        short s2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.endToEndECIDSequenceNumber);
                    OracleLog.recursiveTrace = false;
                }
                s2 = this.endToEndECIDSequenceNumber;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setEndToEndMetrics(String[] metrics, short sequenceNumber) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(metrics) + ", " + OracleLog.argument(sequenceNumber));
                    OracleLog.recursiveTrace = false;
                }
                String[] copyMetrics = new String[metrics.length];
                System.arraycopy(metrics, 0, copyMetrics, 0, metrics.length);
                this.setEndToEndMetricsInternal(copyMetrics, sequenceNumber);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEndToEndMetricsInternal(String[] metrics, short sequenceNumber) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(metrics) + ", " + OracleLog.argument(sequenceNumber));
                OracleLog.recursiveTrace = false;
            }
            if (metrics != this.endToEndValues) {
                String s2;
                int i2;
                if (metrics.length != 4) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 156");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 156);
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    s2 = metrics[i2];
                    if (s2 == null || s2.length() <= endToEndMaxLength[i2]) continue;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 159");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 159, s2);
                }
                if (this.endToEndValues != null) {
                    for (i2 = 0; i2 < 4; ++i2) {
                        s2 = metrics[i2];
                        if ((s2 != null || this.endToEndValues[i2] == null) && (s2 == null || s2.equals(this.endToEndValues[i2]))) continue;
                        this.endToEndHasChanged[i2] = true;
                        this.endToEndAnyChanged = true;
                    }
                    this.endToEndHasChanged[0] = this.endToEndHasChanged[0] | this.endToEndHasChanged[3];
                } else {
                    for (i2 = 0; i2 < 4; ++i2) {
                        this.endToEndHasChanged[i2] = true;
                    }
                    this.endToEndAnyChanged = true;
                }
                this.endToEndValues = metrics;
            }
            this.endToEndECIDSequenceNumber = sequenceNumber;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSystemContext() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetSystemContext() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSystemContext11() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIncludeSynonyms() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.includeSynonyms);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.includeSynonyms;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictGetTables(boolean restrict) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(restrict));
                    OracleLog.recursiveTrace = false;
                }
                this.restrictGettables = restrict;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRestrictGetTables() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.restrictGettables);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.restrictGettables;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultFixedString(boolean fixed) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(fixed));
                    OracleLog.recursiveTrace = false;
                }
                this.fixedString = fixed;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultNChar(boolean defnchar) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(defnchar));
                    OracleLog.recursiveTrace = false;
                }
                this.defaultnchar = defnchar;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDefaultFixedString() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.fixedString);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.fixedString;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNlsRatio() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 1;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getC2SNlsRatio() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 1;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addStatement(OracleStatement os) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(os));
                OracleLog.recursiveTrace = false;
            }
            if (os.next != null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing Error: add_statement called twice on " + os);
                    OracleLog.recursiveTrace = false;
                }
                throw new Error("add_statement called twice on " + os);
            }
            os.next = this.statements;
            if (this.statements != null) {
                this.statements.prev = os;
            }
            this.statements = os;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeStatement(OracleStatement os) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(os));
                OracleLog.recursiveTrace = false;
            }
            OracleStatement p2 = os.prev;
            OracleStatement n2 = os.next;
            if (p2 == null) {
                if (this.statements != os) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                this.statements = n2;
            } else {
                p2.next = n2;
            }
            if (n2 != null) {
                n2.prev = p2;
            }
            os.next = null;
            os.prev = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeStatements(boolean needToCache) throws SQLException {
        try {
            OracleStatement n2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(needToCache));
                OracleLog.recursiveTrace = false;
            }
            OracleStatement s2 = this.statements;
            while (s2 != null) {
                n2 = s2.nextChild;
                if (s2.serverCursor) {
                    s2.close();
                    this.removeStatement(s2);
                }
                s2 = n2;
            }
            s2 = this.statements;
            while (s2 != null) {
                n2 = s2.next;
                if (needToCache) {
                    s2.close();
                } else {
                    s2.hardClose();
                }
                this.removeStatement(s2);
                s2 = n2;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void purgeStatementCache() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.isStatementCacheInitialized()) {
                this.statementCache.purgeImplicitCache();
                this.statementCache.purgeExplicitCache();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeStatementCache() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.isStatementCacheInitialized()) {
                this.statementCache.close();
                this.statementCache = null;
                this.clearStatementMetaData = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void needLine() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            this.needLineUnchecked();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void needLineUnchecked() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.statementHoldingLine != null) {
                this.statementHoldingLine.freeLine();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void holdLine(oracle.jdbc.internal.OracleStatement stmt) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt));
                OracleLog.recursiveTrace = false;
            }
            this.holdLine((OracleStatement)stmt);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void holdLine(OracleStatement stmt) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt));
                OracleLog.recursiveTrace = false;
            }
            this.statementHoldingLine = stmt;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void releaseLine() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.releaseLineForCancel();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLineForCancel() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.statementHoldingLine = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startup(String startup_str, int mode) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(startup_str) + ", " + OracleLog.argument(mode));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startup(OracleConnection.DatabaseStartupMode mode) throws SQLException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument((Object)mode));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (mode == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                this.needLine();
                this.doStartup(mode.getMode());
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown(OracleConnection.DatabaseShutdownMode mode) throws SQLException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument((Object)mode));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (mode == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                this.needLine();
                this.doShutdown(mode.getMode());
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void archive(int mode, int aseq, String acstext) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(mode) + ", " + OracleLog.argument(aseq) + ", " + OracleLog.argument(acstext));
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSQLType(String sql_name, String java_class_name) throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(java_class_name));
                    OracleLog.recursiveTrace = false;
                }
                if (sql_name == null || java_class_name == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                try {
                    this.registerSQLType(sql_name, Class.forName(java_class_name));
                }
                catch (ClassNotFoundException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Class not found: " + java_class_name);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSQLType(String sql_name, Class java_class) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(java_class));
                    OracleLog.recursiveTrace = false;
                }
                if (sql_name == null || java_class == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                this.ensureClassMapExists();
                this.map.put(sql_name, java_class);
                this.map.put(java_class.getName(), sql_name);
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureClassMapExists() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.map == null) {
                this.initializeClassMap();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeClassMap() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Hashtable aMap = new Hashtable(10);
            this.addDefaultClassMapEntriesTo(aMap);
            this.map = aMap;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getSQLType(Object obj) throws SQLException {
        String string;
        block9: {
            block7: {
                String string2;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(obj));
                            OracleLog.recursiveTrace = false;
                        }
                        if (obj == null || this.map == null) break block7;
                        String java_class_name = obj.getClass().getName();
                        String __result__ = (String)this.map.get(java_class_name);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        string2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return string2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            string = null;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getJavaObject(String sql_name) throws SQLException {
        Object var3_3;
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql_name));
                    OracleLog.recursiveTrace = false;
                }
                Object obj = null;
                try {
                    if (sql_name != null && this.map != null) {
                        Class java_class = (Class)this.map.get(sql_name);
                        obj = java_class.newInstance();
                    }
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                }
                catch (InstantiationException e3) {
                    e3.printStackTrace();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + obj);
                    OracleLog.recursiveTrace = false;
                }
                var3_3 = obj;
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putDescriptor(String sql_name, Object desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql_name) + ", " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            if (sql_name != null && desc != null) {
                if (this.descriptorCache == null) {
                    this.descriptorCache = new Hashtable(10);
                }
                ((TypeDescriptor)desc).fixupConnection(this);
                this.descriptorCache.put(sql_name, desc);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getDescriptor(String sql_name) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql_name));
                OracleLog.recursiveTrace = false;
            }
            Object desc = null;
            if (sql_name != null && this.descriptorCache != null) {
                desc = this.descriptorCache.get(sql_name);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + desc);
                OracleLog.recursiveTrace = false;
            }
            Object var3_3 = desc;
            return var3_3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDecriptor(String sql_name) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql_name));
                OracleLog.recursiveTrace = false;
            }
            this.removeDescriptor(sql_name);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeDescriptor(String sql_name) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql_name));
                OracleLog.recursiveTrace = false;
            }
            if (sql_name != null && this.descriptorCache != null) {
                this.descriptorCache.remove(sql_name);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllDescriptor() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.descriptorCache != null) {
                this.descriptorCache.clear();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfDescriptorCacheEntries() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.descriptorCache != null) {
                int __result__ = this.descriptorCache.size();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration descriptorCacheKeys() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.descriptorCache != null) {
                Enumeration __result__ = this.descriptorCache.keys();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                Enumeration enumeration = __result__;
                return enumeration;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Enumeration enumeration = null;
            return enumeration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putDescriptor(byte[] toid, Object desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(toid) + ", " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            if (toid != null && desc != null) {
                if (this.descriptorCache == null) {
                    this.descriptorCache = new Hashtable(10);
                }
                this.descriptorCache.put(new ByteArrayKey(toid), desc);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getDescriptor(byte[] toid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(toid));
                OracleLog.recursiveTrace = false;
            }
            Object desc = null;
            if (toid != null && this.descriptorCache != null) {
                desc = this.descriptorCache.get(new ByteArrayKey(toid));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + desc);
                OracleLog.recursiveTrace = false;
            }
            Object var3_3 = desc;
            return var3_3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeDecriptor(byte[] toid) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(toid));
                OracleLog.recursiveTrace = false;
            }
            if (toid != null && this.descriptorCache != null) {
                this.descriptorCache.remove(new ByteArrayKey(toid));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getJdbcCsId() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.conversion == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 65");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 65);
            }
            short __result__ = this.conversion.getClientCharSet();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getDbCsId() throws SQLException {
        short s2;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.conversion == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 65");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 65);
                }
                short __result__ = this.conversion.getServerCharSetId();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                s2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getNCsId() throws SQLException {
        short s2;
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.conversion == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 65");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 65);
                }
                short __result__ = this.conversion.getNCharSetId();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                s2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getStructAttrCsId() throws SQLException {
        short s2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                short __result__ = this.getDbCsId();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                s2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getStructAttrNCsId() throws SQLException {
        short s2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                short __result__ = this.getNCsId();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                s2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map getTypeMap() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.ensureClassMapExists();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.map);
                OracleLog.recursiveTrace = false;
            }
            Map map = this.map;
            return map;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTypeMap(Map map) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(map));
                    OracleLog.recursiveTrace = false;
                }
                this.addDefaultClassMapEntriesTo(map);
                this.map = map;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDefaultClassMapEntriesTo(Map map) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            if (map != null) {
                this.addClassMapEntry("SYS.XMLTYPE", "oracle.xdb.XMLTypeFactory", map);
                this.addClassMapEntry("SYS.ANYDATA", "oracle.sql.AnyDataFactory", map);
                this.addClassMapEntry("SYS.ANYTYPE", "oracle.sql.TypeDescriptorFactory", map);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassMapEntry(String typeName, String className, Map theMap) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(className) + ", " + OracleLog.argument(theMap));
                OracleLog.recursiveTrace = false;
            }
            if (PhysicalConnection.containsKey(theMap, typeName)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            try {
                Class clazz = this.safelyGetClassForName(className);
                theMap.put(typeName, clazz);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setUsingXAFlag(boolean value) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.usingXA = value;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getUsingXAFlag() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.usingXA);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.usingXA;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setXAErrorFlag(boolean value) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.xaWantsError = value;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getXAErrorFlag() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.xaWantsError);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.xaWantsError;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPropertyFromDatabase(String sql) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String returnValue = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.createStatement();
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    returnValue = rs.getString(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            String __result__ = returnValue;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getUserName() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.userName == null) {
                    this.userName = this.getPropertyFromDatabase("SELECT USER FROM DUAL");
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.userName);
                    OracleLog.recursiveTrace = false;
                }
                string = this.userName;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String __result__ = this.getPropertyFromDatabase("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultSchemaNameForNamedTypes() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String returnValue = null;
                returnValue = this.createDescriptorUseCurrentSchemaForSchemaName ? this.getCurrentSchema() : this.getUserName();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + returnValue);
                    OracleLog.recursiveTrace = false;
                }
                string = returnValue;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStartTime(long startTime) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(startTime));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getStartTime() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                OracleLog.recursiveTrace = false;
            }
            long l2 = -1L;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerHeartbeat() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.logicalConnectionAttached != null) {
                this.logicalConnectionAttached.registerHeartbeat();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeartbeatNoChangeCount() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 152");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 152);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                OracleLog.recursiveTrace = false;
            }
            int n2 = -1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getFDO(boolean init) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(init));
                OracleLog.recursiveTrace = false;
            }
            if (this.fdo == null && init) {
                CallableStatement cstmt = null;
                try {
                    cstmt = this.prepareCall("begin :1 := dbms_pickler.get_format (:2); end;");
                    cstmt.registerOutParameter(1, 2);
                    cstmt.registerOutParameter(2, -4);
                    cstmt.execute();
                    this.fdo = cstmt.getBytes(2);
                }
                finally {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    cstmt = null;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.fdo);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.fdo;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFDO(byte[] fdo) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fdo));
                OracleLog.recursiveTrace = false;
            }
            this.fdo = fdo;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getBigEndian() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.bigEndian == null) {
                int[] ub1fdo = Util.toJavaUnsignedBytes(this.getFDO(true));
                int kopfdo_auxinfo = ub1fdo[6 + ub1fdo[5] + ub1fdo[6] + 5];
                int offset = kopfdo_auxinfo & 0x10;
                if (offset < 0) {
                    offset += 256;
                }
                this.bigEndian = offset > 0 ? new Boolean(true) : new Boolean(false);
            }
            boolean __result__ = this.bigEndian;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(holdability));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 1;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        OracleSavepoint oracleSavepoint;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                OracleSavepoint __result__ = this.oracleSetSavepoint();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleSavepoint = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        OracleSavepoint oracleSavepoint;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name));
                    OracleLog.recursiveTrace = false;
                }
                OracleSavepoint __result__ = this.oracleSetSavepoint(name);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleSavepoint = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(savepoint));
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(122);
                if (this.autocommit) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 121");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 121);
                }
                if (this.savepointStatement == null) {
                    this.savepointStatement = this.createStatement();
                }
                String _svptName = null;
                try {
                    _svptName = savepoint.getSavepointName();
                }
                catch (SQLException exc) {
                    _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
                }
                this.savepointStatement.executeUpdate("ROLLBACK TO " + _svptName);
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(savepoint));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                    OracleLog.recursiveTrace = false;
                }
                Statement __result__ = this.createStatement(resultSetType, resultSetConcurrency);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                statement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement preparedStatement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                    OracleLog.recursiveTrace = false;
                }
                PreparedStatement __result__ = this.prepareStatement(sql, resultSetType, resultSetConcurrency);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                preparedStatement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callableStatement;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency) + ", " + OracleLog.argument(resultSetHoldability));
                    OracleLog.recursiveTrace = false;
                }
                CallableStatement __result__ = this.prepareCall(sql, resultSetType, resultSetConcurrency);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                callableStatement = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement;
        block11: {
            block9: {
                PreparedStatement preparedStatement;
                block10: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                            OracleLog.recursiveTrace = false;
                        }
                        if (autoGeneratedKeys != 2 && AutoKeyInfo.isInsertSqlStmt(sql)) break block9;
                        PreparedStatement __result__ = this.prepareStatement(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        preparedStatement = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block10;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return preparedStatement;
            }
            if (autoGeneratedKeys != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            AutoKeyInfo info = new AutoKeyInfo(sql);
            String newSql = info.getNewSql();
            oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
            OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
            pstmt.isAutoGeneratedKey = true;
            pstmt.autoKeyInfo = info;
            pstmt.registerReturnParamsForAutoKey();
            oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            oraclePreparedStatement = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block11;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement;
        block10: {
            block8: {
                PreparedStatement preparedStatement;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block8;
                        preparedStatement = this.prepareStatement(sql);
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return preparedStatement;
            }
            if (columnIndexes == null || columnIndexes.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            AutoKeyInfo info = new AutoKeyInfo(sql, columnIndexes);
            this.doDescribeTable(info);
            String newSql = info.getNewSql();
            oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
            OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
            pstmt.isAutoGeneratedKey = true;
            pstmt.autoKeyInfo = info;
            pstmt.registerReturnParamsForAutoKey();
            oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            oraclePreparedStatement = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        oracle.jdbc.OraclePreparedStatement oraclePreparedStatement;
        block10: {
            block8: {
                PreparedStatement preparedStatement;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block8;
                        preparedStatement = this.prepareStatement(sql);
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return preparedStatement;
            }
            if (columnNames == null || columnNames.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            AutoKeyInfo info = new AutoKeyInfo(sql, columnNames);
            this.doDescribeTable(info);
            String newSql = info.getNewSql();
            oracle.jdbc.OraclePreparedStatement returnValue = (oracle.jdbc.OraclePreparedStatement)this.prepareStatement(newSql);
            OraclePreparedStatement pstmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)returnValue).preparedStatement;
            pstmt.isAutoGeneratedKey = true;
            pstmt.autoKeyInfo = info;
            pstmt.registerReturnParamsForAutoKey();
            oracle.jdbc.OraclePreparedStatement __result__ = returnValue;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            oraclePreparedStatement = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oraclePreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(117);
                if (this.autocommit) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 120");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 120);
                }
                if (this.savepointStatement == null) {
                    this.savepointStatement = this.createStatement();
                }
                oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint();
                String _svptSqlString = "SAVEPOINT ORACLE_SVPT_" + _osvpt.getSavepointId();
                this.savepointStatement.executeUpdate(_svptSqlString);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + _osvpt);
                    OracleLog.recursiveTrace = false;
                }
                oracleSavepoint = _osvpt;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name));
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(117);
                if (this.autocommit) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 120");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 120);
                }
                if (this.savepointStatement == null) {
                    this.savepointStatement = this.createStatement();
                }
                oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint(name);
                String _svptSqlString = "SAVEPOINT " + _osvpt.getSavepointName();
                this.savepointStatement.executeUpdate(_svptSqlString);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + _osvpt);
                    OracleLog.recursiveTrace = false;
                }
                oracleSavepoint = _osvpt;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(savepoint));
                    OracleLog.recursiveTrace = false;
                }
                this.disallowGlobalTxnMode(115);
                if (this.autocommit) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 121");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 121);
                }
                if (this.savepointStatement == null) {
                    this.savepointStatement = this.createStatement();
                }
                String _svptName = null;
                try {
                    _svptName = savepoint.getSavepointName();
                }
                catch (SQLException exc) {
                    _svptName = "ORACLE_SVPT_" + savepoint.getSavepointId();
                }
                this.savepointStatement.executeUpdate("ROLLBACK TO " + _svptName);
                if (!TRACE || OracleLog.recursiveTrace) break block9;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(savepoint));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disallowGlobalTxnMode(int errorCode) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(errorCode));
                OracleLog.recursiveTrace = false;
            }
            if (this.txnMode == 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: " + errorCode);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), errorCode);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTxnMode(int mode) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(mode));
                OracleLog.recursiveTrace = false;
            }
            this.txnMode = mode;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTxnMode() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.txnMode);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.txnMode;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getClientData(Object key) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(key));
                OracleLog.recursiveTrace = false;
            }
            if (this.clientData == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var2_2 = null;
                return var2_2;
            }
            Object __result__ = this.clientData.get(key);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object v = __result__;
            return v;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object setClientData(Object key, Object value) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(key) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            if (this.clientData == null) {
                this.clientData = new Hashtable();
            }
            Object __result__ = this.clientData.put(key, value);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object removeClientData(Object key) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(key));
                OracleLog.recursiveTrace = false;
            }
            if (this.clientData == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Object var2_2 = null;
                return var2_2;
            }
            Object __result__ = this.clientData.remove(key);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object v = __result__;
            return v;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobDBAccess createBlobDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            BlobDBAccess blobDBAccess = null;
            return blobDBAccess;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClobDBAccess createClobDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            ClobDBAccess clobDBAccess = null;
            return clobDBAccess;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BfileDBAccess createBfileDBAccess() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            BfileDBAccess bfileDBAccess = null;
            return bfileDBAccess;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printState() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                short jdbc_cs_id = this.getJdbcCsId();
                short db_cs_id = this.getDbCsId();
                short struct_cs_id = this.getStructAttrCsId();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProtocolType() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.protocol);
                OracleLog.recursiveTrace = false;
            }
            String string = this.protocol;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURL() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.url);
                    OracleLog.recursiveTrace = false;
                }
                string = this.url;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStmtCacheSize(int size) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(size));
                    OracleLog.recursiveTrace = false;
                }
                this.setStatementCacheSize(size);
                this.setImplicitCachingEnabled(true);
                this.setExplicitCachingEnabled(true);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(size) + ", " + OracleLog.argument(clearMetaData));
                    OracleLog.recursiveTrace = false;
                }
                this.setStatementCacheSize(size);
                this.setImplicitCachingEnabled(true);
                this.setExplicitCachingEnabled(true);
                this.clearStatementMetaData = clearMetaData;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getStmtCacheSize() {
        int n2;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int returnValue = 0;
                try {
                    returnValue = this.getStatementCacheSize();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (returnValue == -1) {
                    returnValue = 0;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + returnValue);
                    OracleLog.recursiveTrace = false;
                }
                n2 = returnValue;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setStatementCacheSize(int size) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(size));
                    OracleLog.recursiveTrace = false;
                }
                if (this.statementCache == null) {
                    this.statementCache = new LRUStatementCache(size);
                    this.byteBufferCache = new BufferCache(size);
                    this.charBufferCache = new BufferCache(size);
                } else {
                    this.statementCache.resize(size);
                    this.byteBufferCache.resize(size);
                    this.charBufferCache.resize(size);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getStatementCacheSize() throws SQLException {
        int n2;
        block9: {
            block7: {
                int n3;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.statementCache != null) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = -1;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            int __result__ = this.statementCache.getCacheSize();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            n2 = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setImplicitCachingEnabled(boolean cache) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cache));
                    OracleLog.recursiveTrace = false;
                }
                if (this.statementCache == null) {
                    this.statementCache = new LRUStatementCache(0);
                    this.byteBufferCache = new BufferCache(0);
                    this.charBufferCache = new BufferCache(0);
                }
                this.statementCache.setImplicitCachingEnabled(cache);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl;
        block9: {
            block7: {
                boolean bl2;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.statementCache != null) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = false;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            boolean __result__ = this.statementCache.getImplicitCachingEnabled();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            bl = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setExplicitCachingEnabled(boolean cache) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cache));
                    OracleLog.recursiveTrace = false;
                }
                if (this.statementCache == null) {
                    this.statementCache = new LRUStatementCache(0);
                    this.byteBufferCache = new BufferCache(0);
                    this.charBufferCache = new BufferCache(0);
                }
                this.statementCache.setExplicitCachingEnabled(cache);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl;
        block9: {
            block7: {
                boolean bl2;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.statementCache != null) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = false;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            boolean __result__ = this.statementCache.getExplicitCachingEnabled();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            bl = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void purgeImplicitCache() throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.statementCache != null) {
                    this.statementCache.purgeImplicitCache();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void purgeExplicitCache() throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.statementCache != null) {
                    this.statementCache.purgeExplicitCache();
                }
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PreparedStatement getStatementWithKey(String key) throws SQLException {
        PreparedStatement preparedStatement;
        block14: {
            block10: {
                PreparedStatement preparedStatement2;
                block13: {
                    block11: {
                        PreparedStatement preparedStatement3;
                        block12: {
                            try {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                                    OracleLog.recursiveTrace = false;
                                }
                                if (this.statementCache == null) break block10;
                                OracleStatement os = this.statementCache.searchExplicitCache(key);
                                if (os != null && os.statementType != 1) break block11;
                                PreparedStatement __result__ = (PreparedStatement)((Object)os);
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                    OracleLog.recursiveTrace = false;
                                }
                                preparedStatement3 = __result__;
                                if (!TRACE || OracleLog.recursiveTrace) break block12;
                                OracleLog.recursiveTrace = true;
                            }
                            catch (Throwable throwable) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                    OracleLog.recursiveTrace = false;
                                }
                                throw throwable;
                            }
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return preparedStatement3;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 125");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 125);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    preparedStatement2 = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return preparedStatement2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            preparedStatement = null;
            if (!TRACE || OracleLog.recursiveTrace) break block14;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CallableStatement getCallWithKey(String key) throws SQLException {
        CallableStatement callableStatement;
        block14: {
            block10: {
                CallableStatement callableStatement2;
                block13: {
                    block11: {
                        CallableStatement callableStatement3;
                        block12: {
                            try {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                                    OracleLog.recursiveTrace = false;
                                }
                                if (this.statementCache == null) break block10;
                                OracleStatement os = this.statementCache.searchExplicitCache(key);
                                if (os != null && os.statementType != 2) break block11;
                                CallableStatement __result__ = (CallableStatement)((Object)os);
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                    OracleLog.recursiveTrace = false;
                                }
                                callableStatement3 = __result__;
                                if (!TRACE || OracleLog.recursiveTrace) break block12;
                                OracleLog.recursiveTrace = true;
                            }
                            catch (Throwable throwable) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                    OracleLog.recursiveTrace = false;
                                }
                                throw throwable;
                            }
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return callableStatement3;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 125");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 125);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    callableStatement2 = null;
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return callableStatement2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            callableStatement = null;
            if (!TRACE || OracleLog.recursiveTrace) break block14;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheImplicitStatement(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(statementType) + ", " + OracleLog.argument(scrollType));
                OracleLog.recursiveTrace = false;
            }
            if (this.statementCache == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 95");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 95);
            } else {
                this.statementCache.addToImplicitCache(stmt, sql, statementType, scrollType);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheExplicitStatement(OraclePreparedStatement stmt, String key) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(key));
                OracleLog.recursiveTrace = false;
            }
            if (this.statementCache == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 95");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 95);
            } else {
                this.statementCache.addToExplicitCache(stmt, key);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isStatementCacheInitialized() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.statementCache == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (this.statementCache.getCacheSize() == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: true");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheBuffer(byte[] buffer) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            if (buffer.length < this.byteBufferLength) {
            } else if (buffer.length == this.byteBufferLength) {
                this.byteBufferCache.put(buffer);
            } else {
                this.byteBufferCache.clear();
                this.byteBufferLength = buffer.length;
                this.byteBufferCache.put(buffer);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheBuffer(char[] buffer) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(buffer));
                OracleLog.recursiveTrace = false;
            }
            if (buffer.length < this.charBufferLength) {
            } else if (buffer.length == this.charBufferLength) {
                this.charBufferCache.put(buffer);
            } else {
                this.charBufferCache.clear();
                this.charBufferLength = buffer.length;
                this.charBufferCache.put(buffer);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getByteBuffer(int length, boolean isPoolable) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(length) + ", " + OracleLog.argument(isPoolable));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = null;
            if (length <= this.byteBufferLength && isPoolable && this.statementCache != null) {
                b2 = (byte[])this.byteBufferCache.get();
                if (b2 == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: byteBufferCache is empty, so new byte[" + this.byteBufferLength + "]");
                        OracleLog.recursiveTrace = false;
                    }
                    b2 = new byte[this.byteBufferLength];
                }
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: get a new byte array. new byte[" + length + "]");
                    OracleLog.recursiveTrace = false;
                }
                b2 = new byte[length];
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + b2);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    char[] getCharBuffer(int length, boolean isPoolable) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(length) + ", " + OracleLog.argument(isPoolable));
                OracleLog.recursiveTrace = false;
            }
            char[] c2 = null;
            if (length <= this.charBufferLength && isPoolable && this.statementCache != null) {
                c2 = (char[])this.charBufferCache.get();
                if (c2 == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: charBufferCache is empty, so new char[" + this.charBufferLength + "]");
                        OracleLog.recursiveTrace = false;
                    }
                    c2 = new char[this.charBufferLength];
                }
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_20, "Debug: get a new char array. new char[" + length + "]");
                    OracleLog.recursiveTrace = false;
                }
                c2 = new char[length];
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + c2);
                OracleLog.recursiveTrace = false;
            }
            char[] cArray = c2;
            return cArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAutoRefetch(boolean autoRefetch) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(autoRefetch));
                    OracleLog.recursiveTrace = false;
                }
                this.defaultAutoRefetch = autoRefetch;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDefaultAutoRefetch() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.defaultAutoRefetch);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.defaultAutoRefetch;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cbk) + ", " + OracleLog.argument(obj));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String string;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.databaseProductVersion == uninitializedMarker) {
                    this.needLine();
                    this.databaseProductVersion = this.doGetDatabaseProductVersion();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.databaseProductVersion);
                    OracleLog.recursiveTrace = false;
                }
                string = this.databaseProductVersion;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getReportRemarks() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.reportRemarks);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.reportRemarks;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getVersionNumber() throws SQLException {
        short s2;
        block10: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.versionNumber == -1) {
                    PhysicalConnection physicalConnection = this;
                    synchronized (physicalConnection) {
                        if (this.versionNumber == -1) {
                            this.needLine();
                            this.versionNumber = this.doGetVersionNumber();
                        }
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.versionNumber);
                    OracleLog.recursiveTrace = false;
                }
                s2 = this.versionNumber;
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(occ) + ", " + OracleLog.argument(privData));
                    OracleLog.recursiveTrace = false;
                }
                this.closeCallback = occ;
                this.privateData = privData;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreateStatementAsRefCursor(boolean value) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCreateStatementAsRefCursor() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pingDatabase() throws SQLException {
        int n2;
        block9: {
            block7: {
                int n3;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.lifecycle == 1) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = -1;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            int __result__ = this.doPingDatabase();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            n2 = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int pingDatabase(int timeOut) throws SQLException {
        int n2;
        block16: {
            block14: {
                int n3;
                block15: {
                    block12: {
                        int n4;
                        block13: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(timeOut));
                                OracleLog.recursiveTrace = false;
                            }
                            if (this.lifecycle == 1) break block12;
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                                OracleLog.recursiveTrace = false;
                            }
                            n4 = -1;
                            if (!TRACE || OracleLog.recursiveTrace) break block13;
                            OracleLog.recursiveTrace = true;
                            {
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                            }
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return n4;
                    }
                    if (timeOut != 0) break block14;
                    int __result__ = this.pingDatabase();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n3 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block15;
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            try {
                this.pingResult = -2;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PhysicalConnection.this.pingResult = PhysicalConnection.this.doPingDatabase();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                t.start();
                t.join(timeOut * 1000);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.pingResult);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.pingResult;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
            }
            catch (InterruptedException ex) {
                int n5;
                block17: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -3");
                        OracleLog.recursiveTrace = false;
                    }
                    n5 = -3;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n5;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doPingDatabase() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            Statement stmt = null;
            try {
                stmt = this.createStatement();
                ((oracle.jdbc.OracleStatement)stmt).defineColumnType(1, 12, 1);
                stmt.executeQuery("SELECT 'x' FROM DUAL");
            }
            catch (SQLException ea) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: -1");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = -1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n2;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map getJavaObjectTypeMap() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.javaObjectMap);
                OracleLog.recursiveTrace = false;
            }
            Map map = this.javaObjectMap;
            return map;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setJavaObjectTypeMap(Map map) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            this.javaObjectMap = map;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClientIdentifier(String clientId) throws SQLException {
        block5: {
            try {
                String[] metrics;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(clientId));
                    OracleLog.recursiveTrace = false;
                }
                if (clientId != null && clientId != uninitializedMarker && (metrics = this.getEndToEndMetrics()) != null && clientId.equals(metrics[1])) {
                    metrics[1] = null;
                    this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
                }
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientIdentifier(String clientId) throws SQLException {
        block5: {
            try {
                String[] metrics;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(clientId));
                    OracleLog.recursiveTrace = false;
                }
                if ((metrics = this.getEndToEndMetrics()) == null) {
                    metrics = new String[4];
                }
                metrics[1] = clientId;
                this.setEndToEndMetrics(metrics, this.getEndToEndECIDSequenceNumber());
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionTimeZone(String regionName) throws SQLException {
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(regionName));
                    OracleLog.recursiveTrace = false;
                }
                Statement stmt = null;
                ResultSet rset = null;
                try {
                    stmt = this.createStatement();
                    stmt.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + regionName + "'");
                    rset = stmt.executeQuery("SELECT DBTIMEZONE FROM DUAL");
                    rset.next();
                    String db_tz_str = rset.getString(1);
                    this.setDbTzCalendar(db_tz_str);
                }
                catch (SQLException e2) {
                    throw e2;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                this.sessionTimeZone = regionName;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZone() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.sessionTimeZone);
                    OracleLog.recursiveTrace = false;
                }
                string = this.sessionTimeZone;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                String sessiontzhours = this.getPropertyFromDatabase("SELECT SESSIONTIMEZONE FROM DUAL");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + sessiontzhours);
                    OracleLog.recursiveTrace = false;
                }
                string = sessiontzhours;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDbTzCalendar(String dbTzStr) {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(dbTzStr));
                    OracleLog.recursiveTrace = false;
                }
                if (dbTzStr.matches("[+|-]+\\d+:\\d{2}")) {
                    char sign = dbTzStr.charAt(0);
                    dbTzStr = sign == '-' || sign == '+' ? "GMT" + dbTzStr : "GMT+" + dbTzStr;
                }
                TimeZone tz = TimeZone.getTimeZone(dbTzStr);
                this.dbTzCalendar = new GregorianCalendar(tz);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar getDbTzCalendar() {
        Calendar calendar;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.dbTzCalendar);
                    OracleLog.recursiveTrace = false;
                }
                calendar = this.dbTzCalendar;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccumulateBatchResult(boolean val) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(val));
                    OracleLog.recursiveTrace = false;
                }
                this.accumulateBatchResult = val;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccumulateBatchResult() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.accumulateBatchResult);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.accumulateBatchResult;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJ2EE13Compliant(boolean val) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(val));
                    OracleLog.recursiveTrace = false;
                }
                this.j2ee13Compliant = val;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJ2EE13Compliant() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.j2ee13Compliant);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.j2ee13Compliant;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class classForNameAndSchema(String name, String schemaName) throws ClassNotFoundException {
        Class<?> clazz;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(schemaName));
                    OracleLog.recursiveTrace = false;
                }
                Class<?> __result__ = Class.forName(name);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                clazz = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name));
                    OracleLog.recursiveTrace = false;
                }
                Class<?> __result__ = Class.forName(name);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                clazz = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeapAllocSize() throws SQLException {
        int n2;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = -1;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        int n2;
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.lifecycle != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = -1;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection wrappedConnection) {
        try {
            oracle.jdbc.OracleConnection previous;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(wrappedConnection));
                OracleLog.recursiveTrace = false;
            }
            oracle.jdbc.OracleConnection next = previous = wrappedConnection;
            while (true) {
                if (next == null) {
                    OracleConnection __result__ = (OracleConnection)previous;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    OracleConnection oracleConnection = __result__;
                    return oracleConnection;
                }
                previous = next;
                next = previous.unwrap();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWrapper(oracle.jdbc.OracleConnection w) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(w));
                OracleLog.recursiveTrace = false;
            }
            this.wrapper = w;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleConnection unwrap() {
        oracle.jdbc.OracleConnection oracleConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = null;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleConnection getWrapper() {
        PhysicalConnection physicalConnection;
        block9: {
            block7: {
                oracle.jdbc.OracleConnection oracleConnection;
                block8: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.wrapper == null) break block7;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.wrapper);
                            OracleLog.recursiveTrace = false;
                        }
                        oracleConnection = this.wrapper;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return oracleConnection;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            physicalConnection = this;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection possiblyWrappedPossiblyLogicalConnection) {
        OracleConnection oracleConnection;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(possiblyWrappedPossiblyLogicalConnection));
                    OracleLog.recursiveTrace = false;
                }
                OracleConnection unwrappedConnection = null;
                if (possiblyWrappedPossiblyLogicalConnection != null) {
                    unwrappedConnection = PhysicalConnection.unwrapCompletely((oracle.jdbc.OracleConnection)possiblyWrappedPossiblyLogicalConnection);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + unwrappedConnection);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = unwrappedConnection;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this;
            return physicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(schemaName) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            long l2 = 0L;
            return l2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(CustomDatum inObject) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(inObject));
                OracleLog.recursiveTrace = false;
            }
            Datum __result__ = inObject.toDatum(this);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Datum datum = __result__;
            return datum;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getNCharSet() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            short __result__ = this.conversion.getNCharSetId();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            short s2 = __result__;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayDataResultSet(Datum[] data, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            ArrayDataResultSet __result__ = new ArrayDataResultSet((OracleConnection)this, data, index, count, map);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ArrayDataResultSet arrayDataResultSet = __result__;
            return arrayDataResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayDataResultSet(ARRAY array, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            ArrayDataResultSet __result__ = new ArrayDataResultSet((OracleConnection)this, array, index, count, map);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ArrayDataResultSet arrayDataResultSet = __result__;
            return arrayDataResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet newArrayLocatorResultSet(ArrayDescriptor desc, byte[] locator, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desc) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            ArrayLocatorResultSet __result__ = new ArrayLocatorResultSet(this, desc, locator, index, count, map);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            ArrayLocatorResultSet arrayLocatorResultSet = __result__;
            return arrayLocatorResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData newStructMetaData(StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            StructMetaData __result__ = new StructMetaData(desc);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            StructMetaData structMetaData = __result__;
            return structMetaData;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int CHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            int[] nBytes = new int[]{nbytes};
            int n2 = this.conversion.CHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int NCHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            int[] nBytes = new int[1];
            int n2 = this.conversion.NCHARBytesToJavaChars(bytes, 0, chars, 0, nBytes, chars.length);
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IsNCharFixedWith() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = this.conversion.IsNCharFixedWith();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getDriverCharSet() {
        short s2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                short __result__ = this.conversion.getClientCharSet();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                s2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharSize() throws SQLException {
        int n2;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 58");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 58);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = -1;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxCharbyteSize() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.conversion.getMaxCharbyteSize();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxNCharbyteSize() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.conversion.getMaxNCharbyteSize();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCharSetMultibyte(short charSet) {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(charSet));
                    OracleLog.recursiveTrace = false;
                }
                boolean __result__ = DBConversion.isCharSetMultibyte(charSet);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.conversion.javaCharsToCHARBytes(chars, nchars, bytes);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.conversion.javaCharsToNCHARBytes(chars, nchars, bytes);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    @Override
    public abstract void getPropertyForPooledConnection(OraclePooledConnection var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPropertyForPooledConnection(OraclePooledConnection pc, String password) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument("******"));
                OracleLog.recursiveTrace = false;
            }
            Hashtable<String, Map> hashTable = new Hashtable<String, Map>();
            hashTable.put("obj_type_map", this.javaObjectMap);
            Properties prop = new Properties();
            prop.put("user", this.userName);
            prop.put("password", password);
            prop.put("connection_url", this.url);
            prop.put("connect_auto_commit", uninitializedMarker + this.autocommit);
            prop.put("trans_isolation", uninitializedMarker + this.txnLevel);
            if (this.getStatementCacheSize() != -1) {
                prop.put("stmt_cache_size", uninitializedMarker + this.getStatementCacheSize());
                prop.put("implicit_cache_enabled", uninitializedMarker + this.getImplicitCachingEnabled());
                prop.put("explict_cache_enabled", uninitializedMarker + this.getExplicitCachingEnabled());
            }
            prop.put("defaultExecuteBatch", uninitializedMarker + this.defaultExecuteBatch);
            prop.put("defaultRowPrefetch", uninitializedMarker + this.defaultRowPrefetch);
            prop.put("remarksReporting", uninitializedMarker + this.reportRemarks);
            prop.put("AccumulateBatchResult", uninitializedMarker + this.accumulateBatchResult);
            prop.put("oracle.jdbc.J2EE13Compliant", uninitializedMarker + this.j2ee13Compliant);
            prop.put("processEscapes", uninitializedMarker + this.processEscapes);
            prop.put("restrictGetTables", uninitializedMarker + this.restrictGettables);
            prop.put("includeSynonyms", uninitializedMarker + this.includeSynonyms);
            prop.put("fixedString", uninitializedMarker + this.fixedString);
            hashTable.put("connection_properties", prop);
            pc.setProperties(hashTable);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getDBAccessProperties() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Properties properties = null;
            return properties;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getOCIHandles() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Properties properties = null;
            return properties;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    abstract void logon() throws SQLException;

    void logoff() throws SQLException {
    }

    abstract void open(OracleStatement var1) throws SQLException;

    abstract void cancelOperationOnServer() throws SQLException;

    abstract void doSetAutoCommit(boolean var1) throws SQLException;

    abstract void doCommit(int var1) throws SQLException;

    abstract void doRollback() throws SQLException;

    abstract String doGetDatabaseProductVersion() throws SQLException;

    abstract short doGetVersionNumber() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDefaultStreamChunkSize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + this.streamChunkSize);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.streamChunkSize;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    abstract OracleStatement RefCursorBytesToStatement(byte[] var1, OracleStatement var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int cursorNumber) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cursorNumber));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            oracle.jdbc.internal.OracleStatement oracleStatement = null;
            return oracleStatement;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getLogicalConnection(OraclePooledConnection pc, boolean autoCommit) throws SQLException {
        try {
            LogicalConnection logicalConn;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(pc) + ", " + OracleLog.argument(autoCommit));
                OracleLog.recursiveTrace = false;
            }
            if (this.logicalConnectionAttached != null || pc.getPhysicalHandle() != this) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 143");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 143);
            }
            this.logicalConnectionAttached = logicalConn = new LogicalConnection(pc, this, autoCommit);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + logicalConn);
                OracleLog.recursiveTrace = false;
            }
            LogicalConnection logicalConnection = logicalConn;
            return logicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            CLOB __result__ = new CLOB(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(csform));
                OracleLog.recursiveTrace = false;
            }
            CLOB __result__ = new CLOB(this, locator_bytes, csform);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CLOB cLOB = __result__;
            return cLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            BLOB __result__ = new BLOB(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            BLOB bLOB = __result__;
            return bLOB;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(locator_bytes));
                OracleLog.recursiveTrace = false;
            }
            BFILE __result__ = new BFILE(this, locator_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            BFILE bFILE = __result__;
            return bFILE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        ARRAY aRRAY;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(elements));
                    OracleLog.recursiveTrace = false;
                }
                ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor(typeName, (Connection)this);
                ARRAY __result__ = new ARRAY(descriptor, this, elements);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                aRRAY = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BINARY_DOUBLE createBINARY_DOUBLE(double value) throws SQLException {
        BINARY_DOUBLE bINARY_DOUBLE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                BINARY_DOUBLE __result__ = new BINARY_DOUBLE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bINARY_DOUBLE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bINARY_DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BINARY_FLOAT createBINARY_FLOAT(float value) throws SQLException {
        BINARY_FLOAT bINARY_FLOAT;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                BINARY_FLOAT __result__ = new BINARY_FLOAT(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bINARY_FLOAT = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bINARY_FLOAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Date value) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Time value) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Timestamp value) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Date value, Calendar cal) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Time value, Calendar cal) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(Timestamp value, Calendar cal) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE createDATE(String value) throws SQLException {
        DATE dATE;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                DATE __result__ = new DATE(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dATE = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS createINTERVALDS(String value) throws SQLException {
        INTERVALDS iNTERVALDS;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                INTERVALDS __result__ = new INTERVALDS(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                iNTERVALDS = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return iNTERVALDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM createINTERVALYM(String value) throws SQLException {
        INTERVALYM iNTERVALYM;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                INTERVALYM __result__ = new INTERVALYM(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                iNTERVALYM = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return iNTERVALYM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(boolean value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(byte value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(short value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(int value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(long value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(float value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(double value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(BigDecimal value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(BigInteger value) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER createNUMBER(String value, int scale) throws SQLException {
        NUMBER nUMBER;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(scale));
                    OracleLog.recursiveTrace = false;
                }
                NUMBER __result__ = new NUMBER(value, scale);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nUMBER = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Array array;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(elements));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwUnsupportedFeatureSqlException();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                array = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        STRUCT sTRUCT;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(typeName) + ", " + OracleLog.argument(attributes));
                    OracleLog.recursiveTrace = false;
                }
                StructDescriptor descriptor = StructDescriptor.createDescriptor(typeName, (Connection)this);
                STRUCT __result__ = new STRUCT(descriptor, (Connection)this, attributes);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                sTRUCT = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Date value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP __result__ = new TIMESTAMP(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(DATE value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP __result__ = new TIMESTAMP(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Time value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP __result__ = new TIMESTAMP(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP __result__ = new TIMESTAMP(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP createTIMESTAMP(String value) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP __result__ = new TIMESTAMP(value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMP = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value, Calendar cal) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value, cal);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(DATE value) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPTZ __result__ = new TIMESTAMPTZ((Connection)this, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(String value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE value, Calendar cal) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMPLTZ __result__ = new TIMESTAMPLTZ((Connection)this, cal, value);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                tIMESTAMPLTZ = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return tIMESTAMPLTZ;
    }

    public abstract BLOB createTemporaryBlob(Connection var1, boolean var2, int var3) throws SQLException;

    public abstract CLOB createTemporaryClob(Connection var1, boolean var2, int var3, short var4) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        BLOB bLOB;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                BLOB __result__ = this.createTemporaryBlob(this, true, 10);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bLOB = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() throws SQLException {
        CLOB cLOB;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                CLOB __result__ = this.createTemporaryClob(this, true, 10, (short)1);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                cLOB = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() throws SQLException {
        NClob nClob;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                NClob __result__ = (NClob)((Object)this.createTemporaryClob(this, true, 10, (short)2));
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                nClob = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return nClob;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        try {
            PhysicalConnection c2;
            PhysicalConnection c1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = (c1 = this) == (c2 = (PhysicalConnection)conn.getPhysicalConnection()) || c1.url.equals(c2.url) || c2.protocol != null && c2.protocol.equals("kprb");
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useLittleEndianSetCHARBinder() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlWarnings(String setting) throws SQLException {
        block15: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(setting));
                    OracleLog.recursiveTrace = false;
                }
                if (setting == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                if (setting != null && (setting = setting.trim()).length() > 0 && !OracleSql.isValidPlsqlWarning(setting)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                }
                String alterSession = "ALTER SESSION SET PLSQL_WARNINGS=" + setting;
                String alterSessionEvent = "ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'";
                Statement stmt = null;
                try {
                    stmt = this.createStatement(-1, -1);
                    stmt.execute(alterSession);
                    if (setting.equals("'DISABLE:ALL'")) {
                        this.plsqlCompilerWarnings = false;
                    } else {
                        stmt.execute(alterSessionEvent);
                        this.plsqlCompilerWarnings = true;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                if (!TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.lifecycle = 4;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XAResource getXAResource() throws SQLException {
        XAResource xAResource;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 164");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 164);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                xAResource = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return xAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        block14: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                if (nameSpace == null || attribute == null || value == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing NullPointerException: ");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new NullPointerException();
                }
                if (nameSpace.equals(uninitializedMarker)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 170");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 170);
                }
                if (nameSpace.compareToIgnoreCase("CLIENTCONTEXT") != 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 174");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 174);
                }
                if (attribute.length() > 30) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 171");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 171);
                }
                if (value.length() > 4000) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 172");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 172);
                }
                this.doSetApplicationContext(nameSpace, attribute, value);
                if (!TRACE || OracleLog.recursiveTrace) break block14;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        block8: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(nameSpace));
                    OracleLog.recursiveTrace = false;
                }
                if (nameSpace == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing NullPointerException: ");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new NullPointerException();
                }
                if (nameSpace.equals(uninitializedMarker)) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 170");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 170);
                }
                this.doClearAllApplicationContext(nameSpace);
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(nameSpace));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] createLightweightUserSession(String userName, KeywordValue[] inKeyVal, int inFlags, KeywordValue[][] outKeyVal, int[] outFlags) throws SQLException {
        byte[] byArray;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                byArray = null;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeLightweightUserSessionFunction(int functionId, byte[] sessionId, KeywordValue[] inKeyVal, int inFlags, KeywordValue[][] outKeyVal, int[] outFlags) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(inKeyVal) + ", " + OracleLog.argument(inFlags) + ", " + OracleLog.argument(outKeyVal) + ", " + OracleLog.argument(outFlags));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeLightweightUserSessionAttributeFunction(int functionId, byte[] sessionId, String namespace, String attributeName, KeywordValue[] inKeyVal, int inFlags) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(functionId) + ", " + OracleLog.argument(sessionId) + ", " + OracleLog.argument(namespace) + ", " + OracleLog.argument(attributeName) + ", " + OracleLog.argument(inKeyVal));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(String queueName, AQEnqueueOptions opt, AQMessage mesg) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(opt) + ", " + OracleLog.argument(mesg));
                    OracleLog.recursiveTrace = false;
                }
                AQMessageI imesg = (AQMessageI)mesg;
                byte[][] msgId = new byte[1][];
                this.doEnqueue(queueName, opt, imesg.getMessagePropertiesI(), imesg.getPayloadTOID(), imesg.getPayload(), msgId, imesg.isRAWPayload());
                if (msgId[0] != null) {
                    imesg.setMessageId(msgId[0]);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] toid) throws SQLException {
        AQMessageI aQMessageI;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(opt) + ", " + OracleLog.argument(toid));
                    OracleLog.recursiveTrace = false;
                }
                byte[][] msgId = new byte[1][];
                AQMessagePropertiesI prop = new AQMessagePropertiesI();
                byte[][] payload = new byte[1][];
                boolean hasAMessageBeenDequeued = false;
                hasAMessageBeenDequeued = this.doDequeue(queueName, opt, prop, toid, payload, msgId, AQMessageI.compareToid(toid, TypeDescriptor.RAWTOID));
                AQMessageI msg = null;
                if (hasAMessageBeenDequeued) {
                    msg = new AQMessageI(prop, this);
                    msg.setPayload(payload[0], toid);
                    msg.setMessageId(msgId[0]);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + msg);
                    OracleLog.recursiveTrace = false;
                }
                aQMessageI = msg;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return aQMessageI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, String typeName) throws SQLException {
        AQMessageI aQMessageI;
        block10: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(opt) + ", " + OracleLog.argument(typeName));
                    OracleLog.recursiveTrace = false;
                }
                byte[] toid = null;
                TypeDescriptor sd = null;
                if (typeName == "RAW" || typeName == "SYS.RAW") {
                    toid = TypeDescriptor.RAWTOID;
                } else if (typeName == "SYS.ANYDATA") {
                    toid = TypeDescriptor.ANYDATATOID;
                } else {
                    sd = TypeDescriptor.getTypeDescriptor(typeName, this);
                    toid = ((OracleTypeADT)sd.getPickler()).getTOID();
                }
                AQMessageI msg = (AQMessageI)this.dequeue(queueName, opt, toid);
                if (msg != null) {
                    msg.setTypeName(typeName);
                    msg.setTypeDescriptor(sd);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + msg);
                    OracleLog.recursiveTrace = false;
                }
                aQMessageI = msg;
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return aQMessageI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doEnqueue(String queueName, AQEnqueueOptions enqueueOptions, AQMessagePropertiesI prop, byte[] payloadTDO, byte[] payload, byte[][] msgId, boolean isRawPayload) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(enqueueOptions) + ", " + OracleLog.argument(prop) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgId) + ", " + OracleLog.argument(isRawPayload));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean doDequeue(String queueName, AQDequeueOptions dequeueOptions, AQMessagePropertiesI msgProp, byte[] payloadTDO, byte[][] payload, byte[][] msgid, boolean isRawQueue) throws SQLException {
        boolean bl;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(queueName) + ", " + OracleLog.argument(dequeueOptions) + ", " + OracleLog.argument(msgProp) + ", " + OracleLog.argument(payloadTDO) + ", " + OracleLog.argument(payload) + ", " + OracleLog.argument(msgid) + ", " + OracleLog.argument(isRawQueue));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isV8Compatible() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.mapDateToTimestamp);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.mapDateToTimestamp;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMapDateToTimestamp() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_30, "return: " + this.mapDateToTimestamp);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.mapDateToTimestamp;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        byte by;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument((Object)whatProperty));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                by = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AQNotificationRegistration[] registerAQNotification(String[] name, Properties[] options, Properties globalOptions) throws SQLException {
        AQNotificationRegistration[] aQNotificationRegistrationArray;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(globalOptions));
                    OracleLog.recursiveTrace = false;
                }
                String dcnhost = this.readNTFlocalhost(globalOptions);
                int tcpport = this.readNTFtcpport(globalOptions);
                NTFAQRegistration[] registrations = this.doRegisterAQNotification(name, dcnhost, tcpport, options);
                AQNotificationRegistration[] __result__ = registrations;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                aQNotificationRegistrationArray = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return aQNotificationRegistrationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFAQRegistration[] doRegisterAQNotification(String[] name, String dcnhost, int tcpport, Properties[] options) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            NTFAQRegistration[] nTFAQRegistrationArray = null;
            return nTFAQRegistrationArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAQNotification(AQNotificationRegistration registration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            NTFAQRegistration aqregistration = (NTFAQRegistration)registration;
            this.doUnregisterAQNotification(aqregistration);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnregisterAQNotification(NTFAQRegistration registration) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readNTFlocalhost(Properties options) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            String dcnhost = null;
            try {
                dcnhost = options.getProperty("NTF_LOCAL_HOST", InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException optionsExcep1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 240");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 240);
            }
            catch (SecurityException optionsExcep2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 241");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 241);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + dcnhost);
                OracleLog.recursiveTrace = false;
            }
            String string = dcnhost;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readNTFtcpport(Properties options) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            int tcpport = 0;
            try {
                tcpport = Integer.parseInt(options.getProperty("NTF_LOCAL_TCP_PORT", "0"));
                if (tcpport < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 242");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 242);
                }
            }
            catch (NumberFormatException optionsExcep3) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 242");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 242);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + tcpport);
                OracleLog.recursiveTrace = false;
            }
            int n2 = tcpport;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readNTFtimeout(Properties options) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            int timeout = 0;
            try {
                timeout = Integer.parseInt(options.getProperty("NTF_TIMEOUT", "0"));
            }
            catch (NumberFormatException optionsExcep4) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 243");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 243);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + timeout);
                OracleLog.recursiveTrace = false;
            }
            int n2 = timeout;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties options) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(options));
                OracleLog.recursiveTrace = false;
            }
            String dcnhost = this.readNTFlocalhost(options);
            int tcpport = this.readNTFtcpport(options);
            int timeout = this.readNTFtimeout(options);
            int txnlag = 0;
            try {
                txnlag = Integer.parseInt(options.getProperty("DCN_NOTIFY_CHANGELAG", "0"));
            }
            catch (NumberFormatException optionsExcep5) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 244");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 244);
            }
            NTFDCNRegistration registration = this.doRegisterDatabaseChangeNotification(dcnhost, tcpport, options, timeout, txnlag);
            ntfManager.addRegistration(registration);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + registration);
                OracleLog.recursiveTrace = false;
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFDCNRegistration doRegisterDatabaseChangeNotification(String dcnhost, int tcpport, Properties options, int timeout, int txnlag) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dcnhost) + ", " + OracleLog.argument(tcpport) + ", " + OracleLog.argument(options) + ", " + OracleLog.argument(timeout) + ", " + OracleLog.argument(txnlag));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            NTFDCNRegistration nTFDCNRegistration = null;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseChangeRegistration getDatabaseChangeRegistration(int regid) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(regid));
                OracleLog.recursiveTrace = false;
            }
            NTFDCNRegistration registration = new NTFDCNRegistration(this.instanceName, regid, this.userName, this.versionNumber);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + registration);
                OracleLog.recursiveTrace = false;
            }
            NTFDCNRegistration nTFDCNRegistration = registration;
            return nTFDCNRegistration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration registration) throws SQLException {
        try {
            NTFDCNRegistration dcnregistration;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            if ((dcnregistration = (NTFDCNRegistration)registration).getDatabaseName().compareToIgnoreCase(this.instanceName) != 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 245");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 245);
            }
            this.doUnregisterDatabaseChangeNotification(dcnregistration);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void doUnregisterDatabaseChangeNotification(NTFDCNRegistration registration) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(int registrationId) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registrationId));
                OracleLog.recursiveTrace = false;
            }
            String dcnhost = null;
            try {
                dcnhost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unregisterDatabaseChangeNotification(registrationId, dcnhost, 47632);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDatabaseChangeNotification(int registrationId, String host, int tcpport) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registrationId) + ", " + OracleLog.argument(host) + ", " + OracleLog.argument(tcpport));
                OracleLog.recursiveTrace = false;
            }
            this.doUnregisterDatabaseChangeNotification(registrationId, host, tcpport);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void doUnregisterDatabaseChangeNotification(int registrationId, String host, int port) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 23");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        block14: {
            try {
                TypeDescriptor[] result;
                block13: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    result = null;
                    Statement stmt = null;
                    try {
                        stmt = this.createStatement();
                        ResultSet rst = stmt.executeQuery("SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info())");
                        result = this.getTypeDescriptorsFromResultSet(rst);
                        rst.close();
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 904) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 165");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 165);
                            break block13;
                        }
                        throw ex;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                typeDescriptorArray = result;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] typeNames) throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        block15: {
            try {
                TypeDescriptor[] result;
                block14: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(typeNames));
                        OracleLog.recursiveTrace = false;
                    }
                    String sql = "SELECT schema_name, typename, typoid, typecode, version, tds  FROM TABLE(private_jdbc.Get_Type_Shape_Info(?))";
                    result = null;
                    PreparedStatement stmt = null;
                    try {
                        stmt = this.prepareStatement(sql);
                        int typeNamesLength = typeNames.length;
                        StringBuffer sb = new StringBuffer(typeNamesLength * 8);
                        for (int i2 = 0; i2 < typeNamesLength; ++i2) {
                            sb.append(typeNames[i2]);
                            if (i2 >= typeNamesLength - 1) continue;
                            sb.append(',');
                        }
                        stmt.setString(1, sb.toString());
                        ResultSet rst = stmt.executeQuery();
                        result = this.getTypeDescriptorsFromResultSet(rst);
                        rst.close();
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 904) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 165");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 165);
                            break block14;
                        }
                        throw ex;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                typeDescriptorArray = result;
                if (!TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] schemaAndTypeNamePairs) throws SQLException {
        TypeDescriptor[] typeDescriptorArray;
        block15: {
            try {
                TypeDescriptor[] result;
                block14: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(schemaAndTypeNamePairs));
                        OracleLog.recursiveTrace = false;
                    }
                    result = null;
                    PreparedStatement stmt = null;
                    int length = schemaAndTypeNamePairs.length;
                    StringBuffer schemaNames = new StringBuffer(length * 8);
                    StringBuffer typeNames = new StringBuffer(length * 8);
                    for (int i2 = 0; i2 < length; ++i2) {
                        schemaNames.append(schemaAndTypeNamePairs[i2][0]);
                        typeNames.append(schemaAndTypeNamePairs[i2][1]);
                        if (i2 >= length - 1) continue;
                        schemaNames.append(',');
                        typeNames.append(',');
                    }
                    try {
                        String sql = "SELECT schema_name, typename, typoid, typecode, version, tds FROM TABLE(private_jdbc.Get_All_Type_Shape_Info(?,?))";
                        stmt = this.prepareStatement(sql);
                        stmt.setString(1, schemaNames.toString());
                        stmt.setString(2, typeNames.toString());
                        ResultSet rst = stmt.executeQuery();
                        result = this.getTypeDescriptorsFromResultSet(rst);
                        rst.close();
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 904) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                PhysicalConnection.logger().log(Level.SEVERE, "Throwing SQLException: 165");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 165);
                            break block14;
                        }
                        throw ex;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                typeDescriptorArray = result;
                if (!TRACE || OracleLog.recursiveTrace) break block15;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return typeDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDescriptor[] getTypeDescriptorsFromResultSet(ResultSet rst) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(rst));
                OracleLog.recursiveTrace = false;
            }
            ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
            while (rst.next()) {
                TypeDescriptor desc;
                String schema = rst.getString(1);
                String typename = rst.getString(2);
                byte[] typoid = rst.getBytes(3);
                String typecode = rst.getString(4);
                int version = rst.getInt(5);
                byte[] tds = rst.getBytes(6);
                SQLName sqlName = new SQLName(schema, typename, this);
                if (typecode.equals("OBJECT")) {
                    desc = StructDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
                    this.putDescriptor(typoid, (Object)desc);
                    this.putDescriptor(desc.getName(), (Object)desc);
                    list.add(desc);
                    continue;
                }
                if (!typecode.equals("COLLECTION")) continue;
                desc = ArrayDescriptor.createDescriptor(sqlName, typoid, version, tds, this);
                this.putDescriptor(typoid, (Object)desc);
                this.putDescriptor(desc.getName(), (Object)desc);
                list.add(desc);
            }
            TypeDescriptor[] result = new TypeDescriptor[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TypeDescriptor desc;
                result[i2] = desc = (TypeDescriptor)list.get(i2);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            TypeDescriptor[] typeDescriptorArray = result;
            return typeDescriptorArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isUsable() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.isUsable);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.isUsable;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setUsable(boolean isUsable) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(isUsable));
                    OracleLog.recursiveTrace = false;
                }
                this.isUsable = isUsable;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queryFCFProperties(Properties prop) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(prop));
                OracleLog.recursiveTrace = false;
            }
            Statement stmt = null;
            ResultSet rs = null;
            String query = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
            try {
                stmt = this.createStatement();
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    String val = null;
                    val = rs.getString(1);
                    if (val != null) {
                        prop.put(INSTANCE_NAME, val.trim());
                    }
                    if ((val = rs.getString(2)) != null) {
                        prop.put(SERVER_HOST, val.trim());
                    }
                    if ((val = rs.getString(3)) != null) {
                        prop.put(SERVICE_NAME, val.trim());
                    }
                    if ((val = rs.getString(4)) == null) continue;
                    prop.put(DATABASE_NAME, val.trim());
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                PhysicalConnection.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(tz));
                    OracleLog.recursiveTrace = false;
                }
                this.defaultTimeZone = tz;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeZone getDefaultTimeZone() throws SQLException {
        TimeZone timeZone;
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                timeZone = this.defaultTimeZone;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            PhysicalConnection.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return timeZone;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        PhysicalConnection.endToEndMaxLength[0] = 32;
        PhysicalConnection.endToEndMaxLength[1] = 64;
        PhysicalConnection.endToEndMaxLength[2] = 64;
        PhysicalConnection.endToEndMaxLength[3] = 48;
        CALL_ABORT_PERMISSION = new OracleSQLPermission("callAbort");
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PhysicalConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

