/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final byte IS_UNINITIALIZED = -1;
    static final byte IS_SELECT = 0;
    static final byte IS_PLSQL_BLOCK = 1;
    static final byte IS_DML = 2;
    static final byte IS_OTHER = 3;
    static final byte IS_CALL_BLOCK = 4;
    int cursorId;
    int numberOfDefinePositions;
    int definesBatchSize;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    int rowsProcessed;
    int cachedDefineByteSize = 0;
    int cachedDefineCharSize = 0;
    int cachedDefineIndicatorSize = 0;
    OracleStatement children;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl currentResultSet;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int batch;
    int numberOfExecutedElementsInBatch = -1;
    int currentRank;
    int currentRow;
    int validRows;
    int maxFieldSize;
    int maxRows;
    int totalRowsVisited;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    boolean gotLastBatch;
    boolean clearParameters;
    boolean closed;
    boolean sqlStringChanged;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    byte sqlKind;
    int autoRollback;
    int defaultFetchDirection;
    boolean autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean isExecuting = false;
    OracleStatementWrapper wrapper;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet scrollRset;
    oracle.jdbc.OracleResultSetCache rsetCache;
    int userRsetType;
    int realRsetType;
    boolean needToAddIdentifier;
    SQLWarning sqlWarning;
    int cacheState = 1;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    int[] returnParamMeta;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 3;
    Accessor[] returnParamAccessors;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    OracleReturnResultSet returnResultSet;
    boolean isAutoGeneratedKey;
    AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone = null;
    Calendar defaultCalendar = null;
    Calendar gmtCalendar = null;
    int lastIndex;
    Vector m_batchItems = new Vector();
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    ArrayList oldTempClobsToFree = null;
    ArrayList oldTempBlobsToFree = null;
    NTFDCNRegistration registration = null;
    String[] dcnTableName = null;
    long dcnQueryId = -1L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:34_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void fetch() throws SQLException;

    void continueReadRow(int start) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 1continueReadRow is only implemented by the T4C statements.");
            OracleLog.recursiveTrace = false;
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.");
    }

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cursorIfRefCursor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 1cursorIfRefCursor not implemented");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_30, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement(PhysicalConnection conn, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, batchValue, rowPrefetchValue, -1, -1);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(batchValue) + ", " + OracleLog.argument(rowPrefetchValue));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement(PhysicalConnection conn, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(batch_value) + ", " + OracleLog.argument(row_prefetch_value) + ", " + OracleLog.argument(UserResultSetType) + ", " + OracleLog.argument(UserResultSetConcur));
                OracleLog.recursiveTrace = false;
            }
            this.connection = conn;
            this.connection.needLine();
            this.connection.registerHeartbeat();
            this.connection.addStatement(this);
            this.sqlObject = new OracleSql(this.connection.conversion);
            this.processEscapes = this.connection.processEscapes;
            this.convertNcharLiterals = this.connection.convertNcharLiterals;
            this.autoRollback = 2;
            this.gotLastBatch = false;
            this.closed = false;
            this.clearParameters = true;
            this.serverCursor = false;
            this.needToAddIdentifier = false;
            this.defaultFetchDirection = 1000;
            this.fixedString = this.connection.getDefaultFixedString();
            this.rowPrefetchChanged = false;
            this.rowPrefetch = row_prefetch_value;
            this.defaultRowPrefetch = row_prefetch_value;
            this.batch = batch_value;
            this.autoRefetch = this.connection.getDefaultAutoRefetch();
            this.sqlStringChanged = true;
            this.needToParse = true;
            this.needToPrepareDefineBuffer = true;
            this.columnsDefinedByUser = false;
            if (UserResultSetType != -1 || UserResultSetConcur != -1) {
                this.realRsetType = 0;
                this.userRsetType = ResultSetUtil.getRsetTypeCode(UserResultSetType, UserResultSetConcur);
                this.needToAddIdentifier = ResultSetUtil.needIdentifier(this.userRsetType);
            } else {
                this.userRsetType = 1;
                this.realRsetType = 1;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeDefineSubRanges() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.defineByteSubRange = 0;
            this.defineCharSubRange = 0;
            this.defineIndicatorSubRange = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareDefinePreambles() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareAccessors() throws SQLException {
        try {
            int preFetchSize;
            Accessor accessor;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            byte[] tmp_defineBytes = null;
            char[] tmp_defineChars = null;
            short[] tmp_defineIndicators = null;
            boolean isIndicatorsReused = false;
            if (this.accessors == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            int defineByteSize = 0;
            int defineCharSize = 0;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                accessor = this.accessors[i2];
                if (accessor == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
                }
                defineByteSize += accessor.byteLength;
                defineCharSize += accessor.charLength;
            }
            if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
                this.rowPrefetch = 1;
            }
            this.definesBatchSize = preFetchSize = this.rowPrefetch;
            this.initializeDefineSubRanges();
            int totalByteSize = this.defineByteSubRange + defineByteSize * preFetchSize;
            if (this.defineBytes == null || this.defineBytes.length < totalByteSize) {
                if (this.defineBytes != null) {
                    tmp_defineBytes = this.defineBytes;
                }
                this.defineBytes = this.connection.getByteBuffer(totalByteSize, this.cacheState != 3);
            }
            this.defineByteSubRange += this.accessorByteOffset;
            int totalCharSize = this.defineCharSubRange + defineCharSize * preFetchSize;
            if ((this.defineChars == null || this.defineChars.length < totalCharSize) && totalCharSize > 0) {
                if (this.defineChars != null) {
                    tmp_defineChars = this.defineChars;
                }
                this.defineChars = this.connection.getCharBuffer(totalCharSize, this.cacheState != 3);
            }
            this.defineCharSubRange += this.accessorCharOffset;
            int defineIndicatorSizeTerm = this.numberOfDefinePositions * preFetchSize;
            int totalIndicatorSize = this.defineIndicatorSubRange + defineIndicatorSizeTerm + defineIndicatorSizeTerm;
            if (this.defineIndicators == null || this.defineIndicators.length < totalIndicatorSize) {
                if (this.defineIndicators != null) {
                    tmp_defineIndicators = this.defineIndicators;
                }
                this.defineIndicators = new short[totalIndicatorSize];
            } else if (this.defineIndicators.length >= totalIndicatorSize) {
                isIndicatorsReused = true;
                tmp_defineIndicators = this.defineIndicators;
            }
            this.defineIndicatorSubRange += this.accessorShortOffset;
            int defineLengthSubRange = this.defineIndicatorSubRange + defineIndicatorSizeTerm;
            for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                accessor = this.accessors[i3];
                accessor.lengthIndexLastRow = accessor.lengthIndex;
                accessor.indicatorIndexLastRow = accessor.indicatorIndex;
                accessor.columnIndexLastRow = accessor.columnIndex;
                accessor.setOffsets(preFetchSize);
                accessor.lengthIndex = defineLengthSubRange;
                accessor.indicatorIndex = this.defineIndicatorSubRange;
                accessor.rowSpaceByte = this.defineBytes;
                accessor.rowSpaceChar = this.defineChars;
                accessor.rowSpaceIndicator = this.defineIndicators;
                this.defineIndicatorSubRange += preFetchSize;
                defineLengthSubRange += preFetchSize;
            }
            this.prepareDefinePreambles();
            if (this.rowPrefetchInLastFetch != -1) {
                if (tmp_defineChars != null || tmp_defineBytes != null) {
                    this.saveDefineBuffersIfRequired(tmp_defineChars, tmp_defineBytes, tmp_defineIndicators != null ? tmp_defineIndicators : this.defineIndicators, isIndicatorsReused);
                } else if (isIndicatorsReused && this.rowPrefetch != this.rowPrefetchInLastFetch) {
                    this.saveDefineBuffersIfRequired(this.defineChars, this.defineBytes, this.defineIndicators, isIndicatorsReused);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: return rowPrefetch = " + this.rowPrefetch + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAccessorsUsable() throws SQLException {
        try {
            int len;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if ((len = this.accessors.length) < this.numberOfDefinePositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            boolean allHaveExternalType = true;
            boolean anyHaveExternalType = false;
            boolean result = false;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null || accessor.externalType == 0) {
                    allHaveExternalType = false;
                    continue;
                }
                anyHaveExternalType = true;
            }
            if (allHaveExternalType) {
                result = true;
            } else if (anyHaveExternalType) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            } else {
                this.columnsDefinedByUser = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeMaybeDescribe() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: rowPrefetchChanged = " + this.rowPrefetchChanged + ", needToParse = " + this.needToParse + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + ", columnsDefinedByUser = " + this.columnsDefinedByUser);
                OracleLog.recursiveTrace = false;
            }
            if (this.rowPrefetchChanged) {
                if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
            if (!this.needToPrepareDefineBuffer) {
                if (this.accessors == null) {
                    this.needToPrepareDefineBuffer = true;
                } else if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = !this.checkAccessorsUsable();
                }
            }
            boolean executed_for_describe = false;
            try {
                this.isExecuting = true;
                if (this.needToPrepareDefineBuffer) {
                    if (!this.columnsDefinedByUser) {
                        this.executeForDescribe();
                        executed_for_describe = true;
                    }
                    this.prepareAccessors();
                }
                int len = this.accessors.length;
                for (int i2 = this.numberOfDefinePositions; i2 < len; ++i2) {
                    Accessor accessor = this.accessors[i2];
                    if (accessor == null) continue;
                    accessor.rowSpaceIndicator = null;
                }
                this.executeForRows(executed_for_describe);
            }
            catch (SQLException ea) {
                this.needToParse = true;
                throw ea;
            }
            finally {
                this.isExecuting = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + " ");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustGotLastBatch() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doExecuteWithTimeout() throws SQLException {
        try {
            block38: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + "");
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.CONFIG, "SQL: " + this.sqlObject.getOriginalSql());
                    OracleLog.recursiveTrace = false;
                }
                try {
                    this.cleanOldTempLobs();
                    this.connection.registerHeartbeat();
                    this.rowsProcessed = 0;
                    if (this.sqlKind == 0) {
                        if (this.connection.j2ee13Compliant && this.executionType == 2) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 129");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 129);
                        }
                        this.connection.needLine();
                        if (!this.isOpen) {
                            this.connection.open(this);
                            this.isOpen = true;
                        }
                        if (this.queryTimeout != 0) {
                            try {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                this.executeMaybeDescribe();
                            }
                            finally {
                                this.connection.getTimeout().cancelTimeout();
                            }
                        } else {
                            this.executeMaybeDescribe();
                        }
                        this.checkValidRowsStatus();
                        if (this.serverCursor) {
                            this.adjustGotLastBatch();
                        }
                        break block38;
                    }
                    if (this.connection.j2ee13Compliant && this.sqlKind != 1 && this.sqlKind != 4 && this.executionType == 1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 128");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 128);
                    }
                    ++this.currentRank;
                    if (this.currentRank >= this.batch) {
                        try {
                            this.connection.needLine();
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            if (this.queryTimeout != 0) {
                                this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                            }
                            this.isExecuting = true;
                            this.executeForRows(false);
                        }
                        catch (SQLException ea) {
                            this.needToParse = true;
                            if (this.batch > 1) {
                                int[] ret_array;
                                this.clearBatch();
                                if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch < this.batch) {
                                    ret_array = new int[this.numberOfExecutedElementsInBatch];
                                    for (int i2 = 0; i2 < ret_array.length; ++i2) {
                                        ret_array[i2] = -2;
                                    }
                                } else {
                                    ret_array = new int[this.batch];
                                    for (int i3 = 0; i3 < ret_array.length; ++i3) {
                                        ret_array[i3] = -3;
                                    }
                                }
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleStatement.logger().log(Level.SEVERE, "Throwing BatchUpdateException: " + ea + ret_array.length + ret_array);
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwBatchUpdateException(ea, ret_array.length, ret_array);
                            }
                            this.resetCurrentRowBinders();
                            throw ea;
                        }
                        finally {
                            if (this.queryTimeout != 0) {
                                this.connection.getTimeout().cancelTimeout();
                            }
                            this.currentRank = 0;
                            this.isExecuting = false;
                            this.checkValidRowsStatus();
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: currentRank=" + this.currentRank + " needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                        OracleLog.recursiveTrace = false;
                    }
                }
                catch (SQLException ea) {
                    this.resetOnExceptionDuringExecute();
                    throw ea;
                }
            }
            this.connection.registerHeartbeat();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: validRows = " + this.validRows + ", needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.isOpen) {
                this.connection.needLine();
                this.connection.open(this);
                this.isOpen = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                        OracleLog.recursiveTrace = false;
                    }
                    OracleResultSet result = null;
                    try {
                        this.executionType = 1;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer);
                            OracleLog.recursiveTrace = false;
                        }
                        this.noMoreUpdateCounts = false;
                        this.ensureOpen();
                        this.checkIfJdbcBatchExists();
                        this.sendBatch();
                        this.sqlObject.initialize(sql);
                        this.sqlKind = this.sqlObject.getSqlKind();
                        this.needToParse = true;
                        this.prepareForNewResults(true, true);
                        if (this.userRsetType == 1) {
                            this.doExecuteWithTimeout();
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                            result = this.currentResultSet;
                        } else {
                            result = this.doScrollStmtExecuteQuery();
                            if (result == null) {
                                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                                result = this.currentResultSet;
                            }
                        }
                    }
                    finally {
                        this.executionType = (byte)-1;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                        OracleLog.recursiveTrace = false;
                    }
                    oracleResultSet = result;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oracleResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String key) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.closeOrCache(null);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOrCache(String key) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(key));
                OracleLog.recursiveTrace = false;
            }
            if (this.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: caching stmt = " + this);
                    OracleLog.recursiveTrace = false;
                }
                if (key == null) {
                    if (this.connection.getImplicitCachingEnabled()) {
                        this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                    } else {
                        this.cacheState = 0;
                        this.hardClose();
                    }
                } else if (this.connection.getExplicitCachingEnabled()) {
                    this.connection.cacheExplicitStatement((OraclePreparedStatement)this, key);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: closing stmt " + this);
                    OracleLog.recursiveTrace = false;
                }
                this.hardClose();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hardClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.hardClose(true);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardClose(boolean closeCursor) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(closeCursor));
                OracleLog.recursiveTrace = false;
            }
            this.alwaysOnClose();
            this.describedWithNames = false;
            this.described = false;
            this.connection.removeStatement(this);
            this.cleanupDefines();
            if (this.isOpen && closeCursor && (this.connection.lifecycle == 1 || this.connection.lifecycle == 16 || this.connection.lifecycle == 2)) {
                this.connection.registerHeartbeat();
                if (this.connection.lifecycle == 2) {
                    this.connection.needLineUnchecked();
                } else {
                    this.connection.needLine();
                }
                this.doClose();
                this.isOpen = false;
            }
            this.sqlObject = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alwaysOnClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleStatement child = this.children;
            while (child != null) {
                OracleStatement n2 = child.nextChild;
                child.close();
                child = n2;
            }
            this.closed = true;
            if (this.connection.lifecycle == 1 || this.connection.lifecycle == 2) {
                if (this.currentResultSet != null) {
                    this.currentResultSet.internal_close(false);
                    this.currentResultSet = null;
                }
                if (this.scrollRset != null) {
                    this.scrollRset.close();
                    this.scrollRset = null;
                }
                if (this.returnResultSet != null) {
                    this.returnResultSet.close();
                    this.returnResultSet = null;
                }
            }
            this.clearWarnings();
            this.m_batchItems = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: needToPrepareDefineBuffer = " + this.needToPrepareDefineBuffer + "");
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                this.hardClose(false);
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setNonAutoKey();
                    int __result__ = this.executeUpdateInternal(sql);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdateInternal(String sql) throws SQLException {
        try {
            int n2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.executionType == -1) {
                    this.executionType = (byte)2;
                }
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.sqlObject.initialize(sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true);
                if (this.userRsetType == 1) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.validRows);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.validRows;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                throw throwable;
            }
            this.executionType = (byte)-1;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setNonAutoKey();
                    boolean __result__ = this.executeInternal(sql);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeInternal(String sql) throws SQLException {
        try {
            boolean bl;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql));
                OracleLog.recursiveTrace = false;
            }
            try {
                boolean __result__;
                this.executionType = (byte)3;
                this.noMoreUpdateCounts = false;
                this.ensureOpen();
                this.checkIfJdbcBatchExists();
                this.sendBatch();
                this.sqlObject.initialize(sql);
                this.sqlKind = this.sqlObject.getSqlKind();
                this.needToParse = true;
                this.prepareForNewResults(true, true);
                if (this.userRsetType == 1) {
                    this.doExecuteWithTimeout();
                } else {
                    this.doScrollStmtExecuteQuery();
                }
                boolean bl2 = __result__ = this.sqlKind == 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                this.executionType = (byte)-1;
                throw throwable;
            }
            this.executionType = (byte)-1;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfColumns() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.described) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.doDescribe(false);
                    this.described = true;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.numberOfDefinePositions);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.numberOfDefinePositions;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Accessor[] getDescription() throws SQLException {
        try {
            Accessor[] accessorArray;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.described) {
                accessorArray = this.connection;
                // MONITORENTER : this.connection
                this.doDescribe(false);
                this.described = true;
                // MONITOREXIT : accessorArray
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.accessors);
                OracleLog.recursiveTrace = false;
            }
            accessorArray = this.accessors;
            return accessorArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        try {
            Accessor[] accessorArray;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.describedWithNames) {
                accessorArray = this.connection;
                // MONITORENTER : this.connection
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
                // MONITOREXIT : accessorArray
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.accessors);
                OracleLog.recursiveTrace = false;
            }
            accessorArray = this.accessors;
            return accessorArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getSqlKind() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_30, "return: " + this.sqlKind);
                OracleLog.recursiveTrace = false;
            }
            byte by = this.sqlKind;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.freeLine();
                    this.streamList = null;
                    this.columnsDefinedByUser = false;
                    this.needToPrepareDefineBuffer = true;
                    this.numberOfDefinePositions = 0;
                    this.definesBatchSize = 0;
                    this.described = false;
                    this.describedWithNames = false;
                    this.cleanupDefines();
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reparseOnRedefineIfNeeded() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defineColumnTypeInternal(int column_index, int type, int size, boolean sizeNotGiven, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            this.defineColumnTypeInternal(column_index, type, size, (short)1, sizeNotGiven, typeName);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(sizeNotGiven) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection.disableDefinecolumntype) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (column_index < 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (type == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
            }
            int idx = column_index - 1;
            int max_len = this.maxFieldSize;
            if (sizeNotGiven) {
                if (type == 1 || type == 12) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.WARNING, "Warning: defineColumnType with a type that requires a length, but no length provided");
                        OracleLog.recursiveTrace = false;
                    }
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
                }
            } else {
                if (size < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 53");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 53);
                }
                if (max_len == 0 || size < max_len) {
                    max_len = size;
                }
            }
            if (this.currentResultSet != null && !this.currentResultSet.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 28");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 28);
            }
            if (!this.columnsDefinedByUser) {
                this.clearDefines();
                this.columnsDefinedByUser = true;
            }
            if (this.numberOfDefinePositions < column_index) {
                if (this.accessors == null || this.accessors.length < column_index) {
                    Accessor[] na = new Accessor[column_index << 1];
                    if (this.accessors != null) {
                        System.arraycopy(this.accessors, 0, na, 0, this.numberOfDefinePositions);
                    }
                    this.accessors = na;
                }
                this.numberOfDefinePositions = column_index;
            }
            switch (type) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = (short)2;
                    break;
                }
            }
            int internal_type = this.getInternalType(type);
            if (!(internal_type != 109 && internal_type != 111 || typeName != null && !typeName.equals(""))) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 60Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
            }
            Accessor accessor = this.accessors[idx];
            boolean need_to_prepare = true;
            if (accessor != null) {
                int reusability = accessor.useForDataAccessIfPossible(internal_type, type, max_len, typeName);
                if (reusability == 0) {
                    form = accessor.formOfUse;
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 1) {
                    accessor = null;
                    this.reparseOnRedefineIfNeeded();
                } else if (reusability == 2) {
                    need_to_prepare = false;
                }
            }
            if (need_to_prepare) {
                this.needToPrepareDefineBuffer = true;
            }
            if (accessor == null) {
                this.accessors[idx] = this.allocateAccessor(internal_type, type, column_index, max_len, form, typeName, false);
                this.described = false;
                this.describedWithNames = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(col_index) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            switch (internal_type) {
                case 96: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    CharAccessor __result__ = new CharAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    CharAccessor charAccessor = __result__;
                    return charAccessor;
                }
                case 8: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    if (!forBind) {
                        LongAccessor __result__ = new LongAccessor(this, col_index, max_len, form, external_type);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        LongAccessor longAccessor = __result__;
                        return longAccessor;
                    }
                }
                case 1: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    VarcharAccessor __result__ = new VarcharAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    VarcharAccessor varcharAccessor = __result__;
                    return varcharAccessor;
                }
                case 2: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    NumberAccessor __result__ = new NumberAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    NumberAccessor numberAccessor = __result__;
                    return numberAccessor;
                }
                case 6: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    VarnumAccessor __result__ = new VarnumAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    VarnumAccessor varnumAccessor = __result__;
                    return varnumAccessor;
                }
                case 24: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    if (!forBind) {
                        LongRawAccessor __result__ = new LongRawAccessor(this, col_index, max_len, form, external_type);
                        return __result__;
                    }
                }
                case 23: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    if (forBind) {
                        OutRawAccessor __result__ = new OutRawAccessor(this, max_len, form, external_type);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        OutRawAccessor outRawAccessor = __result__;
                        return outRawAccessor;
                    }
                    RawAccessor __result__ = new RawAccessor(this, max_len, form, external_type, false);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    RawAccessor rawAccessor = __result__;
                    return rawAccessor;
                }
                case 100: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    BinaryFloatAccessor __result__ = new BinaryFloatAccessor(this, max_len, form, external_type, forBind);
                    return __result__;
                }
                case 101: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    BinaryDoubleAccessor __result__ = new BinaryDoubleAccessor(this, max_len, form, external_type, forBind);
                    return __result__;
                }
                case 104: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    RowidAccessor __result__ = new RowidAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    RowidAccessor rowidAccessor = __result__;
                    return rowidAccessor;
                }
                case 102: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    ResultSetAccessor __result__ = new ResultSetAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    ResultSetAccessor resultSetAccessor = __result__;
                    return resultSetAccessor;
                }
                case 12: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    DateAccessor __result__ = new DateAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    DateAccessor dateAccessor = __result__;
                    return dateAccessor;
                }
                case 113: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    BlobAccessor __result__ = new BlobAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    BlobAccessor blobAccessor = __result__;
                    return blobAccessor;
                }
                case 112: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    ClobAccessor __result__ = new ClobAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    ClobAccessor clobAccessor = __result__;
                    return clobAccessor;
                }
                case 114: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    BfileAccessor __result__ = new BfileAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    BfileAccessor bfileAccessor = __result__;
                    return bfileAccessor;
                }
                case 109: {
                    if (typeName == null) {
                        if (forBind) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                        } else {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 60Unable to resolve type \"null\"");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                        }
                    }
                    NamedTypeAccessor result = new NamedTypeAccessor(this, typeName, form, external_type, forBind);
                    ((Accessor)result).initMetadata();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                        OracleLog.recursiveTrace = false;
                    }
                    NamedTypeAccessor __result__ = result;
                    return __result__;
                }
                case 111: {
                    if (typeName == null) {
                        if (forBind) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                        } else {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 60Unable to resolve type \"null\"");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"");
                        }
                    }
                    RefTypeAccessor result = new RefTypeAccessor(this, typeName, form, external_type, forBind);
                    ((Accessor)result).initMetadata();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                        OracleLog.recursiveTrace = false;
                    }
                    RefTypeAccessor __result__ = result;
                    return __result__;
                }
                case 180: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    TimestampAccessor __result__ = new TimestampAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    TimestampAccessor timestampAccessor = __result__;
                    return timestampAccessor;
                }
                case 181: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    TimestamptzAccessor __result__ = new TimestamptzAccessor(this, max_len, form, external_type, forBind);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    TimestamptzAccessor timestamptzAccessor = __result__;
                    return timestamptzAccessor;
                }
                case 231: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    TimestampltzAccessor timestampltzAccessor = new TimestampltzAccessor(this, max_len, form, external_type, forBind);
                    return timestampltzAccessor;
                }
                case 182: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    IntervalymAccessor intervalymAccessor = new IntervalymAccessor(this, max_len, form, external_type, forBind);
                    return intervalymAccessor;
                }
                case 183: {
                    if (forBind && typeName != null) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12sqlType=" + external_type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type);
                    }
                    IntervaldsAccessor intervaldsAccessor = new IntervaldsAccessor(this, max_len, form, external_type, forBind);
                    return intervaldsAccessor;
                }
                case 995: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 89");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Accessor accessor = null;
            return accessor;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type));
                        OracleLog.recursiveTrace = false;
                    }
                    this.defineColumnTypeInternal(column_index, type, 0, true, null);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type, int max_size) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                    OracleLog.recursiveTrace = false;
                }
                this.defineColumnTypeInternal(column_index, type, max_size, false, null);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int type, int max_size, short form_of_use) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size) + ", " + OracleLog.argument(form_of_use));
                    OracleLog.recursiveTrace = false;
                }
                this.defineColumnTypeInternal(column_index, type, max_size, form_of_use, false, null);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeBytes(int column_index, int type, int max_size) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block8: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.WARNING, "Warning: call to defineColumnTypeBytes which is deprecated and may not behave as expected");
                        OracleLog.recursiveTrace = false;
                    }
                    this.defineColumnTypeInternal(column_index, type, max_size, false, null);
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnTypeChars(int column_index, int type, int max_size) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                    OracleLog.recursiveTrace = false;
                }
                this.defineColumnTypeInternal(column_index, type, max_size, false, null);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineColumnType(int column_index, int typeCode, String typeName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(column_index) + ", " + OracleLog.argument(typeCode) + ", " + OracleLog.argument(typeName));
                        OracleLog.recursiveTrace = false;
                    }
                    this.defineColumnTypeInternal(column_index, typeCode, 0, true, typeName);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCursorId(int id) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(id));
                OracleLog.recursiveTrace = false;
            }
            this.cursorId = id;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrefetchInternal(int new_value, boolean setRowPrefetch, boolean statement) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(new_value) + ", " + OracleLog.argument(setRowPrefetch) + ", " + OracleLog.argument(statement));
                OracleLog.recursiveTrace = false;
            }
            if (setRowPrefetch) {
                if (new_value <= 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 20");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 20);
                }
            } else if (new_value < 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68setFetchSize");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize");
            } else if (new_value == 0) {
                new_value = this.connection.getDefaultRowPrefetch();
            }
            if (statement) {
                if (new_value != this.defaultRowPrefetch) {
                    this.defaultRowPrefetch = new_value;
                    if (this.currentResultSet == null || this.currentResultSet.closed) {
                        this.rowPrefetchChanged = true;
                    }
                }
            } else if (new_value != this.rowPrefetch && this.streamList == null) {
                this.rowPrefetch = new_value;
                this.rowPrefetchChanged = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowPrefetch(int value) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(value));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setPrefetchInternal(value, true, true);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrefetchInternal(boolean statement) {
        try {
            int ret_val;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(statement));
                OracleLog.recursiveTrace = false;
            }
            int n2 = ret_val = statement ? this.defaultRowPrefetch : this.rowPrefetch;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + ret_val);
                OracleLog.recursiveTrace = false;
            }
            int n3 = ret_val;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowPrefetch() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    int __result__ = this.getPrefetchInternal(true);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedString(boolean fixedString_value) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(fixedString_value));
                    OracleLog.recursiveTrace = false;
                }
                this.fixedString = fixedString_value;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getFixedString() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.fixedString);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.fixedString;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check_row_prefetch_changed() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.rowPrefetchChanged) {
                if (this.streamList == null) {
                    this.prepareAccessors();
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefinesInitialized(boolean value) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: no implemetation for kprb and thin, implemented only in OCI");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void printState(String message) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkValidRowsStatus() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.validRows == -2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: nextStream = " + this.nextStream);
                    OracleLog.recursiveTrace = false;
                }
                this.validRows = 1;
                this.connection.holdLine(this);
                OracleInputStream is = this.streamList;
                while (is != null) {
                    if (is.hasBeenOpen) {
                        is = is.accessor.initForNewRow();
                    }
                    is.closed = false;
                    is.hasBeenOpen = true;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: opens " + is);
                        OracleLog.recursiveTrace = false;
                    }
                    is = is.nextStream;
                }
                this.nextStream = this.streamList;
            } else if (this.sqlKind == 0) {
                if (this.validRows < this.rowPrefetch) {
                    this.gotLastBatch = true;
                }
            } else if (this.sqlKind != 1 && this.sqlKind != 4) {
                this.rowsProcessed = this.validRows;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupDefines() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.accessors != null) {
                for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                    this.accessors[i2] = null;
                }
            }
            this.accessors = null;
            if (this.defineBytes != null) {
                this.defineBytes = null;
            }
            if (this.defineChars != null) {
                this.defineChars = null;
            }
            if (this.defineIndicators != null) {
                this.defineIndicators = null;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.maxFieldSize);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = this.maxFieldSize;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(max));
                        OracleLog.recursiveTrace = false;
                    }
                    if (max < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    }
                    this.maxFieldSize = max;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRows() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.maxRows);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.maxRows;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxRows(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(max));
                        OracleLog.recursiveTrace = false;
                    }
                    if (max < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    }
                    this.maxRows = max;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(enable));
                        OracleLog.recursiveTrace = false;
                    }
                    this.processEscapes = enable;
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.queryTimeout);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = this.queryTimeout;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int max) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(max));
                        OracleLog.recursiveTrace = false;
                    }
                    if (max < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    }
                    this.queryTimeout = max;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.doCancel();
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    boolean doCancel() throws SQLException {
        boolean connectionHasBeenCancelled = false;
        if (this.closed) {
            return connectionHasBeenCancelled;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.isExecuting) {
            connectionHasBeenCancelled = true;
            this.connection.cancelOperationOnServer();
        }
        this.connection.releaseLineForCancel();
        return connectionHasBeenCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.sqlWarning);
                    OracleLog.recursiveTrace = false;
                }
                sQLWarning = this.sqlWarning;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.sqlWarning = null;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foundPlsqlCompilerWarning() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            SQLWarning w = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
            if (this.sqlWarning != null) {
                this.sqlWarning.setNextWarning(w);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.WARNING, "Warning: found Plsql compile warning");
                    OracleLog.recursiveTrace = false;
                }
            } else {
                this.sqlWarning = w;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorName(String name) throws SQLException {
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(name));
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ResultSet resultSet;
            block16: {
                block13: {
                    OracleResultSet oracleResultSet;
                    block15: {
                        block12: {
                            OracleResultSetImpl oracleResultSetImpl;
                            block14: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if (this.userRsetType != 1) break block12;
                                    if (this.sqlKind != 0) break block13;
                                    if (this.currentResultSet == null) {
                                        this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                                    }
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.currentResultSet);
                                        OracleLog.recursiveTrace = false;
                                    }
                                    oracleResultSetImpl = this.currentResultSet;
                                    if (!TRACE || OracleLog.recursiveTrace) break block14;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return oracleResultSetImpl;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.scrollRset);
                            OracleLog.recursiveTrace = false;
                        }
                        oracleResultSet = this.scrollRset;
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return oracleResultSet;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                resultSet = null;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block17: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    int l_updateCount = -1;
                    switch (this.sqlKind) {
                        case -1: 
                        case 0: {
                            break;
                        }
                        case 3: {
                            if (!this.noMoreUpdateCounts) {
                                l_updateCount = this.rowsProcessed;
                            }
                            this.noMoreUpdateCounts = true;
                            break;
                        }
                        case 1: 
                        case 4: {
                            this.noMoreUpdateCounts = true;
                            break;
                        }
                        case 2: {
                            if (!this.noMoreUpdateCounts) {
                                l_updateCount = this.rowsProcessed;
                            }
                            this.noMoreUpdateCounts = true;
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + l_updateCount);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = l_updateCount;
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendBatch() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForNewResults(boolean resetPrefetch, boolean clearStreamList) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(resetPrefetch) + ", " + OracleLog.argument(clearStreamList));
                OracleLog.recursiveTrace = false;
            }
            this.clearWarnings();
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
                if (clearStreamList) {
                    OracleInputStream s2 = this.streamList;
                    OracleInputStream prev = null;
                    this.streamList = null;
                    while (s2 != null) {
                        if (!s2.hasBeenOpen) {
                            if (prev == null) {
                                this.streamList = s2;
                            } else {
                                prev.nextStream = s2;
                            }
                            prev = s2;
                        }
                        s2 = s2.nextStream;
                    }
                }
            }
            if (this.currentResultSet != null) {
                this.currentResultSet.internal_close(true);
                this.currentResultSet = null;
            }
            this.currentRow = -1;
            this.validRows = 0;
            this.totalRowsVisited = 0;
            this.gotLastBatch = false;
            if (this.needToParse && !this.columnsDefinedByUser) {
                if (clearStreamList && this.numberOfDefinePositions != 0) {
                    this.numberOfDefinePositions = 0;
                }
                this.needToPrepareDefineBuffer = true;
            }
            if (resetPrefetch && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
                this.rowPrefetch = this.defaultRowPrefetch;
                this.rowPrefetchChanged = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reopenStreams() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleInputStream is = this.streamList;
            while (is != null) {
                if (is.hasBeenOpen) {
                    is = is.accessor.initForNewRow();
                }
                is.closed = false;
                is.hasBeenOpen = true;
                is = is.nextStream;
            }
            this.nextStream = this.streamList;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endOfResultSet(boolean dont_call_prepare_for_new_result) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dont_call_prepare_for_new_result));
                OracleLog.recursiveTrace = false;
            }
            if (!dont_call_prepare_for_new_result) {
                this.prepareForNewResults(false, false);
            }
            this.clearDefines();
            this.rowPrefetchInLastFetch = -1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wasNullValue() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.lastIndex == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 24");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 24);
            }
            if (this.sqlKind == 0) {
                boolean __result__ = this.accessors[this.lastIndex - 1].isNull(this.currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = __result__;
                return bl;
            }
            boolean __result__ = this.outBindAccessors[this.lastIndex - 1].isNull(this.currentRank);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnIndex(String columnName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(columnName));
                OracleLog.recursiveTrace = false;
            }
            if (!this.describedWithNames) {
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.doDescribe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
            for (int index = 0; index < this.numberOfDefinePositions; ++index) {
                if (!this.accessors[index].columnName.equalsIgnoreCase(columnName)) continue;
                int __result__ = index + 1;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 6");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInternalType(int externalType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(externalType));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            switch (externalType) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    result = 6;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case 999: {
                    result = 999;
                    break;
                }
                case 1: {
                    result = 96;
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    result = 1;
                    break;
                }
                case -16: 
                case -1: {
                    result = 8;
                    break;
                }
                case 91: 
                case 92: {
                    result = 12;
                    break;
                }
                case -100: 
                case 93: {
                    result = 180;
                    break;
                }
                case -101: {
                    result = 181;
                    break;
                }
                case -102: {
                    result = 231;
                    break;
                }
                case -103: {
                    result = 182;
                    break;
                }
                case -104: {
                    result = 183;
                    break;
                }
                case -3: 
                case -2: {
                    result = 23;
                    break;
                }
                case -4: {
                    result = 24;
                    break;
                }
                case -8: {
                    result = 104;
                    break;
                }
                case 2004: {
                    result = 113;
                    break;
                }
                case 2005: 
                case 2011: {
                    result = 112;
                    break;
                }
                case -13: {
                    result = 114;
                    break;
                }
                case -10: {
                    result = 102;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    result = 109;
                    break;
                }
                case 2006: {
                    result = 111;
                    break;
                }
                case -14: {
                    result = 998;
                    break;
                }
                case 70: {
                    result = 1;
                    break;
                }
                case 0: {
                    result = 995;
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4" + Integer.toString(externalType));
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(externalType));
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!this.described) {
                    this.doDescribe(false);
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLine() throws SQLException {
        block9: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.streamList == null) break block9;
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUsedStreams(int columnIndex) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(columnIndex));
                OracleLog.recursiveTrace = false;
            }
            while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                        OracleLog.recursiveTrace = false;
                    }
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + exc);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), exc);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureOpen() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.connection.lifecycle != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 8");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
            }
            if (this.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateTmpByteArray() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: for Thin only");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block12: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(direction));
                        OracleLog.recursiveTrace = false;
                    }
                    if (direction == 1000) {
                        this.defaultFetchDirection = direction;
                    } else if (direction == 1001 || direction == 1002) {
                        this.defaultFetchDirection = 1000;
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68setFetchDirection");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block12;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchDirection() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.defaultFetchDirection);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.defaultFetchDirection;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(rows));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setPrefetchInternal(rows, false, true);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = this.getPrefetchInternal(true);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetConcurrency() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = ResultSetUtil.getUpdateConcurrency(this.userRsetType);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetType() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = ResultSetUtil.getScrollType(this.userRsetType);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        OracleConnection oracleConnection;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                OracleConnection __result__ = this.connection.getWrapper();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                oracleConnection = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResultSetCache(oracle.jdbc.OracleResultSetCache cache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block13: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cache));
                        OracleLog.recursiveTrace = false;
                    }
                    try {
                        if (cache == null) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                        }
                        if (this.rsetCache != null) {
                            this.rsetCache.close();
                        }
                        this.rsetCache = cache;
                    }
                    catch (IOException e2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSetCache(OracleResultSetCache cache) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cache));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setResultSetCache((oracle.jdbc.OracleResultSetCache)cache);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OracleResultSetCache getResultSetCache() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetCache oracleResultSetCache;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    OracleResultSetCache __result__ = (OracleResultSetCache)this.rsetCache;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    oracleResultSetCache = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return oracleResultSetCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOracleBatchStyle() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBatch() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatchSize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.m_batchItems.size();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBatchItem(String sql) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql));
                OracleLog.recursiveTrace = false;
            }
            this.m_batchItems.addElement(sql);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getBatchItem(int index) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = (String)this.m_batchItems.elementAt(index);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBatchItems() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.m_batchItems.removeAllElements();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkIfJdbcBatchExists() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.getBatchSize() > 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 81batch must be either executed or cleared");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                        OracleLog.recursiveTrace = false;
                    }
                    this.addBatchItem(sql);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.clearBatchItems();
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int[] nArray;
            block33: {
                int n_batches;
                int i2;
                block29: {
                    int[] nArray2;
                    block30: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        this.cleanOldTempLobs();
                        i2 = 0;
                        n_batches = this.getBatchSize();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: batch size is " + n_batches);
                            OracleLog.recursiveTrace = false;
                        }
                        if (n_batches > 0) break block29;
                        int[] __result__ = new int[]{};
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        nArray2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block30;
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return nArray2;
                }
                try {
                    int[] ret_array = new int[n_batches];
                    this.ensureOpen();
                    this.prepareForNewResults(true, true);
                    int number_of_define_positions_saved = this.numberOfDefinePositions;
                    String saved_sql = this.sqlObject.getOriginalSql();
                    byte saved_sql_kind = this.sqlKind;
                    this.noMoreUpdateCounts = false;
                    int save_valid_rows = 0;
                    try {
                        this.connection.registerHeartbeat();
                        this.connection.needLine();
                        for (i2 = 0; i2 < n_batches; ++i2) {
                            this.sqlObject.initialize(this.getBatchItem(i2));
                            this.sqlKind = this.sqlObject.getSqlKind();
                            this.needToParse = true;
                            this.numberOfDefinePositions = 0;
                            this.rowsProcessed = 0;
                            this.currentRank = 1;
                            if (this.sqlKind == 0) {
                                DatabaseError.throwBatchUpdateException(80, "invalid SELECT batch command " + i2, i2, ret_array);
                            }
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            int ret_val = -1;
                            try {
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().setTimeout(this.queryTimeout * 1000, this);
                                }
                                this.isExecuting = true;
                                this.executeForRows(false);
                                if (this.validRows > 0) {
                                    save_valid_rows += this.validRows;
                                }
                                ret_val = this.validRows;
                            }
                            catch (SQLException ea) {
                                this.needToParse = true;
                                this.resetCurrentRowBinders();
                                throw ea;
                            }
                            finally {
                                if (this.queryTimeout != 0) {
                                    this.connection.getTimeout().cancelTimeout();
                                }
                                this.validRows = save_valid_rows;
                                this.checkValidRowsStatus();
                                this.isExecuting = false;
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: batch item " + i2 + ": return=" + ret_val);
                                OracleLog.recursiveTrace = false;
                            }
                            ret_array[i2] = ret_val;
                            if (ret_array[i2] >= 0) continue;
                            DatabaseError.throwBatchUpdateException(81, "command return value " + ret_array[i2], i2, ret_array);
                        }
                    }
                    catch (SQLException e1) {
                        if (e1 instanceof BatchUpdateException) {
                            throw e1;
                        }
                        DatabaseError.throwBatchUpdateException(81, e1.getMessage(), i2, ret_array);
                    }
                    finally {
                        this.clearBatchItems();
                        this.numberOfDefinePositions = number_of_define_positions_saved;
                        if (saved_sql != null) {
                            this.sqlObject.initialize(saved_sql);
                            this.sqlKind = saved_sql_kind;
                        }
                        this.currentRank = 0;
                    }
                    this.connection.registerHeartbeat();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret_array);
                        OracleLog.recursiveTrace = false;
                    }
                    nArray = ret_array;
                    if (!TRACE || OracleLog.recursiveTrace) break block33;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: 0");
                OracleLog.recursiveTrace = false;
            }
            int n2 = 0;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCloseRset() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.scrollRset = null;
            this.endOfResultSet(false);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginalSql() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.sqlObject.getOriginalSql();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScrollExecuteCommon() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.scrollRset != null) {
                this.scrollRset.close();
                this.scrollRset = null;
            }
            if (this.sqlKind != 0) {
                this.doExecuteWithTimeout();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (!this.needToAddIdentifier) {
                this.doExecuteWithTimeout();
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.realRsetType = this.userRsetType;
            } else {
                try {
                    this.sqlObject.setIncludeRowid(true);
                    this.needToParse = true;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: revised SQL:<" + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals) + ">");
                        OracleLog.recursiveTrace = false;
                    }
                    this.prepareForNewResults(true, false);
                    if (this.columnsDefinedByUser) {
                        Accessor[] oldaccs = this.accessors;
                        if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                            this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                        }
                        if (oldaccs != null) {
                            for (int i2 = this.numberOfDefinePositions; i2 > 0; --i2) {
                                Accessor accessor;
                                this.accessors[i2] = accessor = oldaccs[i2 - 1];
                                if (!accessor.isColumnNumberAware) continue;
                                accessor.updateColumnNumber(i2);
                            }
                        }
                        this.allocateRowidAccessor();
                        ++this.numberOfDefinePositions;
                    }
                    this.doExecuteWithTimeout();
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.realRsetType = this.userRsetType;
                }
                catch (SQLException e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e2.printStackTrace(pw);
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: " + sw.toString());
                        OracleLog.recursiveTrace = false;
                    }
                    this.realRsetType = this.userRsetType > 3 ? 3 : 1;
                    this.sqlObject.setIncludeRowid(false);
                    this.needToParse = true;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: Trying type " + this.realRsetType + "...");
                        OracleLog.recursiveTrace = false;
                    }
                    this.prepareForNewResults(true, false);
                    if (this.columnsDefinedByUser) {
                        this.needToPrepareDefineBuffer = true;
                        --this.numberOfDefinePositions;
                        System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                        this.accessors[this.numberOfDefinePositions] = null;
                        for (int i3 = 0; i3 < this.numberOfDefinePositions; ++i3) {
                            Accessor accessor = this.accessors[i3];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i3);
                        }
                    }
                    this.doExecuteWithTimeout();
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, e2.getMessage());
                }
            }
            this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateRowidAccessor() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.doScrollExecuteCommon();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.scrollRset);
                OracleLog.recursiveTrace = false;
            }
            OracleResultSet oracleResultSet = this.scrollRset;
            return oracleResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDmlReturningBind() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.returnResultSet != null) {
                this.returnResultSet.close();
            }
            this.returnParamsFetched = false;
            this.returnParamRowBytes = 0;
            this.returnParamRowChars = 0;
            int count = 0;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null) continue;
                ++count;
                if (accessor.charLength > 0) {
                    this.returnParamRowChars += accessor.charLength;
                    continue;
                }
                this.returnParamRowBytes += accessor.byteLength;
            }
            if (this.isAutoGeneratedKey) {
                this.numReturnParams = count;
            } else {
                if (this.numReturnParams <= 0) {
                    this.numReturnParams = this.sqlObject.getReturnParameterCount();
                }
                if (this.numReturnParams != count) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 173");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 173);
                }
            }
            this.returnParamMeta[0] = this.numReturnParams;
            this.returnParamMeta[1] = this.returnParamRowBytes;
            this.returnParamMeta[2] = this.returnParamRowChars;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateDmlReturnStorage() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.rowsDmlReturned == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            int totalBytes = this.returnParamRowBytes * this.rowsDmlReturned;
            int totalChars = this.returnParamRowChars * this.rowsDmlReturned;
            int indicatorLength = 2 * this.numReturnParams * this.rowsDmlReturned;
            this.returnParamBytes = new byte[totalBytes];
            this.returnParamChars = new char[totalChars];
            this.returnParamIndicators = new short[indicatorLength];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null || accessor.internalType != 111 && accessor.internalType != 109) continue;
                TypeAccessor typeAccessor = (TypeAccessor)accessor;
                if (typeAccessor.pickledBytes != null && typeAccessor.pickledBytes.length >= this.rowsDmlReturned) continue;
                typeAccessor.pickledBytes = new byte[this.rowsDmlReturned][];
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchDmlReturnParams() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 23");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupReturnParamAccessors() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.rowsDmlReturned == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            int byteOffset = 0;
            int charOffset = 0;
            int indOffset = 0;
            int lenOffset = this.numReturnParams * this.rowsDmlReturned;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.returnParamAccessors[i2];
                if (accessor == null) continue;
                if (accessor.charLength > 0) {
                    accessor.rowSpaceChar = this.returnParamChars;
                    accessor.columnIndex = charOffset;
                    charOffset += this.rowsDmlReturned * accessor.charLength;
                } else {
                    accessor.rowSpaceByte = this.returnParamBytes;
                    accessor.columnIndex = byteOffset;
                    byteOffset += this.rowsDmlReturned * accessor.byteLength;
                }
                accessor.rowSpaceIndicator = this.returnParamIndicators;
                accessor.indicatorIndex = indOffset;
                indOffset += this.rowsDmlReturned;
                accessor.lengthIndex = lenOffset;
                lenOffset += this.rowsDmlReturned;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerReturnParameterInternal(int index, int internalType, int externalType, int maxSize, short form, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(internalType) + ", " + OracleLog.argument(externalType) + ", " + OracleLog.argument(maxSize) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (this.returnParamAccessors == null) {
                this.returnParamAccessors = new Accessor[this.numberOfBindPositions];
            }
            if (this.returnParamMeta == null) {
                this.returnParamMeta = new int[3 + this.numberOfBindPositions * 3];
            }
            switch (externalType) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = (short)2;
                    break;
                }
            }
            Accessor accessor = this.allocateAccessor(internalType, externalType, index + 1, maxSize, form, typeName, true);
            accessor.isDMLReturnedParam = true;
            this.returnParamAccessors[index] = accessor;
            boolean isCharType = accessor.charLength > 0;
            this.returnParamMeta[3 + index * 3 + 0] = accessor.defineType;
            this.returnParamMeta[3 + index * 3 + 1] = isCharType ? 1 : 0;
            this.returnParamMeta[3 + index * 3 + 2] = isCharType ? accessor.charLength : accessor.byteLength;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoRefetch(boolean autoRefetch) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(autoRefetch));
                    OracleLog.recursiveTrace = false;
                }
                this.autoRefetch = autoRefetch;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoRefetch() throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.autoRefetch);
                    OracleLog.recursiveTrace = false;
                }
                bl = this.autoRefetch;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int creationState() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.creationState);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = this.creationState;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnSetNull(int index) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.columnSetNull);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.columnSetNull;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNCHAR(int columnIndex) throws SQLException {
        boolean bl;
        block8: {
            try {
                boolean result;
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                    OracleLog.recursiveTrace = false;
                }
                if (!this.described) {
                    this.describe();
                }
                if ((index = columnIndex - 1) < 0 || index >= this.numberOfDefinePositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                boolean bl2 = result = this.accessors[index].formOfUse == 2;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + result);
                    OracleLog.recursiveTrace = false;
                }
                bl = result;
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(OracleStatement child) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(child));
                OracleLog.recursiveTrace = false;
            }
            child.nextChild = this.children;
            this.children = child;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(current));
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwUnsupportedFeatureSqlException();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        OracleReturnResultSet oracleReturnResultSet;
        block12: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
                }
                if (!this.isAutoGeneratedKey) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
                }
                if (this.returnParamAccessors == null || this.numReturnParams == 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 144");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 144);
                }
                if (this.returnResultSet == null) {
                    this.returnResultSet = new OracleReturnResultSet(this);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.returnResultSet);
                    OracleLog.recursiveTrace = false;
                }
                oracleReturnResultSet = this.returnResultSet;
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleReturnResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int n2;
        block14: {
            block12: {
                int n3;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                            OracleLog.recursiveTrace = false;
                        }
                        if (autoGeneratedKeys != 2 && AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        int __result__ = this.executeUpdate(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            if (autoGeneratedKeys != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int __result__ = this.executeUpdateInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int n2;
        block14: {
            block12: {
                int n3;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        int __result__ = this.executeUpdate(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            if (columnIndexes == null || columnIndexes.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql, columnIndexes);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = columnIndexes.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int __result__ = this.executeUpdateInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int n2;
        block14: {
            block12: {
                int n3;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        int __result__ = this.executeUpdate(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            if (columnNames == null || columnNames.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql, columnNames);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = columnNames.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                int __result__ = this.executeUpdateInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean bl;
        block14: {
            block12: {
                boolean bl2;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(autoGeneratedKeys));
                            OracleLog.recursiveTrace = false;
                        }
                        if (autoGeneratedKeys != 2 && AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        boolean __result__ = this.execute(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (autoGeneratedKeys != 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = 1;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean __result__ = this.executeInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean bl;
        block14: {
            block12: {
                boolean bl2;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnIndexes));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        boolean __result__ = this.execute(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (columnIndexes == null || columnIndexes.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql, columnIndexes);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = columnIndexes.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean __result__ = this.executeInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean bl;
        block14: {
            block12: {
                boolean bl2;
                block13: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql) + ", " + OracleLog.argument(columnNames));
                            OracleLog.recursiveTrace = false;
                        }
                        if (AutoKeyInfo.isInsertSqlStmt(sql)) break block12;
                        boolean __result__ = this.execute(sql);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block13;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (columnNames == null || columnNames.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.isAutoGeneratedKey = true;
                this.autoKeyInfo = new AutoKeyInfo(sql, columnNames);
                this.connection.doDescribeTable(this.autoKeyInfo);
                String newSql = this.autoKeyInfo.getNewSql();
                this.numberOfBindPositions = columnNames.length;
                this.autoKeyRegisterReturnParams();
                this.processDmlReturningBind();
                boolean __result__ = this.executeInternal(newSql);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block14;
            }
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetHoldability() throws SQLException {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 1;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getcacheState() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.cacheState);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.cacheState;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getstatementType() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.statementType);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.statementType;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getserverCursor() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.serverCursor);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.serverCursor;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeIndicatorSubRange() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.bindIndicatorSubRange = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoKeyRegisterReturnParams() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.initializeIndicatorSubRange();
            int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
            int indicatorSize = preambleSize + 2 * this.numberOfBindPositions;
            this.bindIndicators = new short[indicatorSize];
            int metadataOffset = this.bindIndicatorSubRange;
            this.bindIndicators[metadataOffset + 0] = (short)this.numberOfBindPositions;
            this.bindIndicators[metadataOffset + 1] = 0;
            this.bindIndicators[metadataOffset + 2] = 1;
            this.bindIndicators[metadataOffset + 3] = 0;
            this.bindIndicators[metadataOffset + 4] = 1;
            metadataOffset += 5;
            short[] formOfUses = this.autoKeyInfo.tableFormOfUses;
            int[] columnIndexes = this.autoKeyInfo.columnIndexes;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                short form;
                this.bindIndicators[metadataOffset + 0] = 994;
                short s2 = form = this.connection.defaultnchar ? (short)2 : 1;
                if (formOfUses != null && columnIndexes != null && formOfUses[columnIndexes[i2] - 1] == 2) {
                    this.bindIndicators[metadataOffset + 9] = form = 2;
                }
                metadataOffset += 10;
                this.checkTypeForAutoKey(this.autoKeyInfo.returnTypes[i2]);
                String typeName = null;
                if (this.autoKeyInfo.returnTypes[i2] == 111) {
                    typeName = this.autoKeyInfo.tableTypeNames[columnIndexes[i2] - 1];
                }
                this.registerReturnParameterInternal(i2, this.autoKeyInfo.returnTypes[i2], this.autoKeyInfo.returnTypes[i2], -1, form, typeName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setNonAutoKey() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.isAutoGeneratedKey = false;
            this.numberOfBindPositions = 0;
            this.bindIndicators = null;
            this.returnParamMeta = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDefineBuffersIfRequired(char[] tmpDefineChars, byte[] tmpDefineBytes, short[] tmpDefineIndicators, boolean isIndicatorsReused) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tmpDefineChars) + ", " + OracleLog.argument(tmpDefineBytes) + ", " + OracleLog.argument(tmpDefineIndicators) + ", " + OracleLog.argument(isIndicatorsReused));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_20, "Debug: Nothing is to be done");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkTypeForAutoKey(int type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type));
                OracleLog.recursiveTrace = false;
            }
            if (type == 109) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 5");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 5);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(CLOB tclob) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tclob));
                OracleLog.recursiveTrace = false;
            }
            if (this.tempClobsToFree == null) {
                this.tempClobsToFree = new ArrayList();
            }
            this.tempClobsToFree.add(tclob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToTempLobsToFree(BLOB tblob) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tblob));
                OracleLog.recursiveTrace = false;
            }
            if (this.tempBlobsToFree == null) {
                this.tempBlobsToFree = new ArrayList();
            }
            this.tempBlobsToFree.add(tblob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToOldTempLobsToFree(CLOB tclob) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tclob));
                OracleLog.recursiveTrace = false;
            }
            if (this.oldTempClobsToFree == null) {
                this.oldTempClobsToFree = new ArrayList();
            }
            this.oldTempClobsToFree.add(tclob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToOldTempLobsToFree(BLOB tblob) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tblob));
                OracleLog.recursiveTrace = false;
            }
            if (this.oldTempBlobsToFree == null) {
                this.oldTempBlobsToFree = new ArrayList();
            }
            this.oldTempBlobsToFree.add(tblob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAllTempLobs() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cleanTempClobs(this.tempClobsToFree);
            this.tempClobsToFree = null;
            this.cleanTempBlobs(this.tempBlobsToFree);
            this.tempBlobsToFree = null;
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.oldTempClobsToFree = null;
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempBlobsToFree = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanOldTempLobs() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cleanTempClobs(this.oldTempClobsToFree);
            this.cleanTempBlobs(this.oldTempBlobsToFree);
            this.oldTempClobsToFree = this.tempClobsToFree;
            this.tempClobsToFree = null;
            this.oldTempBlobsToFree = this.tempBlobsToFree;
            this.tempBlobsToFree = null;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempClobs(ArrayList x) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((CLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || OracleLog.recursiveTrace) continue;
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.WARNING, "Warning:  exception " + e2.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanTempBlobs(ArrayList x) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if (x != null) {
                Iterator iter = x.iterator();
                while (iter.hasNext()) {
                    try {
                        ((BLOB)iter.next()).freeTemporary();
                    }
                    catch (SQLException e2) {
                        if (!TRACE || OracleLog.recursiveTrace) continue;
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.WARNING, "Warning:  exception " + e2.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimeZone getDefaultTimeZone() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.defaultTimeZone == null) {
                block10: {
                    try {
                        this.defaultTimeZone = this.connection.getDefaultTimeZone();
                    }
                    catch (SQLException ea) {
                        if (!TRACE || OracleLog.recursiveTrace) break block10;
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.WARNING, "Warning:  exception " + ea.getMessage());
                        OracleLog.recursiveTrace = false;
                    }
                }
                if (this.defaultTimeZone == null) {
                    this.defaultTimeZone = TimeZone.getDefault();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.defaultTimeZone);
                OracleLog.recursiveTrace = false;
            }
            TimeZone timeZone = this.defaultTimeZone;
            return timeZone;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration _registration) throws SQLException {
        this.registration = (NTFDCNRegistration)_registration;
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        return this.dcnTableName;
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        return this.dcnQueryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Calendar getDefaultCalendar() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.defaultCalendar == null) {
                this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone());
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.defaultCalendar);
                OracleLog.recursiveTrace = false;
            }
            Calendar calendar = this.defaultCalendar;
            return calendar;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void releaseBuffers() {
        this.cachedDefineByteSize = this.defineBytes != null ? this.defineBytes.length : 0;
        this.cachedDefineCharSize = this.defineChars != null ? this.defineChars.length : 0;
        this.cachedDefineIndicatorSize = this.defineIndicators != null ? this.defineIndicators.length : 0;
        this.defineChars = null;
        this.defineBytes = null;
        this.defineIndicators = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPoolable() throws SQLException {
        boolean bl;
        block7: {
            try {
                boolean __result__;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
                }
                boolean bl2 = __result__ = this.cacheState != 3;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                bl = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(poolable));
                    OracleLog.recursiveTrace = false;
                }
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
                }
                this.cacheState = poolable ? 1 : 3;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean bl;
        block10: {
            block8: {
                boolean bl2;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(iface));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!iface.isInterface()) break block8;
                        boolean __result__ = iface.isInstance(this);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 177");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            bl = false;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        block10: {
            block8: {
                OracleStatement oracleStatement;
                block9: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(iface));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!iface.isInterface() || !iface.isInstance(this)) break block8;
                        OracleStatement __result__ = this;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        oracleStatement = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block9;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return (T)oracleStatement;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(Level.SEVERE, "Throwing SQLException: 177");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 177);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            t = null;
            if (!TRACE || OracleLog.recursiveTrace) break block10;
            OracleLog.recursiveTrace = true;
            OracleStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.connection);
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Calendar getGMTCalendar() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.gmtCalendar == null) {
                this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "return: " + this.gmtCalendar);
                OracleLog.recursiveTrace = false;
            }
            Calendar calendar = this.gmtCalendar;
            return calendar;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

