/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSqlReadOnly;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

public class OracleSql {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST = new String[0];
    DBConversion conversion;
    String originalSql;
    String parameterSql;
    String utickSql;
    String processedSql;
    String rowidSql;
    String actualSql;
    byte[] sqlBytes;
    byte sqlKind = (byte)-1;
    int parameterCount = -1;
    boolean currentConvertNcharLiterals = true;
    boolean currentProcessEscapes = true;
    boolean includeRowid = false;
    String[] parameterList = EMPTY_LIST;
    char[] currentParameter = null;
    int bindParameterCount = -1;
    String[] bindParameterList = null;
    int cachedBindParameterCount = -1;
    String[] cachedBindParameterList = null;
    String cachedParameterSql;
    String cachedUtickSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    int selectEndIndex = -1;
    int orderByStartIndex = -1;
    int orderByEndIndex = -1;
    int whereStartIndex = -1;
    int whereEndIndex = -1;
    int forUpdateStartIndex = -1;
    int forUpdateEndIndex = -1;
    int[] ncharLiteralLocation = new int[513];
    int lastNcharLiteralLocation = -1;
    static final String paramPrefix = "rowid";
    int paramSuffix = 0;
    StringBuffer stringBufferForScrollableStatement = null;
    private static final int cMax = 127;
    private static final int[][] TRANSITION = OracleSqlReadOnly.TRANSITION;
    private static final int[][] ACTION = OracleSqlReadOnly.ACTION;
    private static final int NO_ACTION = 0;
    private static final int DML_ACTION = 1;
    private static final int PLSQL_ACTION = 2;
    private static final int CALL_ACTION = 3;
    private static final int SELECT_ACTION = 4;
    private static final int ORDER_ACTION = 7;
    private static final int ORDER_BY_ACTION = 8;
    private static final int WHERE_ACTION = 6;
    private static final int FOR_ACTION = 9;
    private static final int FOR_UPDATE_ACTION = 10;
    private static final int OTHER_ACTION = 5;
    private static final int QUESTION_ACTION = 11;
    private static final int PARAMETER_ACTION = 12;
    private static final int END_PARAMETER_ACTION = 13;
    private static final int START_NCHAR_LITERAL_ACTION = 14;
    private static final int END_NCHAR_LITERAL_ACTION = 15;
    int current_argument;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    boolean isLocate = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:34_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleSql(DBConversion conv) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conv));
                OracleLog.recursiveTrace = false;
            }
            this.conversion = conv;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String newSql) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(newSql));
                OracleLog.recursiveTrace = false;
            }
            if (newSql == null || newSql == "") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 104");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 104);
            }
            this.originalSql = newSql;
            this.utickSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
            this.sqlKind = (byte)-1;
            this.parameterCount = -1;
            this.includeRowid = false;
            this.parameterSql = this.originalSql;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.cachedBindParameterCount = -1;
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            this.selectEndIndex = -1;
            this.orderByStartIndex = -1;
            this.orderByEndIndex = -1;
            this.whereStartIndex = -1;
            this.whereEndIndex = -1;
            this.forUpdateStartIndex = -1;
            this.forUpdateEndIndex = -1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOriginalSql() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.originalSql);
                OracleLog.recursiveTrace = false;
            }
            String string = this.originalSql;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setNamedParameters(int paramCount, String[] paramList) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramCount) + ", " + OracleLog.argument(paramList));
                OracleLog.recursiveTrace = false;
            }
            boolean needToParse = false;
            if (paramCount == 0) {
                this.bindParameterCount = -1;
                needToParse = this.bindParameterCount != this.cachedBindParameterCount;
            } else {
                this.bindParameterCount = paramCount;
                this.bindParameterList = paramList;
                boolean bl = needToParse = this.bindParameterCount != this.cachedBindParameterCount;
                if (!needToParse) {
                    for (int i2 = 0; i2 < paramCount; ++i2) {
                        if (this.bindParameterList[i2] == this.cachedBindParameterList[i2]) continue;
                        needToParse = true;
                        break;
                    }
                }
                if (needToParse) {
                    if (this.bindParameterCount != this.getParameterCount()) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 197");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 197);
                    }
                    char[] sqlArray = this.originalSql.toCharArray();
                    StringBuffer strBuf = new StringBuffer();
                    int j2 = 0;
                    for (int i3 = 0; i3 < sqlArray.length; ++i3) {
                        if (sqlArray[i3] != '?') {
                            strBuf.append(sqlArray[i3]);
                            continue;
                        }
                        strBuf.append(this.bindParameterList[j2++]);
                        strBuf.append("=>" + this.nextArgument());
                    }
                    this.parameterSql = new String(strBuf);
                    this.actualSql = null;
                    this.utickSql = null;
                    this.processedSql = null;
                    this.rowidSql = null;
                    this.sqlBytes = null;
                } else {
                    this.parameterSql = this.cachedParameterSql;
                    this.actualSql = this.cachedActualSql;
                    this.utickSql = this.cachedUtickSql;
                    this.processedSql = this.cachedProcessedSql;
                    this.rowidSql = this.cachedRowidSql;
                    this.sqlBytes = this.cachedSqlBytes;
                }
            }
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedUtickSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + needToParse);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = needToParse;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetNamedParameters() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cachedBindParameterCount = this.bindParameterCount;
            if (this.bindParameterCount != -1) {
                if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                    this.cachedBindParameterList = new String[this.bindParameterCount];
                }
                System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
                this.cachedParameterSql = this.parameterSql;
                this.cachedActualSql = this.actualSql;
                this.cachedUtickSql = this.utickSql;
                this.cachedProcessedSql = this.processedSql;
                this.cachedRowidSql = this.rowidSql;
                this.cachedSqlBytes = this.sqlBytes;
                this.bindParameterCount = -1;
                this.bindParameterList = null;
                this.parameterSql = this.originalSql;
                this.actualSql = null;
                this.utickSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSql(boolean desiredProcessEscapes, boolean desiredConvertNcharLiterals) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desiredProcessEscapes) + ", " + OracleLog.argument(desiredConvertNcharLiterals));
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlKind == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (desiredProcessEscapes != this.currentProcessEscapes || desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                if (desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                    this.utickSql = null;
                }
                this.processedSql = null;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
            this.currentConvertNcharLiterals = desiredConvertNcharLiterals;
            this.currentProcessEscapes = desiredProcessEscapes;
            if (this.actualSql == null) {
                if (this.utickSql == null) {
                    String string = this.utickSql = this.currentConvertNcharLiterals ? this.convertNcharLiterals(this.parameterSql) : this.parameterSql;
                }
                if (this.processedSql == null) {
                    String string = this.processedSql = this.currentProcessEscapes ? this.parse(this.utickSql) : this.utickSql;
                }
                if (this.rowidSql == null) {
                    this.rowidSql = this.includeRowid ? this.addRowid(this.processedSql) : this.processedSql;
                }
                this.actualSql = this.rowidSql;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.actualSql);
                OracleLog.recursiveTrace = false;
            }
            String string = this.actualSql;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRevisedSql() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String result = null;
            if (this.sqlKind == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            result = this.removeForUpdate(this.parameterSql);
            String __result__ = this.addRowid(result);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeForUpdate(String revisedSql) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(revisedSql));
                OracleLog.recursiveTrace = false;
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                revisedSql = revisedSql.substring(0, this.orderByStartIndex);
            } else if (this.forUpdateStartIndex != -1) {
                revisedSql = revisedSql.substring(0, this.forUpdateStartIndex);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + revisedSql);
                OracleLog.recursiveTrace = false;
            }
            String string = revisedSql;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendForUpdate(StringBuffer stringBuffer) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stringBuffer));
                OracleLog.recursiveTrace = false;
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                stringBuffer.append(this.originalSql.substring(this.orderByStartIndex));
            } else if (this.forUpdateStartIndex != -1) {
                stringBuffer.append(this.originalSql.substring(this.forUpdateStartIndex));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInsertSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(updatableResultSet));
                OracleLog.recursiveTrace = false;
            }
            String originalSql = this.getOriginalSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(originalSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("insert into (");
            this.stringBufferForScrollableStatement.append(this.removeForUpdate(originalSql));
            this.stringBufferForScrollableStatement.append(") values ( ");
            for (int i2 = 1; i2 < updatableResultSet.getColumnCount(); ++i2) {
                if (i2 != 1) {
                    this.stringBufferForScrollableStatement.append(", ");
                }
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append("?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(":" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(")");
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRefetchSqlForScrollableResultSet(ScrollableResultSet scrollableResultSet, int realRefreshSize) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(scrollableResultSet) + ", " + OracleLog.argument(realRefreshSize));
                OracleLog.recursiveTrace = false;
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append(revisedSql);
            if (this.whereStartIndex == -1) {
                this.stringBufferForScrollableStatement.append(needEscapeProcessing ? " WHERE ( ROWID = ?" : " WHERE ( ROWID = :" + this.generateParameterName());
            } else {
                this.stringBufferForScrollableStatement.append(needEscapeProcessing ? " AND ( ROWID = ?" : " AND ( ROWID = :" + this.generateParameterName());
            }
            for (int i2 = 0; i2 < realRefreshSize - 1; ++i2) {
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append(" OR ROWID = ?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(" OR ROWID = :" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(" ) ");
            this.appendForUpdate(this.stringBufferForScrollableStatement);
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUpdateSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet, int numberOfColumnsChanged, Object[] rowBuffer, int[] indexColsChanged) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(updatableResultSet) + ", " + OracleLog.argument(numberOfColumnsChanged) + ", " + OracleLog.argument(rowBuffer) + ", " + OracleLog.argument(indexColsChanged));
                OracleLog.recursiveTrace = false;
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("update (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") set ");
            if (rowBuffer != null) {
                for (int i2 = 0; i2 < numberOfColumnsChanged; ++i2) {
                    if (i2 > 0) {
                        this.stringBufferForScrollableStatement.append(", ");
                    }
                    this.stringBufferForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName(indexColsChanged[i2] + 1));
                    if (needEscapeProcessing) {
                        this.stringBufferForScrollableStatement.append(" = ?");
                        continue;
                    }
                    this.stringBufferForScrollableStatement.append(" = :" + this.generateParameterName());
                }
            }
            this.stringBufferForScrollableStatement.append(" WHERE ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeleteSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(updatableResultSet));
                OracleLog.recursiveTrace = false;
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("delete from (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") where ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    final boolean generatedSqlNeedEscapeProcessing() {
        return this.parameterCount > 0 && this.parameterList == EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getSqlBytes(boolean desiredProcessEscapes, boolean desiredConvertNcharLiterals) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(desiredProcessEscapes) + ", " + OracleLog.argument(desiredConvertNcharLiterals));
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlBytes == null || desiredProcessEscapes != this.currentProcessEscapes) {
                this.sqlBytes = this.conversion.StringToCharBytes(this.getSql(desiredProcessEscapes, desiredConvertNcharLiterals));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.sqlBytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = this.sqlBytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getSqlKind() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlKind == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.sqlKind);
                OracleLog.recursiveTrace = false;
            }
            byte by = this.sqlKind;
            return by;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getParameterCount() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.parameterCount);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.parameterCount;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getParameterList() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + this.parameterList);
                OracleLog.recursiveTrace = false;
            }
            String[] stringArray = this.parameterList;
            return stringArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncludeRowid(boolean enable) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(enable));
                OracleLog.recursiveTrace = false;
            }
            if (enable != this.includeRowid) {
                this.includeRowid = enable;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            String __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String string = __result__ = this.parameterSql == null ? "null" : this.parameterSql;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string2 = __result__;
            return string2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hexUnicode(int c2) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            String hex = Integer.toHexString(c2);
            switch (hex.length()) {
                case 0: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleSql.logger().log(OracleLog.TRACE_30, "return: \\0000");
                        OracleLog.recursiveTrace = false;
                    }
                    String string = "\\0000";
                    return string;
                }
                case 1: {
                    String __result__ = "\\000" + hex;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
                case 2: {
                    String __result__ = "\\00" + hex;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
                case 3: {
                    String __result__ = "\\0" + hex;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
                case 4: {
                    String __result__ = "\\" + hex;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    String string = __result__;
                    return string;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 89Unexpected case in OracleSql.hexUnicode: " + c2);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89, "Unexpected case in OracleSql.hexUnicode: " + c2);
            String __result__ = "never happen";
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String convertNcharLiterals(String sql) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql));
                OracleLog.recursiveTrace = false;
            }
            if (this.lastNcharLiteralLocation <= 2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(OracleLog.TRACE_30, "return: " + sql);
                    OracleLog.recursiveTrace = false;
                }
                String string = sql;
                return string;
            }
            String buf = "";
            int i2 = 0;
            block4: while (true) {
                int end = this.ncharLiteralLocation[i2++];
                int start = this.ncharLiteralLocation[i2++];
                buf = buf + sql.substring(end, start);
                if (i2 >= this.lastNcharLiteralLocation) break;
                end = this.ncharLiteralLocation[i2];
                buf = buf + "u'";
                int j2 = start + 2;
                while (true) {
                    if (j2 >= end) continue block4;
                    char c2 = sql.charAt(j2);
                    buf = c2 == '\\' ? buf + "\\\\" : (c2 < '\u0080' ? buf + c2 : buf + this.hexUnicode(c2));
                    ++j2;
                }
                break;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + buf);
                OracleLog.recursiveTrace = false;
            }
            String string = buf;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBasicInfo(String sql) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(sql));
                OracleLog.recursiveTrace = false;
            }
            this.parameterCount = 0;
            this.lastNcharLiteralLocation = 0;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = 0;
            int currentParameterLength = 0;
            int s2 = 0;
            int len = sql.length();
            int temp_orderByStartIndex = -1;
            int temp_forUpdateStartIndex = -1;
            int stop = len + 1;
            for (int i2 = 0; i2 < stop; ++i2) {
                int unicodeChar;
                int c2 = unicodeChar = i2 < len ? (int)sql.charAt(i2) : 32;
                if (unicodeChar > 127) {
                    c2 = Character.isLetterOrDigit((char)unicodeChar) ? 88 : 32;
                }
                switch (ACTION[s2][c2]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.sqlKind = (byte)2;
                        break;
                    }
                    case 2: {
                        this.sqlKind = 1;
                        break;
                    }
                    case 3: {
                        this.sqlKind = (byte)4;
                        break;
                    }
                    case 4: {
                        this.sqlKind = 0;
                        this.selectEndIndex = i2;
                        break;
                    }
                    case 5: {
                        this.sqlKind = (byte)3;
                        break;
                    }
                    case 6: {
                        this.whereStartIndex = i2 - 5;
                        this.whereEndIndex = i2;
                        break;
                    }
                    case 7: {
                        temp_orderByStartIndex = i2 - 5;
                        break;
                    }
                    case 8: {
                        this.orderByStartIndex = temp_orderByStartIndex;
                        this.orderByEndIndex = i2;
                        break;
                    }
                    case 9: {
                        temp_forUpdateStartIndex = i2 - 3;
                        break;
                    }
                    case 10: {
                        this.forUpdateStartIndex = temp_forUpdateStartIndex;
                        this.forUpdateEndIndex = i2;
                        break;
                    }
                    case 11: {
                        ++this.parameterCount;
                        break;
                    }
                    case 12: {
                        if (this.currentParameter == null) {
                            this.currentParameter = new char[32];
                        }
                        if (currentParameterLength >= this.currentParameter.length) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 134" + new String(this.currentParameter));
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 134, new String(this.currentParameter));
                        }
                        this.currentParameter[currentParameterLength++] = unicodeChar;
                        break;
                    }
                    case 13: {
                        if (currentParameterLength <= 0) break;
                        if (this.parameterList == EMPTY_LIST) {
                            this.parameterList = new String[8];
                        } else if (this.parameterList.length <= this.parameterCount) {
                            String[] newList = new String[this.parameterList.length * 4];
                            System.arraycopy(this.parameterList, 0, newList, 0, this.parameterList.length);
                            this.parameterList = newList;
                        }
                        this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, currentParameterLength).intern();
                        currentParameterLength = 0;
                        ++this.parameterCount;
                        break;
                    }
                    case 14: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i2 - 1;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                        break;
                    }
                    case 15: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i2;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                    }
                }
                s2 = TRANSITION[s2][c2];
            }
            if (this.lastNcharLiteralLocation + 2 >= this.ncharLiteralLocation.length) {
                this.growNcharLiteralLocation(this.lastNcharLiteralLocation + 2);
            }
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = len;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation] = len;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void growNcharLiteralLocation(int size) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(size));
                OracleLog.recursiveTrace = false;
            }
            int[] temp = new int[size];
            System.arraycopy(this.ncharLiteralLocation, 0, temp, 0, this.ncharLiteralLocation.length);
            this.ncharLiteralLocation = null;
            this.ncharLiteralLocation = temp;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private String addRowid(String sql) throws SQLException {
        if (this.selectEndIndex == -1) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 88");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 88);
        }
        String result = "select rowid," + sql.substring(this.selectEndIndex);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String parse(String os) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(os));
                OracleLog.recursiveTrace = false;
            }
            this.current_argument = 1;
            this.i = 0;
            this.first = true;
            this.in_string = false;
            this.odbc_sql = os;
            this.length = this.odbc_sql.length();
            if (this.oracle_sql == null) {
                this.oracle_sql = new StringBuffer(this.length);
                this.token_buffer = new StringBuffer(32);
            } else {
                this.oracle_sql.ensureCapacity(this.length);
            }
            this.oracle_sql.delete(0, this.oracle_sql.length());
            this.skipSpace();
            this.handleODBC();
            if (this.i < this.length) {
                Integer index = new Integer(this.i);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 33" + index);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 33, index);
            }
            String __result__ = this.oracle_sql.substring(0, this.oracle_sql.length());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleODBC() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            StringBuffer arg1 = null;
            StringBuffer arg2 = null;
            boolean arg2Start = false;
            block9: while (this.i < this.length) {
                this.c = this.odbc_sql.charAt(this.i);
                if (this.in_string) {
                    this.oracle_sql.append(this.c);
                    if (this.c == '\'') {
                        this.in_string = false;
                    }
                    ++this.i;
                    continue;
                }
                switch (this.c) {
                    case '\'': {
                        if (this.isLocate) {
                            if (arg1 == null) {
                                arg1 = new StringBuffer();
                                arg2 = new StringBuffer();
                            }
                            if (!arg2Start) {
                                arg1.append(this.c);
                            } else {
                                arg2.append(this.c);
                            }
                            ++this.i;
                            continue block9;
                        }
                        this.oracle_sql.append(this.c);
                        this.in_string = true;
                        ++this.i;
                        this.first = false;
                        continue block9;
                    }
                    case '{': {
                        this.token_buffer.delete(0, this.token_buffer.length());
                        ++this.i;
                        this.skipSpace();
                        while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                            this.token_buffer.append(this.c);
                            ++this.i;
                        }
                        this.handleToken(this.token_buffer.substring(0, this.token_buffer.length()));
                        this.c = this.odbc_sql.charAt(this.i);
                        if (this.c != '}') {
                            String s2 = new String(this.i + ": Expecting \"}\" got \"" + this.c + "\"");
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 33" + s2);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 33, s2);
                        }
                        ++this.i;
                        continue block9;
                    }
                    case '}': {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleSql.logger().log(OracleLog.TRACE_30, "return: ");
                            OracleLog.recursiveTrace = false;
                        }
                        return;
                    }
                }
                if (this.isLocate && this.c != '(') {
                    if (this.c == ')') {
                        if (arg2.substring(0, arg2.length()).trim().equals("?")) {
                            this.oracle_sql.append(this.nextArgument());
                        } else {
                            this.oracle_sql.append(arg2);
                        }
                        this.oracle_sql.append(", ");
                        if (arg1.substring(0, arg1.length()).trim().equals("?")) {
                            this.oracle_sql.append(this.nextArgument());
                        } else {
                            this.oracle_sql.append(arg1);
                        }
                        this.appendChar(this.oracle_sql, this.c);
                        this.isLocate = false;
                    }
                    if (arg1 == null) {
                        arg1 = new StringBuffer();
                        arg2 = new StringBuffer();
                    }
                    if (this.c == ',') {
                        arg2Start = true;
                        ++this.i;
                        this.first = false;
                        continue;
                    }
                    if (!arg2Start) {
                        arg1.append(this.c);
                    } else {
                        arg2.append(this.c);
                    }
                } else {
                    this.appendChar(this.oracle_sql, this.c);
                }
                ++this.i;
                this.first = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleToken(String token) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(token));
                OracleLog.recursiveTrace = false;
            }
            if (token.equalsIgnoreCase("?")) {
                this.handleFunction();
            } else if (token.equalsIgnoreCase("call")) {
                this.handleCall();
            } else if (token.equalsIgnoreCase("ts")) {
                this.handleTimestamp();
            } else if (token.equalsIgnoreCase("t")) {
                this.handleTime();
            } else if (token.equalsIgnoreCase("d")) {
                this.handleDate();
            } else if (token.equalsIgnoreCase("escape")) {
                this.handleEscape();
            } else if (token.equalsIgnoreCase("fn")) {
                this.handleScalarFunction();
            } else if (token.equalsIgnoreCase("oj")) {
                this.handleOuterJoin();
            } else {
                String s2 = new String(this.i + ": " + token);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + s2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, s2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFunction() throws SQLException {
        try {
            String s2;
            boolean need_block;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (need_block = this.first) {
                this.oracle_sql.append("BEGIN ");
            }
            this.appendChar(this.oracle_sql, '?');
            this.skipSpace();
            if (this.c != '=') {
                s2 = new String(this.i + ". Expecting \"=\" got \"" + this.c + "\"");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 33" + s2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 33, s2);
            }
            ++this.i;
            this.skipSpace();
            if (!this.odbc_sql.startsWith("call", this.i)) {
                s2 = new String(this.i + ". Expecting \"call\"");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 33" + s2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 33, s2);
            }
            this.i += 4;
            this.oracle_sql.append(" := ");
            this.skipSpace();
            this.handleODBC();
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCall() throws SQLException {
        try {
            boolean need_block;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (need_block = this.first) {
                this.oracle_sql.append("BEGIN ");
            }
            this.skipSpace();
            this.handleODBC();
            this.skipSpace();
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimestamp() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTime() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'HH24:MI:SS')");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDate() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD')");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEscape() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append("ESCAPE ");
            this.skipSpace();
            this.handleODBC();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleScalarFunction() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.token_buffer.delete(0, this.token_buffer.length());
            ++this.i;
            this.skipSpace();
            while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                this.token_buffer.append(this.c);
                ++this.i;
            }
            String functionName = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
            if (functionName == "ABS") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ACOS") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ASIN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ATAN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "ATAN2") {
                this.usingFunctionName(functionName);
            } else if (functionName == "CEILING") {
                this.usingFunctionName("CEIL");
            } else if (functionName == "COS") {
                this.usingFunctionName(functionName);
            } else if (functionName == "COT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "DEGREES") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "EXP") {
                this.usingFunctionName(functionName);
            } else if (functionName == "FLOOR") {
                this.usingFunctionName(functionName);
            } else if (functionName == "LOG") {
                this.usingFunctionName("LN");
            } else if (functionName == "LOG10") {
                this.replacingFunctionPrefix("LOG ( 10, ");
            } else if (functionName == "MOD") {
                this.usingFunctionName(functionName);
            } else if (functionName == "PI") {
                this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
            } else if (functionName == "POWER") {
                this.usingFunctionName(functionName);
            } else if (functionName == "RADIANS") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "RAND") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "ROUND") {
                this.usingFunctionName(functionName);
            } else if (functionName == "SIGN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "SIN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "SQRT") {
                this.usingFunctionName(functionName);
            } else if (functionName == "TAN") {
                this.usingFunctionName(functionName);
            } else if (functionName == "TRUNCATE") {
                this.usingFunctionName("TRUNC");
            } else if (functionName == "ASCII") {
                this.usingFunctionName(functionName);
            } else if (functionName == "CHAR") {
                this.usingFunctionName("CHR");
            } else if (functionName == "CONCAT") {
                this.usingFunctionName(functionName);
            } else if (functionName == "DIFFERENCE") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "INSERT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "LCASE") {
                this.usingFunctionName("LOWER");
            } else if (functionName == "LEFT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "LENGTH") {
                this.usingFunctionName(functionName);
            } else if (functionName == "LOCATE") {
                this.isLocate = true;
                this.usingFunctionName("INSTR");
            } else if (functionName == "LTRIM") {
                this.usingFunctionName(functionName);
            } else if (functionName == "REPEAT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "REPLACE") {
                this.usingFunctionName(functionName);
            } else if (functionName == "RIGHT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "RTRIM") {
                this.usingFunctionName(functionName);
            } else if (functionName == "SOUNDEX") {
                this.usingFunctionName(functionName);
            } else if (functionName == "SPACE") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "SUBSTRING") {
                this.usingFunctionName("SUBSTR");
            } else if (functionName == "UCASE") {
                this.usingFunctionName("UPPER");
            } else if (functionName == "CURDATE") {
                this.replacingFunctionPrefix("(CURRENT_DATE");
            } else if (functionName == "CURTIME") {
                this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
            } else if (functionName == "DAYNAME") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "DAYOFMONTH") {
                this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
            } else if (functionName == "DAYOFWEEK") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "DAYOFYEAR") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "HOUR") {
                this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
            } else if (functionName == "MINUTE") {
                this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
            } else if (functionName == "MONTH") {
                this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
            } else if (functionName == "MONTHNAME") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "NOW") {
                this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
            } else if (functionName == "QUARTER") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "SECOND") {
                this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
            } else if (functionName == "TIMESTAMPADD") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "TIMESTAMPDIFF") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "WEEK") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "YEAR") {
                this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
            } else if (functionName == "DATABASE") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "IFNULL") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else if (functionName == "USER") {
                this.replacingFunctionPrefix("(USER");
            } else if (functionName == "CONVERT") {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 34" + functionName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usingFunctionName(String newName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(newName));
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append(newName);
            this.skipSpace();
            this.handleODBC();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replacingFunctionPrefix(String newPrefix) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(newPrefix));
                OracleLog.recursiveTrace = false;
            }
            this.skipSpace();
            if (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == '(') {
                ++this.i;
            } else {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleSql.logger().log(Level.SEVERE, "Throwing SQLException: 33");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 33);
            }
            this.oracle_sql.append(newPrefix);
            this.skipSpace();
            this.handleODBC();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOuterJoin() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.oracle_sql.append(" ( ");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(" ) ");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nextArgument() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String result = ":" + this.current_argument;
            ++this.current_argument;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendChar(StringBuffer oracle_sql, char c2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(oracle_sql) + ", " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            if (c2 == '?') {
                oracle_sql.append(this.nextArgument());
            } else {
                oracle_sql.append(c2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void skipSpace() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
                ++this.i;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    String generateParameterName() {
        String newParameter;
        if (this.parameterCount == 0 || this.parameterList == null) {
            return paramPrefix + this.paramSuffix++;
        }
        block0: while (true) {
            newParameter = paramPrefix + this.paramSuffix++;
            for (int i2 = 0; i2 < this.parameterList.length; ++i2) {
                if (newParameter.equals(this.parameterList[i2])) continue block0;
            }
            break;
        }
        return newParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isValidPlsqlWarning(String setting) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(setting));
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = setting.matches("('\\s*([a-zA-Z0-9:,\\(\\)\\s])*')\\s*(,\\s*'([a-zA-Z0-9:,\\(\\)\\s])*')*");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidObjectName(String name) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(name));
                OracleLog.recursiveTrace = false;
            }
            boolean __result__ = name.matches("([a-zA-Z]{1}\\w*(\\$|\\#)*\\w*)|(\".*)");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(args));
                OracleLog.recursiveTrace = false;
            }
            String[] sqlKindStrings = new String[]{"IS_UNINITIALIZED", "IS_SELECT", "IS_PLSQL_BLOCK", "IS_DML", "IS_OTHER", "IS_CALL_BLOCK"};
            try {
                int i2;
                OracleSql o2 = new OracleSql(null);
                boolean escapes = args[0].equals("true");
                boolean nchar = args[1].equals("true");
                o2.initialize(args[2]);
                String sql = o2.getSql(escapes, nchar);
                System.out.println(sqlKindStrings[o2.sqlKind + 1] + ", " + o2.parameterCount);
                String[] p2 = o2.getParameterList();
                if (p2 == EMPTY_LIST) {
                    System.out.println("parameterList is empty");
                } else {
                    for (i2 = 0; i2 < p2.length; ++i2) {
                        System.out.println("parameterList[" + i2 + "] = " + p2[i2]);
                    }
                }
                if (o2.lastNcharLiteralLocation == 2) {
                    System.out.println("No NCHAR literals");
                } else {
                    System.out.println("NCHAR Literals");
                    i2 = 1;
                    while (i2 < o2.lastNcharLiteralLocation - 1) {
                        System.out.println(sql.substring(o2.ncharLiteralLocation[i2++], o2.ncharLiteralLocation[i2++]));
                    }
                }
                System.out.println("Keywords");
                if (o2.selectEndIndex == -1) {
                    System.out.println("no select");
                } else {
                    System.out.println("'" + sql.substring(o2.selectEndIndex - 6, o2.selectEndIndex) + "'");
                }
                if (o2.orderByStartIndex == -1) {
                    System.out.println("no order by");
                } else {
                    System.out.println("'" + sql.substring(o2.orderByStartIndex, o2.orderByEndIndex) + "'");
                }
                if (o2.whereStartIndex == -1) {
                    System.out.println("no where");
                } else {
                    System.out.println("'" + sql.substring(o2.whereStartIndex, o2.whereEndIndex) + "'");
                }
                if (o2.forUpdateStartIndex == -1) {
                    System.out.println("no for update");
                } else {
                    System.out.println("'" + sql.substring(o2.forUpdateStartIndex, o2.forUpdateEndIndex) + "'");
                }
                System.out.println("\"" + sql + "\"");
                System.out.println("\"" + o2.getRevisedSql() + "\"");
            }
            catch (Exception e2) {
                e2.printStackTrace(System.out);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReturnParameterCount() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int returnParameterCount = -1;
            String s2 = this.getOriginalSql().toUpperCase();
            int pos = s2.indexOf("RETURNING");
            if (pos >= 0) {
                char[] clauseOfReturning = new char[s2.length() - pos];
                s2.getChars(pos, s2.length(), clauseOfReturning, 0);
                returnParameterCount = 0;
                for (int i2 = 0; i2 < clauseOfReturning.length; ++i2) {
                    switch (clauseOfReturning[i2]) {
                        case ':': 
                        case '?': {
                            ++returnParameterCount;
                        }
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "return: " + returnParameterCount);
                OracleLog.recursiveTrace = false;
            }
            int n2 = returnParameterCount;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleSql.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleSql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

