/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CopiedByteBinder;
import oracle.jdbc.driver.CopiedCharBinder;
import oracle.jdbc.driver.CopiedNullBinder;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleParameterMetaData;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    int numberOfBindRowsAllocated;
    static Binder theStaticVarnumCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarnumCopyingBinder;
    static Binder theStaticVarnumNullBinder = OraclePreparedStatementReadOnly.theStaticVarnumNullBinder;
    Binder theVarnumNullBinder = theStaticVarnumNullBinder;
    static Binder theStaticBooleanBinder = OraclePreparedStatementReadOnly.theStaticBooleanBinder;
    Binder theBooleanBinder = theStaticBooleanBinder;
    static Binder theStaticByteBinder = OraclePreparedStatementReadOnly.theStaticByteBinder;
    Binder theByteBinder = theStaticByteBinder;
    static Binder theStaticShortBinder = OraclePreparedStatementReadOnly.theStaticShortBinder;
    Binder theShortBinder = theStaticShortBinder;
    static Binder theStaticIntBinder = OraclePreparedStatementReadOnly.theStaticIntBinder;
    Binder theIntBinder = theStaticIntBinder;
    static Binder theStaticLongBinder = OraclePreparedStatementReadOnly.theStaticLongBinder;
    Binder theLongBinder = theStaticLongBinder;
    static Binder theStaticFloatBinder = OraclePreparedStatementReadOnly.theStaticFloatBinder;
    Binder theFloatBinder = null;
    static Binder theStaticDoubleBinder = OraclePreparedStatementReadOnly.theStaticDoubleBinder;
    Binder theDoubleBinder = null;
    static Binder theStaticBigDecimalBinder = OraclePreparedStatementReadOnly.theStaticBigDecimalBinder;
    Binder theBigDecimalBinder = theStaticBigDecimalBinder;
    static Binder theStaticVarcharCopyingBinder = OraclePreparedStatementReadOnly.theStaticVarcharCopyingBinder;
    static Binder theStaticVarcharNullBinder = OraclePreparedStatementReadOnly.theStaticVarcharNullBinder;
    Binder theVarcharNullBinder = theStaticVarcharNullBinder;
    static Binder theStaticStringBinder = OraclePreparedStatementReadOnly.theStaticStringBinder;
    Binder theStringBinder = theStaticStringBinder;
    static Binder theStaticSetCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticSetCHARCopyingBinder;
    static Binder theStaticSetCHARBinder = OraclePreparedStatementReadOnly.theStaticSetCHARBinder;
    static Binder theStaticLittleEndianSetCHARBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianSetCHARBinder;
    static Binder theStaticSetCHARNullBinder = OraclePreparedStatementReadOnly.theStaticSetCHARNullBinder;
    Binder theSetCHARBinder;
    Binder theSetCHARNullBinder = theStaticSetCHARNullBinder;
    static Binder theStaticFixedCHARCopyingBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARCopyingBinder;
    static Binder theStaticFixedCHARBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARBinder;
    static Binder theStaticFixedCHARNullBinder = OraclePreparedStatementReadOnly.theStaticFixedCHARNullBinder;
    Binder theFixedCHARBinder = theStaticFixedCHARBinder;
    Binder theFixedCHARNullBinder = theStaticFixedCHARNullBinder;
    static Binder theStaticDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    static Binder theStaticDateBinder = OraclePreparedStatementReadOnly.theStaticDateBinder;
    static Binder theStaticDateNullBinder = OraclePreparedStatementReadOnly.theStaticDateNullBinder;
    Binder theDateBinder = theStaticDateBinder;
    Binder theDateNullBinder = theStaticDateNullBinder;
    static Binder theStaticTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    static Binder theStaticTimeBinder = OraclePreparedStatementReadOnly.theStaticTimeBinder;
    Binder theTimeBinder = theStaticTimeBinder;
    static Binder theStaticTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    static Binder theStaticTimestampBinder = OraclePreparedStatementReadOnly.theStaticTimestampBinder;
    static Binder theStaticTimestampNullBinder = OraclePreparedStatementReadOnly.theStaticTimestampNullBinder;
    Binder theTimestampBinder = theStaticTimestampBinder;
    Binder theTimestampNullBinder = theStaticTimestampNullBinder;
    static Binder theStaticOracleNumberBinder = OraclePreparedStatementReadOnly.theStaticOracleNumberBinder;
    Binder theOracleNumberBinder = theStaticOracleNumberBinder;
    static Binder theStaticOracleDateBinder = OraclePreparedStatementReadOnly.theStaticOracleDateBinder;
    Binder theOracleDateBinder = theStaticOracleDateBinder;
    static Binder theStaticOracleTimestampBinder = OraclePreparedStatementReadOnly.theStaticOracleTimestampBinder;
    Binder theOracleTimestampBinder = theStaticOracleTimestampBinder;
    static Binder theStaticTSTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSTZCopyingBinder;
    static Binder theStaticTSTZBinder = OraclePreparedStatementReadOnly.theStaticTSTZBinder;
    static Binder theStaticTSTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSTZNullBinder;
    Binder theTSTZBinder = theStaticTSTZBinder;
    Binder theTSTZNullBinder = theStaticTSTZNullBinder;
    static Binder theStaticTSLTZCopyingBinder = OraclePreparedStatementReadOnly.theStaticTSLTZCopyingBinder;
    static Binder theStaticTSLTZBinder = OraclePreparedStatementReadOnly.theStaticTSLTZBinder;
    static Binder theStaticTSLTZNullBinder = OraclePreparedStatementReadOnly.theStaticTSLTZNullBinder;
    Binder theTSLTZBinder = theStaticTSLTZBinder;
    Binder theTSLTZNullBinder = theStaticTSLTZNullBinder;
    static Binder theStaticRowidCopyingBinder = OraclePreparedStatementReadOnly.theStaticRowidCopyingBinder;
    static Binder theStaticRowidBinder = OraclePreparedStatementReadOnly.theStaticRowidBinder;
    static Binder theStaticLittleEndianRowidBinder = OraclePreparedStatementReadOnly.theStaticLittleEndianRowidBinder;
    static Binder theStaticRowidNullBinder = OraclePreparedStatementReadOnly.theStaticRowidNullBinder;
    Binder theRowidBinder;
    Binder theRowidNullBinder = theStaticRowidNullBinder;
    static Binder theStaticIntervalDSCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSCopyingBinder;
    static Binder theStaticIntervalDSBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSBinder;
    static Binder theStaticIntervalDSNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalDSNullBinder;
    Binder theIntervalDSBinder = theStaticIntervalDSBinder;
    Binder theIntervalDSNullBinder = theStaticIntervalDSNullBinder;
    static Binder theStaticIntervalYMCopyingBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMCopyingBinder;
    static Binder theStaticIntervalYMBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMBinder;
    static Binder theStaticIntervalYMNullBinder = OraclePreparedStatementReadOnly.theStaticIntervalYMNullBinder;
    Binder theIntervalYMBinder = theStaticIntervalYMBinder;
    Binder theIntervalYMNullBinder = theStaticIntervalYMNullBinder;
    static Binder theStaticBfileCopyingBinder = OraclePreparedStatementReadOnly.theStaticBfileCopyingBinder;
    static Binder theStaticBfileBinder = OraclePreparedStatementReadOnly.theStaticBfileBinder;
    static Binder theStaticBfileNullBinder = OraclePreparedStatementReadOnly.theStaticBfileNullBinder;
    Binder theBfileBinder = theStaticBfileBinder;
    Binder theBfileNullBinder = theStaticBfileNullBinder;
    static Binder theStaticBlobCopyingBinder = OraclePreparedStatementReadOnly.theStaticBlobCopyingBinder;
    static Binder theStaticBlobBinder = OraclePreparedStatementReadOnly.theStaticBlobBinder;
    static Binder theStaticBlobNullBinder = OraclePreparedStatementReadOnly.theStaticBlobNullBinder;
    Binder theBlobBinder = theStaticBlobBinder;
    Binder theBlobNullBinder = theStaticBlobNullBinder;
    static Binder theStaticClobCopyingBinder = OraclePreparedStatementReadOnly.theStaticClobCopyingBinder;
    static Binder theStaticClobBinder = OraclePreparedStatementReadOnly.theStaticClobBinder;
    static Binder theStaticClobNullBinder = OraclePreparedStatementReadOnly.theStaticClobNullBinder;
    Binder theClobBinder = theStaticClobBinder;
    Binder theClobNullBinder = theStaticClobNullBinder;
    static Binder theStaticRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticRawCopyingBinder;
    static Binder theStaticRawBinder = OraclePreparedStatementReadOnly.theStaticRawBinder;
    static Binder theStaticRawNullBinder = OraclePreparedStatementReadOnly.theStaticRawNullBinder;
    Binder theRawBinder = theStaticRawBinder;
    Binder theRawNullBinder = theStaticRawNullBinder;
    static Binder theStaticPlsqlRawCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawCopyingBinder;
    static Binder theStaticPlsqlRawBinder = OraclePreparedStatementReadOnly.theStaticPlsqlRawBinder;
    Binder thePlsqlRawBinder = theStaticPlsqlRawBinder;
    static Binder theStaticBinaryFloatCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatCopyingBinder;
    static Binder theStaticBinaryFloatBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatBinder;
    static Binder theStaticBinaryFloatNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryFloatNullBinder;
    Binder theBinaryFloatBinder = theStaticBinaryFloatBinder;
    Binder theBinaryFloatNullBinder = theStaticBinaryFloatNullBinder;
    static Binder theStaticBINARY_FLOATCopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATCopyingBinder;
    static Binder theStaticBINARY_FLOATBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATBinder;
    static Binder theStaticBINARY_FLOATNullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_FLOATNullBinder;
    Binder theBINARY_FLOATBinder = theStaticBINARY_FLOATBinder;
    Binder theBINARY_FLOATNullBinder = theStaticBINARY_FLOATNullBinder;
    static Binder theStaticBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;
    static Binder theStaticBinaryDoubleBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleBinder;
    static Binder theStaticBinaryDoubleNullBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleNullBinder;
    Binder theBinaryDoubleBinder = theStaticBinaryDoubleBinder;
    Binder theBinaryDoubleNullBinder = theStaticBinaryDoubleNullBinder;
    static Binder theStaticBINARY_DOUBLECopyingBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLECopyingBinder;
    static Binder theStaticBINARY_DOUBLEBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLEBinder;
    static Binder theStaticBINARY_DOUBLENullBinder = OraclePreparedStatementReadOnly.theStaticBINARY_DOUBLENullBinder;
    Binder theBINARY_DOUBLEBinder = theStaticBINARY_DOUBLEBinder;
    Binder theBINARY_DOUBLENullBinder = theStaticBINARY_DOUBLENullBinder;
    static Binder theStaticLongStreamBinder = OraclePreparedStatementReadOnly.theStaticLongStreamBinder;
    Binder theLongStreamBinder = theStaticLongStreamBinder;
    static Binder theStaticLongRawStreamBinder = OraclePreparedStatementReadOnly.theStaticLongRawStreamBinder;
    Binder theLongRawStreamBinder = theStaticLongRawStreamBinder;
    static Binder theStaticNamedTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeCopyingBinder;
    static Binder theStaticNamedTypeBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeBinder;
    static Binder theStaticNamedTypeNullBinder = OraclePreparedStatementReadOnly.theStaticNamedTypeNullBinder;
    Binder theNamedTypeBinder = theStaticNamedTypeBinder;
    Binder theNamedTypeNullBinder = theStaticNamedTypeNullBinder;
    static Binder theStaticRefTypeCopyingBinder = OraclePreparedStatementReadOnly.theStaticRefTypeCopyingBinder;
    static Binder theStaticRefTypeBinder = OraclePreparedStatementReadOnly.theStaticRefTypeBinder;
    static Binder theStaticRefTypeNullBinder = OraclePreparedStatementReadOnly.theStaticRefTypeNullBinder;
    Binder theRefTypeBinder = theStaticRefTypeBinder;
    Binder theRefTypeNullBinder = theStaticRefTypeNullBinder;
    static Binder theStaticPlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    static Binder theStaticPlsqlIbtBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtBinder;
    static Binder theStaticPlsqlIbtNullBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtNullBinder;
    Binder thePlsqlIbtBinder = theStaticPlsqlIbtBinder;
    Binder thePlsqlNullBinder = theStaticPlsqlIbtNullBinder;
    static Binder theStaticOutBinder = OraclePreparedStatementReadOnly.theStaticOutBinder;
    Binder theOutBinder = theStaticOutBinder;
    static Binder theStaticReturnParamBinder = OraclePreparedStatementReadOnly.theStaticReturnParamBinder;
    Binder theReturnParamBinder = theStaticReturnParamBinder;
    static Binder theStaticT4CRowidBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidBinder;
    static Binder theStaticT4CRowidNullBinder = OraclePreparedStatementReadOnly.theStaticT4CRowidNullBinder;
    public static final int TypeBinder_BYTELEN = 24;
    char[] digits = new char[20];
    Binder[][] binders;
    int[][] parameterInt;
    long[][] parameterLong;
    float[][] parameterFloat;
    double[][] parameterDouble;
    BigDecimal[][] parameterBigDecimal;
    String[][] parameterString;
    Date[][] parameterDate;
    Time[][] parameterTime;
    Timestamp[][] parameterTimestamp;
    byte[][][] parameterDatum;
    OracleTypeADT[][] parameterOtype;
    PlsqlIbtBindInfo[][] parameterPlsqlIbt;
    Binder[] currentRowBinders;
    int[] currentRowCharLens;
    Accessor[] currentRowBindAccessors;
    short[] currentRowFormOfUse;
    boolean currentRowNeedToPrepareBinds = true;
    int[] currentBatchCharLens;
    Accessor[] currentBatchBindAccessors;
    short[] currentBatchFormOfUse;
    boolean currentBatchNeedToPrepareBinds;
    PushedBatch pushedBatches;
    PushedBatch pushedBatchesTail;
    int cachedBindByteSize = 0;
    int cachedBindCharSize = 0;
    int cachedBindIndicatorSize = 0;
    int totalBindByteLength;
    int totalBindCharLength;
    int totalBindIndicatorLength;
    static final int BIND_METADATA_NUMBER_OF_BIND_POSITIONS_OFFSET = 0;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_HI = 1;
    static final int BIND_METADATA_BIND_BUFFER_CAPACITY_OFFSET_LO = 2;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_HI = 3;
    static final int BIND_METADATA_NUMBER_OF_BOUND_ROWS_OFFSET_LO = 4;
    static final int BIND_METADATA_PER_POSITION_DATA_OFFSET = 5;
    static final int BIND_METADATA_TYPE_OFFSET = 0;
    static final int BIND_METADATA_BYTE_PITCH_OFFSET = 1;
    static final int BIND_METADATA_CHAR_PITCH_OFFSET = 2;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_HI = 3;
    static final int BIND_METADATA_VALUE_DATA_OFFSET_LO = 4;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_HI = 5;
    static final int BIND_METADATA_NULL_INDICATORS_OFFSET_LO = 6;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_HI = 7;
    static final int BIND_METADATA_VALUE_LENGTHS_OFFSET_LO = 8;
    static final int BIND_METADATA_FORM_OF_USE_OFFSET = 9;
    static final int BIND_METADATA_PER_POSITION_SIZE = 10;
    int bindBufferCapacity;
    int numberOfBoundRows;
    int indicatorsOffset;
    int valueLengthsOffset;
    boolean preparedAllBinds;
    boolean preparedCharBinds;
    Binder[] lastBinders;
    byte[] lastBoundBytes;
    int lastBoundByteOffset;
    char[] lastBoundChars;
    int lastBoundCharOffset;
    int[] lastBoundByteOffsets;
    int[] lastBoundCharOffsets;
    int[] lastBoundByteLens;
    int[] lastBoundCharLens;
    short[] lastBoundInds;
    short[] lastBoundLens;
    boolean lastBoundNeeded = false;
    byte[][] lastBoundTypeBytes;
    OracleTypeADT[] lastBoundTypeOtypes;
    private static final int STREAM_MAX_BYTES_SQL = Integer.MAX_VALUE;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsNCharsSql;
    int maxVcsBytesPlsql;
    private int maxCharSize = 0;
    private int maxNCharSize = 0;
    private int charMaxCharsSql = 0;
    private int charMaxNCharsSql = 0;
    private int maxVcsCharsPlsql = 0;
    private int maxVcsNCharsPlsql = 0;
    private int maxStreamCharsSql = 0;
    private int maxStreamNCharsSql = 0;
    protected boolean isServerCharSetFixedWidth = false;
    private boolean isServerNCharSetFixedWidth = false;
    int minVcsBindSize;
    int prematureBatchCount;
    boolean checkBindTypes = true;
    boolean scrollRsetTypeSolved;
    int SetBigStringTryClob = 0;
    static final int BSTYLE_UNKNOWN = 0;
    static final int BSTYLE_ORACLE = 1;
    static final int BSTYLE_JDBC = 2;
    int m_batchStyle = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePreparedStatement(PhysicalConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(batchValue) + ", " + OracleLog.argument(rowPrefetchValue));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OraclePreparedStatement(PhysicalConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(batch_value) + ", " + OracleLog.argument(row_prefetch_value));
                OracleLog.recursiveTrace = false;
            }
            if (batch_value > 1) {
                this.setOracleBatchStyle();
            }
            this.theSetCHARBinder = conn.useLittleEndianSetCHARBinder() ? theStaticLittleEndianSetCHARBinder : theStaticSetCHARBinder;
            this.theRowidBinder = conn.useLittleEndianSetCHARBinder() ? theStaticLittleEndianRowidBinder : theStaticRowidBinder;
            this.statementType = 1;
            this.currentRow = -1;
            this.needToParse = true;
            this.processEscapes = conn.processEscapes;
            this.sqlObject.initialize(sql);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.clearParameters = true;
            this.scrollRsetTypeSolved = false;
            this.prematureBatchCount = 0;
            this.initializeBinds();
            this.minVcsBindSize = conn.minVcsBindSize;
            this.maxRawBytesSql = conn.maxRawBytesSql;
            this.maxRawBytesPlsql = conn.maxRawBytesPlsql;
            this.maxVcsCharsSql = conn.maxVcsCharsSql;
            this.maxVcsNCharsSql = conn.maxVcsNCharsSql;
            this.maxVcsBytesPlsql = conn.maxVcsBytesPlsql;
            this.maxCharSize = this.connection.conversion.sMaxCharSize;
            this.maxNCharSize = this.connection.conversion.maxNCharSize;
            this.maxVcsCharsPlsql = this.maxVcsBytesPlsql / this.maxCharSize;
            this.maxVcsNCharsPlsql = this.maxVcsBytesPlsql / this.maxNCharSize;
            this.maxStreamCharsSql = Integer.MAX_VALUE / this.maxCharSize;
            this.maxStreamNCharsSql = this.maxRawBytesSql / this.maxNCharSize;
            this.isServerCharSetFixedWidth = this.connection.conversion.isServerCharSetFixedWidth;
            this.isServerNCharSetFixedWidth = this.connection.conversion.isServerNCharSetFixedWidth;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(new_number_of_bind_rows_allocated));
                OracleLog.recursiveTrace = false;
            }
            boolean growing = new_number_of_bind_rows_allocated > this.numberOfBindRowsAllocated;
            this.initializeIndicatorSubRange();
            int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
            int dataSizeTerm = new_number_of_bind_rows_allocated * this.numberOfBindPositions;
            int indicatorSize = preambleSize + 2 * dataSizeTerm;
            if (indicatorSize > this.totalBindIndicatorLength) {
                short[] oldBindIndicators = this.bindIndicators;
                int oldBindIndicatorOffset = this.bindIndicatorOffset;
                this.bindIndicatorOffset = 0;
                this.bindIndicators = new short[indicatorSize];
                this.totalBindIndicatorLength = indicatorSize;
                if (oldBindIndicators != null && growing) {
                    System.arraycopy(oldBindIndicators, oldBindIndicatorOffset, this.bindIndicators, this.bindIndicatorOffset, preambleSize);
                }
            }
            this.bindIndicatorSubRange += this.bindIndicatorOffset;
            this.bindIndicators[this.bindIndicatorSubRange + 0] = (short)this.numberOfBindPositions;
            this.indicatorsOffset = this.bindIndicatorOffset + preambleSize;
            this.valueLengthsOffset = this.indicatorsOffset + dataSizeTerm;
            int indoffset = this.indicatorsOffset;
            int lenoffset = this.valueLengthsOffset;
            int metadata_offset = this.bindIndicatorSubRange + 5;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                this.bindIndicators[metadata_offset + 5] = (short)(indoffset >> 16);
                this.bindIndicators[metadata_offset + 6] = (short)(indoffset & 0xFFFF);
                this.bindIndicators[metadata_offset + 7] = (short)(lenoffset >> 16);
                this.bindIndicators[metadata_offset + 8] = (short)(lenoffset & 0xFFFF);
                indoffset += new_number_of_bind_rows_allocated;
                lenoffset += new_number_of_bind_rows_allocated;
                metadata_offset += 10;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeBinds() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.numberOfBindPositions = this.sqlObject.getParameterCount();
            if (this.numberOfBindPositions == 0) {
                this.currentRowNeedToPrepareBinds = false;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            this.numberOfBindRowsAllocated = this.batch;
            this.binders = new Binder[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            this.currentRowBinders = this.binders[0];
            this.currentRowCharLens = new int[this.numberOfBindPositions];
            this.currentBatchCharLens = new int[this.numberOfBindPositions];
            this.currentRowFormOfUse = new short[this.numberOfBindPositions];
            this.currentBatchFormOfUse = new short[this.numberOfBindPositions];
            int defaultFormOfUse = 1;
            if (this.connection.defaultnchar) {
                defaultFormOfUse = 2;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                this.currentRowFormOfUse[i2] = defaultFormOfUse;
                this.currentBatchFormOfUse[i2] = defaultFormOfUse;
            }
            this.lastBinders = new Binder[this.numberOfBindPositions];
            this.lastBoundCharLens = new int[this.numberOfBindPositions];
            this.lastBoundByteOffsets = new int[this.numberOfBindPositions];
            this.lastBoundCharOffsets = new int[this.numberOfBindPositions];
            this.lastBoundByteLens = new int[this.numberOfBindPositions];
            this.lastBoundInds = new short[this.numberOfBindPositions];
            this.lastBoundLens = new short[this.numberOfBindPositions];
            this.lastBoundTypeBytes = new byte[this.numberOfBindPositions][];
            this.lastBoundTypeOtypes = new OracleTypeADT[this.numberOfBindPositions];
            this.allocBinds(this.numberOfBindRowsAllocated);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void growBinds(int new_number_of_bind_rows_allocated) throws SQLException {
        try {
            int i2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(new_number_of_bind_rows_allocated));
                OracleLog.recursiveTrace = false;
            }
            Binder[][] oldBinders = this.binders;
            this.binders = new Binder[new_number_of_bind_rows_allocated][];
            if (oldBinders != null) {
                System.arraycopy(oldBinders, 0, this.binders, 0, this.numberOfBindRowsAllocated);
            }
            for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                this.binders[i2] = new Binder[this.numberOfBindPositions];
            }
            this.allocBinds(new_number_of_bind_rows_allocated);
            if (this.parameterInt != null) {
                int[][] oldParameterInt = this.parameterInt;
                this.parameterInt = new int[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterInt, 0, this.parameterInt, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterInt[i2] = new int[this.numberOfBindPositions];
                }
            }
            if (this.parameterLong != null) {
                long[][] oldParameterLong = this.parameterLong;
                this.parameterLong = new long[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterLong, 0, this.parameterLong, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterLong[i2] = new long[this.numberOfBindPositions];
                }
            }
            if (this.parameterFloat != null) {
                float[][] oldParameterFloat = this.parameterFloat;
                this.parameterFloat = new float[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterFloat, 0, this.parameterFloat, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterFloat[i2] = new float[this.numberOfBindPositions];
                }
            }
            if (this.parameterDouble != null) {
                double[][] oldParameterDouble = this.parameterDouble;
                this.parameterDouble = new double[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterDouble, 0, this.parameterDouble, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterDouble[i2] = new double[this.numberOfBindPositions];
                }
            }
            if (this.parameterBigDecimal != null) {
                BigDecimal[][] oldParameterBigDecimal = this.parameterBigDecimal;
                this.parameterBigDecimal = new BigDecimal[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterBigDecimal, 0, this.parameterBigDecimal, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterBigDecimal[i2] = new BigDecimal[this.numberOfBindPositions];
                }
            }
            if (this.parameterString != null) {
                String[][] oldParameterString = this.parameterString;
                this.parameterString = new String[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterString, 0, this.parameterString, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterString[i2] = new String[this.numberOfBindPositions];
                }
            }
            if (this.parameterDate != null) {
                Date[][] oldParameterDate = this.parameterDate;
                this.parameterDate = new Date[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterDate, 0, this.parameterDate, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterDate[i2] = new Date[this.numberOfBindPositions];
                }
            }
            if (this.parameterTime != null) {
                Time[][] oldParameterTime = this.parameterTime;
                this.parameterTime = new Time[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterTime, 0, this.parameterTime, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterTime[i2] = new Time[this.numberOfBindPositions];
                }
            }
            if (this.parameterTimestamp != null) {
                Timestamp[][] oldParameterTimestamp = this.parameterTimestamp;
                this.parameterTimestamp = new Timestamp[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterTimestamp, 0, this.parameterTimestamp, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterTimestamp[i2] = new Timestamp[this.numberOfBindPositions];
                }
            }
            if (this.parameterDatum != null) {
                byte[][][] oldParameterDatum = this.parameterDatum;
                this.parameterDatum = new byte[new_number_of_bind_rows_allocated][][];
                System.arraycopy(oldParameterDatum, 0, this.parameterDatum, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterDatum[i2] = new byte[this.numberOfBindPositions][];
                }
            }
            if (this.parameterOtype != null) {
                OracleTypeADT[][] oldParameterOtype = this.parameterOtype;
                this.parameterOtype = new OracleTypeADT[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterOtype, 0, this.parameterOtype, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterOtype[i2] = new OracleTypeADT[this.numberOfBindPositions];
                }
            }
            if (this.parameterStream != null) {
                InputStream[][] oldParameterStream = this.parameterStream;
                this.parameterStream = new InputStream[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterStream, 0, this.parameterStream, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterStream[i2] = new InputStream[this.numberOfBindPositions];
                }
            }
            if (this.parameterPlsqlIbt != null) {
                PlsqlIbtBindInfo[][] oldParameterPlsqlIbt = this.parameterPlsqlIbt;
                this.parameterPlsqlIbt = new PlsqlIbtBindInfo[new_number_of_bind_rows_allocated][];
                System.arraycopy(oldParameterPlsqlIbt, 0, this.parameterPlsqlIbt, 0, this.numberOfBindRowsAllocated);
                for (i2 = this.numberOfBindRowsAllocated; i2 < new_number_of_bind_rows_allocated; ++i2) {
                    this.parameterPlsqlIbt[i2] = new PlsqlIbtBindInfo[this.numberOfBindPositions];
                }
            }
            this.numberOfBindRowsAllocated = new_number_of_bind_rows_allocated;
            this.currentRowNeedToPrepareBinds = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompletedBindRow(int number_of_rows_in_batch, boolean batchForPlsql) throws SQLException {
        try {
            int nextRank;
            Binder binder;
            int i2;
            Binder[] prevBinders;
            boolean isFirstRowInBatch;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(number_of_rows_in_batch) + ", " + OracleLog.argument(batchForPlsql));
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfBindPositions == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            boolean bindTypeChange = false;
            boolean bindTypeConflict = false;
            boolean bl = isFirstRowInBatch = this.currentRank == this.firstRowInBatch;
            Binder[] binderArray = this.currentRank == 0 ? (this.lastBinders[0] == null ? null : this.lastBinders) : (prevBinders = this.binders[this.currentRank - 1]);
            if (this.currentRowBindAccessors == null) {
                boolean requireAutoKeyRegistration;
                boolean bl2 = requireAutoKeyRegistration = this.isAutoGeneratedKey && this.clearParameters;
                if (prevBinders == null) {
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        if (this.currentRowBinders[i2] != null) continue;
                        if (requireAutoKeyRegistration) {
                            this.registerReturnParamsForAutoKey();
                            requireAutoKeyRegistration = false;
                            continue;
                        }
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                    }
                } else if (this.checkBindTypes) {
                    OracleTypeADT[] prevOtypes = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        Binder binder2;
                        if (this.currentRowBinders[i2] == null && requireAutoKeyRegistration) {
                            this.registerReturnParamsForAutoKey();
                            requireAutoKeyRegistration = false;
                        }
                        if ((binder2 = this.currentRowBinders[i2]) == null) {
                            if (this.clearParameters) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                            }
                            this.currentRowBinders[i2] = prevBinders[i2].copyingBinder();
                            this.currentRowCharLens[i2] = -1;
                            if (isFirstRowInBatch || this.m_batchStyle == 2) {
                                this.lastBoundNeeded = true;
                            }
                        } else {
                            short type = binder2.type;
                            if (type != prevBinders[i2].type || (type == 109 || type == 111) && !this.parameterOtype[this.currentRank][i2].isInHierarchyOf(prevOtypes[i2]) || type == 9 && binder2.bytelen == 0 != (prevBinders[i2].bytelen == 0)) {
                                bindTypeChange = true;
                            }
                        }
                        if (this.currentBatchFormOfUse[i2] == this.currentRowFormOfUse[i2]) continue;
                        bindTypeChange = true;
                    }
                } else {
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        binder = this.currentRowBinders[i2];
                        if (binder != null) continue;
                        if (this.clearParameters) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                        }
                        this.currentRowBinders[i2] = prevBinders[i2].copyingBinder();
                        this.currentRowCharLens[i2] = -1;
                        if (!isFirstRowInBatch && this.m_batchStyle != 2) continue;
                        this.lastBoundNeeded = true;
                    }
                }
            } else if (prevBinders == null) {
                for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    Binder binder3 = this.currentRowBinders[i2];
                    Accessor accessor = this.currentRowBindAccessors[i2];
                    if (binder3 == null) {
                        if (accessor == null) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                            continue;
                        }
                        this.currentRowBinders[i2] = this.theOutBinder;
                        continue;
                    }
                    if (accessor == null || accessor.defineType == binder3.type || this.connection.permitTimestampDateMismatch && binder3.type == 180 && accessor.defineType == 12) continue;
                    bindTypeConflict = true;
                }
            } else if (this.checkBindTypes) {
                OracleTypeADT[] prevOtypes = this.currentRank == 0 ? this.lastBoundTypeOtypes : (this.parameterOtype == null ? null : this.parameterOtype[this.currentRank - 1]);
                for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    binder = this.currentRowBinders[i2];
                    Accessor accessor = this.currentRowBindAccessors[i2];
                    if (binder == null) {
                        if (this.clearParameters && prevBinders[i2] != this.theOutBinder) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                        }
                        this.currentRowBinders[i2] = binder = prevBinders[i2];
                        this.currentRowCharLens[i2] = -1;
                        if (isFirstRowInBatch && binder != this.theOutBinder) {
                            this.lastBoundNeeded = true;
                        }
                    } else {
                        short type = binder.type;
                        if (type != prevBinders[i2].type || (type == 109 || type == 111) && !this.parameterOtype[this.currentRank][i2].isInHierarchyOf(prevOtypes[i2]) || type == 9 && binder.bytelen == 0 != (prevBinders[i2].bytelen == 0)) {
                            bindTypeChange = true;
                        }
                    }
                    if (this.currentBatchFormOfUse[i2] != this.currentRowFormOfUse[i2]) {
                        bindTypeChange = true;
                    }
                    Accessor lastAccessor = this.currentBatchBindAccessors[i2];
                    if (accessor == null) {
                        this.currentRowBindAccessors[i2] = accessor = lastAccessor;
                    } else if (lastAccessor != null && accessor.defineType != lastAccessor.defineType) {
                        bindTypeChange = true;
                    }
                    if (accessor == null || binder == this.theOutBinder || accessor.defineType == binder.type || this.connection.permitTimestampDateMismatch && binder.type == 180 && accessor.defineType == 12) continue;
                    bindTypeConflict = true;
                }
            } else {
                for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    Binder binder4 = this.currentRowBinders[i2];
                    if (binder4 == null) {
                        if (this.clearParameters && prevBinders[i2] != this.theOutBinder) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 41" + new Integer(i2 + 1));
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 41, new Integer(i2 + 1));
                        }
                        this.currentRowBinders[i2] = binder4 = prevBinders[i2];
                        this.currentRowCharLens[i2] = -1;
                        if (isFirstRowInBatch && binder4 != this.theOutBinder) {
                            this.lastBoundNeeded = true;
                        }
                    }
                    if (this.currentRowBindAccessors[i2] != null) continue;
                    this.currentRowBindAccessors[i2] = this.currentBatchBindAccessors[i2];
                }
            }
            if (bindTypeChange) {
                if (!isFirstRowInBatch) {
                    if (this.m_batchStyle == 2) {
                        this.pushBatch(false);
                    } else {
                        int save_valid_rows = this.validRows;
                        this.prematureBatchCount = this.sendBatch();
                        this.validRows = save_valid_rows;
                    }
                }
                this.needToParse = true;
                this.currentRowNeedToPrepareBinds = true;
            } else if (batchForPlsql) {
                this.pushBatch(false);
                this.needToParse = false;
                this.currentBatchNeedToPrepareBinds = false;
            }
            if (bindTypeConflict) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12);
            }
            for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int charlen = this.currentRowCharLens[i2];
                if (charlen == -1) {
                    charlen = this.lastBoundCharLens[i2];
                }
                if (this.currentBatchCharLens[i2] < charlen) {
                    this.currentBatchCharLens[i2] = charlen;
                }
                this.currentRowCharLens[i2] = 0;
                this.currentBatchFormOfUse[i2] = this.currentRowFormOfUse[i2];
            }
            if (this.currentRowNeedToPrepareBinds) {
                this.currentBatchNeedToPrepareBinds = true;
            }
            if (this.currentRowBindAccessors != null) {
                Accessor[] tmp = this.currentBatchBindAccessors;
                this.currentBatchBindAccessors = this.currentRowBindAccessors;
                if (tmp == null) {
                    tmp = new Accessor[this.numberOfBindPositions];
                } else {
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        tmp[i2] = null;
                    }
                }
                this.currentRowBindAccessors = tmp;
            }
            if ((nextRank = this.currentRank + 1) < number_of_rows_in_batch) {
                if (nextRank >= this.numberOfBindRowsAllocated) {
                    int new_number_of_bind_rows_allocated = this.numberOfBindRowsAllocated << 1;
                    if (new_number_of_bind_rows_allocated <= nextRank) {
                        new_number_of_bind_rows_allocated = nextRank + 1;
                    }
                    this.growBinds(new_number_of_bind_rows_allocated);
                    this.currentBatchNeedToPrepareBinds = true;
                }
                this.currentRowBinders = this.binders[nextRank];
            } else {
                this.setupBindBuffers(0, number_of_rows_in_batch);
                this.currentRowBinders = this.binders[0];
            }
            this.currentRowNeedToPrepareBinds = false;
            this.clearParameters = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPlsqlIndexTabBinds(int cur_row_to_be_bound) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cur_row_to_be_bound));
                OracleLog.recursiveTrace = false;
            }
            int num_plsql_index_tab_binds = 0;
            int total_elements = 0;
            int bytes = 0;
            int chars = 0;
            Binder[] curRowBinders = this.binders[cur_row_to_be_bound];
            PlsqlIbtBindInfo[] inBindInfos = this.parameterPlsqlIbt == null ? null : this.parameterPlsqlIbt[cur_row_to_be_bound];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                PlsqlIndexTableAccessor ibtAccessor;
                Binder binder = curRowBinders[i2];
                Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i2];
                PlsqlIndexTableAccessor plsqlIndexTableAccessor = ibtAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
                if (binder.type == 998) {
                    PlsqlIbtBindInfo inBindInfo = inBindInfos[i2];
                    if (ibtAccessor != null) {
                        if (inBindInfo.element_internal_type != ibtAccessor.elementInternalType) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 12");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 12);
                        }
                        if (inBindInfo.maxLen < ibtAccessor.maxNumberOfElements) {
                            inBindInfo.maxLen = ibtAccessor.maxNumberOfElements;
                        }
                        if (inBindInfo.elemMaxLen < ibtAccessor.elementMaxLen) {
                            inBindInfo.elemMaxLen = ibtAccessor.elementMaxLen;
                        }
                        if (inBindInfo.ibtByteLength > 0) {
                            inBindInfo.ibtByteLength = inBindInfo.elemMaxLen * inBindInfo.maxLen;
                        } else {
                            inBindInfo.ibtCharLength = inBindInfo.elemMaxLen * inBindInfo.maxLen;
                        }
                    }
                    ++num_plsql_index_tab_binds;
                    bytes += inBindInfo.ibtByteLength;
                    chars += inBindInfo.ibtCharLength;
                    total_elements += inBindInfo.maxLen;
                    continue;
                }
                if (ibtAccessor == null) continue;
                ++num_plsql_index_tab_binds;
                bytes += ibtAccessor.ibtByteLength;
                chars += ibtAccessor.ibtCharLength;
                total_elements += ibtAccessor.maxNumberOfElements;
            }
            if (num_plsql_index_tab_binds == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            this.ibtBindIndicatorSize = 6 + num_plsql_index_tab_binds * 8 + total_elements * 2;
            this.ibtBindIndicators = new short[this.ibtBindIndicatorSize];
            this.ibtBindIndicatorOffset = 0;
            if (bytes > 0) {
                this.ibtBindBytes = new byte[bytes];
            }
            this.ibtBindByteOffset = 0;
            if (chars > 0) {
                this.ibtBindChars = new char[chars];
            }
            this.ibtBindCharOffset = 0;
            int byteOffset = this.ibtBindByteOffset;
            int charOffset = this.ibtBindCharOffset;
            int indOffset = this.ibtBindIndicatorOffset;
            int offset = indOffset + 6 + num_plsql_index_tab_binds * 8;
            this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(num_plsql_index_tab_binds & 0xFFFF);
            this.ibtBindIndicators[indOffset++] = (short)(bytes >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(bytes & 0xFFFF);
            this.ibtBindIndicators[indOffset++] = (short)(chars >> 16);
            this.ibtBindIndicators[indOffset++] = (short)(chars & 0xFFFF);
            for (int i3 = 0; i3 < this.numberOfBindPositions; ++i3) {
                int byteOrCharOffset;
                PlsqlIndexTableAccessor ibtAccessor;
                Binder binder = curRowBinders[i3];
                Accessor accessor = this.currentBatchBindAccessors == null ? null : this.currentBatchBindAccessors[i3];
                PlsqlIndexTableAccessor plsqlIndexTableAccessor = ibtAccessor = accessor == null || accessor.defineType != 998 ? null : (PlsqlIndexTableAccessor)accessor;
                if (binder.type == 998) {
                    PlsqlIbtBindInfo inBindInfo = inBindInfos[i3];
                    int maxlen = inBindInfo.maxLen;
                    this.ibtBindIndicators[indOffset++] = (short)inBindInfo.element_internal_type;
                    this.ibtBindIndicators[indOffset++] = (short)inBindInfo.elemMaxLen;
                    this.ibtBindIndicators[indOffset++] = (short)(maxlen >> 16);
                    this.ibtBindIndicators[indOffset++] = (short)(maxlen & 0xFFFF);
                    this.ibtBindIndicators[indOffset++] = (short)(inBindInfo.curLen >> 16);
                    this.ibtBindIndicators[indOffset++] = (short)(inBindInfo.curLen & 0xFFFF);
                    if (inBindInfo.ibtByteLength > 0) {
                        byteOrCharOffset = byteOffset;
                        byteOffset += inBindInfo.ibtByteLength;
                    } else {
                        byteOrCharOffset = charOffset;
                        charOffset += inBindInfo.ibtCharLength;
                    }
                    this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset >> 16);
                    this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset & 0xFFFF);
                    inBindInfo.ibtValueIndex = byteOrCharOffset;
                    inBindInfo.ibtIndicatorIndex = offset;
                    inBindInfo.ibtLengthIndex = offset + maxlen;
                    if (ibtAccessor != null) {
                        ibtAccessor.ibtIndicatorIndex = inBindInfo.ibtIndicatorIndex;
                        ibtAccessor.ibtLengthIndex = inBindInfo.ibtLengthIndex;
                        ibtAccessor.ibtMetaIndex = indOffset - 8;
                        ibtAccessor.ibtValueIndex = byteOrCharOffset;
                    }
                    offset += 2 * maxlen;
                    continue;
                }
                if (ibtAccessor == null) continue;
                int maxlen = ibtAccessor.maxNumberOfElements;
                this.ibtBindIndicators[indOffset++] = (short)ibtAccessor.elementInternalType;
                this.ibtBindIndicators[indOffset++] = (short)ibtAccessor.elementMaxLen;
                this.ibtBindIndicators[indOffset++] = (short)(maxlen >> 16);
                this.ibtBindIndicators[indOffset++] = (short)(maxlen & 0xFFFF);
                this.ibtBindIndicators[indOffset++] = 0;
                this.ibtBindIndicators[indOffset++] = 0;
                if (ibtAccessor.ibtByteLength > 0) {
                    byteOrCharOffset = byteOffset;
                    byteOffset += ibtAccessor.ibtByteLength;
                } else {
                    byteOrCharOffset = charOffset;
                    charOffset += ibtAccessor.ibtCharLength;
                }
                this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset >> 16);
                this.ibtBindIndicators[indOffset++] = (short)(byteOrCharOffset & 0xFFFF);
                ibtAccessor.ibtValueIndex = byteOrCharOffset;
                ibtAccessor.ibtIndicatorIndex = offset;
                ibtAccessor.ibtLengthIndex = offset + maxlen;
                ibtAccessor.ibtMetaIndex = indOffset - 8;
                offset += 2 * maxlen;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeBindSubRanges(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(number_of_rows_to_be_bound) + ", " + OracleLog.argument(number_of_rows_to_be_set_up));
                OracleLog.recursiveTrace = false;
            }
            this.bindByteSubRange = 0;
            this.bindCharSubRange = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeIndicatorSubRange() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.bindIndicatorSubRange = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareBindPreambles(int number_of_rows_to_be_bound, int number_of_rows_to_be_set_up) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(number_of_rows_to_be_bound) + ", " + OracleLog.argument(number_of_rows_to_be_set_up));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: do nothing");
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupBindBuffers(int first_row_to_be_bound, int number_of_rows_to_be_bound) throws SQLException {
        try {
            block46: {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(first_row_to_be_bound) + ", " + OracleLog.argument(number_of_rows_to_be_bound));
                    OracleLog.recursiveTrace = false;
                }
                if (this.numberOfBindPositions != 0) break block46;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            try {
                int per_position_metadata_offset;
                int i2;
                this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
                this.preparedCharBinds = false;
                this.currentBatchNeedToPrepareBinds = false;
                this.numberOfBoundRows = number_of_rows_to_be_bound;
                this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
                this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
                int number_of_rows_to_be_set_up = this.bindBufferCapacity;
                if (this.numberOfBoundRows > this.bindBufferCapacity) {
                    number_of_rows_to_be_set_up = this.numberOfBoundRows;
                    this.preparedAllBinds = true;
                }
                if (this.currentBatchBindAccessors != null) {
                    if (this.outBindAccessors == null) {
                        this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                    }
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        int charlen;
                        Accessor accessor;
                        this.outBindAccessors[i2] = accessor = this.currentBatchBindAccessors[i2];
                        if (accessor == null || this.currentBatchCharLens[i2] >= (charlen = accessor.charLength)) continue;
                        this.currentBatchCharLens[i2] = charlen;
                    }
                }
                int row_charlen = 0;
                int row_bytelen = 0;
                int metadata_offset = per_position_metadata_offset = this.bindIndicatorSubRange + 5;
                if (this.preparedAllBinds) {
                    this.preparedCharBinds = true;
                    Binder[] firstRankBinders = this.binders[first_row_to_be_bound];
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        short type;
                        int bytelen;
                        Binder binder = firstRankBinders[i2];
                        int charlen = this.currentBatchCharLens[i2];
                        if (binder == this.theOutBinder) {
                            Accessor accessor = this.currentBatchBindAccessors[i2];
                            bytelen = accessor.byteLength;
                            type = (short)accessor.defineType;
                        } else {
                            bytelen = binder.bytelen;
                            type = binder.type;
                        }
                        row_bytelen += bytelen;
                        row_charlen += charlen;
                        this.bindIndicators[metadata_offset + 0] = type;
                        this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                        this.bindIndicators[metadata_offset + 2] = (short)charlen;
                        this.bindIndicators[metadata_offset + 9] = this.currentBatchFormOfUse[i2];
                        metadata_offset += 10;
                    }
                } else if (this.preparedCharBinds) {
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        int charlen = this.currentBatchCharLens[i2];
                        row_charlen += charlen;
                        this.bindIndicators[metadata_offset + 2] = (short)charlen;
                        metadata_offset += 10;
                    }
                } else {
                    for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        boolean wasLastBindNull;
                        int pitchOffset = metadata_offset + 2;
                        int charlen = this.currentBatchCharLens[i2];
                        int oldcharlen = this.bindIndicators[pitchOffset];
                        int ind_offset = (this.bindIndicators[metadata_offset + 5] << 16) + this.bindIndicators[metadata_offset + 6];
                        boolean bl = wasLastBindNull = this.bindIndicators[ind_offset] == -1;
                        if (wasLastBindNull && charlen > 1) {
                            this.preparedCharBinds = true;
                        }
                        if (oldcharlen >= charlen && !this.preparedCharBinds) {
                            this.currentBatchCharLens[i2] = oldcharlen;
                            row_charlen += oldcharlen;
                        } else {
                            this.bindIndicators[pitchOffset] = (short)charlen;
                            row_charlen += charlen;
                            this.preparedCharBinds = true;
                        }
                        metadata_offset += 10;
                    }
                }
                if (this.preparedCharBinds) {
                    this.initializeBindSubRanges(this.numberOfBoundRows, number_of_rows_to_be_set_up);
                }
                if (this.preparedAllBinds) {
                    int total_bytelen = this.bindByteSubRange + row_bytelen * number_of_rows_to_be_set_up;
                    if (this.lastBoundNeeded || total_bytelen > this.totalBindByteLength) {
                        this.bindByteOffset = 0;
                        this.bindBytes = new byte[total_bytelen];
                        this.totalBindByteLength = total_bytelen;
                    }
                    this.bindBufferCapacity = number_of_rows_to_be_set_up;
                    this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)((this.bindBufferCapacity & 0xFFFF0000) >> 16);
                    this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)(this.bindBufferCapacity & 0xFFFF);
                }
                if (this.preparedCharBinds) {
                    int total_charlen = this.bindCharSubRange + row_charlen * this.bindBufferCapacity;
                    if (this.lastBoundNeeded || total_charlen > this.totalBindCharLength) {
                        this.bindCharOffset = 0;
                        this.bindChars = new char[total_charlen];
                        this.totalBindCharLength = total_charlen;
                    }
                    this.bindByteSubRange += this.bindByteOffset;
                    this.bindCharSubRange += this.bindCharOffset;
                }
                int byteoffset = this.bindByteSubRange;
                int charoffset = this.bindCharSubRange;
                int indoffset = this.indicatorsOffset;
                int lenoffset = this.valueLengthsOffset;
                metadata_offset = per_position_metadata_offset;
                if (this.preparedCharBinds) {
                    int valueoffset;
                    int bytelen;
                    if (this.currentBatchBindAccessors == null) {
                        for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                            bytelen = this.bindIndicators[metadata_offset + 1];
                            int charlen = this.currentBatchCharLens[i2];
                            valueoffset = charlen == 0 ? byteoffset : charoffset;
                            this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                            this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                            byteoffset += bytelen * this.bindBufferCapacity;
                            charoffset += charlen * this.bindBufferCapacity;
                            metadata_offset += 10;
                        }
                    } else {
                        for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                            bytelen = this.bindIndicators[metadata_offset + 1];
                            int charlen = this.currentBatchCharLens[i2];
                            valueoffset = charlen == 0 ? byteoffset : charoffset;
                            this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                            this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                            Accessor accessor = this.currentBatchBindAccessors[i2];
                            if (accessor != null) {
                                if (charlen > 0) {
                                    accessor.columnIndex = charoffset;
                                    accessor.charLength = charlen;
                                } else {
                                    accessor.columnIndex = byteoffset;
                                    accessor.byteLength = bytelen;
                                }
                                accessor.lengthIndex = lenoffset;
                                accessor.indicatorIndex = indoffset;
                                accessor.rowSpaceByte = this.bindBytes;
                                accessor.rowSpaceChar = this.bindChars;
                                accessor.rowSpaceIndicator = this.bindIndicators;
                                if (accessor.defineType == 109 || accessor.defineType == 111) {
                                    accessor.setOffsets(this.bindBufferCapacity);
                                }
                            }
                            byteoffset += bytelen * this.bindBufferCapacity;
                            charoffset += charlen * this.bindBufferCapacity;
                            indoffset += this.numberOfBindRowsAllocated;
                            lenoffset += this.numberOfBindRowsAllocated;
                            metadata_offset += 10;
                        }
                    }
                    byteoffset = this.bindByteSubRange;
                    charoffset = this.bindCharSubRange;
                    indoffset = this.indicatorsOffset;
                    lenoffset = this.valueLengthsOffset;
                    metadata_offset = per_position_metadata_offset;
                }
                int unused_rows = this.bindBufferCapacity - this.numberOfBoundRows;
                int lastrow_in_buffers = this.numberOfBoundRows - 1;
                int lastrow_in_binders = lastrow_in_buffers + first_row_to_be_bound;
                Binder[] lastRowBinders = this.binders[lastrow_in_binders];
                if (this.parameterOtype != null) {
                    System.arraycopy(this.parameterDatum[lastrow_in_binders], 0, this.lastBoundTypeBytes, 0, this.numberOfBindPositions);
                    System.arraycopy(this.parameterOtype[lastrow_in_binders], 0, this.lastBoundTypeOtypes, 0, this.numberOfBindPositions);
                }
                if (this.hasIbtBind) {
                    this.processPlsqlIndexTabBinds(first_row_to_be_bound);
                }
                if (this.returnParamAccessors != null) {
                    this.processDmlReturningBind();
                }
                boolean clearPriorBindValues = this.sqlKind != 1 && this.sqlKind != 4 || this.currentRowBindAccessors == null;
                for (i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    int bytelen = this.bindIndicators[metadata_offset + 1];
                    int charlen = this.currentBatchCharLens[i2];
                    this.lastBinders[i2] = lastRowBinders[i2];
                    this.lastBoundByteLens[i2] = bytelen;
                    for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                        int rowInBinders = first_row_to_be_bound + rowInBuffers;
                        this.binders[rowInBinders][i2].bind(this, i2, rowInBuffers, rowInBinders, this.bindBytes, this.bindChars, this.bindIndicators, bytelen, charlen, byteoffset, charoffset, lenoffset + rowInBuffers, indoffset + rowInBuffers, clearPriorBindValues);
                        this.binders[rowInBinders][i2] = null;
                        byteoffset += bytelen;
                        charoffset += charlen;
                    }
                    this.lastBoundByteOffsets[i2] = byteoffset - bytelen;
                    this.lastBoundCharOffsets[i2] = charoffset - charlen;
                    this.lastBoundInds[i2] = this.bindIndicators[indoffset + lastrow_in_buffers];
                    this.lastBoundLens[i2] = this.bindIndicators[lenoffset + lastrow_in_buffers];
                    this.lastBoundCharLens[i2] = 0;
                    byteoffset += unused_rows * bytelen;
                    charoffset += unused_rows * charlen;
                    indoffset += this.numberOfBindRowsAllocated;
                    lenoffset += this.numberOfBindRowsAllocated;
                    metadata_offset += 10;
                }
                this.lastBoundBytes = this.bindBytes;
                this.lastBoundByteOffset = this.bindByteOffset;
                this.lastBoundChars = this.bindChars;
                this.lastBoundCharOffset = this.bindCharOffset;
                int[] tmp = this.currentBatchCharLens;
                this.currentBatchCharLens = this.lastBoundCharLens;
                this.lastBoundCharLens = tmp;
                this.lastBoundNeeded = false;
                this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
            }
            catch (NullPointerException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 89");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseBuffers() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.defineBytes != null) {
                this.connection.cacheBuffer(this.defineBytes);
            }
            if (this.defineChars != null) {
                this.connection.cacheBuffer(this.defineChars);
            }
            this.cachedBindCharSize = this.bindChars != null ? this.bindChars.length : 0;
            this.cachedBindByteSize = this.bindBytes != null ? this.bindBytes.length : 0;
            this.bindChars = null;
            this.bindBytes = null;
            this.lastBoundChars = null;
            this.lastBoundBytes = null;
            super.releaseBuffers();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterImplicitCache() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.alwaysOnClose();
            if (!this.connection.isClosed()) {
                this.cleanAllTempLobs();
            }
            if (this.connection.clearStatementMetaData) {
                this.lastBoundBytes = null;
                this.lastBoundChars = null;
            }
            this.clearParameters();
            this.cacheState = 2;
            this.creationState = 1;
            this.currentResultSet = null;
            this.lastIndex = 0;
            this.queryTimeout = 0;
            this.autoRollback = 2;
            this.rowPrefetchChanged = false;
            this.currentRank = 0;
            this.currentRow = -1;
            this.validRows = 0;
            this.maxRows = 0;
            this.totalRowsVisited = 0;
            this.maxFieldSize = 0;
            this.gotLastBatch = false;
            this.clearParameters = true;
            this.scrollRset = null;
            this.needToAddIdentifier = false;
            this.defaultFetchDirection = 1000;
            this.defaultTimeZone = null;
            this.defaultCalendar = null;
            if (this.sqlKind == 3) {
                this.needToParse = true;
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = false;
            }
            this.releaseBuffers();
            if (this.accessors != null) {
                int len = this.accessors.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    if (this.accessors[i2] == null) continue;
                    this.accessors[i2].rowSpaceByte = null;
                    this.accessors[i2].rowSpaceChar = null;
                    this.accessors[i2].rowSpaceIndicator = null;
                    if (!this.columnsDefinedByUser) continue;
                    this.accessors[i2].externalType = 0;
                }
            }
            this.fixedString = this.connection.getDefaultFixedString();
            this.defaultRowPrefetch = this.rowPrefetch;
            this.rowPrefetchInLastFetch = -1;
            if (this.connection.clearStatementMetaData) {
                this.sqlStringChanged = true;
                this.needToParse = true;
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = false;
                if (this.userRsetType == 0) {
                    this.userRsetType = 1;
                    this.realRsetType = 1;
                }
                this.currentRowNeedToPrepareBinds = true;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterExplicitCache() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheState = 2;
            this.creationState = 2;
            this.defaultTimeZone = null;
            this.alwaysOnClose();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitImplicitCacheToActive() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheState = 1;
            this.closed = false;
            if (this.rowPrefetch != this.connection.getDefaultRowPrefetch() && this.streamList == null) {
                this.defaultRowPrefetch = this.rowPrefetch = this.connection.getDefaultRowPrefetch();
                this.rowPrefetchChanged = true;
            }
            if (this.batch != this.connection.getDefaultExecuteBatch()) {
                this.resetBatch();
            }
            if (this.autoRefetch != this.connection.getDefaultAutoRefetch()) {
                this.autoRefetch = this.connection.getDefaultAutoRefetch();
            }
            this.processEscapes = this.connection.processEscapes;
            if (this.cachedDefineIndicatorSize != 0) {
                this.defineBytes = this.connection.getByteBuffer(this.cachedDefineByteSize, this.cacheState != 3);
                this.defineChars = this.connection.getCharBuffer(this.cachedDefineCharSize, this.cacheState != 3);
                this.defineIndicators = new short[this.cachedDefineIndicatorSize];
                if (this.accessors != null) {
                    int len = this.accessors.length;
                    for (int i2 = 0; i2 < len; ++i2) {
                        if (this.accessors[i2] == null) continue;
                        this.accessors[i2].rowSpaceByte = this.defineBytes;
                        this.accessors[i2].rowSpaceChar = this.defineChars;
                        this.accessors[i2].rowSpaceIndicator = this.defineIndicators;
                    }
                    this.doInitializationAfterDefineBufferRestore();
                }
            }
            if (this.cachedBindCharSize != 0 || this.cachedBindByteSize != 0) {
                if (this.cachedBindByteSize > 0) {
                    this.bindBytes = new byte[this.cachedBindByteSize];
                }
                if (this.cachedBindCharSize > 0) {
                    this.bindChars = new char[this.cachedBindCharSize];
                }
                this.doLocalInitialization();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLocalInitialization() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doInitializationAfterDefineBufferRestore() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitExplicitCacheToActive() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheState = 1;
            this.closed = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitImplicitCacheToClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheState = 0;
            this.closed = false;
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.hardClose();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitExplicitCacheToClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.cacheState = 0;
            this.closed = false;
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.hardClose();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWithKey(String key) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(key));
                        OracleLog.recursiveTrace = false;
                    }
                    this.closeOrCache(key);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeInternal() throws SQLException {
        try {
            boolean incrementRowCount;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            if (this.currentRank > 0 && this.m_batchStyle == 2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 81batch must be either executed or cleared");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            }
            boolean regularResultSet = this.userRsetType == 1;
            this.prepareForNewResults(true, false);
            this.processCompletedBindRow(this.sqlKind == 0 ? 1 : this.batch, false);
            if (!regularResultSet && !this.scrollRsetTypeSolved) {
                int __result__ = this.doScrollPstmtExecuteUpdate() + this.prematureBatchCount;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                int n2 = __result__;
                return n2;
            }
            this.doExecuteWithTimeout();
            boolean bl = incrementRowCount = this.prematureBatchCount != 0 && this.validRows > 0;
            if (!regularResultSet) {
                this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                this.scrollRset = ResultSetUtil.createScrollResultSet(this, this.currentResultSet, this.realRsetType);
                if (!this.connection.accumulateBatchResult) {
                    incrementRowCount = false;
                }
            }
            if (incrementRowCount) {
                this.validRows += this.prematureBatchCount;
                this.prematureBatchCount = 0;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.validRows);
                OracleLog.recursiveTrace = false;
            }
            int n3 = this.validRows;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet oracleResultSet;
            block12: {
                block10: {
                    OracleResultSetImpl oracleResultSetImpl;
                    block11: {
                        try {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                OracleLog.recursiveTrace = false;
                            }
                            this.executionType = 1;
                            this.executeInternal();
                            if (this.userRsetType != 1) break block10;
                            this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.currentResultSet);
                                OracleLog.recursiveTrace = false;
                            }
                            oracleResultSetImpl = this.currentResultSet;
                            if (!TRACE || OracleLog.recursiveTrace) break block11;
                            OracleLog.recursiveTrace = true;
                        }
                        catch (Throwable throwable) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            throw throwable;
                        }
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return oracleResultSetImpl;
                }
                if (this.scrollRset == null) {
                    this.currentResultSet = new OracleResultSetImpl(this.connection, this);
                    this.scrollRset = this.currentResultSet;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.scrollRset);
                    OracleLog.recursiveTrace = false;
                }
                oracleResultSet = this.scrollRset;
                if (!TRACE || OracleLog.recursiveTrace) break block12;
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return oracleResultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.executionType = (byte)2;
                    int __result__ = this.executeInternal();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    n2 = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block9: {
                try {
                    boolean __result__;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.executionType = (byte)3;
                    this.executeInternal();
                    boolean bl2 = __result__ = this.sqlKind == 0;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    bl = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void slideDownCurrentRow(int fromRow) {
        try {
            Object tmp;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fromRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.binders != null) {
                this.binders[fromRow] = this.binders[0];
                this.binders[0] = this.currentRowBinders;
            }
            if (this.parameterInt != null) {
                tmp = this.parameterInt[0];
                this.parameterInt[0] = this.parameterInt[fromRow];
                this.parameterInt[fromRow] = tmp;
            }
            if (this.parameterLong != null) {
                tmp = this.parameterLong[0];
                this.parameterLong[0] = this.parameterLong[fromRow];
                this.parameterLong[fromRow] = tmp;
            }
            if (this.parameterFloat != null) {
                tmp = this.parameterFloat[0];
                this.parameterFloat[0] = this.parameterFloat[fromRow];
                this.parameterFloat[fromRow] = tmp;
            }
            if (this.parameterDouble != null) {
                tmp = this.parameterDouble[0];
                this.parameterDouble[0] = this.parameterDouble[fromRow];
                this.parameterDouble[fromRow] = tmp;
            }
            if (this.parameterBigDecimal != null) {
                tmp = this.parameterBigDecimal[0];
                this.parameterBigDecimal[0] = this.parameterBigDecimal[fromRow];
                this.parameterBigDecimal[fromRow] = (BigDecimal[])tmp;
            }
            if (this.parameterString != null) {
                tmp = this.parameterString[0];
                this.parameterString[0] = this.parameterString[fromRow];
                this.parameterString[fromRow] = (String[])tmp;
            }
            if (this.parameterDate != null) {
                tmp = this.parameterDate[0];
                this.parameterDate[0] = this.parameterDate[fromRow];
                this.parameterDate[fromRow] = (Date[])tmp;
            }
            if (this.parameterTime != null) {
                tmp = this.parameterTime[0];
                this.parameterTime[0] = this.parameterTime[fromRow];
                this.parameterTime[fromRow] = (Time[])tmp;
            }
            if (this.parameterTimestamp != null) {
                tmp = this.parameterTimestamp[0];
                this.parameterTimestamp[0] = this.parameterTimestamp[fromRow];
                this.parameterTimestamp[fromRow] = (Timestamp[])tmp;
            }
            if (this.parameterDatum != null) {
                tmp = this.parameterDatum[0];
                this.parameterDatum[0] = this.parameterDatum[fromRow];
                this.parameterDatum[fromRow] = (byte[][])tmp;
            }
            if (this.parameterOtype != null) {
                tmp = this.parameterOtype[0];
                this.parameterOtype[0] = this.parameterOtype[fromRow];
                this.parameterOtype[fromRow] = (OracleTypeADT[])tmp;
            }
            if (this.parameterStream != null) {
                tmp = this.parameterStream[0];
                this.parameterStream[0] = this.parameterStream[fromRow];
                this.parameterStream[fromRow] = (InputStream[])tmp;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBatch() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.batch = this.connection.getDefaultExecuteBatch();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int sendBatch() throws SQLException {
        if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
            OracleLog.recursiveTrace = false;
        }
        if (!this.isJdbcBatchStyle()) ** GOTO lbl25
        if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
            OracleLog.recursiveTrace = false;
        }
        var1_1 = 0;
        if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
        }
        ** GOTO lbl24
        {
            catch (Throwable var7_9) {
                if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw var7_9;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
lbl24:
            // 2 sources

            return var1_1;
lbl25:
            // 1 sources

            var1_2 = this.connection;
            synchronized (var1_2) {
                this.ensureOpen();
                if (this.currentRank > 0) ** break block25
                v0 = __result__ = this.connection.accumulateBatchResult != false ? 0 : this.validRows;
                if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                var3_5 = __result__;
                this.currentRank = 0;
                ** if (!OraclePreparedStatement.TRACE || OracleLog.recursiveTrace) goto lbl41
            }
lbl-1000:
            // 1 sources

            {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
lbl41:
            // 2 sources

            return var3_5;
            {
                actual_batch = this.batch;
                try {
                    saved_current_rank = this.currentRank;
                    if (this.batch != this.currentRank) {
                        this.batch = this.currentRank;
                    }
                    this.setupBindBuffers(0, this.currentRank);
                    --this.currentRank;
                    this.doExecuteWithTimeout();
                    this.slideDownCurrentRow(saved_current_rank);
                }
                finally {
                    if (this.batch != actual_batch) {
                        this.batch = actual_batch;
                    }
                }
                if (this.connection.accumulateBatchResult) {
                    this.validRows += this.prematureBatchCount;
                    this.prematureBatchCount = 0;
                }
                if (OraclePreparedStatement.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.validRows);
                    OracleLog.recursiveTrace = false;
                }
                var3_6 = this.validRows;
                this.currentRank = 0;
                ** if (!OraclePreparedStatement.TRACE || OracleLog.recursiveTrace) goto lbl72
            }
lbl-1000:
            // 1 sources

            {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
lbl72:
            // 2 sources

            return var3_6;
            {
                catch (Throwable var5_8) {}
                {
                    this.currentRank = 0;
                    throw var5_8;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecuteBatch(int batchValue) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(batchValue));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setOracleBatchStyle();
                    this.set_execute_batch(batchValue);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set_execute_batch(int batchValue) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(batchValue));
                    OracleLog.recursiveTrace = false;
                }
                if (batchValue <= 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 42");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 42);
                }
                if (batchValue == this.batch) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                if (this.currentRank > 0) {
                    int save_valid_rows = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = save_valid_rows;
                }
                int oldBatch = this.batch;
                this.batch = batchValue;
                if (this.numberOfBindRowsAllocated < this.batch) {
                    this.growBinds(this.batch);
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getExecuteBatch() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.batch);
                    OracleLog.recursiveTrace = false;
                }
                n2 = this.batch;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterTypeBytes(int param_index, int type, int max_size) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(param_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                        OracleLog.recursiveTrace = false;
                    }
                    if (max_size < 0) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 53");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 53);
                    }
                    if (param_index < 1) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    switch (type) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            type = 6;
                            break;
                        }
                        case 1: {
                            type = 96;
                            break;
                        }
                        case 12: {
                            type = 1;
                            break;
                        }
                        case 91: 
                        case 92: {
                            type = 12;
                            break;
                        }
                        case -103: {
                            type = 182;
                            break;
                        }
                        case -104: {
                            type = 183;
                            break;
                        }
                        case -100: 
                        case 93: {
                            type = 180;
                            break;
                        }
                        case -101: {
                            type = 181;
                            break;
                        }
                        case -102: {
                            type = 231;
                            break;
                        }
                        case -3: 
                        case -2: {
                            type = 23;
                            break;
                        }
                        case 100: {
                            type = 100;
                            break;
                        }
                        case 101: {
                            type = 101;
                            break;
                        }
                        case -8: {
                            type = 104;
                            break;
                        }
                        case 2004: {
                            type = 113;
                            break;
                        }
                        case 2005: {
                            type = 112;
                            break;
                        }
                        case -13: {
                            type = 114;
                            break;
                        }
                        case -10: {
                            type = 102;
                            break;
                        }
                        case 0: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
                        }
                        default: {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwUnsupportedFeatureSqlException();
                        }
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block33;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterTypeChars(int param_index, int type, int max_size) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(param_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                        OracleLog.recursiveTrace = false;
                    }
                    int nlsratio = this.connection.getNlsRatio();
                    if (type == 1 || type == 12) {
                        this.defineParameterTypeBytes(param_index, type, max_size * nlsratio);
                    } else {
                        this.defineParameterTypeBytes(param_index, type, max_size);
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defineParameterType(int param_index, int type, int max_size) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(param_index) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(max_size));
                        OracleLog.recursiveTrace = false;
                    }
                    this.defineParameterTypeBytes(param_index, type, max_size);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData;
        block9: {
            block7: {
                ResultSetMetaData resultSetMetaData2;
                block8: {
                    try {
                        ResultSet _rset;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                            OracleLog.recursiveTrace = false;
                        }
                        if ((_rset = this.getResultSet()) == null) break block7;
                        ResultSetMetaData __result__ = _rset.getMetaData();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        resultSetMetaData2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block8;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return resultSetMetaData2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            resultSetMetaData = null;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int paramIndex, int sqlType, String sqlName) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlName));
                    OracleLog.recursiveTrace = false;
                }
                this.setNullInternal(paramIndex, sqlType, sqlName);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullInternal(int paramIndex, int sqlType, String sqlName) throws SQLException {
        block12: {
            try {
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlName));
                    OracleLog.recursiveTrace = false;
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003 || sqlType == 2007 || sqlType == 2006) {
                    PhysicalConnection physicalConnection = this.connection;
                    synchronized (physicalConnection) {
                        this.setNullCritial(index, sqlType, sqlName);
                        this.currentRowCharLens[index] = 0;
                        break block12;
                    }
                }
                this.setNullInternal(paramIndex, sqlType);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullInternal(int paramIndex, int sqlType) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType));
                    OracleLog.recursiveTrace = false;
                }
                this.setNullCritical(paramIndex, sqlType);
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullCritial(int index, int sqlType, String sqlName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlName));
                OracleLog.recursiveTrace = false;
            }
            OracleTypeADT otype = null;
            Binder binder = this.theNamedTypeNullBinder;
            switch (sqlType) {
                case 2006: {
                    binder = this.theRefTypeNullBinder;
                }
                case 2002: 
                case 2008: {
                    StructDescriptor desc = StructDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    otype = desc.getOracleTypeADT();
                    break;
                }
                case 2003: {
                    ArrayDescriptor desc = ArrayDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    otype = desc.getOracleTypeCOLLECTION();
                    break;
                }
                case 2007: {
                    OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    otype = (OracleTypeADT)desc.getPickler();
                    break;
                }
            }
            this.currentRowBinders[index] = binder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = null;
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNullAtName(String paramName, int sqlType, String sqlName) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlName));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setNullInternal(i2 + 1, sqlType, sqlName);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(int paramIndex, int sqlType) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setNullCritical(paramIndex, sqlType);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNullCritical(int paramIndex, int sqlType) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(sqlType));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            Binder binder = null;
            int dbtype = this.getInternalType(sqlType);
            switch (dbtype) {
                case 6: {
                    binder = this.theVarnumNullBinder;
                    break;
                }
                case 1: 
                case 8: 
                case 96: 
                case 995: {
                    binder = this.theVarcharNullBinder;
                    this.currentRowCharLens[index] = 1;
                    break;
                }
                case 999: {
                    binder = this.theFixedCHARNullBinder;
                    break;
                }
                case 12: {
                    binder = this.theDateNullBinder;
                    break;
                }
                case 180: {
                    binder = this.theTimestampNullBinder;
                    break;
                }
                case 181: {
                    binder = this.theTSTZNullBinder;
                    break;
                }
                case 231: {
                    binder = this.theTSLTZNullBinder;
                    break;
                }
                case 104: {
                    binder = this.getRowidNullBinder(index);
                    break;
                }
                case 183: {
                    binder = this.theIntervalDSNullBinder;
                    break;
                }
                case 182: {
                    binder = this.theIntervalYMNullBinder;
                    break;
                }
                case 23: 
                case 24: {
                    binder = this.theRawNullBinder;
                    break;
                }
                case 100: {
                    binder = this.theBinaryFloatNullBinder;
                    break;
                }
                case 101: {
                    binder = this.theBinaryDoubleNullBinder;
                    break;
                }
                case 113: {
                    binder = this.theBlobNullBinder;
                    break;
                }
                case 112: {
                    binder = this.theClobNullBinder;
                    break;
                }
                case 114: {
                    binder = this.theBfileNullBinder;
                    break;
                }
                case 109: 
                case 111: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4sqlType=" + sqlType);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4, "sqlType=" + sqlType);
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 23sqlType=" + sqlType);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 23, "sqlType=" + sqlType);
                }
            }
            this.currentRowBinders[index] = binder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder getRowidNullBinder(int index) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.theRowidNullBinder);
                OracleLog.recursiveTrace = false;
            }
            Binder binder = this.theRowidNullBinder;
            return binder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNullAtName(String paramName, int sqlType) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(sqlType));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setNull(i2 + 1, sqlType);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int paramIndex, boolean x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBooleanInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBooleanInternal(int paramIndex, boolean x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theBooleanBinder;
            if (this.parameterInt == null) {
                this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterInt[this.currentRank][index] = x ? 1 : 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int paramIndex, byte x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setByteInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setByteInternal(int paramIndex, byte x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theByteBinder;
            if (this.parameterInt == null) {
                this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterInt[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int paramIndex, short x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setShortInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShortInternal(int paramIndex, short x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theShortBinder;
            if (this.parameterInt == null) {
                this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterInt[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int paramIndex, int x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setIntInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIntInternal(int paramIndex, int x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theIntBinder;
            if (this.parameterInt == null) {
                this.parameterInt = new int[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterInt[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int paramIndex, long x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setLongInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLongInternal(int paramIndex, long x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theLongBinder;
            if (this.parameterLong == null) {
                this.parameterLong = new long[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterLong[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int paramIndex, float x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setFloatInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFloatInternal(int paramIndex, float x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (this.theFloatBinder == null) {
                this.theFloatBinder = theStaticFloatBinder;
                if (this.connection.setFloatAndDoubleUseBinary) {
                    this.theFloatBinder = theStaticBinaryFloatBinder;
                }
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theFloatBinder;
            if (this.theFloatBinder == theStaticFloatBinder) {
                if (this.parameterDouble == null) {
                    this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterDouble[this.currentRank][index] = x;
            } else {
                if (this.parameterFloat == null) {
                    this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterFloat[this.currentRank][index] = x;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int paramIndex, float x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBinaryFloatInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryFloatInternal(int paramIndex, float x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theBinaryFloatBinder;
            if (this.parameterFloat == null) {
                this.parameterFloat = new float[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterFloat[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(bf));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBinaryFloatInternal(paramIndex, bf);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryFloatInternal(int paramIndex, BINARY_FLOAT bf) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(bf));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (bf == null) {
                this.currentRowBinders[index] = this.theBINARY_FLOATNullBinder;
            } else {
                this.currentRowBinders[index] = this.theBINARY_FLOATBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = bf.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int paramIndex, double x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBinaryDoubleInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryDoubleInternal(int paramIndex, double x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowBinders[index] = this.theBinaryDoubleBinder;
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.currentRowCharLens[index] = 0;
            this.parameterDouble[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(bd));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBinaryDoubleInternal(paramIndex, bd);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryDoubleInternal(int paramIndex, BINARY_DOUBLE bd) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(bd));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (bd == null) {
                this.currentRowBinders[index] = this.theBINARY_DOUBLENullBinder;
            } else {
                this.currentRowBinders[index] = this.theBINARY_DOUBLEBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = bd.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int paramIndex, double x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setDoubleInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDoubleInternal(int paramIndex, double x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (this.theDoubleBinder == null) {
                this.theDoubleBinder = theStaticDoubleBinder;
                if (this.connection.setFloatAndDoubleUseBinary) {
                    this.theDoubleBinder = theStaticBinaryDoubleBinder;
                }
            }
            this.currentRowCharLens[index] = 0;
            this.currentRowBinders[index] = this.theDoubleBinder;
            if (this.parameterDouble == null) {
                this.parameterDouble = new double[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterDouble[this.currentRank][index] = x;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBigDecimalInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBigDecimalInternal(int paramIndex, BigDecimal x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theVarnumNullBinder;
            } else {
                this.currentRowBinders[index] = this.theBigDecimalBinder;
                if (this.parameterBigDecimal == null) {
                    this.parameterBigDecimal = new BigDecimal[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterBigDecimal[this.currentRank][index] = x;
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int paramIndex, String x) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                this.setStringInternal(paramIndex, x);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStringInternal(int paramIndex, String x) throws SQLException {
        try {
            int stringLength;
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            int n2 = stringLength = x != null ? x.length() : 0;
            if (stringLength == 0) {
                this.basicBindNullString(paramIndex);
            } else if (this.currentRowFormOfUse[paramIndex - 1] == 1) {
                if (this.sqlKind == 1 || this.sqlKind == 4) {
                    if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsCharsPlsql && this.isServerCharSetFixedWidth) {
                        this.setStringForClobCritical(paramIndex, x);
                    } else if (stringLength > this.maxVcsCharsPlsql) {
                        int bytes_length = this.connection.conversion.encodedByteLength(x, false);
                        if (bytes_length > this.maxVcsBytesPlsql) {
                            this.setStringForClobCritical(paramIndex, x);
                        } else {
                            this.basicBindString(paramIndex, x);
                        }
                    } else {
                        this.basicBindString(paramIndex, x);
                    }
                } else if (stringLength <= this.maxVcsCharsSql) {
                    this.basicBindString(paramIndex, x);
                } else if (stringLength <= this.maxStreamCharsSql) {
                    this.basicBindCharacterStream(paramIndex, new StringReader(x), stringLength);
                } else {
                    this.setStringForClobCritical(paramIndex, x);
                }
            } else if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (stringLength > this.maxVcsBytesPlsql || stringLength > this.maxVcsNCharsPlsql && this.isServerNCharSetFixedWidth) {
                    this.setStringForClobCritical(paramIndex, x);
                } else if (stringLength > this.maxVcsNCharsPlsql) {
                    int bytes_length = this.connection.conversion.encodedByteLength(x, true);
                    if (bytes_length > this.maxVcsBytesPlsql) {
                        this.setStringForClobCritical(paramIndex, x);
                    } else {
                        this.basicBindString(paramIndex, x);
                    }
                } else {
                    this.basicBindString(paramIndex, x);
                }
            } else if (stringLength <= this.maxVcsCharsSql) {
                this.basicBindString(paramIndex, x);
            } else if (stringLength <= this.maxStreamNCharsSql) {
                this.setStringForClobCritical(paramIndex, x);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindNullString(int paramIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex));
                    OracleLog.recursiveTrace = false;
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = this.theVarcharNullBinder;
                this.currentRowCharLens[index] = this.sqlKind == 1 || this.sqlKind == 4 ? this.minVcsBindSize : 1;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindString(int paramIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int min_size;
                int cur_len;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = this.theStringBinder;
                int stringLength = x.length();
                this.currentRowCharLens[index] = this.sqlKind == 1 || this.sqlKind == 4 ? ((cur_len = stringLength + 1) < (min_size = this.connection.minVcsBindSize) ? min_size : cur_len) : stringLength + 1;
                if (this.parameterString == null) {
                    this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterString[this.currentRank][index] = x;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringForClob(int paramIndex, String x) throws SQLException {
        block18: {
            int stringLength;
            block16: {
                block17: {
                    block14: {
                        block15: {
                            try {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                                    OracleLog.recursiveTrace = false;
                                }
                                if (x != null) break block14;
                                this.setNull(paramIndex, 1);
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                                    OracleLog.recursiveTrace = false;
                                }
                                if (!TRACE || OracleLog.recursiveTrace) break block15;
                                OracleLog.recursiveTrace = true;
                            }
                            catch (Throwable throwable) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                    OracleLog.recursiveTrace = false;
                                }
                                throw throwable;
                            }
                            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return;
                    }
                    stringLength = x.length();
                    if (stringLength != 0) break block16;
                    this.setNull(paramIndex, 1);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (stringLength <= this.maxVcsCharsPlsql) {
                    this.setStringInternal(paramIndex, x);
                } else {
                    this.setStringForClobCritical(paramIndex, x);
                }
            } else if (stringLength <= this.maxVcsCharsSql) {
                this.setStringInternal(paramIndex, x);
            } else {
                this.setStringForClobCritical(paramIndex, x);
            }
            if (!TRACE || OracleLog.recursiveTrace) break block18;
            OracleLog.recursiveTrace = true;
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStringForClobCritical(int paramIndex, String x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                tclob.setString(1L, x);
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReaderContentsForClobCritical(int paramIndex, Reader reader, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                OracleClobWriter writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                int bufferSize = tclob.getBufferSize();
                char[] charbuf = new char[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        reader.read(charbuf);
                        writer.write(charbuf);
                    }
                    if (lengthRemaining > 0) {
                        reader.read(charbuf, 0, lengthRemaining);
                        writer.write(charbuf, 0, lengthRemaining);
                    }
                    writer.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamContentsForClobCritical(int paramIndex, InputStream inputStream, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                CLOB tclob = CLOB.createTemporary(this.connection, true, 10, this.currentRowFormOfUse[paramIndex - 1]);
                OracleClobWriter writer = (OracleClobWriter)tclob.setCharacterStream(1L);
                int bufferSize = tclob.getBufferSize();
                byte[] bytebuf = new byte[bufferSize];
                char[] charbuf = new char[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        inputStream.read(bytebuf);
                        DBConversion cfr_ignored_0 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(bytebuf, bufferSize, charbuf);
                        writer.write(charbuf);
                    }
                    if (lengthRemaining > 0) {
                        inputStream.read(bytebuf, 0, lengthRemaining);
                        DBConversion cfr_ignored_1 = this.connection.conversion;
                        DBConversion.asciiBytesToJavaChars(bytebuf, lengthRemaining, charbuf);
                        writer.write(charbuf, 0, lengthRemaining);
                    }
                    writer.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tclob);
                this.setCLOBInternal(paramIndex, tclob);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringForClobAtName(String paramName, String x) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setStringForClob(i2 + 1, x);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHAR(int paramIndex, String x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setFixedCHARInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFixedCHARInternal(int paramIndex, String x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            int stringLength = 0;
            if (x != null) {
                stringLength = x.length();
            }
            if (stringLength > 32766) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 157");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 157);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theFixedCHARNullBinder;
                this.currentRowCharLens[index] = 1;
            } else {
                this.currentRowBinders[index] = this.theFixedCHARBinder;
                this.currentRowCharLens[index] = stringLength + 1;
                if (this.parameterString == null) {
                    this.parameterString = new String[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterString[this.currentRank][index] = x;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(int paramIndex, ResultSet rs) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(rs));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setCursorInternal(paramIndex, rs);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCursorInternal(int paramIndex, ResultSet rs) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(rs));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwUnsupportedFeatureSqlException();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWID(int paramIndex, ROWID rowid) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(rowid));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setROWIDInternal(paramIndex, rowid);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setROWIDInternal(int paramIndex, ROWID rowid) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(rowid));
                OracleLog.recursiveTrace = false;
            }
            if (this.sqlKind == 4) {
                if (rowid == null) {
                    this.setNull(paramIndex, 12);
                } else {
                    this.setStringInternal(paramIndex, rowid.stringValue());
                }
                return;
            }
            int index = paramIndex - 1;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (rowid == null) {
                this.currentRowBinders[index] = this.theRowidNullBinder;
            } else {
                this.currentRowBinders[index] = this.theRowidBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = rowid.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int paramIndex, Array arr) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arr));
                    OracleLog.recursiveTrace = false;
                }
                this.setARRAYInternal(paramIndex, (ARRAY)arr);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setArrayInternal(int paramIndex, Array arr) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arr));
                OracleLog.recursiveTrace = false;
            }
            this.setARRAYInternal(paramIndex, (ARRAY)arr);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setARRAY(int paramIndex, ARRAY arr) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arr));
                    OracleLog.recursiveTrace = false;
                }
                this.setARRAYInternal(paramIndex, arr);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setARRAYInternal(int paramIndex, ARRAY arr) throws SQLException {
        block12: {
            try {
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arr));
                    OracleLog.recursiveTrace = false;
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if (arr == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    break block12;
                }
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.setArrayCritical(index, arr);
                    this.currentRowCharLens[index] = 0;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setArrayCritical(int index, ARRAY arr) throws SQLException {
        try {
            ArrayDescriptor desc;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(arr));
                OracleLog.recursiveTrace = false;
            }
            if ((desc = arr.getDescriptor()) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 61");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 61);
            }
            this.currentRowBinders[index] = this.theNamedTypeBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = arr.toBytes();
            OracleTypeCOLLECTION otype = desc.getOracleTypeCOLLECTION();
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOPAQUE(int paramIndex, OPAQUE opaque) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(opaque));
                    OracleLog.recursiveTrace = false;
                }
                this.setOPAQUEInternal(paramIndex, opaque);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOPAQUEInternal(int paramIndex, OPAQUE opaque) throws SQLException {
        block12: {
            try {
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(opaque));
                    OracleLog.recursiveTrace = false;
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if (opaque == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    break block12;
                }
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.setOPAQUECritical(index, opaque);
                    this.currentRowCharLens[index] = 0;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOPAQUECritical(int index, OPAQUE opaque) throws SQLException {
        try {
            OpaqueDescriptor desc;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(opaque));
                OracleLog.recursiveTrace = false;
            }
            if ((desc = opaque.getDescriptor()) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 61");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 61);
            }
            this.currentRowBinders[index] = this.theNamedTypeBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = opaque.toBytes();
            OracleTypeADT otype = (OracleTypeADT)desc.getPickler();
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    void setSQLXMLInternal(int index, SQLXML sqlxml) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStructDescriptor(int paramIndex, StructDescriptor desc) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(desc));
                    OracleLog.recursiveTrace = false;
                }
                this.setStructDescriptorInternal(paramIndex, desc);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStructDescriptorInternal(int paramIndex, StructDescriptor desc) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (desc == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.setStructDescriptorCritical(index, desc);
                this.currentRowCharLens[index] = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStructDescriptorCritical(int index, StructDescriptor desc) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(desc));
                OracleLog.recursiveTrace = false;
            }
            this.currentRowBinders[index] = this.theNamedTypeBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            OracleTypeADT otype = desc.getOracleTypeADT();
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStructDescriptorAtName(String paramName, StructDescriptor desc) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(desc));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setStructDescriptorInternal(i2 + 1, desc);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPreBindsCompelete() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSTRUCT(int paramIndex, STRUCT struct) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(struct));
                    OracleLog.recursiveTrace = false;
                }
                this.setSTRUCTInternal(paramIndex, struct);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSTRUCTInternal(int paramIndex, STRUCT struct) throws SQLException {
        block12: {
            try {
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(struct));
                    OracleLog.recursiveTrace = false;
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                if (struct == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    break block12;
                }
                PhysicalConnection physicalConnection = this.connection;
                synchronized (physicalConnection) {
                    this.setSTRUCTCritical(index, struct);
                    this.currentRowCharLens[index] = 0;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSTRUCTCritical(int index, STRUCT struct) throws SQLException {
        try {
            StructDescriptor desc;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(struct));
                OracleLog.recursiveTrace = false;
            }
            if ((desc = struct.getDescriptor()) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 61");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 61);
            }
            this.currentRowBinders[index] = this.theNamedTypeBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = struct.toBytes();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: parameterDatum[" + this.currentRank + "][" + index + "] = " + OracleLog.toHex(this.parameterDatum[this.currentRank][index]));
                OracleLog.recursiveTrace = false;
            }
            OracleTypeADT otype = desc.getOracleTypeADT();
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRAW(int paramIndex, RAW raw) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(raw));
                    OracleLog.recursiveTrace = false;
                }
                this.setRAWInternal(paramIndex, raw);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRAWInternal(int paramIndex, RAW raw) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(raw));
                OracleLog.recursiveTrace = false;
            }
            boolean invokeBindBytes = false;
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                int index = paramIndex - 1;
                if (index < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                this.currentRowCharLens[index] = 0;
                if (raw == null) {
                    this.currentRowBinders[index] = this.theRawNullBinder;
                } else {
                    invokeBindBytes = true;
                }
            }
            if (invokeBindBytes) {
                this.setBytesInternal(paramIndex, raw.getBytes());
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHAR(int paramIndex, CHAR ch) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ch));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setCHARInternal(paramIndex, ch);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCHARInternal(int paramIndex, CHAR ch) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ch));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (ch == null || ch.shareBytes().length == 0) {
                this.currentRowBinders[index] = this.theSetCHARNullBinder;
                this.currentRowCharLens[index] = 1;
            } else {
                byte[] b2;
                CharacterSet targetCS;
                short char_cs_id = (short)ch.oracleId();
                this.currentRowBinders[index] = this.theSetCHARBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                CharacterSet characterSet = targetCS = this.currentRowFormOfUse[index] == 2 ? this.connection.setCHARNCharSetObj : this.connection.setCHARCharSetObj;
                if (targetCS != null && targetCS.getOracleId() != char_cs_id) {
                    byte[] cb = ch.shareBytes();
                    b2 = targetCS.convert(ch.getCharacterSet(), cb, 0, cb.length);
                } else {
                    b2 = ch.getBytes();
                }
                this.parameterDatum[this.currentRank][index] = b2;
                this.currentRowCharLens[index] = (b2.length + 1 >> 1) + 1;
            }
            if ((this.sqlKind == 1 || this.sqlKind == 4) && this.currentRowCharLens[index] < this.minVcsBindSize) {
                this.currentRowCharLens[index] = this.minVcsBindSize;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATE(int paramIndex, DATE date) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(date));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setDATEInternal(paramIndex, date);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDATEInternal(int paramIndex, DATE date) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(date));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            if (date == null) {
                this.currentRowBinders[index] = this.theDateNullBinder;
            } else {
                this.currentRowBinders[index] = this.theOracleDateBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = date.getBytes();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBER(int paramIndex, NUMBER num) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(num));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setNUMBERInternal(paramIndex, num);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNUMBERInternal(int paramIndex, NUMBER num) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(num));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            if (num == null) {
                this.currentRowBinders[index] = this.theVarnumNullBinder;
            } else {
                this.currentRowBinders[index] = this.theOracleNumberBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = num.getBytes();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBLOBInternal(paramIndex, lob);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBLOBInternal(int paramIndex, BLOB lob) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            if (lob == null) {
                this.currentRowBinders[index] = this.theBlobNullBinder;
            } else {
                this.currentRowBinders[index] = this.theBlobBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = lob.getBytes();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int paramIndex, Blob lob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBLOBInternal(paramIndex, (BLOB)lob);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlobInternal(int paramIndex, Blob lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            this.setBLOBInternal(paramIndex, (BLOB)lob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setCLOBInternal(paramIndex, lob);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCLOBInternal(int paramIndex, CLOB lob) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            if (lob == null) {
                this.currentRowBinders[index] = this.theClobNullBinder;
            } else {
                this.currentRowBinders[index] = this.theClobBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = lob.getBytes();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int paramIndex, Clob lob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setCLOBInternal(paramIndex, (CLOB)lob);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClobInternal(int paramIndex, Clob lob) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(lob));
                OracleLog.recursiveTrace = false;
            }
            this.setCLOBInternal(paramIndex, (CLOB)lob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILE(int paramIndex, BFILE file) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(file));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBFILEInternal(paramIndex, file);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBFILEInternal(int paramIndex, BFILE file) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(file));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.currentRowCharLens[index] = 0;
            if (file == null) {
                this.currentRowBinders[index] = this.theBfileNullBinder;
            } else {
                this.currentRowBinders[index] = this.theBfileBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = file.getBytes();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfile(int paramIndex, BFILE file) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(file));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setBFILEInternal(paramIndex, file);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBfileInternal(int paramIndex, BFILE file) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(file));
                OracleLog.recursiveTrace = false;
            }
            this.setBFILEInternal(paramIndex, file);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                this.setBytesInternal(paramIndex, x);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBytesInternal(int paramIndex, byte[] x) throws SQLException {
        try {
            int byteLength;
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            int n2 = byteLength = x != null ? x.length : 0;
            if (byteLength == 0) {
                this.setNullInternal(paramIndex, -2);
            } else if (this.sqlKind == 1) {
                if (byteLength > this.maxRawBytesPlsql) {
                    this.setBytesForBlobCritical(paramIndex, x);
                } else {
                    this.basicBindBytes(paramIndex, x);
                }
            } else if (this.sqlKind == 4) {
                if (byteLength > this.maxRawBytesPlsql) {
                    this.setBytesForBlobCritical(paramIndex, x);
                } else {
                    this.basicBindBytes(paramIndex, x);
                }
            } else if (byteLength > this.maxRawBytesSql) {
                this.bindBytesAsStream(paramIndex, x);
            } else {
                this.basicBindBytes(paramIndex, x);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindBytesAsStream(int paramIndex, byte[] x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            int byteLength = x.length;
            byte[] bytebuf = new byte[byteLength];
            System.arraycopy(x, 0, bytebuf, 0, byteLength);
            this.basicBindBinaryStream(paramIndex, new ByteArrayInputStream(bytebuf), byteLength);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindBytes(int paramIndex, byte[] x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                Binder binder;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = binder = this.sqlKind == 1 || this.sqlKind == 4 ? this.thePlsqlRawBinder : this.theRawBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x;
                this.currentRowCharLens[index] = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = this.theLongRawStreamBinder;
                if (this.parameterStream == null) {
                    this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 6, length);
                this.currentRowCharLens[index] = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        block18: {
            int arrayLength;
            block16: {
                block17: {
                    block14: {
                        block15: {
                            try {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                                    OracleLog.recursiveTrace = false;
                                }
                                if (x != null) break block14;
                                this.setNull(paramIndex, -2);
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                                    OracleLog.recursiveTrace = false;
                                }
                                if (!TRACE || OracleLog.recursiveTrace) break block15;
                                OracleLog.recursiveTrace = true;
                            }
                            catch (Throwable throwable) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                    OracleLog.recursiveTrace = false;
                                }
                                throw throwable;
                            }
                            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        return;
                    }
                    arrayLength = x.length;
                    if (arrayLength != 0) break block16;
                    this.setNull(paramIndex, -2);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return;
            }
            if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (arrayLength <= this.maxRawBytesPlsql) {
                    this.setBytes(paramIndex, x);
                } else {
                    this.setBytesForBlobCritical(paramIndex, x);
                }
            } else if (arrayLength <= this.maxRawBytesSql) {
                this.setBytes(paramIndex, x);
            } else {
                this.setBytesForBlobCritical(paramIndex, x);
            }
            if (!TRACE || OracleLog.recursiveTrace) break block18;
            OracleLog.recursiveTrace = true;
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBytesForBlobCritical(int paramIndex, byte[] x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            BLOB tblob = BLOB.createTemporary(this.connection, true, 10);
            tblob.putBytes(1L, x);
            this.addToTempLobsToFree(tblob);
            this.setBLOBInternal(paramIndex, tblob);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamContentsForBlobCritical(int paramIndex, InputStream inputStream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                BLOB tblob = BLOB.createTemporary(this.connection, true, 10);
                OracleBlobOutputStream outputStream = (OracleBlobOutputStream)tblob.setBinaryStream(1L);
                int bufferSize = tblob.getBufferSize();
                byte[] bytebuf = new byte[bufferSize];
                try {
                    int lengthRemaining;
                    for (lengthRemaining = length; lengthRemaining >= bufferSize; lengthRemaining -= bufferSize) {
                        inputStream.read(bytebuf);
                        outputStream.write(bytebuf);
                    }
                    if (lengthRemaining > 0) {
                        inputStream.read(bytebuf, 0, lengthRemaining);
                        outputStream.write(bytebuf, 0, lengthRemaining);
                    }
                    outputStream.flush();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.addToTempLobsToFree(tblob);
                this.setBLOBInternal(paramIndex, tblob);
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesForBlobAtName(String paramName, byte[] x) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setBytesForBlob(i2 + 1, x);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInternalBytes(int paramIndex, byte[] x, int dbtype) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(dbtype));
                    OracleLog.recursiveTrace = false;
                }
                this.setInternalBytesInternal(paramIndex, x, dbtype);
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInternalBytesInternal(int paramIndex, byte[] x, int dbtype) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(dbtype));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwUnsupportedFeatureSqlException();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int paramIndex, Date x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setDateInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDateInternal(int paramIndex, Date x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theDateNullBinder;
            } else {
                this.currentRowBinders[index] = this.theDateBinder;
                if (this.parameterDate == null) {
                    this.parameterDate = new Date[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterDate[this.currentRank][index] = x;
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int paramIndex, Time x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setTimeInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeInternal(int paramIndex, Time x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theDateNullBinder;
            } else {
                this.currentRowBinders[index] = this.theTimeBinder;
                if (this.parameterTime == null) {
                    this.parameterTime = new Time[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterTime[this.currentRank][index] = x;
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setTimestampInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimestampInternal(int paramIndex, Timestamp x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theTimestampNullBinder;
            } else {
                this.currentRowBinders[index] = this.theTimestampBinder;
                if (this.parameterTimestamp == null) {
                    this.parameterTimestamp = new Timestamp[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterTimestamp[this.currentRank][index] = x;
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setINTERVALYMInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setINTERVALYMInternal(int paramIndex, INTERVALYM x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theIntervalYMNullBinder;
            } else {
                this.currentRowBinders[index] = this.theIntervalYMBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setINTERVALDSInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setINTERVALDSInternal(int paramIndex, INTERVALDS x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theIntervalDSNullBinder;
            } else {
                this.currentRowBinders[index] = this.theIntervalDSBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setTIMESTAMPInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTIMESTAMPInternal(int paramIndex, TIMESTAMP x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theTimestampNullBinder;
            } else {
                this.currentRowBinders[index] = this.theOracleTimestampBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setTIMESTAMPTZInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTIMESTAMPTZInternal(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theTSTZNullBinder;
            } else {
                this.currentRowBinders[index] = this.theTSTZBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setTIMESTAMPLTZInternal(paramIndex, x);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTIMESTAMPLTZInternal(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if (this.connection.getSessionTimeZone() == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 105");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 105);
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (x == null) {
                this.currentRowBinders[index] = this.theTSLTZNullBinder;
            } else {
                this.currentRowBinders[index] = this.theTSLTZBinder;
                if (this.parameterDatum == null) {
                    this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
                }
                this.parameterDatum[this.currentRank][index] = x.getBytes();
            }
            this.currentRowCharLens[index] = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setAsciiStreamInternal(paramIndex, istream, length);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.set_execute_batch(1);
            if (istream == null) {
                this.basicBindNullString(paramIndex);
            } else if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 169");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 169);
            } else if (this.currentRowFormOfUse[index] == 1) {
                if (this.sqlKind == 1 || this.sqlKind == 4) {
                    if (length <= this.maxVcsCharsPlsql) {
                        this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
                    } else {
                        this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
                    }
                } else if (length <= this.maxVcsCharsSql) {
                    this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
                } else {
                    this.basicBindAsciiStream(paramIndex, istream, length);
                }
            } else if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (length <= this.maxVcsNCharsPlsql) {
                    this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
                } else {
                    this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
                }
            } else if (length <= this.maxVcsNCharsSql) {
                this.setAsciiStreamContentsForStringInternal(paramIndex, istream, length);
            } else {
                this.setAsciiStreamContentsForClobCritical(paramIndex, istream, length);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                if (this.userRsetType != 1) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 169");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 169);
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = this.theLongStreamBinder;
                if (this.parameterStream == null) {
                    this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 5, length);
                this.currentRowCharLens[index] = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamContentsForStringInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            byte[] bytebuf = new byte[length];
            int actual_length = 0;
            try {
                actual_length = istream.read(bytebuf, 0, length);
                if (actual_length == -1) {
                    actual_length = 0;
                }
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            if (actual_length == 0) {
                this.basicBindNullString(paramIndex);
            }
            char[] charbuf = new char[length];
            DBConversion cfr_ignored_0 = this.connection.conversion;
            DBConversion.asciiBytesToJavaChars(bytebuf, actual_length, charbuf);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                byte[] crap = new byte[length];
                int crud = this.connection.conversion.javaCharsToDbCsBytes(charbuf, 0, crap, 0, length);
                OraclePreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(charbuf)) + OracleLog.bytesToPrintableForm("bytes[]=", crap) + "crud=" + crud);
                crap = this.connection.conversion.asciiBytesToCHARBytes(bytebuf);
                OraclePreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: " + OracleLog.bytesToPrintableForm("in bytes[]=", bytebuf) + OracleLog.bytesToPrintableForm("outbytes[]=", crap) + "dbCS: " + this.connection.conversion.getDbCharSetObj());
                OracleLog.recursiveTrace = false;
            }
            this.basicBindString(paramIndex, new String(charbuf));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setBinaryStreamInternal(paramIndex, istream, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int index;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                }
                this.set_execute_batch(1);
                if (istream == null) {
                    this.setRAWInternal(paramIndex, null);
                } else if (this.userRsetType != 1 && length > this.maxRawBytesSql) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 169");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 169);
                } else if (this.sqlKind == 1 || this.sqlKind == 4) {
                    if (length > this.maxRawBytesPlsql) {
                        this.setBinaryStreamContentsForBlobCritical(paramIndex, istream, length);
                    } else {
                        this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, length);
                    }
                } else if (length > this.maxRawBytesSql) {
                    this.basicBindBinaryStream(paramIndex, istream, length);
                } else {
                    this.setBinaryStreamContentsForByteArrayInternal(paramIndex, istream, length);
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamContentsForByteArrayInternal(int paramIndex, InputStream inputStream, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            byte[] bytebuf = new byte[length];
            int actual_length = 0;
            try {
                actual_length = inputStream.read(bytebuf, 0, length);
                if (actual_length == -1) {
                    actual_length = 0;
                }
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            if (actual_length != length) {
                byte[] newbuf = new byte[actual_length];
                System.arraycopy(bytebuf, 0, newbuf, 0, actual_length);
                bytebuf = newbuf;
            }
            this.setBytesInternal(paramIndex, bytebuf);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int paramIndex, InputStream istream, int length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setUnicodeStreamInternal(paramIndex, istream, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUnicodeStreamInternal(int paramIndex, InputStream istream, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block19: {
                try {
                    int index;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                        OracleLog.recursiveTrace = false;
                    }
                    if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    }
                    this.set_execute_batch(1);
                    if (istream == null) {
                        this.setStringInternal(paramIndex, null);
                        break block19;
                    }
                    if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 169");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 169);
                        break block19;
                    }
                    if (this.sqlKind == 1 || this.sqlKind == 4 || length <= this.maxVcsCharsSql) {
                        byte[] bytebuf = new byte[length];
                        int actual_length = 0;
                        try {
                            actual_length = istream.read(bytebuf, 0, length);
                            if (actual_length == -1) {
                                actual_length = 0;
                            }
                        }
                        catch (IOException e2) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                        }
                        char[] charbuf = new char[actual_length >> 1];
                        DBConversion cfr_ignored_0 = this.connection.conversion;
                        DBConversion.ucs2BytesToJavaChars(bytebuf, actual_length, charbuf);
                        this.setStringInternal(paramIndex, new String(charbuf));
                        break block19;
                    }
                    this.currentRowBinders[index] = this.theLongStreamBinder;
                    if (this.parameterStream == null) {
                        this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                    }
                    this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(istream, 4, length);
                    this.currentRowCharLens[index] = 0;
                }
                finally {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setObjectInternal(paramIndex, this.connection.toDatum(x));
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCustomDatumInternal(int paramIndex, CustomDatum x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                Datum datum = this.connection.toDatum(x);
                int sqlType = this.sqlTypeForObject(datum);
                this.setObjectCritical(paramIndex, datum, sqlType, 0);
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                this.setORADataInternal(paramIndex, x);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setORADataInternal(int paramIndex, ORAData x) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                Datum datum = x.toDatum(this.connection);
                int sqlType = this.sqlTypeForObject(datum);
                this.setObjectCritical(paramIndex, datum, sqlType, 0);
                if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003) {
                    this.currentRowCharLens[paramIndex - 1] = 0;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType) + ", " + OracleLog.argument(scale));
                    OracleLog.recursiveTrace = false;
                }
                this.setObjectInternal(paramIndex, x, targetSqlType, scale);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setObjectInternal(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType) + ", " + OracleLog.argument(scale));
                OracleLog.recursiveTrace = false;
            }
            if (x == null && targetSqlType != 2002 && targetSqlType != 2008 && targetSqlType != 2003 && targetSqlType != 2007 && targetSqlType != 2006) {
                this.setNullInternal(paramIndex, targetSqlType);
            } else if (targetSqlType == 2002 || targetSqlType == 2008 || targetSqlType == 2003) {
                this.setObjectCritical(paramIndex, x, targetSqlType, scale);
                this.currentRowCharLens[paramIndex - 1] = 0;
            } else {
                this.setObjectCritical(paramIndex, x, targetSqlType, scale);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setObjectCritical(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType) + ", " + OracleLog.argument(scale));
                OracleLog.recursiveTrace = false;
            }
            switch (targetSqlType) {
                case 1: {
                    if (x instanceof CHAR) {
                        this.setCHARInternal(paramIndex, (CHAR)x);
                        return;
                    } else if (x instanceof String) {
                        this.setStringInternal(paramIndex, (String)x);
                        return;
                    } else if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        return;
                    } else if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        return;
                    } else if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        return;
                    } else if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        return;
                    } else if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        return;
                    } else if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        return;
                    } else if (x instanceof Date) {
                        this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                        return;
                    } else if (x instanceof Time) {
                        this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 12: {
                    if (x instanceof String) {
                        this.setStringInternal(paramIndex, (String)x);
                        return;
                    } else if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        return;
                    } else if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        return;
                    } else if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        return;
                    } else if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        return;
                    } else if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        return;
                    } else if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        return;
                    } else if (x instanceof Date) {
                        this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                        return;
                    } else if (x instanceof Time) {
                        this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 999: {
                    this.setFixedCHARInternal(paramIndex, (String)x);
                    return;
                }
                case -1: {
                    if (x instanceof String) {
                        this.setStringInternal(paramIndex, (String)x);
                        return;
                    } else if (x instanceof Boolean) {
                        this.setStringInternal(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                        return;
                    } else if (x instanceof Integer) {
                        this.setStringInternal(paramIndex, "" + (Integer)x);
                        return;
                    } else if (x instanceof Long) {
                        this.setStringInternal(paramIndex, "" + (Long)x);
                        return;
                    } else if (x instanceof Float) {
                        this.setStringInternal(paramIndex, "" + ((Float)x).floatValue());
                        return;
                    } else if (x instanceof Double) {
                        this.setStringInternal(paramIndex, "" + (Double)x);
                        return;
                    } else if (x instanceof BigDecimal) {
                        this.setStringInternal(paramIndex, ((BigDecimal)x).toString());
                        return;
                    } else if (x instanceof Date) {
                        this.setStringInternal(paramIndex, "" + ((Date)x).toString());
                        return;
                    } else if (x instanceof Time) {
                        this.setStringInternal(paramIndex, "" + ((Time)x).toString());
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setStringInternal(paramIndex, "" + ((Timestamp)x).toString());
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 2: {
                    if (x instanceof NUMBER) {
                        this.setNUMBERInternal(paramIndex, (NUMBER)x);
                        return;
                    } else if (x instanceof Integer) {
                        this.setIntInternal(paramIndex, (Integer)x);
                        return;
                    } else if (x instanceof Long) {
                        this.setLongInternal(paramIndex, (Long)x);
                        return;
                    } else if (x instanceof Float) {
                        this.setFloatInternal(paramIndex, ((Float)x).floatValue());
                        return;
                    } else if (x instanceof Double) {
                        this.setDoubleInternal(paramIndex, (Double)x);
                        return;
                    } else if (x instanceof BigDecimal) {
                        this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                        return;
                    } else if (x instanceof String) {
                        this.setNUMBERInternal(paramIndex, new NUMBER((String)x, 0));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 3: {
                    if (x instanceof BigDecimal) {
                        this.setBigDecimalInternal(paramIndex, (BigDecimal)x);
                        return;
                    } else if (x instanceof Number) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal(((Number)x).doubleValue()));
                        return;
                    } else if (x instanceof NUMBER) {
                        this.setBigDecimalInternal(paramIndex, ((NUMBER)x).bigDecimalValue());
                        return;
                    } else if (x instanceof String) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setBigDecimalInternal(paramIndex, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case -7: {
                    if (x instanceof Boolean) {
                        this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                        return;
                    } else if (x instanceof String) {
                        this.setByteInternal(paramIndex, (byte)("true".equalsIgnoreCase((String)x) || "1".equals(x) ? 1 : 0));
                        return;
                    } else if (x instanceof Number) {
                        this.setIntInternal(paramIndex, ((Number)x).byteValue() != 0 ? 1 : 0);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case -6: {
                    if (x instanceof Number) {
                        this.setByteInternal(paramIndex, ((Number)x).byteValue());
                        return;
                    } else if (x instanceof String) {
                        this.setByteInternal(paramIndex, Byte.parseByte((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setByteInternal(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 5: {
                    if (x instanceof Number) {
                        this.setShortInternal(paramIndex, ((Number)x).shortValue());
                        return;
                    } else if (x instanceof String) {
                        this.setShortInternal(paramIndex, Short.parseShort((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setShortInternal(paramIndex, (short)((Boolean)x != false ? 1 : 0));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 4: {
                    if (x instanceof Number) {
                        this.setIntInternal(paramIndex, ((Number)x).intValue());
                        return;
                    } else if (x instanceof String) {
                        this.setIntInternal(paramIndex, Integer.parseInt((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setIntInternal(paramIndex, (Boolean)x != false ? 1 : 0);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case -5: {
                    if (x instanceof Number) {
                        this.setLongInternal(paramIndex, ((Number)x).longValue());
                        return;
                    } else if (x instanceof String) {
                        this.setLongInternal(paramIndex, Long.parseLong((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setLongInternal(paramIndex, (Boolean)x != false ? 1L : 0L);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 7: {
                    if (x instanceof Number) {
                        this.setFloatInternal(paramIndex, ((Number)x).floatValue());
                        return;
                    } else if (x instanceof String) {
                        this.setFloatInternal(paramIndex, Float.valueOf((String)x).floatValue());
                        return;
                    } else if (x instanceof Boolean) {
                        this.setFloatInternal(paramIndex, (Boolean)x != false ? 1.0f : 0.0f);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 6: 
                case 8: {
                    if (x instanceof Number) {
                        this.setDoubleInternal(paramIndex, ((Number)x).doubleValue());
                        return;
                    } else if (x instanceof String) {
                        this.setDoubleInternal(paramIndex, Double.valueOf((String)x));
                        return;
                    } else if (x instanceof Boolean) {
                        this.setDoubleInternal(paramIndex, (Boolean)x != false ? 1.0 : 0.0);
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case -2: {
                    if (x instanceof RAW) {
                        this.setRAWInternal(paramIndex, (RAW)x);
                        return;
                    } else {
                        this.setBytesInternal(paramIndex, (byte[])x);
                        return;
                    }
                }
                case -3: {
                    this.setBytesInternal(paramIndex, (byte[])x);
                    return;
                }
                case -4: {
                    this.setBytesInternal(paramIndex, (byte[])x);
                    return;
                }
                case 91: {
                    if (x instanceof DATE) {
                        this.setDATEInternal(paramIndex, (DATE)x);
                        return;
                    } else if (x instanceof Date) {
                        this.setDateInternal(paramIndex, (Date)x);
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setDATEInternal(paramIndex, new DATE((Timestamp)x));
                        return;
                    } else if (x instanceof String) {
                        this.setDateInternal(paramIndex, Date.valueOf((String)x));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 92: {
                    if (x instanceof Time) {
                        this.setTimeInternal(paramIndex, (Time)x);
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setTimeInternal(paramIndex, new Time(((Timestamp)x).getTime()));
                        return;
                    } else if (x instanceof Date) {
                        this.setTimeInternal(paramIndex, new Time(((Date)x).getTime()));
                        return;
                    } else if (x instanceof String) {
                        this.setTimeInternal(paramIndex, Time.valueOf((String)x));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case 93: {
                    if (x instanceof TIMESTAMP) {
                        this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x);
                        return;
                    } else if (x instanceof Timestamp) {
                        this.setTimestampInternal(paramIndex, (Timestamp)x);
                        return;
                    } else if (x instanceof Date) {
                        this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP((Date)x));
                        return;
                    } else if (x instanceof DATE) {
                        this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP(((DATE)x).timestampValue()));
                        return;
                    } else if (x instanceof String) {
                        this.setTimestampInternal(paramIndex, Timestamp.valueOf((String)x));
                        return;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 132");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 132);
                        return;
                    }
                }
                case -100: {
                    this.setTIMESTAMPInternal(paramIndex, (TIMESTAMP)x);
                    return;
                }
                case -101: {
                    this.setTIMESTAMPTZInternal(paramIndex, (TIMESTAMPTZ)x);
                    return;
                }
                case -102: {
                    this.setTIMESTAMPLTZInternal(paramIndex, (TIMESTAMPLTZ)x);
                    return;
                }
                case -103: {
                    this.setINTERVALYMInternal(paramIndex, (INTERVALYM)x);
                    return;
                }
                case -104: {
                    this.setINTERVALDSInternal(paramIndex, (INTERVALDS)x);
                    return;
                }
                case -8: {
                    this.setROWIDInternal(paramIndex, (ROWID)x);
                    return;
                }
                case 100: {
                    this.setBinaryFloatInternal(paramIndex, (BINARY_FLOAT)x);
                    return;
                }
                case 101: {
                    this.setBinaryDoubleInternal(paramIndex, (BINARY_DOUBLE)x);
                    return;
                }
                case 2004: {
                    this.setBLOBInternal(paramIndex, (BLOB)x);
                    return;
                }
                case 2005: {
                    this.setCLOBInternal(paramIndex, (CLOB)x);
                    return;
                }
                case -13: {
                    this.setBFILEInternal(paramIndex, (BFILE)x);
                    return;
                }
                case 2002: 
                case 2008: {
                    this.setSTRUCTInternal(paramIndex, STRUCT.toSTRUCT(x, this.connection));
                    return;
                }
                case 2003: {
                    this.setARRAYInternal(paramIndex, ARRAY.toARRAY(x, this.connection));
                    return;
                }
                case 2007: {
                    this.setOPAQUEInternal(paramIndex, (OPAQUE)x);
                    return;
                }
                case 2006: {
                    this.setREFInternal(paramIndex, (REF)x);
                    return;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    return;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectAtName(String paramName, Object x, int targetSqlType, int scale) throws SQLException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType) + ", " + OracleLog.argument(scale));
                    OracleLog.recursiveTrace = false;
                }
                String iName = paramName.intern();
                String[] names = this.sqlObject.getParameterList();
                boolean nameMatchedAtLeastOnce = false;
                int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                for (int i2 = 0; i2 < count; ++i2) {
                    if (names[i2] != iName) continue;
                    this.setObjectInternal(i2 + 1, x);
                    nameMatchedAtLeastOnce = true;
                }
                if (!nameMatchedAtLeastOnce) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int paramIndex, Object x, int targetSqlType) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType));
                    OracleLog.recursiveTrace = false;
                }
                this.setObjectInternal(paramIndex, x, targetSqlType, 0);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setObjectInternal(int paramIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(targetSqlType));
                OracleLog.recursiveTrace = false;
            }
            this.setObjectInternal(paramIndex, x, targetSqlType, 0);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefType(int paramIndex, REF ref) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                    OracleLog.recursiveTrace = false;
                }
                this.setREFInternal(paramIndex, ref);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRefTypeInternal(int paramIndex, REF ref) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                OracleLog.recursiveTrace = false;
            }
            this.setREFInternal(paramIndex, ref);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int paramIndex, Ref ref) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                    OracleLog.recursiveTrace = false;
                }
                this.setREFInternal(paramIndex, (REF)ref);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRefInternal(int paramIndex, Ref ref) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                OracleLog.recursiveTrace = false;
            }
            this.setREFInternal(paramIndex, (REF)ref);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setREF(int paramIndex, REF ref) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                    OracleLog.recursiveTrace = false;
                }
                this.setREFInternal(paramIndex, ref);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setREFInternal(int paramIndex, REF ref) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(ref));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (ref == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            } else {
                this.setREFCritical(index, ref);
                this.currentRowCharLens[index] = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setREFCritical(int index, REF ref) throws SQLException {
        try {
            StructDescriptor desc;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(index) + ", " + OracleLog.argument(ref));
                OracleLog.recursiveTrace = false;
            }
            if ((desc = ref.getDescriptor()) == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 52");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 52);
            }
            this.currentRowBinders[index] = this.theRefTypeBinder;
            if (this.parameterDatum == null) {
                this.parameterDatum = new byte[this.numberOfBindRowsAllocated][this.numberOfBindPositions][];
            }
            this.parameterDatum[this.currentRank][index] = ref.getBytes();
            OracleTypeADT otype = desc.getOracleTypeADT();
            otype.getTOID();
            if (this.parameterOtype == null) {
                this.parameterOtype = new OracleTypeADT[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterOtype[this.currentRank][index] = otype;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int paramIndex, Object x) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                this.setObjectInternal(paramIndex, x);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setObjectInternal(int paramIndex, Object x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if (x instanceof ORAData) {
                this.setORADataInternal(paramIndex, (ORAData)x);
            } else if (x instanceof CustomDatum) {
                this.setCustomDatumInternal(paramIndex, (CustomDatum)x);
            } else {
                int sqlType = this.sqlTypeForObject(x);
                this.setObjectInternal(paramIndex, x, sqlType, 0);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                    OracleLog.recursiveTrace = false;
                }
                this.setObjectInternal(paramIndex, x);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOracleObjectInternal(int paramIndex, Datum x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            this.setObjectInternal(paramIndex, x);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block7: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arrayData) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(curLen) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemMaxLen));
                        OracleLog.recursiveTrace = false;
                    }
                    this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
                    if (!TRACE || OracleLog.recursiveTrace) break block7;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlsqlIndexTableInternal(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(arrayData) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(curLen) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemMaxLen));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            int elem_internal_type = this.getInternalType(elemSqlType);
            Object[] darray = null;
            switch (elem_internal_type) {
                case 1: 
                case 96: {
                    String[] l_darray = null;
                    int datalen = 0;
                    if (arrayData instanceof CHAR[]) {
                        CHAR[] data = (CHAR[])arrayData;
                        datalen = data.length;
                        l_darray = new String[datalen];
                        for (int i2 = 0; i2 < datalen; ++i2) {
                            CHAR elem = data[i2];
                            if (elem == null) continue;
                            l_darray[i2] = elem.getString();
                        }
                    } else if (arrayData instanceof String[]) {
                        l_darray = (String[])arrayData;
                        datalen = l_darray.length;
                    }
                    if (elemMaxLen == 0 && l_darray != null) {
                        for (int i3 = 0; i3 < datalen; ++i3) {
                            String elem = l_darray[i3];
                            if (elem == null || elemMaxLen >= elem.length()) continue;
                            elemMaxLen = elem.length();
                        }
                    }
                    darray = l_darray;
                    break;
                }
                case 2: 
                case 6: {
                    darray = OracleTypeNUMBER.toNUMBERArray(arrayData, this.connection, 1L, curLen);
                    if (elemMaxLen == 0 && darray != null) {
                        elemMaxLen = 22;
                    }
                    this.currentRowCharLens[index] = 0;
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 97");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 97);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
            }
            this.currentRowBinders[index] = this.thePlsqlIbtBinder;
            if (this.parameterPlsqlIbt == null) {
                this.parameterPlsqlIbt = new PlsqlIbtBindInfo[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterPlsqlIbt[this.currentRank][index] = new PlsqlIbtBindInfo(darray, maxLen, curLen, elem_internal_type, elemMaxLen);
            this.hasIbtBind = true;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlsqlIndexTableAtName(String paramName, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(arrayData) + ", " + OracleLog.argument(maxLen) + ", " + OracleLog.argument(curLen) + ", " + OracleLog.argument(elemSqlType) + ", " + OracleLog.argument(elemMaxLen));
                        OracleLog.recursiveTrace = false;
                    }
                    String iName = paramName.intern();
                    String[] names = this.sqlObject.getParameterList();
                    boolean nameMatchedAtLeastOnce = false;
                    int count = Math.min(this.sqlObject.getParameterCount(), names.length);
                    for (int i2 = 0; i2 < count; ++i2) {
                        if (names[i2] != iName) continue;
                        this.setPlsqlIndexTableInternal(i2 + 1, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
                        nameMatchedAtLeastOnce = true;
                    }
                    if (!nameMatchedAtLeastOnce) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void endOfResultSet(boolean dont_call_prepare_for_new_result) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(dont_call_prepare_for_new_result));
                OracleLog.recursiveTrace = false;
            }
            if (!dont_call_prepare_for_new_result) {
                this.prepareForNewResults(false, false);
            }
            this.rowPrefetchInLastFetch = -1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sqlTypeForObject(Object x) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            if (x == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = 0;
                return n2;
            }
            if (!(x instanceof Datum)) {
                if (x instanceof String) {
                    int __result__;
                    int n3 = __result__ = this.fixedString ? 999 : 12;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    int n4 = __result__;
                    return n4;
                }
                if (x instanceof BigDecimal) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2");
                        OracleLog.recursiveTrace = false;
                    }
                    int n5 = 2;
                    return n5;
                }
                if (x instanceof Boolean) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -7");
                        OracleLog.recursiveTrace = false;
                    }
                    int n6 = -7;
                    return n6;
                }
                if (x instanceof Integer) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    int n7 = 4;
                    return n7;
                }
                if (x instanceof Long) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -5");
                        OracleLog.recursiveTrace = false;
                    }
                    int n8 = -5;
                    return n8;
                }
                if (x instanceof Float) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 7");
                        OracleLog.recursiveTrace = false;
                    }
                    int n9 = 7;
                    return n9;
                }
                if (x instanceof Double) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 8");
                        OracleLog.recursiveTrace = false;
                    }
                    int n10 = 8;
                    return n10;
                }
                if (x instanceof byte[]) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -3");
                        OracleLog.recursiveTrace = false;
                    }
                    int n11 = -3;
                    return n11;
                }
                if (x instanceof Short) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 5");
                        OracleLog.recursiveTrace = false;
                    }
                    int n12 = 5;
                    return n12;
                }
                if (x instanceof Byte) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -6");
                        OracleLog.recursiveTrace = false;
                    }
                    int n13 = -6;
                    return n13;
                }
                if (x instanceof Date) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 91");
                        OracleLog.recursiveTrace = false;
                    }
                    int n14 = 91;
                    return n14;
                }
                if (x instanceof Time) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 92");
                        OracleLog.recursiveTrace = false;
                    }
                    int n15 = 92;
                    return n15;
                }
                if (x instanceof Timestamp) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 93");
                        OracleLog.recursiveTrace = false;
                    }
                    int n16 = 93;
                    return n16;
                }
                if (x instanceof SQLData) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2002");
                        OracleLog.recursiveTrace = false;
                    }
                    int n17 = 2002;
                    return n17;
                }
                if (x instanceof ObjectData) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2002");
                        OracleLog.recursiveTrace = false;
                    }
                    int n18 = 2002;
                    return n18;
                }
            } else {
                if (x instanceof BINARY_FLOAT) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 100");
                        OracleLog.recursiveTrace = false;
                    }
                    int n19 = 100;
                    return n19;
                }
                if (x instanceof BINARY_DOUBLE) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 101");
                        OracleLog.recursiveTrace = false;
                    }
                    int n20 = 101;
                    return n20;
                }
                if (x instanceof BLOB) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2004");
                        OracleLog.recursiveTrace = false;
                    }
                    int n21 = 2004;
                    return n21;
                }
                if (x instanceof CLOB) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2005");
                        OracleLog.recursiveTrace = false;
                    }
                    int n22 = 2005;
                    return n22;
                }
                if (x instanceof BFILE) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -13");
                        OracleLog.recursiveTrace = false;
                    }
                    int n23 = -13;
                    return n23;
                }
                if (x instanceof ROWID) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -8");
                        OracleLog.recursiveTrace = false;
                    }
                    int n24 = -8;
                    return n24;
                }
                if (x instanceof NUMBER) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2");
                        OracleLog.recursiveTrace = false;
                    }
                    int n25 = 2;
                    return n25;
                }
                if (x instanceof DATE) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 91");
                        OracleLog.recursiveTrace = false;
                    }
                    int n26 = 91;
                    return n26;
                }
                if (x instanceof TIMESTAMP) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 93");
                        OracleLog.recursiveTrace = false;
                    }
                    int n27 = 93;
                    return n27;
                }
                if (x instanceof TIMESTAMPTZ) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -101");
                        OracleLog.recursiveTrace = false;
                    }
                    int n28 = -101;
                    return n28;
                }
                if (x instanceof TIMESTAMPLTZ) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -102");
                        OracleLog.recursiveTrace = false;
                    }
                    int n29 = -102;
                    return n29;
                }
                if (x instanceof REF) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2006");
                        OracleLog.recursiveTrace = false;
                    }
                    int n30 = 2006;
                    return n30;
                }
                if (x instanceof CHAR) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n31 = 1;
                    return n31;
                }
                if (x instanceof RAW) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -2");
                        OracleLog.recursiveTrace = false;
                    }
                    int n32 = -2;
                    return n32;
                }
                if (x instanceof ARRAY) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2003");
                        OracleLog.recursiveTrace = false;
                    }
                    int n33 = 2003;
                    return n33;
                }
                if (x instanceof STRUCT) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2002");
                        OracleLog.recursiveTrace = false;
                    }
                    int n34 = 2002;
                    return n34;
                }
                if (x instanceof OPAQUE) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 2007");
                        OracleLog.recursiveTrace = false;
                    }
                    int n35 = 2007;
                    return n35;
                }
                if (x instanceof INTERVALYM) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -103");
                        OracleLog.recursiveTrace = false;
                    }
                    int n36 = -103;
                    return n36;
                }
                if (x instanceof INTERVALDS) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: -104");
                        OracleLog.recursiveTrace = false;
                    }
                    int n37 = -104;
                    return n37;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: 1111");
                OracleLog.recursiveTrace = false;
            }
            int n38 = 1111;
            return n38;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block8: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    this.clearParameters = true;
                    for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                        this.currentRowBinders[i2] = null;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printByteArray(byte[] b2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(b2));
                OracleLog.recursiveTrace = false;
            }
            if (b2 == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_32, "Debug: <Null byte array!>");
                    OracleLog.recursiveTrace = false;
                }
            } else {
                int n2 = b2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int v = b2[i2] & 0xFF;
                    if (v < 16) {
                        if (!TRACE || OracleLog.recursiveTrace) continue;
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.TRACE_32, "Debug: 0" + Integer.toHexString(v) + " ");
                        OracleLog.recursiveTrace = false;
                        continue;
                    }
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_32, "Debug: " + Integer.toHexString(v) + " ");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setCharacterStreamInternal(paramIndex, reader, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCharacterStreamInternal(int paramIndex, Reader reader, int length) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            this.set_execute_batch(1);
            if (reader == null) {
                this.basicBindNullString(paramIndex);
            } else if (this.userRsetType != 1 && length > this.maxVcsCharsSql) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 169");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 169);
            } else if (this.currentRowFormOfUse[index] == 1) {
                if (this.sqlKind == 1 || this.sqlKind == 4) {
                    if (length > this.maxVcsBytesPlsql || length > this.maxVcsCharsPlsql & this.isServerCharSetFixedWidth) {
                        this.setReaderContentsForClobCritical(paramIndex, reader, length);
                    } else if (length <= this.maxVcsCharsPlsql) {
                        this.setReaderContentsForStringInternal(paramIndex, reader, length);
                    } else {
                        this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, length, false);
                    }
                } else if (length <= this.maxVcsCharsSql) {
                    this.setReaderContentsForStringInternal(paramIndex, reader, length);
                } else {
                    this.basicBindCharacterStream(paramIndex, reader, length);
                }
            } else if (this.sqlKind == 1 || this.sqlKind == 4) {
                if (length > this.maxVcsBytesPlsql || length > this.maxVcsNCharsPlsql & this.isServerCharSetFixedWidth) {
                    this.setReaderContentsForClobCritical(paramIndex, reader, length);
                } else if (length <= this.maxVcsNCharsPlsql) {
                    this.setReaderContentsForStringInternal(paramIndex, reader, length);
                } else {
                    this.setReaderContentsForStringOrClobInVariableWidthCase(paramIndex, reader, length, true);
                }
            } else if (length <= this.maxVcsNCharsSql) {
                this.setReaderContentsForStringInternal(paramIndex, reader, length);
            } else {
                this.setReaderContentsForClobCritical(paramIndex, reader, length);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBindCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                int index = paramIndex - 1;
                this.currentRowBinders[index] = this.theLongStreamBinder;
                if (this.parameterStream == null) {
                    this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
                }
                this.parameterStream[this.currentRank][index] = this.connection.conversion.ConvertStream(reader, 7, length, this.currentRowFormOfUse[index]);
                this.currentRowCharLens[index] = 0;
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReaderContentsForStringOrClobInVariableWidthCase(int paramIndex, Reader reader, int length, boolean isNChar) throws SQLException {
        try {
            int bytes_length;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(isNChar));
                OracleLog.recursiveTrace = false;
            }
            char[] charbuf = new char[length];
            int chars_length = 0;
            try {
                chars_length = reader.read(charbuf, 0, length);
                if (chars_length == -1) {
                    chars_length = 0;
                }
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            if (chars_length != length) {
                char[] newbuf = new char[chars_length];
                System.arraycopy(charbuf, 0, newbuf, 0, chars_length);
                charbuf = newbuf;
            }
            if ((bytes_length = this.connection.conversion.encodedByteLength(charbuf, isNChar)) < this.maxVcsBytesPlsql) {
                this.setStringInternal(paramIndex, new String(charbuf));
            } else {
                this.setStringForClobCritical(paramIndex, new String(charbuf));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReaderContentsForStringInternal(int paramIndex, Reader reader, int length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            char[] charbuf = new char[length];
            int actual_length = 0;
            try {
                actual_length = reader.read(charbuf, 0, length);
                if (actual_length == -1) {
                    actual_length = 0;
                }
            }
            catch (IOException e2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
            }
            if (actual_length != length) {
                char[] newbuf = new char[actual_length];
                System.arraycopy(charbuf, 0, newbuf, 0, actual_length);
                charbuf = newbuf;
            }
            this.setStringInternal(paramIndex, new String(charbuf));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int paramIndex, Date x, Calendar cal) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDateInternal(int paramIndex, Date x, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int paramIndex, Time x, Calendar cal) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeInternal(int paramIndex, Time x, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            this.setDATEInternal(paramIndex, x == null ? null : new DATE(x, cal));
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                    OracleLog.recursiveTrace = false;
                }
                this.setTimestampInternal(paramIndex, x, cal);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimestampInternal(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(cal));
                OracleLog.recursiveTrace = false;
            }
            if (x == null) {
                this.setTIMESTAMPInternal(paramIndex, null);
            } else {
                int nanos = x.getNanos();
                byte[] result = nanos == 0 ? new byte[7] : new byte[11];
                if (cal == null) {
                    cal = Calendar.getInstance();
                }
                cal.clear();
                cal.setTime(x);
                int year = cal.get(1);
                if (cal.get(0) == 0) {
                    year = -(year - 1);
                }
                result[0] = (byte)(year / 100 + 100);
                result[1] = (byte)(year % 100 + 100);
                result[2] = (byte)(cal.get(2) + 1);
                result[3] = (byte)cal.get(5);
                result[4] = (byte)(cal.get(11) + 1);
                result[5] = (byte)(cal.get(12) + 1);
                result[6] = (byte)(cal.get(13) + 1);
                if (nanos != 0) {
                    result[7] = (byte)(nanos >> 24);
                    result[8] = (byte)(nanos >> 16 & 0xFF);
                    result[9] = (byte)(nanos >> 8 & 0xFF);
                    result[10] = (byte)(nanos & 0xFF);
                }
                this.setTIMESTAMPInternal(paramIndex, new TIMESTAMP(result));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckBindTypes(boolean flag) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(flag));
                OracleLog.recursiveTrace = false;
            }
            this.checkBindTypes = flag;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOracleBatchStyle() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.m_batchStyle == 2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90operation cannot be mixed with JDBC-2.0-style batching");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with JDBC-2.0-style batching");
            } else if (this.m_batchStyle == 0 && TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_10, "Event: First detected Oracle-style batching");
                OracleLog.recursiveTrace = false;
            }
            this.m_batchStyle = 1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isOracleBatchStyle() {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.m_batchStyle == 1;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setJdbcBatchStyle() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.m_batchStyle == 1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90operation cannot be mixed with Oracle-style batching");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90, "operation cannot be mixed with Oracle-style batching");
            }
            this.m_batchStyle = 2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void checkIfJdbcBatchExists() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.doesJdbcBatchExist()) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 81batch must be either executed or cleared");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesJdbcBatchExist() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.currentRank > 0 && this.m_batchStyle == 2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJdbcBatchStyle() {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.m_batchStyle == 2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        if (this.m_batchStyle == 0) {
                            OraclePreparedStatement.logger().log(OracleLog.TRACE_10, "Event: First detected Jdbc-style batching");
                        }
                        OracleLog.recursiveTrace = false;
                    }
                    this.setJdbcBatchStyle();
                    this.processCompletedBindRow(this.currentRank + 2, this.currentRank > 0 && (this.sqlKind == 1 || this.sqlKind == 4));
                    ++this.currentRank;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block8: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sql));
                        OracleLog.recursiveTrace = false;
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwUnsupportedFeatureSqlException();
                    if (!TRACE || OracleLog.recursiveTrace) break block8;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block10: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    for (int r2 = this.currentRank - 1; r2 >= 0; --r2) {
                        for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                            this.binders[r2][i2] = null;
                        }
                    }
                    this.currentRank = 0;
                    if (this.binders != null) {
                        this.currentRowBinders = this.binders[0];
                    }
                    this.pushedBatches = null;
                    this.pushedBatchesTail = null;
                    this.firstRowInBatch = 0;
                    this.clearParameters = true;
                    if (!TRACE || OracleLog.recursiveTrace) break block10;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int[] nArray;
            block37: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                        OracleLog.recursiveTrace = false;
                    }
                    int[] ret_array = new int[this.currentRank];
                    int i2 = 0;
                    this.cleanOldTempLobs();
                    this.setJdbcBatchStyle();
                    if (this.currentRank > 0) {
                        this.ensureOpen();
                        this.prepareForNewResults(true, true);
                        if (this.sqlKind == 0) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing BatchUpdateException: 800" + null);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwBatchUpdateException(80, 0, null);
                        }
                        this.noMoreUpdateCounts = false;
                        int save_valid_rows = 0;
                        try {
                            this.connection.registerHeartbeat();
                            this.connection.needLine();
                            if (!this.isOpen) {
                                this.connection.open(this);
                                this.isOpen = true;
                            }
                            int saved_current_rank = this.currentRank;
                            if (this.pushedBatches == null) {
                                this.setupBindBuffers(0, this.currentRank);
                                this.executeForRows(false);
                            } else {
                                if (this.currentRank > this.firstRowInBatch) {
                                    this.pushBatch(true);
                                }
                                boolean saved_need_to_parse = this.needToParse;
                                do {
                                    PushedBatch pb = this.pushedBatches;
                                    this.currentBatchCharLens = pb.currentBatchCharLens;
                                    this.lastBoundCharLens = pb.lastBoundCharLens;
                                    this.lastBoundNeeded = pb.lastBoundNeeded;
                                    this.currentBatchBindAccessors = pb.currentBatchBindAccessors;
                                    this.needToParse = pb.need_to_parse;
                                    this.currentBatchNeedToPrepareBinds = pb.current_batch_need_to_prepare_binds;
                                    this.firstRowInBatch = pb.first_row_in_batch;
                                    this.setupBindBuffers(pb.first_row_in_batch, pb.number_of_rows_to_be_bound);
                                    this.currentRank = pb.number_of_rows_to_be_bound;
                                    this.executeForRows(false);
                                    if (this.sqlKind == 1 || this.sqlKind == 4) {
                                        save_valid_rows += this.validRows;
                                        ret_array[i2++] = this.validRows;
                                    }
                                    this.pushedBatches = pb.next;
                                } while (this.pushedBatches != null);
                                this.pushedBatchesTail = null;
                                this.firstRowInBatch = 0;
                                this.needToParse = saved_need_to_parse;
                            }
                            this.slideDownCurrentRow(saved_current_rank);
                        }
                        catch (SQLException e2) {
                            int currentRankBak = this.currentRank;
                            this.clearBatch();
                            this.needToParse = true;
                            if (this.sqlKind != 1 && this.sqlKind != 4) {
                                if (this.numberOfExecutedElementsInBatch != -1 && this.numberOfExecutedElementsInBatch != currentRankBak) {
                                    ret_array = new int[this.numberOfExecutedElementsInBatch];
                                    for (i2 = 0; i2 < this.numberOfExecutedElementsInBatch; ++i2) {
                                        ret_array[i2] = -2;
                                    }
                                } else {
                                    for (i2 = 0; i2 < ret_array.length; ++i2) {
                                        ret_array[i2] = -3;
                                    }
                                }
                            }
                            this.resetCurrentRowBinders();
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing BatchUpdateException: " + e2 + (this.sqlKind == 1 || this.sqlKind == 4 ? i2 : ret_array.length) + ret_array);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwBatchUpdateException(e2, this.sqlKind == 1 || this.sqlKind == 4 ? i2 : ret_array.length, ret_array);
                        }
                        finally {
                            if (this.sqlKind == 1 || this.sqlKind == 4) {
                                this.validRows = save_valid_rows;
                            }
                            this.checkValidRowsStatus();
                            this.currentRank = 0;
                        }
                        if (this.validRows < 0) {
                            for (i2 = 0; i2 < ret_array.length; ++i2) {
                                ret_array[i2] = -3;
                            }
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing BatchUpdateException: 810" + ret_array);
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwBatchUpdateException(81, 0, ret_array);
                        } else if (this.sqlKind != 1 && this.sqlKind != 4) {
                            for (i2 = 0; i2 < ret_array.length; ++i2) {
                                ret_array[i2] = -2;
                            }
                        }
                    }
                    this.connection.registerHeartbeat();
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret_array);
                        OracleLog.recursiveTrace = false;
                    }
                    nArray = ret_array;
                    if (!TRACE || OracleLog.recursiveTrace) break block37;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushBatch(boolean fromExecuteBatch) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(fromExecuteBatch));
                OracleLog.recursiveTrace = false;
            }
            PushedBatch pb = new PushedBatch();
            pb.currentBatchCharLens = new int[this.numberOfBindPositions];
            System.arraycopy(this.currentBatchCharLens, 0, pb.currentBatchCharLens, 0, this.numberOfBindPositions);
            pb.lastBoundCharLens = new int[this.numberOfBindPositions];
            System.arraycopy(this.lastBoundCharLens, 0, pb.lastBoundCharLens, 0, this.numberOfBindPositions);
            if (this.currentBatchBindAccessors != null) {
                pb.currentBatchBindAccessors = new Accessor[this.numberOfBindPositions];
                System.arraycopy(this.currentBatchBindAccessors, 0, pb.currentBatchBindAccessors, 0, this.numberOfBindPositions);
            }
            pb.lastBoundNeeded = this.lastBoundNeeded;
            pb.need_to_parse = this.needToParse;
            pb.current_batch_need_to_prepare_binds = this.currentBatchNeedToPrepareBinds;
            pb.first_row_in_batch = this.firstRowInBatch;
            pb.number_of_rows_to_be_bound = this.currentRank - this.firstRowInBatch;
            if (this.pushedBatches == null) {
                this.pushedBatches = pb;
            } else {
                this.pushedBatchesTail.next = pb;
            }
            this.pushedBatchesTail = pb;
            if (!fromExecuteBatch) {
                int[] tmp = this.currentBatchCharLens;
                this.currentBatchCharLens = this.lastBoundCharLens;
                this.lastBoundCharLens = tmp;
                this.lastBoundNeeded = false;
                for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    this.currentBatchCharLens[i2] = 0;
                }
                this.firstRowInBatch = this.currentRank;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doScrollPstmtExecuteUpdate() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.doScrollExecuteCommon();
            if (this.sqlKind == 0) {
                this.scrollRsetTypeSolved = true;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.validRows);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.validRows;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyBinds(Statement toStmt, int offset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(toStmt) + ", " + OracleLog.argument(offset));
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfBindPositions > 0) {
                OraclePreparedStatement to = (OraclePreparedStatement)toStmt;
                Binder[] binds = this.binders[0];
                int metadata_offset = this.bindIndicatorSubRange + 5;
                int byteoffset = this.bindByteSubRange;
                int charoffset = this.bindCharSubRange;
                int indoffset = this.indicatorsOffset;
                int lenoffset = this.valueLengthsOffset;
                for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    short type = this.bindIndicators[metadata_offset + 0];
                    short bytePitch = this.bindIndicators[metadata_offset + 1];
                    int charPitch = this.bindIndicators[metadata_offset + 2];
                    int toPos = i2 + offset;
                    if (this.bindIndicators[indoffset] == -1) {
                        to.currentRowBinders[toPos] = this.copiedNullBinder(type, bytePitch);
                        if (charPitch > 0) {
                            to.currentRowCharLens[toPos] = 1;
                        }
                    } else if (type == 109 || type == 111) {
                        to.currentRowBinders[toPos] = type == 109 ? this.theNamedTypeBinder : this.theRefTypeBinder;
                        byte[] from = this.parameterDatum[0][i2];
                        int len = from.length;
                        byte[] tob = new byte[len];
                        to.parameterDatum[0][toPos] = tob;
                        System.arraycopy(from, 0, tob, 0, len);
                        to.parameterOtype[0][toPos] = this.parameterOtype[0][i2];
                    } else if (bytePitch > 0) {
                        to.currentRowBinders[toPos] = this.copiedByteBinder(type, this.bindBytes, byteoffset, bytePitch, this.bindIndicators[lenoffset]);
                    } else if (charPitch > 0) {
                        to.currentRowBinders[toPos] = this.copiedCharBinder(type, this.bindChars, charoffset, charPitch, this.bindIndicators[lenoffset]);
                        to.currentRowCharLens[toPos] = charPitch;
                    } else {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OraclePreparedStatement.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: 89copyBinds doesn't understand type " + type);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 89, "copyBinds doesn't understand type " + type);
                    }
                    byteoffset += this.bindBufferCapacity * bytePitch;
                    charoffset += this.bindBufferCapacity * charPitch;
                    indoffset += this.numberOfBindRowsAllocated;
                    lenoffset += this.numberOfBindRowsAllocated;
                    metadata_offset += 10;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.numberOfBindPositions);
                OracleLog.recursiveTrace = false;
            }
            int n2 = this.numberOfBindPositions;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copiedNullBinder(short type, int bytelen) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(bytelen));
                OracleLog.recursiveTrace = false;
            }
            CopiedNullBinder __result__ = new CopiedNullBinder(type, bytelen);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CopiedNullBinder copiedNullBinder = __result__;
            return copiedNullBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copiedByteBinder(short type, byte[] bytes, int offset, int pitch, short len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(pitch) + ", " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            byte[] b2 = new byte[pitch];
            System.arraycopy(bytes, offset, b2, 0, pitch);
            CopiedByteBinder __result__ = new CopiedByteBinder(type, pitch, b2, len);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CopiedByteBinder copiedByteBinder = __result__;
            return copiedByteBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copiedCharBinder(short type, char[] chars, int offset, int pitch, short len) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(pitch) + ", " + OracleLog.argument(len));
                OracleLog.recursiveTrace = false;
            }
            char[] c2 = new char[pitch];
            System.arraycopy(chars, offset, c2, 0, pitch);
            CopiedCharBinder __result__ = new CopiedCharBinder(type, c2, len);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            CopiedCharBinder copiedCharBinder = __result__;
            return copiedCharBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void hardClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            super.hardClose();
            this.bindBytes = null;
            this.bindChars = null;
            this.bindIndicators = null;
            if (!this.connection.isClosed()) {
                this.cleanAllTempLobs();
            }
            this.lastBoundBytes = null;
            this.lastBoundChars = null;
            this.clearParameters();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void alwaysOnClose() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.currentRank > 0) {
                if (this.m_batchStyle == 2) {
                    this.clearBatch();
                } else {
                    int save_valid_rows = this.validRows;
                    this.prematureBatchCount = this.sendBatch();
                    this.validRows = save_valid_rows;
                }
            }
            super.alwaysOnClose();
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisableStmtCaching(boolean cache) {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cache));
                    OracleLog.recursiveTrace = false;
                }
                if (cache) {
                    this.cacheState = 3;
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFormOfUse(int paramIndex, short formOfUse) {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int i2;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(formOfUse));
                    OracleLog.recursiveTrace = false;
                }
                if (this.currentRowFormOfUse[i2 = paramIndex - 1] != formOfUse) {
                    Accessor accessor;
                    this.currentRowFormOfUse[i2] = formOfUse;
                    if (this.currentRowBindAccessors != null && (accessor = this.currentRowBindAccessors[i2]) != null) {
                        accessor.setFormOfUse(formOfUse);
                    }
                    if (this.returnParamAccessors != null && (accessor = this.returnParamAccessors[i2]) != null) {
                        accessor.setFormOfUse(formOfUse);
                    }
                }
            }
            finally {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int paramIndex, URL x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            this.setURLInternal(paramIndex, x);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setURLInternal(int paramIndex, URL x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            this.setStringInternal(paramIndex, x.toString());
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleParameterMetaData __result__ = new OracleParameterMetaData(this.sqlObject.getParameterCount());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleParameterMetaData oracleParameterMetaData = __result__;
            return oracleParameterMetaData;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public oracle.jdbc.OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing Unsupported Feature: ");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwUnsupportedFeatureSqlException();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            oracle.jdbc.OracleParameterMetaData oracleParameterMetaData = null;
            return oracleParameterMetaData;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerReturnParameter(int paramIndex, int externalType) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(externalType));
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfBindPositions <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
            }
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
                if (this.numReturnParams <= 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
                }
            }
            if ((index = paramIndex - 1) < this.numberOfBindPositions - this.numReturnParams || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            int internalType = this.getInternalTypeForDmlReturning(externalType);
            short form = 0;
            if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
                form = this.currentRowFormOfUse[index];
            }
            this.registerReturnParameterInternal(index, internalType, externalType, -1, form, null);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerReturnParameter(int paramIndex, int externalType, int maxSize) throws SQLException {
        try {
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(externalType) + ", " + OracleLog.argument(maxSize));
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfBindPositions <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if (externalType != 1 && externalType != 12 && externalType != -1 && externalType != -2 && externalType != -3 && externalType != -4 && externalType != 12) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            if (maxSize <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            int internalType = this.getInternalTypeForDmlReturning(externalType);
            short form = 0;
            if (this.currentRowFormOfUse != null && this.currentRowFormOfUse[index] != 0) {
                form = this.currentRowFormOfUse[index];
            }
            this.registerReturnParameterInternal(index, internalType, externalType, maxSize, form, null);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerReturnParameter(int paramIndex, int externalType, String typeName) throws SQLException {
        try {
            int internalType;
            int index;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(externalType) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (this.numberOfBindPositions <= 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 90");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 90);
            }
            if ((index = paramIndex - 1) < 0 || paramIndex > this.numberOfBindPositions) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 3");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 3);
            }
            if ((internalType = this.getInternalTypeForDmlReturning(externalType)) != 111 && internalType != 109) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 68");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
            }
            this.registerReturnParameterInternal(index, internalType, externalType, -1, (short)0, typeName);
            this.currentRowBinders[index] = this.theReturnParamBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 9");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 9);
            }
            if (this.returnParamAccessors == null || this.numReturnParams == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 144");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 144);
            }
            if (this.returnResultSet == null) {
                this.returnResultSet = new OracleReturnResultSet(this);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + this.returnResultSet);
                OracleLog.recursiveTrace = false;
            }
            OracleReturnResultSet oracleReturnResultSet = this.returnResultSet;
            return oracleReturnResultSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInternalTypeForDmlReturning(int externalType) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(externalType));
                OracleLog.recursiveTrace = false;
            }
            int result = 0;
            switch (externalType) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    result = 6;
                    break;
                }
                case 100: {
                    result = 100;
                    break;
                }
                case 101: {
                    result = 101;
                    break;
                }
                case -15: 
                case 1: {
                    result = 96;
                    break;
                }
                case -9: 
                case 12: {
                    result = 1;
                    break;
                }
                case -16: 
                case -1: {
                    result = 8;
                    break;
                }
                case 91: 
                case 92: {
                    result = 12;
                    break;
                }
                case 93: {
                    result = 180;
                    break;
                }
                case -101: {
                    result = 181;
                    break;
                }
                case -102: {
                    result = 231;
                    break;
                }
                case -103: {
                    result = 182;
                    break;
                }
                case -104: {
                    result = 183;
                    break;
                }
                case -3: 
                case -2: {
                    result = 23;
                    break;
                }
                case -4: {
                    result = 24;
                    break;
                }
                case -8: {
                    result = 104;
                    break;
                }
                case 2004: {
                    result = 113;
                    break;
                }
                case 2005: 
                case 2011: {
                    result = 112;
                    break;
                }
                case -13: {
                    result = 114;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    result = 109;
                    break;
                }
                case 2006: {
                    result = 111;
                    break;
                }
                case 70: {
                    result = 1;
                    break;
                }
                default: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_20, "Debug: return: " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerReturnParamsForAutoKey() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int[] returnTypes = this.autoKeyInfo.returnTypes;
            short[] formOfUses = this.autoKeyInfo.tableFormOfUses;
            int[] columnIndexes = this.autoKeyInfo.columnIndexes;
            int numberOfReturnParams = returnTypes.length;
            int startPos = this.numberOfBindPositions - numberOfReturnParams;
            for (int i2 = 0; i2 < numberOfReturnParams; ++i2) {
                short form;
                int index = startPos + i2;
                this.currentRowBinders[index] = this.theReturnParamBinder;
                short s2 = form = this.connection.defaultnchar ? (short)2 : 1;
                if (formOfUses != null && columnIndexes != null && formOfUses[columnIndexes[i2] - 1] == 2) {
                    form = 2;
                    this.setFormOfUse(index + 1, form);
                }
                this.checkTypeForAutoKey(returnTypes[i2]);
                String typeName = null;
                if (returnTypes[i2] == 111) {
                    typeName = this.autoKeyInfo.tableTypeNames[columnIndexes[i2] - 1];
                }
                this.registerReturnParameterInternal(index, returnTypes[i2], returnTypes[i2], -1, form, typeName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cleanOldTempLobs() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.m_batchStyle != 1 || this.currentRank == this.batch - 1) {
                super.cleanOldTempLobs();
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    @Override
    void resetOnExceptionDuringExecute() {
        super.resetOnExceptionDuringExecute();
        this.currentRank = 0;
        this.currentBatchNeedToPrepareBinds = true;
    }

    @Override
    void resetCurrentRowBinders() {
        Binder[] lastBoundRow = this.currentRowBinders;
        if (this.binders != null && this.currentRowBinders != null && lastBoundRow != this.binders[0]) {
            this.currentRowBinders = this.binders[0];
            this.binders[this.numberOfBoundRows] = lastBoundRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int paramIndex, InputStream istream) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream));
                    OracleLog.recursiveTrace = false;
                }
                this.setAsciiStreamInternal(paramIndex, istream);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int paramIndex, InputStream istream, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setAsciiStreamInternal(paramIndex, istream, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int paramIndex, InputStream istream) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream));
                    OracleLog.recursiveTrace = false;
                }
                this.setBinaryStreamInternal(paramIndex, istream);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int paramIndex, InputStream istream, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setBinaryStreamInternal(paramIndex, istream, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int paramIndex, InputStream s2) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(s2));
                    OracleLog.recursiveTrace = false;
                }
                this.setBlobInternal(paramIndex, s2);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int paramIndex, InputStream s2, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(s2) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setBlobInternal(paramIndex, s2, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int paramIndex, Reader reader) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                    OracleLog.recursiveTrace = false;
                }
                this.setCharacterStreamInternal(paramIndex, reader);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int paramIndex, Reader reader, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setCharacterStreamInternal(paramIndex, reader, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int paramIndex, Reader reader, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setClobInternal(paramIndex, reader, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int paramIndex, Reader reader) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                    OracleLog.recursiveTrace = false;
                }
                this.setClobInternal(paramIndex, reader);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(int paramIndex, RowId value) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.setRowIdInternal(paramIndex, value);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int paramIndex, Reader reader) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                    OracleLog.recursiveTrace = false;
                }
                this.setNCharacterStreamInternal(paramIndex, reader);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int paramIndex, Reader reader, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setNCharacterStreamInternal(paramIndex, reader, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int paramIndex, NClob value) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.setNClobInternal(paramIndex, value);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int paramIndex, Reader reader, long length) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                    OracleLog.recursiveTrace = false;
                }
                this.setNClobInternal(paramIndex, reader, length);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int paramIndex, Reader reader) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                    OracleLog.recursiveTrace = false;
                }
                this.setNClobInternal(paramIndex, reader);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    @Override
    public void setSQLXML(int paramIndex, SQLXML value) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int paramIndex, String value) throws SQLException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                    OracleLog.recursiveTrace = false;
                }
                this.setNStringInternal(paramIndex, value);
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OraclePreparedStatement.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamInternal(int paramIndex, InputStream istream) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream));
                OracleLog.recursiveTrace = false;
            }
            this.setAsciiStreamInternal(paramIndex, istream, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsciiStreamInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setAsciiStreamInternal(paramIndex, istream, (int)length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamInternal(int paramIndex, InputStream istream) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream));
                OracleLog.recursiveTrace = false;
            }
            this.setBinaryStreamInternal(paramIndex, istream, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBinaryStreamInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setBinaryStreamInternal(paramIndex, istream, (int)length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlobInternal(int paramIndex, InputStream istream, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setBinaryStream(paramIndex, istream, length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlobInternal(int paramIndex, InputStream istream) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(istream));
                OracleLog.recursiveTrace = false;
            }
            this.setBinaryStream(paramIndex, istream);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCharacterStreamInternal(int paramIndex, Reader reader) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                OracleLog.recursiveTrace = false;
            }
            this.setCharacterStreamInternal(paramIndex, reader, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCharacterStreamInternal(int paramIndex, Reader reader, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setCharacterStreamInternal(paramIndex, reader, (int)length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClobInternal(int paramIndex, Reader reader) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                OracleLog.recursiveTrace = false;
            }
            this.setClobInternal(paramIndex, reader, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClobInternal(int paramIndex, Reader reader, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setCharacterStream(paramIndex, reader, length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNCharacterStreamInternal(int paramIndex, Reader reader) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setCharacterStreamInternal(paramIndex, reader, Integer.MAX_VALUE);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNCharacterStreamInternal(int paramIndex, Reader reader, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setCharacterStreamInternal(paramIndex, reader, (int)length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNClobInternal(int paramIndex, NClob value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setClobInternal(paramIndex, value);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNClobInternal(int paramIndex, Reader value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setClobInternal(paramIndex, value);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNClobInternal(int paramIndex, Reader value, long length) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setClobInternal(paramIndex, value, length);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNStringInternal(int paramIndex, String value) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(value));
                OracleLog.recursiveTrace = false;
            }
            this.setFormOfUse(paramIndex, (short)2);
            this.setStringInternal(paramIndex, value);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRowIdInternal(int paramIndex, RowId rowid) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramIndex) + ", " + OracleLog.argument(rowid));
                OracleLog.recursiveTrace = false;
            }
            this.setROWIDInternal(paramIndex, (ROWID)rowid);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArrayAtName(String paramName, Array x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setArray(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimalAtName(String paramName, BigDecimal x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBigDecimal(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobAtName(String paramName, Blob x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBlob(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBooleanAtName(String paramName, boolean x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBoolean(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteAtName(String paramName, byte x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setByte(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesAtName(String paramName, byte[] x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBytes(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClobAtName(String paramName, Clob x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setClob(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDateAtName(String paramName, Date x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setDate(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDateAtName(String paramName, Date x, Calendar y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setDate(i2 + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDoubleAtName(String paramName, double x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setDouble(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloatAtName(String paramName, float x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setFloat(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIntAtName(String paramName, int x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setInt(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLongAtName(String paramName, long x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setLong(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClobAtName(String paramName, NClob x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setNClob(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNStringAtName(String paramName, String x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setNString(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectAtName(String paramName, Object x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setObject(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectAtName(String paramName, Object x, int y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setObject(i2 + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefAtName(String paramName, Ref x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setRef(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowIdAtName(String paramName, RowId x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setRowId(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShortAtName(String paramName, short x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setShort(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXMLAtName(String paramName, SQLXML x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setSQLXML(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringAtName(String paramName, String x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setString(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeAtName(String paramName, Time x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTime(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeAtName(String paramName, Time x, Calendar y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTime(i2 + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestampAtName(String paramName, Timestamp x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTimestamp(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestampAtName(String paramName, Timestamp x, Calendar y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTimestamp(i2 + 1, x, y);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURLAtName(String paramName, URL x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setURL(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setARRAYAtName(String paramName, ARRAY x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setARRAY(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILEAtName(String paramName, BFILE x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBFILE(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfileAtName(String paramName, BFILE x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBfile(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloatAtName(String paramName, float x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBinaryFloat(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloatAtName(String paramName, BINARY_FLOAT x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBinaryFloat(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDoubleAtName(String paramName, double x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBinaryDouble(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDoubleAtName(String paramName, BINARY_DOUBLE x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBinaryDouble(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOBAtName(String paramName, BLOB x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setBLOB(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHARAtName(String paramName, CHAR x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setCHAR(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOBAtName(String paramName, CLOB x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setCLOB(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorAtName(String paramName, ResultSet x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setCursor(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomDatumAtName(String paramName, CustomDatum x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setCustomDatum(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATEAtName(String paramName, DATE x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setDATE(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHARAtName(String paramName, String x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setFixedCHAR(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDSAtName(String paramName, INTERVALDS x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setINTERVALDS(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYMAtName(String paramName, INTERVALYM x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setINTERVALYM(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBERAtName(String paramName, NUMBER x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setNUMBER(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOPAQUEAtName(String paramName, OPAQUE x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setOPAQUE(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOracleObjectAtName(String paramName, Datum x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setOracleObject(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setORADataAtName(String paramName, ORAData x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setORAData(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRAWAtName(String paramName, RAW x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setRAW(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setREFAtName(String paramName, REF x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setREF(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefTypeAtName(String paramName, REF x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setRefType(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWIDAtName(String paramName, ROWID x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setROWID(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSTRUCTAtName(String paramName, STRUCT x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setSTRUCT(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZAtName(String paramName, TIMESTAMPLTZ x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTIMESTAMPLTZ(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZAtName(String paramName, TIMESTAMPTZ x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTIMESTAMPTZ(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPAtName(String paramName, TIMESTAMP x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            boolean nameMatchedAtLeastOnce = false;
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                this.setTIMESTAMP(i2 + 1, x);
                nameMatchedAtLeastOnce = true;
            }
            if (!nameMatchedAtLeastOnce) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobAtName(String paramName, InputStream x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setBlob(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobAtName(String paramName, InputStream x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setBlob(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClobAtName(String paramName, Reader x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setClob(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClobAtName(String paramName, Reader x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setClob(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClobAtName(String paramName, Reader x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setNClob(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClobAtName(String paramName, Reader x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setNClob(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStreamAtName(String paramName, InputStream x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setAsciiStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStreamAtName(String paramName, InputStream x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setBinaryStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStreamAtName(String paramName, Reader x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStreamAtName(String paramName, Reader x, int y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStreamAtName(String paramName, Reader x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setCharacterStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStreamAtName(String paramName, Reader x) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setNCharacterStream(i2 + 1, x);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStreamAtName(String paramName, Reader x, long y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setNCharacterStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStreamAtName(String paramName, InputStream x, int y) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(paramName) + ", " + OracleLog.argument(x) + ", " + OracleLog.argument(y));
                OracleLog.recursiveTrace = false;
            }
            String iName = paramName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (names[i2] != iName) continue;
                if (firstOccurrence) {
                    this.setUnicodeStream(i2 + 1, x, y);
                    firstOccurrence = false;
                    continue;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 135");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 135);
            }
            if (firstOccurrence) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OraclePreparedStatement.logger().log(Level.SEVERE, "Throwing SQLException: 147" + paramName);
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 147, paramName);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OraclePreparedStatement.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OraclePreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PushedBatch {
        int[] currentBatchCharLens;
        int[] lastBoundCharLens;
        Accessor[] currentBatchBindAccessors;
        boolean lastBoundNeeded;
        boolean need_to_parse;
        boolean current_batch_need_to_prepare_binds;
        int first_row_in_batch;
        int number_of_rows_to_be_bound;
        PushedBatch next;

        PushedBatch() {
        }
    }
}

