/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDiagnosabilityMBean;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

public class OracleDriver
implements Driver {
    public static final String oracle_string = "oracle";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String proxy_client_name = "oracle.jdbc.proxyClientName";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String prelim_auth_string = "prelim_auth";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String convert_nchar_literals_string = "oracle.jdbc.convertNcharLiterals";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String set_new_password_string = "OCINewPassword";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    public static final String secret_store_connect = "oracle.security.client.connect_string";
    public static final String secret_store_username = "oracle.security.client.username";
    public static final String secret_store_password = "oracle.security.client.password";
    public static final String secret_store_default_username = "oracle.security.client.default_username";
    public static final String secret_store_default_password = "oracle.security.client.default_password";
    public static final String wallet_location_string = "oracle.net.wallet_location";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties driverAccess;
    protected static Connection defaultConn;
    private static OracleDriver defaultDriver;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    public static void registerMBeans() {
        try {
            MBeanServer mbs = null;
            try {
                Class<?> cls = Class.forName("oracle.as.jmx.framework.PortableMBeanFactory");
                Constructor<?> con = cls.getConstructor(new Class[0]);
                Object factory = con.newInstance(new Object[0]);
                Method mthd = cls.getMethod("getMBeanServer", new Class[0]);
                mbs = (MBeanServer)mthd.invoke(factory, new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Found Oracle Apps MBeanServer but not the getMBeanServer method.", ex);
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            catch (InstantiationException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Found Oracle Apps MBeanServer but could not create an instance.", ex);
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Found Oracle Apps MBeanServer but could not access the getMBeanServer method.", ex);
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Found Oracle Apps MBeanServer but the getMBeanServer method threw an exception.", ex);
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs != null) {
                String loader = Thread.currentThread().getContextClassLoader().toString();
                loader = loader.replaceAll("[,=:\"]+", "");
                ObjectName name = new ObjectName("com.oracle.jdbc:type=diagnosability,name=" + loader);
                mbs.registerMBean(new OracleDiagnosabilityMBean(), name);
            } else {
                Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Unable to find an MBeanServer so no MBears are registered.");
            }
        }
        catch (JMException ex) {
            Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
        }
        catch (Throwable ex) {
            Logger.getLogger("oracle.jdbc").log(Level.SEVERE, "Error while registering Oracle JDBC Diagnosability MBean.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            Driver driverobj;
            int extensionType;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(url) + ", " + OracleLog.argument(info));
                OracleLog.recursiveTrace = false;
            }
            if (url.regionMatches(0, "jdbc:default:connection", 0, 23)) {
                String url1 = "jdbc:oracle:kprb";
                int l2 = url.length();
                url = l2 > 23 ? url1.concat(url.substring(23, url.length())) : url1.concat(":");
                url1 = null;
            }
            if ((extensionType = OracleDriver.oracleDriverExtensionTypeFromURL(url)) == -2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                Connection l2 = null;
                return l2;
            }
            if (extensionType == -3) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(Level.SEVERE, "Throwing SQLException: 67");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 67);
            }
            OracleDriverExtension driverExtension = null;
            driverExtension = this.driverExtensions[extensionType];
            if (driverExtension == null) {
                try {
                    OracleDriver oracleDriver = this;
                    synchronized (oracleDriver) {
                        if (driverExtension == null) {
                            this.driverExtensions[extensionType] = driverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[extensionType]).newInstance();
                        } else {
                            driverExtension = this.driverExtensions[extensionType];
                        }
                    }
                }
                catch (Exception e2) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleDriver.logger().log(OracleLog.INTERNAL_ERROR, "Internal Error: " + e2);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                }
            }
            if (info == null) {
                info = new Properties();
            }
            Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
            while (enumdrivers.hasMoreElements() && !((driverobj = enumdrivers.nextElement()) instanceof OracleDriver)) {
            }
            while (enumdrivers.hasMoreElements()) {
                driverobj = enumdrivers.nextElement();
                if (!(driverobj instanceof OracleDriver)) continue;
                DriverManager.deregisterDriver(driverobj);
            }
            PhysicalConnection conn = (PhysicalConnection)driverExtension.getConnection(url, info);
            conn.protocolId = extensionType;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "return: " + conn);
                OracleLog.recursiveTrace = false;
            }
            PhysicalConnection physicalConnection = conn;
            return physicalConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Connection defaultConnection() throws SQLException {
        try {
            Object object;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (defaultConn == null || defaultConn.isClosed()) {
                object = OracleDriver.class;
                // MONITORENTER : oracle.jdbc.driver.OracleDriver.class
                if (defaultConn == null || defaultConn.isClosed()) {
                    defaultConn = this.connect("jdbc:oracle:kprb:", new Properties());
                }
                // MONITOREXIT : object
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "return: " + defaultConn);
                OracleLog.recursiveTrace = false;
            }
            object = defaultConn;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int oracleDriverExtensionTypeFromURL(String url) {
        try {
            int first_colon;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(url));
                OracleLog.recursiveTrace = false;
            }
            if ((first_colon = url.indexOf(58) + 1) == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: -2");
                    OracleLog.recursiveTrace = false;
                }
                int n2 = -2;
                return n2;
            }
            int second_colon = url.indexOf(58, first_colon);
            if (second_colon == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: -2");
                    OracleLog.recursiveTrace = false;
                }
                int n3 = -2;
                return n3;
            }
            if (!url.regionMatches(true, first_colon, oracle_string, 0, second_colon - first_colon)) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: -2");
                    OracleLog.recursiveTrace = false;
                }
                int n4 = -2;
                return n4;
            }
            int third_colon = url.indexOf(58, ++second_colon);
            String sub_name = null;
            if (third_colon == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: -3");
                    OracleLog.recursiveTrace = false;
                }
                int n5 = -3;
                return n5;
            }
            sub_name = url.substring(second_colon, third_colon);
            if (sub_name.equals("thin")) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                int n6 = 0;
                return n6;
            }
            if (sub_name.equals("oci8") || sub_name.equals("oci")) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.TRACE_16, "return: 2");
                    OracleLog.recursiveTrace = false;
                }
                int n7 = 2;
                return n7;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "return: -3");
                OracleLog.recursiveTrace = false;
            }
            int n8 = -3;
            return n8;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsURL(String url) {
        boolean bl;
        block8: {
            block6: {
                boolean bl2;
                block7: {
                    try {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(url));
                            OracleLog.recursiveTrace = false;
                        }
                        if (!url.startsWith("jdbc:oracle:")) break block6;
                        boolean bl3 = bl2 = OracleDriver.oracleDriverExtensionTypeFromURL(url) > -2;
                        if (!TRACE || OracleLog.recursiveTrace) break block7;
                        OracleLog.recursiveTrace = true;
                    }
                    catch (Throwable throwable) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw throwable;
                    }
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return bl2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            bl = false;
            if (!TRACE || OracleLog.recursiveTrace) break block8;
            OracleLog.recursiveTrace = true;
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray;
        block13: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Class<?> oracleConnectionClass = null;
                try {
                    oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                int offset = 0;
                String[] propertyNames = new String[150];
                String[] propertyValues = new String[150];
                Field[] publicPropertiesFields = oracleConnectionClass.getFields();
                for (int i2 = 0; i2 < publicPropertiesFields.length; ++i2) {
                    if (!publicPropertiesFields[i2].getName().startsWith("CONNECTION_PROPERTY_") || publicPropertiesFields[i2].getName().endsWith("_DEFAULT") || publicPropertiesFields[i2].getName().endsWith("_ACCESSMODE")) continue;
                    try {
                        String propertyName = (String)publicPropertiesFields[i2].get(null);
                        Field propertyDefaultField = oracleConnectionClass.getField(publicPropertiesFields[i2].getName() + "_DEFAULT");
                        String propertyValue = (String)propertyDefaultField.get(null);
                        if (offset == propertyNames.length) {
                            String[] propertyNames2 = new String[propertyNames.length * 2];
                            String[] propertyValues2 = new String[propertyNames.length * 2];
                            System.arraycopy(propertyNames, 0, propertyNames2, 0, propertyNames.length);
                            System.arraycopy(propertyValues, 0, propertyValues2, 0, propertyNames.length);
                            propertyNames = propertyNames2;
                            propertyValues = propertyValues2;
                        }
                        propertyNames[offset] = propertyName;
                        propertyValues[offset] = propertyValue;
                        ++offset;
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        continue;
                    }
                    catch (NoSuchFieldException ex2) {
                        // empty catch block
                    }
                }
                DriverPropertyInfo[] ret = new DriverPropertyInfo[offset];
                for (int i3 = 0; i3 < offset; ++i3) {
                    ret[i3] = new DriverPropertyInfo(propertyNames[i3], propertyValues[i3]);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + ret);
                    OracleLog.recursiveTrace = false;
                }
                driverPropertyInfoArray = ret;
                if (!TRACE || OracleLog.recursiveTrace) break block13;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return driverPropertyInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMajorVersion() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = OracleDatabaseMetaData.getDriverMajorVersionInfo();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMinorVersion() {
        int n2;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                int __result__ = OracleDatabaseMetaData.getDriverMinorVersionInfo();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                n2 = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean jdbcCompliant() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processSqlEscapes(String sqlString) throws SQLException {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(sqlString));
                    OracleLog.recursiveTrace = false;
                }
                OracleSql sql = new OracleSql(null);
                sql.initialize(sqlString);
                String __result__ = sql.parse(sqlString);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                string = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleDriver.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCompileTime() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String string = BUILD_DATE;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(defaultValue));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = PhysicalConnection.getSystemPropertyFastConnectionFailover(defaultValue);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleDriver.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        defaultConn = null;
        defaultDriver = null;
        try {
            if (defaultDriver == null) {
                defaultDriver = new oracle.jdbc.OracleDriver();
                DriverManager.registerDriver(defaultDriver);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    OracleDriver.registerMBeans();
                    return null;
                }
            });
            Timestamp ignore = Timestamp.valueOf("2000-01-01 00:00:00.0");
        }
        catch (SQLException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "SQLException in static block.", ex);
        }
        catch (RuntimeException ex) {
            Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "RuntimeException in static block.", ex);
        }
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleDriver"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

