/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] javaChars;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion) {
        this(conv_object, istream, conversion, 1);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, short formOfUse) {
        super(4096);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(formOfUse));
                OracleLog.recursiveTrace = false;
            }
            this.istream = istream;
            this.conversion = conversion;
            this.converter = conv_object;
            this.maxSize = 0;
            this.totalSize = 0;
            this.numUnconvertedBytes = 0;
            this.endOfStream = false;
            this.nbytes = new int[1];
            this.csform = formOfUse;
            switch (conversion) {
                case 0: {
                    this.javaChars = new char[4096];
                    this.convbuf = new byte[4096];
                    return;
                }
                case 1: {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[2048];
                    return;
                }
                case 2: {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[4096];
                    return;
                }
                case 3: {
                    this.convbuf = new byte[1024];
                    this.javaChars = new char[2048];
                    return;
                }
                case 4: {
                    int size = 4096 / this.converter.getMaxCharbyteSize();
                    this.convbuf = new byte[size * 2];
                    this.javaChars = new char[size];
                    return;
                }
                case 5: {
                    if (this.converter.isUcs2CharSet()) {
                        this.convbuf = new byte[2048];
                        this.javaChars = new char[2048];
                        return;
                    } else {
                        this.convbuf = new byte[4096];
                        this.javaChars = new char[4096];
                        return;
                    }
                }
                case 7: {
                    int size = 4096 / (formOfUse == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                    this.javaChars = new char[size];
                    return;
                }
                default: {
                    this.convbuf = new byte[4096];
                    this.javaChars = new char[4096];
                    return;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        this(conv_object, istream, conversion, 1);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(max_bytesize));
                OracleLog.recursiveTrace = false;
            }
            this.maxSize = max_bytesize;
            this.totalSize = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        this(conv_object, (InputStream)null, conversion, formOfUse);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_charsize) + ", " + OracleLog.argument(formOfUse));
                OracleLog.recursiveTrace = false;
            }
            this.reader = reader;
            this.maxSize = max_charsize;
            this.totalSize = 0;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormOfUse(short csform) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(csform));
                OracleLog.recursiveTrace = false;
            }
            this.csform = csform;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needBytes() throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.closed) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                return bl;
            }
            if (this.pos < this.count) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (this.istream != null) {
                boolean __result__ = this.needBytesFromStream();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = __result__;
                return bl;
            }
            if (this.reader != null) {
                boolean __result__ = this.needBytesFromReader();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = __result__;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean needBytesFromReader() throws IOException {
        int chars_read;
        block16: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int read_size = 0;
            read_size = this.maxSize == 0 ? this.javaChars.length : Math.min(this.maxSize - this.totalSize, this.javaChars.length);
            if (read_size <= 0) {
                this.reader.close();
                this.close();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = false;
                if (!TRACE) return bl;
                if (OracleLog.recursiveTrace) return bl;
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
                return bl;
            }
            chars_read = this.reader.read(this.javaChars, 0, read_size);
            if (chars_read != -1) break block16;
            this.reader.close();
            this.close();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            if (!TRACE) return bl;
            if (OracleLog.recursiveTrace) return bl;
            OracleLog.recursiveTrace = true;
            OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
            return bl;
        }
        try {
            this.totalSize += chars_read;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, this.buf);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.buf);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.buf, 0, chars_read);
                    this.count = chars_read;
                    break;
                }
            }
        }
        catch (SQLException e2) {
            DatabaseError.SQLToIOException(e2);
        }
        this.pos = 0;
        if (!TRACE) return true;
        if (OracleLog.recursiveTrace) return true;
        OracleLog.recursiveTrace = true;
        OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: true");
        OracleLog.recursiveTrace = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needBytesFromStream() throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (!this.endOfStream) {
                int bytes_read;
                block33: {
                    int read_size = 0;
                    read_size = this.maxSize == 0 ? this.convbuf.length : Math.min(this.maxSize - this.totalSize, this.convbuf.length);
                    bytes_read = 0;
                    if (read_size <= 0) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleConversionInputStream.logger().log(Level.SEVERE, "Throwing SQLException: 55");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 55);
                        }
                    } else {
                        bytes_read = this.istream.read(this.convbuf, this.numUnconvertedBytes, read_size - this.numUnconvertedBytes);
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleConversionInputStream.logger().log(OracleLog.TRACE_20, "Debug: " + OracleLog.bytesToPrintableForm("Read " + bytes_read + " bytes into convbuf", this.convbuf, bytes_read));
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    if (bytes_read == -1) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleConversionInputStream.logger().log(Level.SEVERE, "Throwing SQLException: 55");
                                OracleLog.recursiveTrace = false;
                            }
                            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 55);
                        }
                    } else {
                        this.totalSize += (bytes_read += this.numUnconvertedBytes);
                    }
                    if (bytes_read > 0) break block33;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                    switch (this.conversion) {
                        case 0: {
                            this.nbytes[0] = bytes_read;
                            int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                this.convbuf[i2] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.buf);
                            break;
                        }
                        case 1: {
                            this.nbytes[0] = bytes_read;
                            int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i3 = 0; i3 < this.numUnconvertedBytes; ++i3) {
                                this.convbuf[i3] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                            this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.buf);
                            break;
                        }
                        case 2: {
                            int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.buf);
                            break;
                        }
                        case 3: {
                            int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.buf);
                            break;
                        }
                        case 4: {
                            int chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.buf);
                            break;
                        }
                        case 5: {
                            DBConversion.asciiBytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, bytes_read, this.buf);
                            break;
                        }
                        default: {
                            System.arraycopy(this.convbuf, 0, this.buf, 0, bytes_read);
                            this.count = bytes_read;
                            break;
                        }
                    }
                }
                catch (SQLException e2) {
                    DatabaseError.SQLToIOException(e2);
                }
                this.pos = 0;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleConversionInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

