/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobReader
extends Reader {
    CLOB clob;
    DBConversion dbConversion;
    long lobOffset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    long maxPosition = Long.MAX_VALUE;
    boolean isClosed;
    boolean endOfStream;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:31_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobReader(CLOB clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getInternalConnection()).getDefaultStreamChunkSize() / 3);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobReader(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize) + ", " + OracleLog.argument(beginOffset));
                OracleLog.recursiveTrace = false;
            }
            if (clob == null || bufferSize <= 0 || clob.getInternalConnection() == null || beginOffset < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(Level.SEVERE, "Throwing IllegalArgumentException: ");
                    OracleLog.recursiveTrace = false;
                }
                throw new IllegalArgumentException();
            }
            this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
            this.clob = clob;
            this.lobOffset = beginOffset;
            this.markedChar = -1L;
            this.buf = new char[bufferSize];
            this.count = 0;
            this.pos = 0;
            this.chunkSize = bufferSize;
            this.isClosed = false;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset, long length) throws SQLException {
        this(clob, bufferSize, beginOffset);
        this.maxPosition = beginOffset + length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n2;
        block10: {
            block8: {
                int n3;
                block9: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cbuf) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                        OracleLog.recursiveTrace = false;
                    }
                    this.ensureOpen();
                    if (this.needChars()) break block8;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: -1");
                        OracleLog.recursiveTrace = false;
                    }
                    n3 = -1;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return n3;
            }
            try {
                int start = off;
                int end = start + Math.min(len, cbuf.length - off);
                start += this.writeChars(cbuf, start, end - start);
                while (start < end && this.needChars()) {
                    start += this.writeChars(cbuf, start, end - start);
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (start - off));
                    OracleLog.recursiveTrace = false;
                }
                n2 = start - off;
                if (!TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean needChars() throws IOException {
        block18: {
            block14: {
                block17: {
                    block19: {
                        block15: {
                            block16: {
                                if (OracleClobReader.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                    OracleLog.recursiveTrace = false;
                                }
                                this.ensureOpen();
                                if (this.pos < this.count) break block14;
                                if (this.endOfStream) ** GOTO lbl37
                                size = this.chunkSize;
                                if (this.maxPosition - this.lobOffset < (long)this.chunkSize) {
                                    size = (int)(this.maxPosition - this.lobOffset);
                                }
                                this.count = this.clob.getChars(this.lobOffset, size, this.buf);
                                if (this.count < this.chunkSize) {
                                    this.endOfStream = true;
                                }
                                if (this.count <= 0) break block15;
                                this.pos = 0;
                                this.lobOffset += (long)this.count;
                                if (this.lobOffset >= this.maxPosition) {
                                    this.endOfStream = true;
                                }
                                if (OracleClobReader.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                    OracleLog.recursiveTrace = false;
                                }
                                var2_5 = true;
                                if (!OracleClobReader.TRACE || OracleLog.recursiveTrace) break block16;
                                OracleLog.recursiveTrace = true;
                                OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return var2_5;
                        }
                        break block19;
                        {
                            catch (SQLException e) {
                                DatabaseError.SQLToIOException(e);
                            }
                        }
                    }
                    if (OracleClobReader.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                        OracleLog.recursiveTrace = false;
                    }
                    var1_3 = false;
                    if (!OracleClobReader.TRACE || OracleLog.recursiveTrace) break block17;
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var1_3;
            }
            try {
                if (OracleClobReader.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                var1_4 = true;
                if (!OracleClobReader.TRACE || OracleLog.recursiveTrace) break block18;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable var3_6) {
                if (OracleClobReader.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw var3_6;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var1_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeChars(char[] destbuf, int offset, int length) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(destbuf) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                OracleLog.recursiveTrace = false;
            }
            int availableLength = Math.min(length, this.count - this.pos);
            System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
            this.pos += availableLength;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "return: " + availableLength);
                OracleLog.recursiveTrace = false;
            }
            int n2 = availableLength;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + (this.pos < this.count));
                    OracleLog.recursiveTrace = false;
                }
                boolean bl2 = bl = this.pos < this.count;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.isClosed = true;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.isClosed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(Level.SEVERE, "Throwing SQLException: 57" + null);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                }
            }
            catch (SQLException e2) {
                DatabaseError.SQLToIOException(e2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(readAheadLimit));
                    OracleLog.recursiveTrace = false;
                }
                if (readAheadLimit < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(Level.SEVERE, "Throwing IllegalArgumentException: " + DatabaseError.findMessage(195, null));
                        OracleLog.recursiveTrace = false;
                    }
                    throw new IllegalArgumentException(DatabaseError.findMessage(195, null));
                }
                this.markedChar = this.lobOffset - (long)this.count + (long)this.pos;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                if (this.markedChar < 0L) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleClobReader.logger().log(Level.SEVERE, "Throwing IOException: " + DatabaseError.findMessage(195, null));
                        OracleLog.recursiveTrace = false;
                    }
                    throw new IOException(DatabaseError.findMessage(195, null));
                }
                this.lobOffset = this.markedChar;
                this.pos = this.count;
                this.endOfStream = false;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n2) throws IOException {
        long l2;
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(n2));
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                long start = 0L;
                if ((long)(this.count - this.pos) >= n2) {
                    this.pos = (int)((long)this.pos + n2);
                    start += n2;
                } else {
                    start += (long)(this.count - this.pos);
                    this.pos = this.count;
                    try {
                        long remainLen = this.clob.length() - this.lobOffset + 1L;
                        if (remainLen >= n2 - start) {
                            this.lobOffset += n2 - start;
                            start += n2 - start;
                        } else {
                            this.lobOffset += remainLen;
                            start += remainLen;
                        }
                    }
                    catch (SQLException e2) {
                        DatabaseError.SQLToIOException(e2);
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + start);
                    OracleLog.recursiveTrace = false;
                }
                l2 = start;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleClobReader.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                OracleConnection oracleConnection = __result__;
                return oracleConnection;
            }
            catch (Exception exc) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                OracleConnection oracleConnection = null;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return oracleConnection;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleClobReader.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

