/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;
    long maxPosition = Long.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:31_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BLOB blob) throws SQLException {
        this(blob, ((PhysicalConnection)blob.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BLOB blob, int chunkSize) throws SQLException {
        this(blob, chunkSize, 1L);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BLOB blob, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (blob == null || chunkSize <= 0 || beginOffset < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(Level.SEVERE, "Throwing IllegalArgumentException: Illegal Arguments");
                    OracleLog.recursiveTrace = false;
                }
                throw new IllegalArgumentException("Illegal Arguments");
            }
            this.lob = blob;
            this.markedByte = -1L;
            this.lobOffset = beginOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public OracleBlobInputStream(BLOB blob, int chunkSize, long beginOffset, long length) throws SQLException {
        this(blob, chunkSize, beginOffset);
        this.maxPosition = beginOffset + length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BFILE bfile) throws SQLException {
        this(bfile, ((PhysicalConnection)bfile.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BFILE bfile, int chunkSize) throws SQLException {
        this(bfile, chunkSize, 1L);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleBlobInputStream(BFILE bfile, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(beginOffset));
                OracleLog.recursiveTrace = false;
            }
            if (bfile == null || chunkSize <= 0 || beginOffset < 1L) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(Level.SEVERE, "Throwing IllegalArgumentException: Illegal Arguments");
                    OracleLog.recursiveTrace = false;
                }
                throw new IllegalArgumentException("Illegal Arguments");
            }
            this.lob = bfile;
            this.markedByte = -1L;
            this.lobOffset = beginOffset;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean needBytes() throws IOException {
        block17: {
            block13: {
                block16: {
                    block18: {
                        block14: {
                            block15: {
                                if (OracleBlobInputStream.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleBlobInputStream.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                    OracleLog.recursiveTrace = false;
                                }
                                this.ensureOpen();
                                if (this.pos < this.count) break block13;
                                if (this.endOfStream) ** GOTO lbl35
                                size = (long)this.chunkSize < this.maxPosition - this.lobOffset ? this.chunkSize : (int)(this.maxPosition - this.lobOffset);
                                this.count = this.lob instanceof BLOB != false ? ((BLOB)this.lob).getBytes(this.lobOffset, size, this.buf) : ((BFILE)this.lob).getBytes(this.lobOffset, size, this.buf);
                                if (this.count < this.chunkSize) {
                                    this.endOfStream = true;
                                }
                                if (this.count <= 0) break block14;
                                this.pos = 0;
                                this.lobOffset += (long)this.count;
                                if (this.lobOffset > this.maxPosition) {
                                    this.endOfStream = true;
                                }
                                if (OracleBlobInputStream.TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    OracleBlobInputStream.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                    OracleLog.recursiveTrace = false;
                                }
                                var2_5 = true;
                                if (!OracleBlobInputStream.TRACE || OracleLog.recursiveTrace) break block15;
                                OracleLog.recursiveTrace = true;
                                OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return var2_5;
                        }
                        break block18;
                        {
                            catch (SQLException e) {
                                DatabaseError.SQLToIOException(e);
                            }
                        }
                    }
                    if (OracleBlobInputStream.TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleBlobInputStream.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                        OracleLog.recursiveTrace = false;
                    }
                    var1_3 = false;
                    if (!OracleBlobInputStream.TRACE || OracleLog.recursiveTrace) break block16;
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                return var1_3;
            }
            try {
                if (OracleBlobInputStream.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                var1_4 = true;
                if (!OracleBlobInputStream.TRACE || OracleLog.recursiveTrace) break block17;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable var3_6) {
                if (OracleBlobInputStream.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw var3_6;
            }
            OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var1_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleBlobInputStream.logger().log(Level.SEVERE, "Throwing SQLException: 57" + null);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                }
            }
            catch (SQLException e2) {
                DatabaseError.SQLToIOException(e2);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        boolean bl;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                    OracleLog.recursiveTrace = false;
                }
                bl = true;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(readLimit));
                    OracleLog.recursiveTrace = false;
                }
                if (readLimit < 0) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleBlobInputStream.logger().log(Level.SEVERE, "Throwing IllegalArgumentException: Read-ahead limit < 0");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new IllegalArgumentException("Read-ahead limit < 0");
                }
                this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    public void markInternal(int readLimit) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                if (this.markedByte < 0L) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleBlobInputStream.logger().log(Level.SEVERE, "Throwing IOException: Mark invalid or stream not marked.");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new IOException("Mark invalid or stream not marked.");
                }
                this.lobOffset = this.markedByte;
                this.pos = this.count;
                this.endOfStream = false;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n2) throws IOException {
        long l2;
        block11: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(n2));
                    OracleLog.recursiveTrace = false;
                }
                this.ensureOpen();
                long start = 0L;
                if ((long)(this.count - this.pos) >= n2) {
                    this.pos = (int)((long)this.pos + n2);
                    start += n2;
                } else {
                    start += (long)(this.count - this.pos);
                    this.pos = this.count;
                    try {
                        long remainLen = 0L;
                        remainLen = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lobOffset + 1L : ((BFILE)this.lob).length() - this.lobOffset + 1L;
                        if (remainLen >= n2 - start) {
                            this.lobOffset += n2 - start;
                            start += n2 - start;
                        } else {
                            this.lobOffset += remainLen;
                            start += remainLen;
                        }
                    }
                    catch (SQLException e2) {
                        DatabaseError.SQLToIOException(e2);
                    }
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + start);
                    OracleLog.recursiveTrace = false;
                }
                l2 = start;
                if (!TRACE || OracleLog.recursiveTrace) break block11;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleBlobInputStream.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            OracleConnection _conn = null;
            if (this.lob != null) {
                try {
                    _conn = this.lob instanceof BLOB ? ((BLOB)this.lob).getInternalConnection() : ((BFILE)this.lob).getInternalConnection();
                }
                catch (Exception exc) {
                    _conn = null;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "return: " + _conn);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = _conn;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleBlobInputStream.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleBlobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

