/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class NTFManager {
    private Hashtable nsListeners = new Hashtable();
    private Hashtable ntfRegistrations = new Hashtable();
    private byte[] listOfJdbcRegId = new byte[20];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:30_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    NTFManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean listenOnPortT4C(int[] portArr, boolean force) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(portArr) + ", " + OracleLog.argument(force));
                OracleLog.recursiveTrace = false;
            }
            int port = portArr[0];
            boolean ret = false;
            if (this.nsListeners.get(new Integer(port)) == null) {
                ret = true;
                try {
                    ServerSocketChannel ssChannel = ServerSocketChannel.open();
                    ssChannel.configureBlocking(false);
                    ServerSocket serverSocket = ssChannel.socket();
                    while (true) {
                        try {
                            InetSocketAddress isa = new InetSocketAddress(port);
                            serverSocket.bind(isa);
                        }
                        catch (BindException be) {
                            if (!force) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    NTFManager.logger().log(Level.SEVERE, "Throwing SQLException: 250");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 250);
                            }
                            ++port;
                            continue;
                        }
                        catch (IOException iox2) {
                            if (!force) {
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    NTFManager.logger().log(Level.SEVERE, "Throwing SQLException: 250");
                                    OracleLog.recursiveTrace = false;
                                }
                                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 250);
                            }
                            ++port;
                            continue;
                        }
                        break;
                    }
                    NTFListener listener = new NTFListener(this, ssChannel, port);
                    this.nsListeners.put(new Integer(port), listener);
                    listener.start();
                }
                catch (IOException ioe) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        NTFManager.logger().log(Level.SEVERE, "Throwing SQLException: " + ioe);
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), ioe);
                }
            }
            portArr[0] = port;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getNextJdbcRegId() {
        try {
            int off;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            for (off = 1; off < this.listOfJdbcRegId.length && this.listOfJdbcRegId[off] != 0; ++off) {
            }
            if (off == this.listOfJdbcRegId.length - 1) {
                byte[] listOfJdbcRegId2 = new byte[this.listOfJdbcRegId.length * 2];
                System.arraycopy(this.listOfJdbcRegId, 0, listOfJdbcRegId2, 0, this.listOfJdbcRegId.length);
                this.listOfJdbcRegId = listOfJdbcRegId2;
            }
            this.listOfJdbcRegId[off] = 2;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "return: " + off);
                OracleLog.recursiveTrace = false;
            }
            int n2 = off;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addRegistration(NTFRegistration registration) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            Integer key = new Integer(registration.getJdbcRegId());
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            ntfRegistrations2.put(key, registration);
            this.ntfRegistrations = ntfRegistrations2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean removeRegistration(NTFRegistration registration) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(registration));
                OracleLog.recursiveTrace = false;
            }
            Integer key = new Integer(registration.getJdbcRegId());
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            Object obj = ntfRegistrations2.remove(key);
            this.ntfRegistrations = ntfRegistrations2;
            boolean ret = false;
            if (obj != null) {
                ret = true;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeJdbcRegId(int jdbcRegId) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(jdbcRegId));
                OracleLog.recursiveTrace = false;
            }
            if (this.listOfJdbcRegId != null && this.listOfJdbcRegId.length > jdbcRegId) {
                this.listOfJdbcRegId[jdbcRegId] = 0;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanListenersT4C(int tcpport) {
        try {
            NTFListener listener;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(tcpport));
                OracleLog.recursiveTrace = false;
            }
            Enumeration keys = this.ntfRegistrations.keys();
            boolean portUsed = false;
            while (!portUsed && keys.hasMoreElements()) {
                Object localkey = keys.nextElement();
                NTFRegistration reg = (NTFRegistration)this.ntfRegistrations.get(localkey);
                if (reg.getClientTCPPort() != tcpport) continue;
                portUsed = true;
            }
            if (!portUsed && (listener = (NTFListener)this.nsListeners.get(new Integer(tcpport))) != null) {
                listener.closeThisListener();
                listener.interrupt();
                this.nsListeners.remove(new Integer(tcpport));
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFRegistration getRegistration(int jdbcRegId) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(jdbcRegId));
                OracleLog.recursiveTrace = false;
            }
            Integer key = new Integer(jdbcRegId);
            Hashtable localHandle = this.ntfRegistrations;
            Object obj = localHandle.get(key);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "return: " + (NTFRegistration)obj);
                OracleLog.recursiveTrace = false;
            }
            NTFRegistration nTFRegistration = (NTFRegistration)obj;
            return nTFRegistration;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                NTFManager.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

