/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawCommonAccessor;

class LongRawAccessor
extends RawCommonAccessor {
    OracleInputStream stream;
    int columnPosition = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:29_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(column_pos) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 24, 24, form, false);
            this.columnPosition = column_pos;
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(column_pos) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 24, 24, form, false);
            this.columnPosition = column_pos;
            this.initForDescribe(24, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.isStream = true;
            this.isColumnNumberAware = true;
            this.internalTypeMaxLength = Integer.MAX_VALUE;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = 0;
            this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.initForDataAccess, columnPosition=" + this.columnPosition + ", stream= " + this.stream);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    OracleInputStream initForNewRow() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: initForNewRow accessor " + this + ", old stream " + this.stream);
                OracleLog.recursiveTrace = false;
            }
            this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: initForNewRow accessor " + this + ", new stream " + this.stream);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + this.stream);
                OracleLog.recursiveTrace = false;
            }
            OracleInputStream oracleInputStream = this.stream;
            return oracleInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateColumnNumber(int colNumber) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(colNumber));
                OracleLog.recursiveTrace = false;
            }
            this.columnPosition = ++colNumber;
            if (this.stream != null) {
                this.stream.columnIndex = colNumber;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getBytes(" + currentRow + ") " + "accessor = " + this + ", stream = " + this.stream + ", nullIndicator = " + (this.rowSpaceIndicator == null ? "null" : "" + this.rowSpaceIndicator[this.indicatorIndex + currentRow]));
                OracleLog.recursiveTrace = false;
            }
            byte[] result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                if (this.stream == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: stream is null in LongRawAccessor.getBytes accessor = " + this);
                        OracleLog.recursiveTrace = false;
                    }
                } else {
                    if (this.stream.closed) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 27");
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 27);
                    }
                    ByteArrayOutputStream outs = new ByteArrayOutputStream(1024);
                    byte[] buffer = new byte[1024];
                    try {
                        int length;
                        while ((length = this.stream.read(buffer)) != -1) {
                            outs.write(buffer, 0, length);
                        }
                    }
                    catch (IOException e2) {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: " + e2);
                            OracleLog.recursiveTrace = false;
                        }
                        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    }
                    result = outs.toByteArray();
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getBytes(" + currentRow + ") " + "accessor = " + this + " returns " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getAsciiStream(" + currentRow + ") " + "accessor = " + this + ", stream = " + this.stream + ", nullIndicator = " + (this.rowSpaceIndicator == null ? "null" : "" + this.rowSpaceIndicator[this.indicatorIndex + currentRow]));
                OracleLog.recursiveTrace = false;
            }
            InputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1 && this.stream != null) {
                if (this.stream.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 27");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 27);
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.ConvertStream(this.stream, 2);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getAsciiStream(" + currentRow + ") " + "accessor = " + this + " returns " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getUnicodeStream(" + currentRow + ") " + "accessor = " + this + ", stream = " + this.stream + ", nullIndicator = " + (this.rowSpaceIndicator == null ? "null" : "" + this.rowSpaceIndicator[this.indicatorIndex + currentRow]));
                OracleLog.recursiveTrace = false;
            }
            InputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1 && this.stream != null) {
                if (this.stream.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 27");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 27);
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.ConvertStream(this.stream, 3);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getUnicodeStream(" + currentRow + ") " + "accessor = " + this + " returns " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getCharacterStream(" + currentRow + ") " + "accessor = " + this + ", stream = " + this.stream + ", nullIndicator = " + (this.rowSpaceIndicator == null ? "null" : "" + this.rowSpaceIndicator[this.indicatorIndex + currentRow]));
                OracleLog.recursiveTrace = false;
            }
            Reader result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1 && this.stream != null) {
                if (this.stream.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 27");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 27);
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.ConvertCharacterStream(this.stream, 8);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getCharacterStream(" + currentRow + ") " + "accessor = " + this + " returns " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Reader reader = result;
            return reader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getBinaryStream(" + currentRow + ") " + "accessor = " + this + ", stream = " + this.stream + ", nullIndicator = " + (this.rowSpaceIndicator == null ? "null" : "" + this.rowSpaceIndicator[this.indicatorIndex + currentRow]));
                OracleLog.recursiveTrace = false;
            }
            InputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1 && this.stream != null) {
                if (this.stream.closed) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        LongRawAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 27");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 27);
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.ConvertStream(this.stream, 6);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_20, "Debug: LongRawAccessor.getBinaryStream(" + currentRow + ") " + "accessor = " + this + " returns " + result);
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            String __result__ = "LongRawAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                LongRawAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.LongRawAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

