/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValue;

class KeywordValueI
extends KeywordValue {
    int keyword;
    String textValue;
    byte[] binaryValue;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:29_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    KeywordValueI(int _keyword, String _textValue, byte[] _binaryValue) {
        this.keyword = _keyword;
        this.textValue = _textValue;
        this.binaryValue = _binaryValue;
    }

    @Override
    public byte[] getBinaryValue() throws SQLException {
        return this.binaryValue;
    }

    @Override
    public String getTextValue() throws SQLException {
        return this.textValue;
    }

    @Override
    public int getKeyword() throws SQLException {
        return this.keyword;
    }

    void marshal(T4CMAREngine mar) throws SQLException, IOException {
        if (this.textValue != null) {
            byte[] textValueArr = mar.conv.StringToCharBytes(this.textValue);
            mar.marshalUB2(textValueArr.length);
            mar.marshalCLR(textValueArr, textValueArr.length);
            mar.marshalUB2(0);
        } else {
            mar.marshalUB2(0);
            if (this.binaryValue != null) {
                mar.marshalUB2(this.binaryValue.length);
                mar.marshalCLR(this.binaryValue, this.binaryValue.length);
            } else {
                mar.marshalUB2(0);
            }
        }
        mar.marshalUB2(this.keyword);
    }

    static KeywordValueI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int kpdkvbl;
        int[] intArr = new int[1];
        String kpdkvcv = null;
        byte[] kpdkvbv = null;
        int kpdkvcl = mar.unmarshalUB2();
        if (kpdkvcl != 0) {
            byte[] textValueArr = new byte[kpdkvcl];
            mar.unmarshalCLR(textValueArr, 0, intArr);
            kpdkvcv = mar.conv.CharBytesToString(textValueArr, textValueArr.length);
        }
        if ((kpdkvbl = mar.unmarshalUB2()) != 0) {
            kpdkvbv = new byte[kpdkvbl];
            mar.unmarshalCLR(kpdkvbv, 0, intArr);
        }
        int kpdkvk = mar.unmarshalUB2();
        return new KeywordValueI(kpdkvk, kpdkvcv, kpdkvbv);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.KeywordValueI"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

