/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 7;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:28_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 12, 12, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                OracleLog.recursiveTrace = false;
            }
            this.init(stmt, 12, 12, form, false);
            this.initForDescribe(12, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                OracleLog.recursiveTrace = false;
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 7;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getString(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            String result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                int year = ((this.rowSpaceByte[0 + off] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + off] & 0xFF) - 100;
                int hour = 0;
                hour = this.rowSpaceByte[4 + off] - 1;
                result = this.toText(year, this.rowSpaceByte[2 + off], this.rowSpaceByte[3 + off], hour, this.rowSpaceByte[5 + off] - 1, this.rowSpaceByte[6 + off] - 1, 0, hour < 12, "* region name *");
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(hour) + ", " + OracleLog.argument(min) + ", " + OracleLog.argument(sec) + ", " + OracleLog.argument(nanos) + ", " + OracleLog.argument(am) + ", " + OracleLog.argument(zone));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = year + "-" + DateAccessor.toStr(month) + "-" + DateAccessor.toStr(day) + " " + DateAccessor.toStr(hour) + ":" + DateAccessor.toStr(min) + ":" + DateAccessor.toStr(sec) + ".0";
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            Date result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                if (this.externalType == 0) {
                    result = this.statement.connection.mapDateToTimestamp ? this.getTimestamp(currentRow) : this.getDate(currentRow);
                } else {
                    switch (this.externalType) {
                        case 91: {
                            java.sql.Date __result__ = this.getDate(currentRow);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            java.sql.Date date = __result__;
                            return date;
                        }
                        case 92: {
                            Time __result__ = this.getTime(currentRow);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            Time time = __result__;
                            return time;
                        }
                        case 93: {
                            Timestamp __result__ = this.getTimestamp(currentRow);
                            if (TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                                OracleLog.recursiveTrace = false;
                            }
                            Timestamp timestamp = __result__;
                            return timestamp;
                        }
                    }
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DateAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 4);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + null);
                        OracleLog.recursiveTrace = false;
                    }
                    Object var3_6 = null;
                    return var3_6;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            DATE __result__ = this.getDATE(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            DATE dATE = __result__;
            return dATE;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            Object __result__ = this.getObject(currentRow);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            Object object = __result__;
            return object;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(currentRow));
                OracleLog.recursiveTrace = false;
            }
            if (this.externalType != 91) {
                TIMESTAMP __result__ = super.getTIMESTAMP(currentRow);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                TIMESTAMP tIMESTAMP = __result__;
                return tIMESTAMP;
            }
            TIMESTAMP result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DateAccessor.logger().log(Level.SEVERE, "Throwing SQLException: 21");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = new TIMESTAMP(data);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "return: " + result);
                OracleLog.recursiveTrace = false;
            }
            TIMESTAMP tIMESTAMP = result;
            return tIMESTAMP;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String toStr(int x) {
        try {
            String __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(x));
                OracleLog.recursiveTrace = false;
            }
            String string = __result__ = x < 10 ? "0" + x : Integer.toString(x);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_30, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string2 = __result__;
            return string2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DateAccessor.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DateAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

