/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterSetMetaData;

public class DBConversion {
    public static final boolean DO_CONVERSION_WITH_REPLACEMENT = true;
    public static final short ORACLE8_PROD_VERSION = 8030;
    protected short serverNCharSetId;
    protected short serverCharSetId;
    protected short clientCharSetId;
    protected CharacterSet serverCharSet;
    protected CharacterSet serverNCharSet;
    protected CharacterSet clientCharSet;
    protected CharacterSet asciiCharSet;
    protected boolean isServerCharSetFixedWidth;
    protected boolean isServerNCharSetFixedWidth;
    protected int c2sNlsRatio;
    protected int s2cNlsRatio;
    protected int sMaxCharSize;
    protected int cMaxCharSize;
    protected int maxNCharSize;
    protected boolean isServerCSMultiByte;
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short AL16UTF16_CHARSET = 2000;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:28_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConversion(short svrCharSet, short drvrCharSet, short svrNCharSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(svrCharSet) + ", " + OracleLog.argument(drvrCharSet) + ", " + OracleLog.argument(svrNCharSet));
                OracleLog.recursiveTrace = false;
            }
            if (drvrCharSet != -1) {
                this.init(svrCharSet, drvrCharSet, svrNCharSet);
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(short svrCharSet, short drvrCharSet, short svrNCharSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(svrCharSet) + ", " + OracleLog.argument(drvrCharSet) + ", " + OracleLog.argument(svrNCharSet));
                OracleLog.recursiveTrace = false;
            }
            switch (drvrCharSet) {
                case -5: 
                case 1: 
                case 2: 
                case 31: 
                case 178: 
                case 870: 
                case 871: 
                case 873: {
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(drvrCharSet);
                }
            }
            this.serverCharSetId = svrCharSet;
            this.clientCharSetId = drvrCharSet;
            this.serverCharSet = CharacterSet.make(this.serverCharSetId);
            this.serverNCharSetId = svrNCharSet;
            this.serverNCharSet = CharacterSet.make(this.serverNCharSetId);
            this.clientCharSet = CharacterSet.make(this.clientCharSetId);
            this.c2sNlsRatio = CharacterSetMetaData.getRatio(svrCharSet, drvrCharSet);
            this.s2cNlsRatio = CharacterSetMetaData.getRatio(drvrCharSet, svrCharSet);
            this.sMaxCharSize = CharacterSetMetaData.getRatio(svrCharSet, 1);
            this.cMaxCharSize = CharacterSetMetaData.getRatio(drvrCharSet, 1);
            this.maxNCharSize = CharacterSetMetaData.getRatio(svrNCharSet, 1);
            this.findFixedWidthInfo();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_20, "Debug: DBConversion.c2sNlsRatio=" + this.c2sNlsRatio + "DBConversion.s2cNlsRatio=" + this.s2cNlsRatio);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findFixedWidthInfo() throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            this.isServerCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverCharSetId);
            this.isServerNCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverNCharSetId);
            this.isServerCSMultiByte = this.sMaxCharSize > 1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getServerCharSetId() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.serverCharSetId);
                OracleLog.recursiveTrace = false;
            }
            short s2 = this.serverCharSetId;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getNCharSetId() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.serverNCharSetId);
                OracleLog.recursiveTrace = false;
            }
            short s2 = this.serverNCharSetId;
            return s2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsNCharFixedWith() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + (this.serverNCharSetId == 2000));
                OracleLog.recursiveTrace = false;
            }
            boolean bl = this.serverNCharSetId == 2000;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getClientCharSet() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.clientCharSetId == -1) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.serverCharSetId);
                    OracleLog.recursiveTrace = false;
                }
                short s2 = this.serverCharSetId;
                return s2;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.clientCharSetId);
                OracleLog.recursiveTrace = false;
            }
            short s3 = this.clientCharSetId;
            return s3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterSet getDbCharSetObj() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.serverCharSet);
                OracleLog.recursiveTrace = false;
            }
            CharacterSet characterSet = this.serverCharSet;
            return characterSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterSet getDriverCharSetObj() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.clientCharSet);
                OracleLog.recursiveTrace = false;
            }
            CharacterSet characterSet = this.clientCharSet;
            return characterSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharacterSet getDriverNCharSetObj() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + this.serverNCharSet);
                OracleLog.recursiveTrace = false;
            }
            CharacterSet characterSet = this.serverNCharSet;
            return characterSet;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final short findDriverCharSet(short svrCharSet, short oraVersion) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(svrCharSet) + ", " + OracleLog.argument(oraVersion));
                OracleLog.recursiveTrace = false;
            }
            short driver_charset = 0;
            switch (svrCharSet) {
                case 1: 
                case 2: 
                case 31: 
                case 178: 
                case 873: {
                    driver_charset = svrCharSet;
                    break;
                }
                default: {
                    short s2 = driver_charset = oraVersion >= 8030 ? (short)871 : 870;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + driver_charset);
                OracleLog.recursiveTrace = false;
            }
            short s3 = driver_charset;
            return s3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToDriverCharBytes(String str, short charset) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(str) + ", " + OracleLog.argument(charset));
                OracleLog.recursiveTrace = false;
            }
            if (str == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] ret_bytes = null;
            switch (charset) {
                case -5: 
                case 2000: {
                    ret_bytes = CharacterSet.stringToAL16UTF16Bytes(str);
                    break;
                }
                case 1: 
                case 2: {
                    ret_bytes = CharacterSet.stringToASCII(str);
                    break;
                }
                case 870: 
                case 871: {
                    ret_bytes = CharacterSet.stringToUTF(str);
                    break;
                }
                case 873: {
                    ret_bytes = CharacterSet.stringToAL32UTF8(str);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(charset);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ret_bytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = ret_bytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] StringToCharBytes(String str) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(str));
                OracleLog.recursiveTrace = false;
            }
            if (str.length() == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                byte[] byArray = null;
                return byArray;
            }
            switch (this.clientCharSetId) {
                case -1: {
                    byte[] __result__ = this.serverCharSet.convertWithReplacement(str);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    byte[] byArray = __result__;
                    return byArray;
                }
                case 31: 
                case 178: {
                    byte[] __result__ = this.clientCharSet.convertWithReplacement(str);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    byte[] byArray = __result__;
                    return byArray;
                }
            }
            byte[] __result__ = DBConversion.stringToDriverCharBytes(str, this.clientCharSetId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String CharBytesToString(byte[] bytes, int nbytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes));
                OracleLog.recursiveTrace = false;
            }
            String __result__ = this.CharBytesToString(bytes, nbytes, true);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String CharBytesToString(byte[] bytes, int nbytes, boolean useReplacementChar) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(useReplacementChar));
                OracleLog.recursiveTrace = false;
            }
            String ret_str = null;
            if (bytes.length == 0) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ret_str);
                    OracleLog.recursiveTrace = false;
                }
                String string = ret_str;
                return string;
            }
            switch (this.clientCharSetId) {
                case -5: {
                    ret_str = CharacterSet.AL16UTF16BytesToString(bytes, nbytes);
                    break;
                }
                case 1: 
                case 2: {
                    ret_str = new String(bytes, 0, 0, nbytes);
                    break;
                }
                case 31: 
                case 178: {
                    if (useReplacementChar) {
                        ret_str = this.clientCharSet.toStringWithReplacement(bytes, 0, nbytes);
                        break;
                    }
                    ret_str = this.clientCharSet.toString(bytes, 0, nbytes);
                    break;
                }
                case 870: 
                case 871: {
                    ret_str = CharacterSet.UTFToString(bytes, 0, nbytes, useReplacementChar);
                    break;
                }
                case 873: {
                    ret_str = CharacterSet.AL32UTF8ToString(bytes, 0, nbytes, useReplacementChar);
                    break;
                }
                case -1: {
                    ret_str = this.serverCharSet.toStringWithReplacement(bytes, 0, nbytes);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.clientCharSetId);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ret_str);
                OracleLog.recursiveTrace = false;
            }
            String string = ret_str;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String NCharBytesToString(byte[] bytes, int nbytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes));
                OracleLog.recursiveTrace = false;
            }
            String ret_str = null;
            if (this.clientCharSetId == -1) {
                ret_str = this.serverNCharSet.toStringWithReplacement(bytes, 0, nbytes);
            } else {
                switch (this.serverNCharSetId) {
                    case -5: 
                    case 2000: {
                        ret_str = CharacterSet.AL16UTF16BytesToString(bytes, nbytes);
                        break;
                    }
                    case 1: 
                    case 2: {
                        ret_str = new String(bytes, 0, 0, nbytes);
                        break;
                    }
                    case 31: 
                    case 178: {
                        ret_str = this.serverNCharSet.toStringWithReplacement(bytes, 0, nbytes);
                        break;
                    }
                    case 870: 
                    case 871: {
                        ret_str = CharacterSet.UTFToString(bytes, 0, nbytes);
                        break;
                    }
                    case 873: {
                        ret_str = CharacterSet.AL32UTF8ToString(bytes, 0, nbytes);
                        break;
                    }
                    case -1: {
                        ret_str = this.serverCharSet.toStringWithReplacement(bytes, 0, nbytes);
                        break;
                    }
                    default: {
                        DBConversion.unexpectedCharset(this.clientCharSetId);
                    }
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ret_str);
                OracleLog.recursiveTrace = false;
            }
            String string = ret_str;
            return string;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.javaCharsToCHARBytes(chars, nchars, bytes, this.clientCharSetId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToCHARBytes(char[] chars, int charOffset, byte[] bytes, int byteOffset, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.javaCharsToCHARBytes(chars, charOffset, bytes, byteOffset, this.clientCharSetId, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.javaCharsToCHARBytes(chars, nchars, bytes, this.serverNCharSetId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToNCHARBytes(char[] chars, int charOffset, byte[] bytes, int byteOffset, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.javaCharsToCHARBytes(chars, charOffset, bytes, byteOffset, this.serverNCharSetId, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes, short cs) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(cs));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this.javaCharsToCHARBytes(chars, 0, bytes, 0, cs, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int javaCharsToCHARBytes(char[] chars, int charOffset, byte[] bytes, int byteOffset, short cs, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(cs) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            int ret = 0;
            switch (cs) {
                case -5: 
                case 2000: {
                    ret = CharacterSet.convertJavaCharsToAL16UTF16Bytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                case 2: 
                case 178: {
                    byte[] tempBytes = new byte[nchars];
                    tempBytes = this.clientCharSet.convertWithReplacement(new String(chars, charOffset, nchars));
                    System.arraycopy(tempBytes, 0, bytes, 0, tempBytes.length);
                    ret = tempBytes.length;
                    break;
                }
                case 1: {
                    ret = CharacterSet.convertJavaCharsToASCIIBytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                case 31: {
                    ret = CharacterSet.convertJavaCharsToISOLATIN1Bytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                case 870: 
                case 871: {
                    ret = CharacterSet.convertJavaCharsToUTFBytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                case 873: {
                    ret = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                case -1: {
                    ret = this.javaCharsToDbCsBytes(chars, charOffset, bytes, byteOffset, nchars);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.clientCharSetId);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ret);
                OracleLog.recursiveTrace = false;
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int CHARBytesToJavaChars(byte[] bytes, int byteOffset, char[] chars, int charOffset, int[] nbytes, int charSize) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(charSize));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = DBConversion._CHARBytesToJavaChars(bytes, byteOffset, chars, charOffset, this.clientCharSetId, nbytes, charSize, this.serverCharSet, this.serverNCharSet, this.clientCharSet, false);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int NCHARBytesToJavaChars(byte[] bytes, int byteOffset, char[] chars, int charOffset, int[] nbytes, int charSize) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(charSize));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = DBConversion._CHARBytesToJavaChars(bytes, byteOffset, chars, charOffset, this.serverNCharSetId, nbytes, charSize, this.serverCharSet, this.serverNCharSet, this.clientCharSet, true);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int _CHARBytesToJavaChars(byte[] bytes, int byteOffset, char[] chars, int charOffset, short cs, int[] nbytes, int charSize, CharacterSet _m_databaseCs, CharacterSet _m_databaseNCs, CharacterSet _m_driverCs, boolean isNCharData) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(cs) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(charSize) + ", " + OracleLog.argument(_m_databaseCs) + ", " + OracleLog.argument(_m_databaseNCs) + ", " + OracleLog.argument(_m_driverCs) + ", " + OracleLog.argument(isNCharData));
                OracleLog.recursiveTrace = false;
            }
            int count = 0;
            int nbBytes = 0;
            switch (cs) {
                case -5: 
                case 2000: {
                    nbBytes = nbytes[0] - nbytes[0] % 2;
                    if (charSize > chars.length - charOffset) {
                        charSize = chars.length - charOffset;
                    }
                    if (charSize * 2 < nbBytes) {
                        nbBytes = charSize * 2;
                    }
                    count = CharacterSet.convertAL16UTF16BytesToJavaChars(bytes, byteOffset, chars, charOffset, nbBytes, true);
                    nbytes[0] = nbytes[0] - nbBytes;
                    break;
                }
                case 1: 
                case 2: {
                    nbBytes = nbytes[0];
                    if (charSize > chars.length - charOffset) {
                        charSize = chars.length - charOffset;
                    }
                    if (charSize < nbBytes) {
                        nbBytes = charSize;
                    }
                    count = CharacterSet.convertASCIIBytesToJavaChars(bytes, byteOffset, chars, charOffset, nbBytes);
                    nbytes[0] = nbytes[0] - nbBytes;
                    break;
                }
                case 31: 
                case 178: {
                    nbBytes = nbytes[0];
                    count = _m_databaseCs.toCharWithReplacement(bytes, 0, chars, charOffset, nbBytes);
                    nbytes[0] = nbytes[0] - count;
                    break;
                }
                case 870: 
                case 871: {
                    if (charSize > chars.length - charOffset) {
                        charSize = chars.length - charOffset;
                    }
                    count = CharacterSet.convertUTFBytesToJavaChars(bytes, byteOffset, chars, charOffset, nbytes, true, charSize);
                    break;
                }
                case 873: {
                    if (charSize > chars.length - charOffset) {
                        charSize = chars.length - charOffset;
                    }
                    count = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, byteOffset, chars, charOffset, nbytes, true, charSize);
                    break;
                }
                case -1: {
                    DBConversion.unexpectedCharset((short)-1);
                    break;
                }
                default: {
                    String converted;
                    char[] convertedChars;
                    int nbCharsToCopy;
                    CharacterSet chSet = _m_driverCs;
                    if (isNCharData) {
                        chSet = _m_databaseNCs;
                    }
                    if ((nbCharsToCopy = (convertedChars = (converted = chSet.toString(bytes, byteOffset, nbytes[0])).toCharArray()).length) > charSize) {
                        nbCharsToCopy = charSize;
                    }
                    System.arraycopy(convertedChars, 0, chars, charOffset, nbCharsToCopy);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + count);
                OracleLog.recursiveTrace = false;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asciiBytesToCHARBytes(byte[] bytes) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            byte[] retbytes = null;
            switch (this.clientCharSetId) {
                case -5: {
                    retbytes = new byte[bytes.length * 2];
                    int retbyte_i = 0;
                    for (int i2 = 0; i2 < bytes.length; ++i2) {
                        retbytes[retbyte_i++] = 0;
                        retbytes[retbyte_i++] = bytes[i2];
                    }
                    break;
                }
                case -1: {
                    if (this.asciiCharSet == null) {
                        this.asciiCharSet = CharacterSet.make(1);
                    }
                    try {
                        retbytes = this.serverCharSet.convert(this.asciiCharSet, bytes, 0, bytes.length);
                    }
                    catch (SQLException e2) {}
                    break;
                }
                default: {
                    retbytes = bytes;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + retbytes);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = retbytes;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToDbCsBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            int num_conv_bytes = this.javaCharsToDbCsBytes(chars, 0, bytes, 0, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + num_conv_bytes);
                OracleLog.recursiveTrace = false;
            }
            int n2 = num_conv_bytes;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int javaCharsToDbCsBytes(char[] chars, int charOffset, byte[] bytes, int byteOffset, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            int num_conv_bytes = 0;
            DBConversion.catchCharsLen(chars, charOffset, nchars);
            String str = new String(chars, charOffset, nchars);
            byte[] dbcs_bytes = this.serverCharSet.convertWithReplacement(str);
            str = null;
            if (dbcs_bytes != null) {
                num_conv_bytes = dbcs_bytes.length;
                DBConversion.catchBytesLen(bytes, byteOffset, num_conv_bytes);
                System.arraycopy(dbcs_bytes, 0, bytes, byteOffset, num_conv_bytes);
                dbcs_bytes = null;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + num_conv_bytes);
                OracleLog.recursiveTrace = false;
            }
            int n2 = num_conv_bytes;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int javaCharsToUcs2Bytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            int byte_i = DBConversion.javaCharsToUcs2Bytes(chars, 0, bytes, 0, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + byte_i);
                OracleLog.recursiveTrace = false;
            }
            int n2 = byte_i;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int javaCharsToUcs2Bytes(char[] chars, int charOffset, byte[] bytes, int byteOffset, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(charOffset) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(byteOffset) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            DBConversion.catchCharsLen(chars, charOffset, nchars);
            DBConversion.catchBytesLen(bytes, byteOffset, nchars * 2);
            int lastChar = nchars + charOffset;
            int byte_i = byteOffset;
            for (int char_i = charOffset; char_i < lastChar; ++char_i) {
                bytes[byte_i++] = (byte)(chars[char_i] >> 8 & 0xFF);
                bytes[byte_i++] = (byte)(chars[char_i] & 0xFF);
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + (byte_i - byteOffset));
                OracleLog.recursiveTrace = false;
            }
            int n2 = byte_i - byteOffset;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int ucs2BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = CharacterSet.AL16UTF16BytesToJavaChars(bytes, nbytes, chars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] stringToAsciiBytes(String str) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(str));
                OracleLog.recursiveTrace = false;
            }
            byte[] __result__ = CharacterSet.stringToASCII(str);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int asciiBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = CharacterSet.convertASCIIBytesToJavaChars(bytes, 0, chars, 0, nbytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int javaCharsToAsciiBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(nchars) + ", " + OracleLog.argument(bytes));
                OracleLog.recursiveTrace = false;
            }
            int __result__ = CharacterSet.convertJavaCharsToASCIIBytes(chars, 0, bytes, 0, nchars);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isCharSetMultibyte(short charSet) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(charSet));
                OracleLog.recursiveTrace = false;
            }
            switch (charSet) {
                case 1: 
                case 31: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: false");
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = false;
                    return bl;
                }
                case -5: 
                case -1: 
                case 870: 
                case 871: 
                case 873: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: true");
                        OracleLog.recursiveTrace = false;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: false");
                OracleLog.recursiveTrace = false;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCharbyteSize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this._getMaxCharbyteSize(this.clientCharSetId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxNCharbyteSize() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            int __result__ = this._getMaxCharbyteSize(this.serverNCharSetId);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            int n2 = __result__;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _getMaxCharbyteSize(short cs) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(cs));
                OracleLog.recursiveTrace = false;
            }
            switch (cs) {
                case 1: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n2 = 1;
                    return n2;
                }
                case 31: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 1");
                        OracleLog.recursiveTrace = false;
                    }
                    int n3 = 1;
                    return n3;
                }
                case 870: 
                case 871: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 3");
                        OracleLog.recursiveTrace = false;
                    }
                    int n4 = 3;
                    return n4;
                }
                case -5: 
                case 2000: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 2");
                        OracleLog.recursiveTrace = false;
                    }
                    int n5 = 2;
                    return n5;
                }
                case -1: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    int n6 = 4;
                    return n6;
                }
                case 873: {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        DBConversion.logger().log(OracleLog.TRACE_16, "return: 4");
                        OracleLog.recursiveTrace = false;
                    }
                    int n7 = 4;
                    return n7;
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: 1");
                OracleLog.recursiveTrace = false;
            }
            int n8 = 1;
            return n8;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUcs2CharSet() {
        try {
            boolean __result__;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            boolean bl = __result__ = this.clientCharSetId == -5;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int RAWBytesToHexChars(byte[] bytes, int nbytes, char[] chars) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(nbytes) + ", " + OracleLog.argument(chars));
                OracleLog.recursiveTrace = false;
            }
            int char_i = 0;
            for (int byte_i = 0; byte_i < nbytes; ++byte_i) {
                chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] >> 4 & 0xF));
                chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] & 0xF));
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + char_i);
                OracleLog.recursiveTrace = false;
            }
            int n2 = char_i;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream ConvertStream(InputStream stream, int conversion) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream) + ", " + OracleLog.argument(conversion));
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream __result__ = new OracleConversionInputStream(this, stream, conversion);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = __result__;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream ConvertStream(InputStream stream, int conversion, int max_bytes) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_bytes));
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream __result__ = new OracleConversionInputStream(this, stream, conversion, max_bytes);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = __result__;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream ConvertStream(Reader stream, int conversion, int max_chars, short form_of_use) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_chars) + ", " + OracleLog.argument(form_of_use));
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream ocis = new OracleConversionInputStream(this, stream, conversion, max_chars, form_of_use);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ocis);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionInputStream oracleConversionInputStream = ocis;
            return oracleConversionInputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader ConvertCharacterStream(InputStream stream, int conversion) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream) + ", " + OracleLog.argument(conversion));
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader __result__ = new OracleConversionReader(this, stream, conversion);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = __result__;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader ConvertCharacterStream(InputStream stream, int conversion, short form_of_use) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(form_of_use));
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader ocr = new OracleConversionReader(this, stream, conversion);
            ocr.setFormOfUse(form_of_use);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + ocr);
                OracleLog.recursiveTrace = false;
            }
            OracleConversionReader oracleConversionReader = ocr;
            return oracleConversionReader;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream CharsToStream(char[] javachars, int offset, int len, int conversion) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(javachars) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(len) + ", " + OracleLog.argument(conversion));
                OracleLog.recursiveTrace = false;
            }
            if (conversion == 10) {
                AsciiStream __result__ = new AsciiStream(javachars, offset, len);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                AsciiStream asciiStream = __result__;
                return asciiStream;
            }
            if (conversion == 11) {
                UnicodeStream __result__ = new UnicodeStream(javachars, offset, len);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                UnicodeStream unicodeStream = __result__;
                return unicodeStream;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(Level.SEVERE, "Throwing SQLException: 39unknownConversion");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 39, "unknownConversion");
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void unexpectedCharset(short charSet) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(charSet));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(Level.SEVERE, "Throwing SQLException: 35DBConversion");
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(null, 35, "DBConversion");
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void catchBytesLen(byte[] bytes, int offset, int nbytes) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nbytes));
                OracleLog.recursiveTrace = false;
            }
            if (offset + nbytes > bytes.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(Level.SEVERE, "Throwing SQLException: 39catchBytesLen");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 39, "catchBytesLen");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void catchCharsLen(char[] chars, int offset, int nchars) throws SQLException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(nchars));
                OracleLog.recursiveTrace = false;
            }
            if (offset + nchars > chars.length) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    DBConversion.logger().log(Level.SEVERE, "Throwing SQLException: 39catchCharsLen");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(null, 39, "catchCharsLen");
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getUtfLen(char c2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(c2));
                OracleLog.recursiveTrace = false;
            }
            int utf_len = 0;
            utf_len = (c2 & 0xFF80) == 0 ? 1 : ((c2 & 0xF800) == 0 ? 2 : 3);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + utf_len);
                OracleLog.recursiveTrace = false;
            }
            int n2 = utf_len;
            return n2;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int encodedByteLength(String s2, boolean isNChar) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(isNChar));
                OracleLog.recursiveTrace = false;
            }
            int len = 0;
            if (s2 != null && (len = s2.length()) != 0) {
                if (isNChar) {
                    len = this.isServerNCharSetFixedWidth ? len * this.maxNCharSize : this.serverNCharSet.encodedByteLength(s2);
                } else {
                    int n2 = len = this.isServerCharSetFixedWidth ? len * this.sMaxCharSize : this.serverCharSet.encodedByteLength(s2);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + len);
                OracleLog.recursiveTrace = false;
            }
            int n3 = len;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int encodedByteLength(char[] c2, boolean isNChar) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(c2) + ", " + OracleLog.argument(isNChar));
                OracleLog.recursiveTrace = false;
            }
            int len = 0;
            if (c2 != null && (len = c2.length) != 0) {
                if (isNChar) {
                    len = this.isServerNCharSetFixedWidth ? len * this.maxNCharSize : this.serverNCharSet.encodedByteLength(c2);
                } else {
                    int n2 = len = this.isServerCharSetFixedWidth ? len * this.sMaxCharSize : this.serverCharSet.encodedByteLength(c2);
                }
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + len);
                OracleLog.recursiveTrace = false;
            }
            int n3 = len;
            return n3;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                DBConversion.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DBConversion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class UnicodeStream
    extends OracleBufferedStream {
        UnicodeStream(char[] javachars, int offset, int len) {
            super(len);
            int cind = offset;
            int bind = 0;
            while (bind < len) {
                char c2 = javachars[cind++];
                this.buf[bind++] = (byte)(c2 >> 8 & 0xFF);
                this.buf[bind++] = (byte)(c2 & 0xFF);
            }
            this.count = len;
        }

        @Override
        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }
    }

    class AsciiStream
    extends OracleBufferedStream {
        AsciiStream(char[] javachars, int offset, int len) {
            super(len);
            int cind = offset;
            for (int bind = 0; bind < len; ++bind) {
                this.buf[bind] = (byte)javachars[cind++];
            }
            this.count = len;
        }

        @Override
        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }
    }
}

