/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class CharCopyingBinder
extends Binder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:32_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    CharCopyingBinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Binder copyingBinder() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharCopyingBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharCopyingBinder.logger().log(OracleLog.TRACE_30, "return: " + this);
                OracleLog.recursiveTrace = false;
            }
            CharCopyingBinder charCopyingBinder = this;
            return charCopyingBinder;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharCopyingBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        try {
            int len;
            int fromCharOffset;
            char[] fromChars;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharCopyingBinder.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                OracleLog.recursiveTrace = false;
            }
            if (rankInBuffer == 0) {
                fromChars = stmt.lastBoundChars;
                fromCharOffset = stmt.lastBoundCharOffsets[bindPosition];
                bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
                bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
                if (fromChars == bindChars && fromCharOffset == charoffset) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        CharCopyingBinder.logger().log(OracleLog.TRACE_30, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                len = stmt.lastBoundCharLens[bindPosition];
                if (len > charPitch) {
                    len = charPitch;
                }
            } else {
                fromChars = bindChars;
                fromCharOffset = charoffset - charPitch;
                bindIndicators[indoffset] = bindIndicators[indoffset - 1];
                bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
                len = charPitch;
            }
            System.arraycopy(fromChars, fromCharOffset, bindChars, charoffset, len);
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                CharCopyingBinder.logger().log(OracleLog.TRACE_30, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.CharCopyingBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

