/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

class BufferCache {
    SoftReference[] buffers;
    int top = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Jul_25_09:00:27_PDT_2007";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferCache(int size) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(size));
                OracleLog.recursiveTrace = false;
            }
            this.buffers = new SoftReference[size];
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resize(int size) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(size));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_20, "Debug: on entry top = " + this.top + "buffers.length = " + this.buffers.length);
                OracleLog.recursiveTrace = false;
            }
            SoftReference[] b2 = new SoftReference[size];
            System.arraycopy(this.buffers, Math.max(0, this.top - b2.length), b2, 0, Math.min(this.top, b2.length));
            this.buffers = b2;
            this.top = Math.min(this.top, this.buffers.length);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_20, "Debug: on exit top = " + this.top + "buffers.length = " + this.buffers.length);
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            while (this.top > 0) {
                this.buffers[--this.top] = null;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(Object b2) {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(b2));
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_20, "Debug: top = " + this.top + "buffers.length = " + this.buffers.length);
                OracleLog.recursiveTrace = false;
            }
            if (this.top < this.buffers.length) {
                this.buffers[this.top++] = new SoftReference<Object>(b2);
            } else {
                int i2 = this.top;
                while (i2 > 0) {
                    if (this.buffers[--i2].get() != null) continue;
                    this.buffers[i2] = new SoftReference<Object>(b2);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        BufferCache.logger().log(OracleLog.TRACE_16, "return: ");
                        OracleLog.recursiveTrace = false;
                    }
                    return;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BufferCache.logger().log(OracleLog.TRACE_20, "Debug: cache is full so drop buffer on the floor");
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get() {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_20, "Debug: top = " + this.top + "buffers.length = " + this.buffers.length);
                OracleLog.recursiveTrace = false;
            }
            while (this.top > 0) {
                Object b2 = this.buffers[--this.top].get();
                this.buffers[this.top] = null;
                if (b2 == null) continue;
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    BufferCache.logger().log(OracleLog.TRACE_16, "return: " + b2);
                    OracleLog.recursiveTrace = false;
                }
                Object t = b2;
                return t;
            }
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "return: " + null);
                OracleLog.recursiveTrace = false;
            }
            Object var1_1 = null;
            return var1_1;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                BufferCache.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.BufferCache"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

